/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.common.cache;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.SystemProtectionSession;
import com.cognos.cps.cache.CacheEncryptor;
import com.cognos.cps.cache.CacheException;
import com.cognos.cps.cache.CacheManager;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.properties.PropertiesManager;
import java.io.File;

public class CacheManagerSingleton {
    private static CacheManager cacheManager;

    private CacheManagerSingleton() {
    }

    public static synchronized CacheManager getInstance() throws XTSInstructionException {
        if (cacheManager == null) {
            cacheManager = new CacheManager("blockCache", new File(CacheManagerSingleton.tempDirPath()), CacheManagerSingleton.timeToIdleSeconds(), CacheManagerSingleton.timeToLiveSeconds(), CacheManagerSingleton.checkExpiryIntervalSeconds(), CacheManagerSingleton.cacheEncryptor(), CacheManagerSingleton.getCacheMaxSizePerPortlet());
        }
        return cacheManager;
    }

    private static CacheEncryptor cacheEncryptor() throws XTSInstructionException {
        String encryptTemporaryFiles = PropertiesManager.getInstance().getProperty("encryptTemporaryFiles");
        if (encryptTemporaryFiles != null && encryptTemporaryFiles.equals("true")) {
            try {
                return new JCAMCacheEncryptor();
            }
            catch (CAMCryptoException e) {
                throw new XTSInstructionException("cps.cache.creatingencryptorerror", (Throwable)e);
            }
        }
        return new NullCacheEncryptor();
    }

    private static int timeToIdleSeconds() {
        String sTimeToIdleSeconds = PropertiesManager.getInstance().getProperty("properties.config.cps.cache.timeToIdleSeconds");
        if (sTimeToIdleSeconds != null) {
            try {
                return Integer.parseInt(sTimeToIdleSeconds);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1800;
    }

    private static int getCacheMaxSizePerPortlet() {
        int cacheValue;
        String value = PropertiesManager.getInstance().getProperty("CPSMaxCacheSizePerPortlet");
        try {
            cacheValue = value != null ? Integer.parseInt(value) : -1;
        }
        catch (NumberFormatException e) {
            cacheValue = -1;
        }
        return cacheValue;
    }

    private static int timeToLiveSeconds() {
        String sTimeToLiveSeconds = PropertiesManager.getInstance().getProperty("properties.config.cps.cache.timeToLiveSeconds");
        if (sTimeToLiveSeconds != null) {
            try {
                return Integer.parseInt(sTimeToLiveSeconds);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 86400;
    }

    private static int checkExpiryIntervalSeconds() {
        String sCheckExpiryIntervalSeconds = PropertiesManager.getInstance().getProperty("properties.config.cps.cache.checkExpiryIntervalSeconds");
        if (sCheckExpiryIntervalSeconds != null) {
            try {
                return Integer.parseInt(sCheckExpiryIntervalSeconds);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 300;
    }

    private static String tempDirPath() throws XTSInstructionException {
        String tempDirPath = PropertiesManager.getInstance().getProperty("xts.tempdir");
        if (tempDirPath == null) {
            throw new XTSInstructionException("cps.cache.undefinedtempdir");
        }
        return tempDirPath;
    }

    private static class JCAMCacheEncryptor
    implements CacheEncryptor {
        private SystemProtectionSession session = new SystemProtectionSession();

        @Override
        public synchronized byte[] encrypt(byte[] b) {
            try {
                return this.session.encryptData(b);
            }
            catch (CAMCryptoException e) {
                String[] args = new String[]{e.getMessage()};
                throw new CacheException("cps.cache.crypto.encryptfailed", args, e);
            }
        }

        @Override
        public synchronized byte[] decrypt(byte[] b) {
            try {
                return this.session.decryptData(b);
            }
            catch (CAMCryptoException e) {
                String[] args = new String[]{e.getMessage()};
                throw new CacheException("cps.cache.crypto.decryptfailed", args, e);
            }
        }
    }

    private static class NullCacheEncryptor
    implements CacheEncryptor {
        private NullCacheEncryptor() {
        }

        @Override
        public byte[] encrypt(byte[] b) {
            return b;
        }

        @Override
        public byte[] decrypt(byte[] b) {
            return b;
        }
    }
}

