/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.common.request;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cps.bseries.xts.common.CPSExceptionWrapper;
import com.cognos.cps.bseries.xts.common.logging.XTSServiceLoggerImpl;
import com.cognos.cps.bseries.xts.common.request.WebServiceResult;
import com.cognos.cps.bseries.xts.common.sax.BIBusBufferXMLContentHandler;
import com.cognos.cps.bseries.xts.common.sax.CookieVarsHandler;
import com.cognos.cps.bseries.xts.common.sax.LocalesHandler;
import com.cognos.cps.bseries.xts.common.sax.ParseUtils;
import com.cognos.cps.bseries.xts.common.sax.PassportHandler;
import com.cognos.cps.bseries.xts.common.sax.ServiceSoapHandler;
import com.cognos.cps.bseries.xts.common.sax.UserAgentHandler;
import com.cognos.cps.bseries.xts.common.utils.HttpSOAPConnectionFactoryImpl;
import com.cognos.cps.bseries.xts.common.utils.SoapUtils;
import com.cognos.cps.common.ExceptionExtension;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.common.sax.EnhancedSAXException;
import com.cognos.cps.common.sax.MultiHandler;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.pagelet.assembler.v1.types.GetPageletResponse;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletMarkup;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.TrustedSOAPConnectionFactoryImpl;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.capability.UserCapabilities;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class WebServiceRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    protected ServiceLogger m_logger = new XTSServiceLoggerImpl(WebServiceRequest.class);
    protected String m_identifier;
    private SOAPConnectionFactoryImpl soapConnectionFactory;
    private TrustedSOAPConnectionFactoryImpl trustedSOAPConnectionFactory;
    private TrustedSOAPConnectionFactoryImpl consumerTrustedSOAPConnectionFactory;
    private HttpSOAPConnectionFactoryImpl httpSOAPConnectionFactory;

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_identifier = identifier;
        ContextImpl portalContext = new ContextImpl();
        try {
            portalContext.setProperty("cmPath", (Object)new URL(CCLConfigurationFactory.getInstance().getValue("contentManager", true)).getFile());
            portalContext.setProperty("dispatcherPath", (Object)new URL(CCLConfigurationFactory.getInstance().getValue("internalDispatcher", true)).getFile());
        }
        catch (MalformedURLException e) {
            throw new XTSInstructionException("cps.common.init.error", (Object[])new String[]{WebServiceRequest.class.getName()}, (Throwable)e);
        }
        catch (CCLConfigurationException e) {
            throw new XTSInstructionException("cps.common.init.error", (Object[])new String[]{WebServiceRequest.class.getName()}, (Throwable)e);
        }
        this.soapConnectionFactory = new SOAPConnectionFactoryImpl((com.cognos.portal.utils.IContext)portalContext);
        this.trustedSOAPConnectionFactory = new TrustedSOAPConnectionFactoryImpl((com.cognos.portal.utils.IContext)portalContext, "CPS");
        this.consumerTrustedSOAPConnectionFactory = new TrustedSOAPConnectionFactoryImpl((com.cognos.portal.utils.IContext)portalContext, "CPSConsumer");
        this.httpSOAPConnectionFactory = new HttpSOAPConnectionFactoryImpl();
    }

    public void terminate() throws XTSInstructionException {
        this.m_identifier = null;
    }

    public final String getIdentifier() {
        return this.m_identifier;
    }

    public final boolean isInitialized() {
        return this.m_identifier != null;
    }

    public final IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String MN = "execute";
        IXTSLogger perfLogger = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (perfLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
            perfLogger.log(env, 2, ((Object)((Object)this)).getClass().getName(), this.getComponentName(), "parse and deserialze request");
            perfLogger.starttimer();
        }
        QName busHeader = new QName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        QName cpsServiceHeader = new QName("http://developer.cognos.com/schemas/cps/header/service/1/", "serviceHeader");
        QName userCapabilityCache = new QName("http://developer.cognos.com/schemas/bibus/3/", "userCapabilityCache");
        QName userCapabilityCacheNoNs = new QName("", "userCapabilityCache");
        BIBusBufferXMLContentHandler headerBufferHandler = new BIBusBufferXMLContentHandler(busHeader);
        headerBufferHandler.addElementName(cpsServiceHeader);
        headerBufferHandler.addElementName(userCapabilityCache);
        headerBufferHandler.addElementName(userCapabilityCacheNoNs);
        CookieVarsHandler cookieHandler = new CookieVarsHandler();
        LocalesHandler localesHandler = new LocalesHandler();
        PassportHandler passportHandler = new PassportHandler();
        UserAgentHandler userAgentHandler = new UserAgentHandler();
        ContentHandler[] handlers = new ContentHandler[]{headerBufferHandler, cookieHandler, localesHandler, passportHandler, userAgentHandler};
        MultiHandler headerHandler = new MultiHandler(handlers);
        ServiceSoapHandler soapHandler = new ServiceSoapHandler(this.getTypeFactory(), (ContentHandler)headerHandler);
        UserCapabilities userCapabilities = null;
        try {
            if (this.m_logger.isDebugEnabled()) {
                StringBuffer bodyBuffer = new StringBuffer();
                try {
                    body = UXTSInstructionUtils.copyReader((Reader)body, (StringBuffer)bodyBuffer);
                }
                catch (IOException e) {
                    Object[] args = new String[]{this.m_identifier};
                    throw new XTSInstructionException("cps.common.parse.error", args, (Throwable)e);
                }
                this.m_logger.debug("request body is:\n" + bodyBuffer.toString());
            }
            XMLReader xmlReader = ParseUtils.getXMLReader();
            xmlReader.setContentHandler(soapHandler);
            xmlReader.parse(new InputSource(body));
            userCapabilities = new UserCapabilities();
            String capability = headerBufferHandler.getElementAsString(userCapabilityCache);
            if (capability.length() == 0) {
                capability = headerBufferHandler.getElementAsString(userCapabilityCacheNoNs);
            }
            String passportID = passportHandler.getPassportID();
            userCapabilities.processUserCapabilityCache(capability, passportID);
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && perfLogger != null) {
                perfLogger.stoptimer();
                perfLogger.log(env, 3, ((Object)((Object)this)).getClass().getName(), this.getComponentName(), "parse and deserialze request");
            }
            Object request = soapHandler.getObject();
            com.cognos.cps.services.helpers.ContextImpl context = new com.cognos.cps.services.helpers.ContextImpl();
            context.setProperty("SoapConnectionFactory", (Object)this.soapConnectionFactory);
            context.setProperty("trustedSoapConnectionFactory", (Object)this.trustedSOAPConnectionFactory);
            context.setProperty("consumerTrustedSoapConnectionFactory", (Object)this.consumerTrustedSOAPConnectionFactory);
            context.setProperty("httpSoapConnectionFactory", (Object)this.httpSOAPConnectionFactory);
            context.setProperty("CPS_SOAP_HEADER", (Object)headerBufferHandler.getElementAsString(cpsServiceHeader));
            context.setProperty("COOKIES", (Object)cookieHandler.getCookies());
            context.setProperty("PRODUCT_LOCALE", (Object)localesHandler.getProductLocale());
            context.setProperty("CONTENT_LOCALE", (Object)localesHandler.getContentLocale());
            context.setProperty("PASSPORT", (Object)passportHandler.getPassportID());
            context.setProperty("USER_AGENT", (Object)userAgentHandler.getHttpUserAgent());
            context.setProperty("BUS_HEADER", (Object)headerBufferHandler.getElementAsString(busHeader));
            context.setProperty("XTS_ENV", (Object)env);
            context.setProperty("XTS_IDENTIFIER", (Object)this.m_identifier);
            context.setProperty("USER_CAPABILITIES", (Object)userCapabilities.getUserCapabilities());
            Object response = this.performRequest(soapHandler.getMethodName(), request, (IContext)context);
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (perfLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                perfLogger.log(env, 2, ((Object)((Object)this)).getClass().getName(), this.getComponentName(), "serialize response");
                perfLogger.starttimer();
            }
            if (response != null) {
                String responseEnvelope;
                PageletMarkup pageletMarkup;
                StringBuffer moreXML = new StringBuffer();
                this.processResponse(request, response, instParams, moreXML);
                String markupString = "";
                String option = (String)instAtts.get("option");
                if (option != null && option.equals("xml-part") && (pageletMarkup = ((GetPageletResponse)response).getPageletMarkup()) != null) {
                    markupString = pageletMarkup.getMarkupString();
                    if (markupString == null) {
                        markupString = "";
                    } else {
                        pageletMarkup.setMarkupString(null);
                    }
                }
                String resultString = this.serialize(response, soapHandler.getMethodName() + "Response");
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("response is: \n" + resultString);
                }
                if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && perfLogger != null) {
                    perfLogger.stoptimer();
                    perfLogger.log(env, 3, ((Object)((Object)this)).getClass().getName(), this.getComponentName(), "serialize response");
                }
                if ((responseEnvelope = UXTSInstructionUtils.getParameter((String)"responseEnvelope", (Map)instParams)) != null && responseEnvelope.equals("true")) {
                    String[] headers = new String[]{context.getProperty("BUS_HEADER").toString(), context.getProperty("CPS_SOAP_HEADER").toString()};
                    return new WebServiceResult(SoapUtils.createSOAPEnvelopeReader(resultString, headers, moreXML.toString()), markupString);
                }
                return new WebServiceResult(new StringReader(resultString + moreXML.toString()), markupString);
            }
        }
        catch (IOException e) {
            this.m_logger.error(MN, (Throwable)e);
            Object[] args = new String[]{this.m_identifier};
            throw new XTSInstructionException("cps.common.parse.error", args, (Throwable)e);
        }
        catch (EnhancedSAXException e) {
            this.m_logger.error(MN, (Throwable)e);
            Object[] args = new String[]{this.m_identifier};
            throw new XTSInstructionException("cps.common.parse.error", args, (Throwable)((Object)new CPSExceptionWrapper((ExceptionExtension)e)));
        }
        catch (SAXException e) {
            this.m_logger.error(MN, (Throwable)e);
            Object[] args = new String[]{this.m_identifier};
            throw new XTSInstructionException("cps.common.parse.error", args, (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof XTSInstructionException) {
                throw (XTSInstructionException)e;
            }
            Object[] args = new String[]{this.m_identifier};
            throw new XTSInstructionException("cps.transform.parse.error", args, (Throwable)e);
        }
        this.m_logger.error(MN);
        Object[] args = new String[]{this.m_identifier};
        throw new XTSInstructionException(this.getDefaultExceptionCode(), args);
    }

    protected final String serialize(Object obj, String elementName) throws XTSInstructionException {
        String MN = "serialize";
        try {
            StringWriter out = new StringWriter(32768);
            this.getTypeFactory().serialize(obj, (Writer)out, new QName(this.getTypeFactoryNamespace(), elementName));
            return out.getBuffer().toString();
        }
        catch (IOException e) {
            this.m_logger.error(MN, (Throwable)e);
            throw new XTSInstructionException("cps.common.writecopyto.error");
        }
    }

    protected abstract Object performRequest(String var1, Object var2, IContext var3) throws XTSInstructionException;

    protected abstract void processResponse(Object var1, Object var2, Map var3, StringBuffer var4) throws XTSInstructionException;

    protected abstract String getDefaultExceptionCode();

    protected abstract String getComponentName();

    protected abstract SOAPObjectHandler getTypeFactory();

    protected abstract String getTypeFactoryNamespace();

    static {
        ArrayList<String> msgFileList = new ArrayList<String>();
        msgFileList.add("cpsconsumermsgs");
        msgFileList.add("cpsservicemsgs");
        msgFileList.add("cpssoapmsgs");
        msgFileList.add("cpsstringsmsgs");
        MessagesManager.getInstance().initialize(msgFileList);
    }
}

