/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.common.sax;

import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CookieVarsHandler
extends DefaultHandler {
    private StringBuffer charBuf = new StringBuffer();
    private boolean inCookieVars = false;
    private Cookie currentCookie;
    private Map<String, Cookie> cookies = new HashMap<String, Cookie>();

    public Cookie[] getCookies() {
        Cookie[] cookieArray = new Cookie[this.cookies.entrySet().size()];
        int i = 0;
        for (Map.Entry<String, Cookie> pair : this.cookies.entrySet()) {
            cookieArray[i++] = pair.getValue();
        }
        return cookieArray;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inCookieVars) {
            this.charBuf.append(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String local, String qname, Attributes attributes) throws SAXException {
        String tag;
        String string = tag = "".equals(uri) ? qname : local;
        if (this.inCookieVars) {
            if (tag.equals("item")) {
                this.currentCookie = new Cookie();
            } else if (tag.equals("name")) {
                this.charBuf.setLength(0);
            } else if (tag.equals("value")) {
                this.charBuf.setLength(0);
            } else if (tag.equals("maxAge")) {
                this.charBuf.setLength(0);
            }
        } else if (tag.equals("cookieVars") || tag.equals("setCookieVars")) {
            this.inCookieVars = true;
        }
    }

    @Override
    public void endElement(String uri, String local, String qname) throws SAXException {
        if (this.inCookieVars) {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("item")) {
                if (!this.currentCookie.hasMaxAge() || this.currentCookie.getMaxAge() >= 0) {
                    this.cookies.put(this.currentCookie.getName(), this.currentCookie);
                }
                this.currentCookie = null;
            } else if (tag.equals("name")) {
                this.currentCookie.setName(this.charBuf.toString());
            } else if (tag.equals("value")) {
                this.currentCookie.setContent(this.charBuf.toString());
            } else if (tag.equals("maxAge")) {
                String maxAgeStr = this.charBuf.toString();
                if (!"".equals(maxAgeStr)) {
                    this.currentCookie.setMaxAge(new Integer(maxAgeStr).intValue());
                }
            } else if (tag.equals("cookieVars") || tag.equals("setCookieVars")) {
                this.inCookieVars = false;
            }
        }
    }
}

