/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.common.sax;

import com.cognos.cps.common.sax.EnhancedSAXException;
import com.cognos.cps.soap.SOAPObjectHandler;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceSoapHandler
extends DefaultHandler {
    private static final String SOAP_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String TAG_BODY = "Body";
    private static final String TAG_HEADER = "Header";
    private static final int MODE_NONE = 0;
    private static final int MODE_HEADER = 1;
    private static final int MODE_BODY = 2;
    private static final int MODE_UNMARSHALL = 3;
    private ContentHandler m_objectHandler;
    private ContentHandler m_headerHandler;
    private HashMap m_Namespaces = new HashMap();
    private int mode = 0;
    private String m_methodName;
    private SOAPObjectHandler m_factory;

    public ServiceSoapHandler(SOAPObjectHandler factory, ContentHandler soapHeaderHandler) {
        this.m_factory = factory;
        this.m_headerHandler = soapHeaderHandler;
    }

    public ContentHandler getSoapHeaderHandler() {
        return this.m_headerHandler;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.mode == 1) {
            this.m_headerHandler.setDocumentLocator(locator);
        } else if (this.mode == 3) {
            this.m_objectHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.mode == 1) {
            this.m_headerHandler.characters(ch, start, length);
        } else if (this.mode == 3) {
            this.m_objectHandler.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.mode == 3 && SOAP_NAMESPACE.equals(uri) && TAG_BODY.equals(localName)) {
            this.mode = 0;
            this.m_objectHandler.endDocument();
        }
        if (this.mode == 1) {
            this.m_headerHandler.endElement(uri, localName, qName);
        } else if (this.mode == 3) {
            this.m_objectHandler.endElement(uri, localName, qName);
        }
        if (this.mode == 1 && SOAP_NAMESPACE.equals(uri) && TAG_HEADER.equals(localName)) {
            this.mode = 0;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.mode == 1) {
            this.m_headerHandler.endPrefixMapping(prefix);
        } else if (this.mode == 3) {
            this.m_objectHandler.endPrefixMapping(prefix);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.mode == 1) {
            this.m_headerHandler.ignorableWhitespace(ch, start, length);
        } else if (this.mode == 3) {
            this.m_objectHandler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.mode == 1) {
            this.m_headerHandler.processingInstruction(target, data);
        } else if (this.mode == 3) {
            this.m_objectHandler.processingInstruction(target, data);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.mode == 0) {
            if (SOAP_NAMESPACE.equals(uri) && TAG_HEADER.equals(localName)) {
                this.mode = 1;
                for (Map.Entry entry : this.m_Namespaces.entrySet()) {
                    this.m_headerHandler.startPrefixMapping(entry.getKey().toString(), entry.getValue().toString());
                }
            }
        } else if (this.mode == 2) {
            this.mode = 3;
        }
        if (this.mode == 1) {
            this.m_headerHandler.startElement(uri, localName, qName, attributes);
        } else if (this.mode == 3) {
            if (this.m_methodName == null) {
                this.m_methodName = localName;
                this.m_objectHandler = this.m_factory.getContentHandler(uri, this.m_methodName);
                if (this.m_objectHandler == null) {
                    Object[] args = new String[]{this.m_methodName};
                    throw new EnhancedSAXException("cps.sax.deserializeunknownobject.error", args);
                }
                this.m_objectHandler.startDocument();
                for (Map.Entry entry : this.m_Namespaces.entrySet()) {
                    this.m_objectHandler.startPrefixMapping(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            this.m_objectHandler.startElement(uri, localName, qName, attributes);
        }
        if (this.mode == 0 && SOAP_NAMESPACE.equals(uri) && TAG_BODY.equals(localName)) {
            this.mode = 2;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.mode == 1) {
            if (this.m_Namespaces.get(prefix) == null) {
                this.m_headerHandler.startPrefixMapping(prefix, uri);
            }
        } else if (this.mode == 3) {
            if (this.m_Namespaces.get(prefix) == null) {
                this.m_objectHandler.startPrefixMapping(prefix, uri);
            }
        } else {
            this.m_Namespaces.put(prefix, uri);
        }
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public Object getObject() {
        return this.m_factory.getObject(this.m_objectHandler);
    }
}

