/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.common.utils;

import com.cognos.cps.common.io.StringArrayReader;
import java.io.Reader;

public class SoapUtils {
    private static final String SOAP_ENVELOPE_OPEN = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">";
    private static final String SOAP_HEADER_OPEN = "<SOAP-ENV:Header>";
    private static final String SOAP_HEADER_CLOSE = "</SOAP-ENV:Header>";
    private static final String SOAP_BODY_OPEN = "<SOAP-ENV:Body>";
    private static final String SOAP_BODY_CLOSE = "</SOAP-ENV:Body>";
    private static final String SOAP_ENVELOPE_CLOSE = "</SOAP-ENV:Envelope>";

    public static Reader createSOAPEnvelopeReader(String body, String[] headers, String additionalXML) {
        String[] strings;
        if (headers != null) {
            int c = 0;
            strings = new String[7 + headers.length + (additionalXML != null ? 1 : 0)];
            strings[c++] = SOAP_ENVELOPE_OPEN;
            strings[c++] = SOAP_HEADER_OPEN;
            for (int i = 0; i < headers.length; ++i) {
                strings[c++] = headers[i];
            }
            strings[c++] = SOAP_HEADER_CLOSE;
            strings[c++] = SOAP_BODY_OPEN;
            strings[c++] = body;
            strings[c++] = SOAP_BODY_CLOSE;
            strings[c++] = SOAP_ENVELOPE_CLOSE;
            if (additionalXML != null) {
                strings[c++] = additionalXML;
            }
        } else {
            strings = additionalXML != null ? new String[]{SOAP_ENVELOPE_OPEN, SOAP_BODY_OPEN, body, SOAP_BODY_CLOSE, SOAP_ENVELOPE_CLOSE, additionalXML} : new String[]{SOAP_ENVELOPE_OPEN, SOAP_BODY_OPEN, body, SOAP_BODY_CLOSE, SOAP_ENVELOPE_CLOSE};
        }
        return new StringArrayReader(strings);
    }

    public static Reader createSOAPEnvelopeReader(String body, String[] headers) {
        return SoapUtils.createSOAPEnvelopeReader(body, headers, null);
    }

    public static String createSOAPEnvelopeString(String body, String[] headers) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(SOAP_ENVELOPE_OPEN);
        buffer.append(SOAP_HEADER_OPEN);
        for (int i = 0; i < headers.length; ++i) {
            buffer.append(headers[i]);
        }
        buffer.append(SOAP_HEADER_CLOSE);
        buffer.append(SOAP_BODY_OPEN);
        buffer.append(body);
        buffer.append(SOAP_BODY_CLOSE);
        buffer.append(SOAP_ENVELOPE_CLOSE);
        return buffer.toString();
    }
}

