/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.common.utils;

import com.cognos.cps.bseries.xts.common.utils.BIBusSOAPObjectHandlerImpl;
import com.cognos.cps.common.io.EnhancedIOException;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.pagelet.common.http.HttpSOAPConnectionImpl;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.soap.SOAPFault;
import com.cognos.cps.soap.SOAPMessage;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import com.cognos.xts.interpreter.instructions.request.XTSSoapRequest;
import com.cognos.xts.util.ReaderInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.xml.namespace.QName;
import org.xml.sax.SAXException;

public class XTSHttpSOAPConnectionImpl
extends HttpSOAPConnectionImpl {
    public XTSHttpSOAPConnectionImpl(TypeFactory factory, ServiceLogger logger) {
        super((SOAPObjectHandler)factory, (SOAPObjectHandler)new BIBusSOAPObjectHandlerImpl(), logger);
    }

    @Override
    public SOAPMessage call(SOAPMessage requestMsg, String url) throws SOAPFault, IOException, SAXException {
        XTSSoapRequest xtsRequest = new XTSSoapRequest();
        XTSEnvironment env = (XTSEnvironment)this.context.getProperty("XTS_ENV");
        String identifier = (String)this.context.getProperty("XTS_IDENTIFIER");
        String soapAction = null;
        QName bodyRootElemName = requestMsg.getBodyRootElemName();
        if (bodyRootElemName != null) {
            soapAction = bodyRootElemName.getLocalPart();
            if (bodyRootElemName.getNamespaceURI() != null && bodyRootElemName.getNamespaceURI().length() > 0) {
                soapAction = bodyRootElemName.getNamespaceURI().startsWith("http://") ? bodyRootElemName.getNamespaceURI() + "#" + soapAction : bodyRootElemName.getNamespaceURI() + ":" + soapAction;
            }
        }
        HashMap<String, String> instAtts = new HashMap<String, String>();
        instAtts.put("target", url);
        HashMap<String, String[]> instParams = new HashMap<String, String[]>();
        instParams.put("responseEnvelope", new String[]{"true"});
        if (soapAction != null) {
            instParams.put("soapAction", new String[]{soapAction});
        }
        if (this.m_requestCookies != null) {
            ((BIBusSOAPObjectHandlerImpl)this.m_soapHeaderHandler).setCookies(this.m_requestCookies);
            StringBuffer cookies = new StringBuffer(256);
            for (int i = 0; i < this.m_requestCookies.length; ++i) {
                if (this.m_requestCookies[i] == null) continue;
                if (cookies.length() > 0) {
                    cookies.append(";");
                }
                cookies.append(this.m_requestCookies[i].getName());
                cookies.append("=");
                String content = this.m_requestCookies[i].getContent();
                if (content == null) continue;
                cookies.append(content);
            }
            instParams.put("Cookie", new String[]{cookies.toString()});
        }
        CharArrayWriter writerOutput = new CharArrayWriter();
        this.writeRequest(requestMsg, writerOutput, false);
        char[] request = writerOutput.toCharArray();
        this.writeRequestLog(request);
        CharArrayReader body = new CharArrayReader(request);
        try {
            String[] strCookies;
            InternetHeaders headers;
            IXTSOutputableInstructionResult output;
            xtsRequest.initialize(env, identifier, instAtts, instParams);
            IXTSInstructionResult result = xtsRequest.execute(env, instAtts, instParams, (Reader)body);
            Reader xtsResponse = result.getResult().getReader();
            SOAPMessage soapResponse = this.readResponse((InputStream)new ReaderInputStream(xtsResponse, "UTF-8"));
            if (result instanceof IXTSOutputableInstructionResult && (output = (IXTSOutputableInstructionResult)result).protocolHeaderSupported() && (headers = output.getProtocolHeaders()) != null && (strCookies = headers.getHeader("Set-Cookie")) != null) {
                for (int i = 0; i < strCookies.length; ++i) {
                    StringTokenizer tokens = new StringTokenizer(strCookies[i], ";");
                    while (tokens.hasMoreElements()) {
                        String cookieStr = (String)tokens.nextElement();
                        Cookie cookie = new Cookie();
                        int sep = cookieStr.indexOf(61);
                        if (sep >= 0) {
                            cookie.setName(cookieStr.substring(0, sep).trim());
                            cookie.setContent(cookieStr.substring(sep + 1).trim());
                        } else {
                            cookie.setName(cookieStr);
                            cookie.setContent("");
                        }
                        this.m_responseCookies = XTSHttpSOAPConnectionImpl.addCookie(this.m_responseCookies, cookie);
                    }
                }
            }
            result.release();
            this.logResponseCookies();
            return soapResponse;
        }
        catch (XTSSoapFaultException e) {
            return this.readResponse((InputStream)new ReaderInputStream(e.getSoapEnvReaderCopy(), "UTF-8"));
        }
        catch (XTSInstructionException e) {
            throw new EnhancedIOException("cps.soap.soapfaultencountered", (Throwable)e);
        }
    }

    @Override
    public void disconnect() {
    }

    @Override
    protected HttpURLConnection openConnection(URL url) throws IOException {
        throw new UnsupportedOperationException();
    }
}

