/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.mashup;

import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.JSONObject;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.StringUtils;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction;
import com.cognos.xts.interpreter.instructions.transform.XTSTransformResult;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CPSWebRewriter
extends AXTSInstruction
implements IXTSTransformInstruction {
    private static final String FEATURE_BROWSER_LOGIN = "BrowserLogin";
    static Pattern FILTER_PATTERM;
    static Pattern JS_FUNCTION_PATTERM;
    static Pattern EXTRACT_JS_FUNCTION_PATTERM;
    private String m_identifier = null;
    private static final Pattern SCRIPT_TAG_WITH_SCR_PATTERN;
    private static final Pattern LINK_TAG_WITH_SCR_PATTERN;
    private static final Pattern ATTR_SCR_PATTERN;
    private static final Pattern ATTR_TYPE_PATTERN;
    private static final Pattern ATTR_HREF_PATTERN;
    private static final Pattern ATTR_REL_PATTERN;

    public String getIdentifier() {
        return this.m_identifier;
    }

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_identifier = identifier;
    }

    public void terminate() {
        this.m_identifier = null;
    }

    public boolean isInitialized() {
        return this.m_identifier != null;
    }

    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        try {
            int read;
            String nsPrefix;
            String scope = (String)instAtts.get("scope");
            if (scope == null || scope.length() == 0) {
                scope = "CognosConnect";
            }
            if ((nsPrefix = (String)instAtts.get("namespacePrefix")) == null) {
                nsPrefix = "";
            }
            boolean rewriteFunctions = "true".equals((String)instAtts.get("rewriteFunctions"));
            StringBuilder builder = new StringBuilder();
            String webcontent = (String)instAtts.get("webcontent");
            builder.append("<script language='javascript' src='" + webcontent + "cps4/sdk/portletapi.js'></script>");
            builder.append("<form style=\"display:none;\" name=\"" + scope + "_editSaveForm\" id=\"" + scope + "_editSaveFormId\" action=\"wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=save&wsrp-mode=wsrp:view/wsrp_rewrite\" method=\"POST\"></form>");
            builder.append("<script>");
            builder.append("var ");
            builder.append(scope);
            builder.append("= new  CPSWebApplication(");
            builder.append("{\n");
            builder.append("proxyTemplate:(new Object().href=\"wsrp_rewrite?wsrp-urlType=resource&wsrp-requiresRewrite=true&wsrp-url=_cpsresourceurl%3Acpsendmarker_/wsrp_rewrite\"),\n");
            builder.append("actionTemplate:(new Object().href=\"wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=nav&_cpsparamsurl=cpsendmarker_/wsrp_rewrite\"),\n");
            builder.append("editSaveTemplate:(new Object().href=\"wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=save&wsrp-mode=wsrp:view/wsrp_rewrite\"),\n");
            builder.append("editCancelTemplate:(new Object().href=\"wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-mode=wsrp:view/wsrp_rewrite\"),\n");
            builder.append("editResetTemplate:(new Object().href=\"wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=reset&wsrp-mode=wsrp:view/wsrp_rewrite\"),\n");
            String features = (String)instAtts.get("features");
            Iterator it = instAtts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("camPassport".equals(name) && (features == null || features.indexOf(FEATURE_BROWSER_LOGIN) == -1)) continue;
                if (name.endsWith("Query")) {
                    name = name.replaceAll("Query", "");
                    Parameters params = Parameters.parse((String)value);
                    JSONObject json = new JSONObject();
                    for (Parameters.NameValuePair nvp : params) {
                        String nvpName = nvp.getName();
                        String[] nvpValues = nvp.getValues();
                        if (nvpValues.length == 0) {
                            json.addMember(nvpName, "");
                            continue;
                        }
                        if (nvpValues.length == 1) {
                            json.addMember(nvpName, nvpValues[0]);
                            continue;
                        }
                        json.addArrayMember(nvpName);
                        for (int i = 0; i < nvpValues.length; ++i) {
                            json.addValue(nvpValues[i]);
                        }
                        json.endArray();
                    }
                    StringBuffer buffer = new StringBuffer();
                    json.write(buffer);
                    value = buffer.toString();
                }
                builder.append(name);
                if (value.startsWith("{") && value.endsWith("}")) {
                    builder.append(":").append(value);
                } else {
                    builder.append(":\"");
                    builder.append(EncodingUtils.javascriptencode((String)((String)entry.getValue())));
                    builder.append("\"");
                }
                if (!it.hasNext()) continue;
                builder.append(",\n");
            }
            builder.append("\n}");
            builder.append(");\n");
            builder.append("</script>");
            char[] chars = new char[1024];
            while ((read = body.read(chars)) != -1) {
                builder.append(chars, 0, read);
            }
            String html = builder.toString();
            String filtered = CPSWebRewriter.removeUnwantedtags(html);
            List<String> functions = null;
            if (rewriteFunctions) {
                functions = CPSWebRewriter.extractFunctionNames(filtered);
            }
            String result = CPSWebRewriter.addNamespacePrefix(filtered, scope, nsPrefix, functions);
            result = CPSWebRewriter.rewriteCssTagWithSrc(CPSWebRewriter.rewriteScriptTagWithSrc(result, instAtts), instAtts);
            StringReader reader = new StringReader(result);
            return new XTSTransformResult((IXTSTransformInstruction)this, (Reader)reader);
        }
        catch (IOException e) {
            throw new XTSInstructionException("FIXME: error", (Throwable)e);
        }
    }

    private static List<String> extractFunctionNames(String html) {
        ArrayList<String> functions = new ArrayList<String>();
        Matcher matcher = EXTRACT_JS_FUNCTION_PATTERM.matcher(html);
        while (matcher.find()) {
            String script = matcher.group(1);
            if (script == null) continue;
            Matcher functionMatcher = JS_FUNCTION_PATTERM.matcher(script);
            while (functionMatcher.find()) {
                String variableName;
                String functionName = functionMatcher.group(1);
                if (functionName != null) {
                    functions.add(functionName);
                    continue;
                }
                if (functionMatcher.groupCount() <= 1 || (variableName = functionMatcher.group(2)) == null) continue;
                functions.add(variableName);
            }
        }
        return functions;
    }

    private static String addNamespacePrefix(String html, String scope, String nsPrefix, List<String> functions) {
        StringBuilder prefixPattern = new StringBuilder();
        prefixPattern.append("(?<![A-Za-z0-9])");
        prefixPattern.append(scope);
        prefixPattern.append("(?![A-Za-z0-9])");
        if (functions != null) {
            for (String function : functions) {
                prefixPattern.append("|(?<![A-Za-z_0-9])");
                prefixPattern.append(function);
                prefixPattern.append("(?![A-Za-z_0-9])");
            }
        }
        Pattern scopePattern = Pattern.compile(prefixPattern.toString());
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = scopePattern.matcher(html);
        while (matcher.find()) {
            String group = matcher.group();
            if (group == null) continue;
            matcher.appendReplacement(buffer, nsPrefix + group);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static String removeUnwantedtags(String html) {
        Matcher m = FILTER_PATTERM.matcher(html);
        String bodyAttributes = null;
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String group = m.group(1);
            if (group != null) {
                bodyAttributes = group;
            }
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        if (bodyAttributes != null) {
            String[] attributes;
            sb.append("<script>\n");
            for (String attribute : attributes = bodyAttributes.split(" ")) {
                String[] pair;
                if (!(attribute = attribute.trim()).startsWith("on") || (pair = attribute.split("=")).length != 2) continue;
                String s = pair[0];
                if (s.startsWith("on")) {
                    s = s.substring(2);
                    sb.append("com_ibm_cognos_cps._F_DOM.addEventListener(window,\"" + s + "\"," + "function(event){eval(" + pair[1] + ")}" + ");");
                    continue;
                }
                sb.append("window.");
                sb.append(s);
                sb.append("= function(event){");
                sb.append("eval(");
                sb.append(pair[1]);
                sb.append(")");
                sb.append("};\n");
            }
            sb.append("</script>");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String text = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\r\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n  <head>\r\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"/>\r\n    <title>CMS Branch Map Demo</title>\r\n\r\n    \r\n    <script src=\"http://localhost/cognos8/fragments/mashup/cpsweb.js\" type=\"text/javascript\"></script>\r\n\r\n    <script src=\"http://maps.google.com/maps?file=api&amp;v=2&amp;key=ABQIAAAAupeesN8gAkqBSRIAzxWwohQnvQaQdbrBFK5aX8eiZDSEe7aN7hQrGWe_0DC1-8FdBI-_o4xizFQyTQ\"\r\n      type=\"text/javascript\"></script> \r\n    <script type=\"text/javascript\">\r\n\r\nvar gatewayURL = CognosConnect.getProperty(\"gateway\");\r\nvar geocoder = new GClientGeocoder();\r\nvar map;\r\nvar branchIcon;\r\nvar MAX_GEOCODE_RETRIES = 4;\r\n\r\ntry {\r\n  var objXHR = new XMLHttpRequest();\r\n} catch (e) {\r\ntry {\r\n  var objXHR = new ActiveXObject('Msxml2.XMLHTTP');\r\n} catch (e) {\r\ntry {\r\n  var objXHR = new ActiveXObject('Microsoft.XMLHTTP');\r\n} catch (e) {\r\n  alert('XMLHttpRequest not supported'); }\r\n}\r\n}\r\n\r\nfunction populateMap()\r\n{\r\n    /*\r\n    * The reportSearchPath is the CM search path for the report that you are looking for. Alternatively you could use the storeId.\r\n    */\r\n    var reportSearchPath = \"/content/folder[@name='maps']/report[@name='branches']\";\r\n    var xpath = \"/document/page/body/item/lst/group/row/cell/item/txt/val\";\r\n    \r\n    var url = CognosConnect.getProxiedResource(gatewayURL + \"/rds/output/searchPath\" + reportSearchPath + \"?xpath=\" + xpath);\r\n    \r\n    window.status = \"Loading Report. Please wait....\";\r\n    var frag = document.getElementById(\"fragment\");\r\n    frag.innerHTML= \"<HTML><BODY>Loading Report. Please wait....</BODY></HTML>\";\r\n    try\r\n    {\r\n        objXHR.open(\"GET\", url, true);\r\n        objXHR.onreadystatechange = callBack;\r\n        objXHR.send(null);\r\n    }\r\n    catch (e)\r\n    {\r\n        alert(e);\r\n    }\r\n}\r\n\r\nfunction addMarkers(obj)\r\n{\r\n    map.clearOverlays();\r\n    var vals = obj.getElementsByTagName(\"val\");\r\n    \r\n    branchIcon = new GIcon(G_DEFAULT_ICON);\r\n    branchIcon.image = CognosConnect.getWebContentResource(\"/mashup/building.gif\");;\r\n    \r\n    var row = 0;\r\n    while(row < vals.length) \r\n    {\r\n        var location = vals[row].childNodes[0].nodeValue;\r\n        row++;\r\n        var branchkey = vals[row].childNodes[0].nodeValue;\r\n        addMarker(location, branchkey, 0);\r\n        \r\n        row++;\r\n    }\r\n}\r\n\r\nfunction addMarker(address, branchKey, runCount) {\r\n    if(runCount > MAX_GEOCODE_RETRIES)\r\n        return;\r\n    \r\n    if (geocoder) {\r\n        geocoder.getLatLng(\r\n            address,\r\n            function(point) {\r\n                if (!point) {\r\n                    setTimeout('addMarker(\\'' + address + '\\', \\'' + branchKey + '\\', ' + runCount++ + ')', 100);\r\n                }\r\n                else {\r\n                    var marker = new GMarker(point, { icon: branchIcon });\r\n                    GEvent.addListener(marker, 'click', function(){\r\n                        openInfo(point, branchKey);\r\n                    }); \r\n                    map.addOverlay(marker);\r\n                }\r\n            }\r\n        );\r\n    }\r\n}\r\n\r\nfunction openInfo(point, branchKey)\r\n{\r\n    var reportSearchPath = \"/content/folder[@name='maps']/report[@name='branch-detail']\";\r\n    var url = CognosConnect.getProxiedResource(gatewayURL + \"/rds/output/searchPath\" + reportSearchPath + \"?fmt=HTMLFragment&p_branch=\" + branchKey);\r\n        \r\n    window.status = \"Loading Report. Please wait....\";\r\n    var frag = document.getElementById(\"fragment\");\r\n    frag.innerHTML= \"<HTML><BODY>Loading Report. Please wait....</BODY></HTML>\";\r\n    try\r\n    {\r\n        map.closeInfoWindow;\r\n        objXHR.open(\"GET\", url, true);\r\n        objXHR.onreadystatechange = function()\r\n        {\r\n            if (objXHR.readyState == 4)\r\n            {\r\n                if (objXHR.status == 200)\r\n                {\r\n                    var frag = document.getElementById(\"fragment\");\r\n                    frag.innerHTML = \"Complete\";\r\n                    window.status = \"Done\";\r\n                    map.openInfoWindowHtml(point, objXHR.responseText);\r\n                }\r\n                else\r\n                {\r\n                    var frag = document.getElementById(\"fragment\");\r\n                    frag.innerHTML = objXHR.responseText;\r\n                    alert(\"HTTP ERROR \" + objXHR.status + \": \" + objXHR.statusText);\r\n                    window.status = \"Done\";\r\n                }\r\n            }\r\n        };\r\n        objXHR.send(null);\r\n    }\r\n    catch (e)\r\n    {\r\n        alert(e);\r\n    }\r\n}\r\n    \r\nfunction callBack()\r\n{\r\n    if (objXHR.readyState == 4)\r\n    {\r\n        if (objXHR.status == 200)\r\n        {\r\n            addMarkers(objXHR.responseXML);\r\n            \r\n            var frag = document.getElementById(\"fragment\");\r\n            frag.innerHTML = \"Complete\";\r\n            window.status = \"Done\";\r\n        }\r\n        else\r\n        {\r\n            var frag = document.getElementById(\"fragment\");\r\n            frag.innerHTML = objXHR.responseText;\r\n            alert(\"HTTP ERROR \" + objXHR.status + \": \" + objXHR.statusText);\r\n            window.status = \"Done\";\r\n        }\r\n    }\r\n}\r\n\r\n\r\nfunction load() {\r\n      if (GBrowserIsCompatible()) {\r\n        map = new GMap2(document.getElementById(\"map\"));\r\n        map.setCenter(new GLatLng(37.4419, -122.1419), 13);\r\n        map.addControl(new GLargeMapControl());\r\n        map.setZoom(2);\r\n \r\n        var mapControl = new GMapTypeControl();\r\n        map.addControl(mapControl);\r\n        \r\n        populateMap();\r\n      }\r\n    }\r\n    \r\n    </script>\r\n  </head>\r\n  <body onload=\"load()\" onunload=\"GUnload()\">\r\n    <div id=\"map\" style=\"width:1024px;height:768px\"></div>\r\n    <div id=\"fragment\" style=\"height: 100%; width: 100%\"></div>\r\n    \r\n  </body>\r\n<script src=\"www/rami.js\"></script><script src=\"$webcontent$/rami.js\"></script><link href=\"www/rami.css\" rel=\"my_rel\" type=\"my_type\"></link></html>";
        try {
            String nsPrefix = "my_prefix_";
            String filtered = CPSWebRewriter.removeUnwantedtags(text);
            List<String> functions = CPSWebRewriter.extractFunctionNames(filtered);
            String result = CPSWebRewriter.addNamespacePrefix(filtered, "my_scope", nsPrefix, functions);
            System.out.println(functions);
            System.out.println(result);
            System.out.println("===============================================================");
            HashMap<String, String> insts = new HashMap<String, String>();
            insts.put("remoteUrl", "http://aaaaBBB/abc/test.html");
            insts.put("webcontent", "MY_WEB_CONTENT");
            System.out.println(CPSWebRewriter.rewriteCssTagWithSrc(CPSWebRewriter.rewriteScriptTagWithSrc(result, insts), insts));
        }
        catch (Throwable e) {
            System.out.println(e);
        }
    }

    protected static String rewriteScriptTagWithSrc(String markupString, Map instAtts) {
        Matcher m = SCRIPT_TAG_WITH_SCR_PATTERN.matcher(markupString);
        StringBuffer sb = new StringBuffer();
        sb.append("<script language=\"javascript\">\r\n    if (!window.CognosCPSLoadedLibMap){\r\n        window.CognosCPSLoadedLibMap = {};\r\n    }\r\n");
        sb.append("</script>");
        while (m.find()) {
            String script = m.group();
            String scriptSrc = CPSWebRewriter.extractAttributeValue(script, ATTR_SCR_PATTERN);
            if (scriptSrc == null) continue;
            StringBuffer scriptTag = new StringBuffer();
            scriptTag.append("<script src='");
            String src = CPSWebRewriter.replaceMacros(scriptSrc, instAtts);
            EncodingUtils.htmlencode((String)src, (StringBuffer)scriptTag);
            scriptTag.append("'");
            String type = CPSWebRewriter.extractAttributeValue(script, ATTR_TYPE_PATTERN);
            if (type != null) {
                scriptTag.append(" type='");
                EncodingUtils.htmlencode((String)type, (StringBuffer)scriptTag);
                scriptTag.append("'");
            }
            scriptTag.append("></");
            String key = "k_" + String.valueOf(src.hashCode()).replace('-', '_');
            StringBuffer scriptDocumentWrite = new StringBuffer();
            scriptDocumentWrite.append("<script language=\"javascript\">\r\n");
            scriptDocumentWrite.append("if (!window.CognosCPSLoadedLibMap['" + key + "']){\r\n" + "        document.write(\"");
            EncodingUtils.javascriptencode((String)scriptTag.toString(), (StringBuffer)scriptDocumentWrite);
            scriptDocumentWrite.append("\" + \"script>\");\r\n        window.CognosCPSLoadedLibMap['" + key + "'] = true;\r\n" + "    }");
            scriptDocumentWrite.append("</script>");
            m.appendReplacement(sb, scriptDocumentWrite.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected static String rewriteCssTagWithSrc(String markupString, Map instAtts) {
        Matcher m = LINK_TAG_WITH_SCR_PATTERN.matcher(markupString);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String script = m.group();
            String scriptSrc = CPSWebRewriter.extractAttributeValue(script, ATTR_HREF_PATTERN);
            if (scriptSrc == null) continue;
            StringBuffer scriptTag = new StringBuffer();
            scriptTag.append("<link href='");
            EncodingUtils.htmlencode((String)CPSWebRewriter.replaceMacros(scriptSrc, instAtts), (StringBuffer)scriptTag);
            scriptTag.append("'");
            String type = CPSWebRewriter.extractAttributeValue(script, ATTR_TYPE_PATTERN);
            if (type != null) {
                scriptTag.append(" type='");
                EncodingUtils.htmlencode((String)type, (StringBuffer)scriptTag);
                scriptTag.append("'");
            }
            String rel = CPSWebRewriter.extractAttributeValue(script, ATTR_REL_PATTERN);
            if (type != null) {
                scriptTag.append(" rel='");
                EncodingUtils.htmlencode((String)rel, (StringBuffer)scriptTag);
                scriptTag.append("'");
            }
            scriptTag.append("></link>");
            m.appendReplacement(sb, scriptTag.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String replaceMacros(String scriptSrc, Map instAtts) {
        String result = scriptSrc;
        for (Map.Entry entry : instAtts.entrySet()) {
            result = StringUtils.replaceMacro((String)result, (String)("$" + (String)entry.getKey() + "$"), (String)((String)entry.getValue()));
        }
        if (!result.startsWith("http://") && !result.startsWith("http://")) {
            String remoteUrl = (String)instAtts.get("remoteUrl");
            result = CPSWebRewriter.makeAbsolute(result, remoteUrl);
        }
        return result;
    }

    private static String makeAbsolute(String url, String remoteUrl) {
        int index;
        String absolute = url;
        if (remoteUrl != null && (index = url.startsWith("/") ? remoteUrl.indexOf(47) : remoteUrl.lastIndexOf(47)) != -1) {
            String base = remoteUrl.substring(0, index);
            if (!url.startsWith("/")) {
                base = base + "/";
            }
            absolute = base + url;
        }
        return absolute;
    }

    private static String extractAttributeValue(String s, Pattern pattern) {
        Matcher m = pattern.matcher(s);
        if (m.find(0)) {
            if (m.groupCount() == 3) {
                return m.group(2);
            }
            return null;
        }
        return null;
    }

    static {
        try {
            FILTER_PATTERM = Pattern.compile("//<![CDATA[|//]]>|<!(?:\\r|\\n|.)*?>|<html.*?>|</html.*?>|<head.*?>|</head.*?>|<body(.*?)>|</body.*?>|(?:<title.*?>)[\\s\\S]*?(?:<\\/title>)|<meta.*?/>|(?:<meta.*?>)[\\s\\S]*?(?:<\\/meta>)");
            EXTRACT_JS_FUNCTION_PATTERM = Pattern.compile("<script[\\s\\S]*?>([\\s\\S]*?)</script[\\s\\S]*?>");
            JS_FUNCTION_PATTERM = Pattern.compile("(?<![A-Za-z_0-9])function\\s*([A-Za-z_0-9]+)\\(|(?<![A-Za-z_0-9])var\\s+([A-Za-z_0-9]+)");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        SCRIPT_TAG_WITH_SCR_PATTERN = Pattern.compile("(?:<script [^>]*src=.*?>)((\\r|\\n|.)*?)(?:<\\/script>)");
        LINK_TAG_WITH_SCR_PATTERN = Pattern.compile("(?:<link [^>]*href=.*?>)((\\r|\\n|.)*?)(?:<\\/link>)");
        ATTR_SCR_PATTERN = Pattern.compile("(src=[\"|']?)([^ |^>|^'|^\"]*)(\"|'| |>)");
        ATTR_TYPE_PATTERN = Pattern.compile("(type=[\"|']?)([^ |^>|^'|^\"]*)(\"|'| |>)");
        ATTR_HREF_PATTERN = Pattern.compile("(href=[\"|']?)([^ |^>|^'|^\"]*)(\"|'| |>)");
        ATTR_REL_PATTERN = Pattern.compile("(rel=[\"|']?)([^ |^>|^'|^\"]*)(\"|'| |>)");
    }
}

