/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.pagelet.assembler;

import com.cognos.cps.bseries.xts.common.CPSExceptionWrapper;
import com.cognos.cps.bseries.xts.common.cache.CacheManagerSingleton;
import com.cognos.cps.bseries.xts.common.logging.XTSServiceLoggerImpl;
import com.cognos.cps.bseries.xts.common.request.WebServiceRequest;
import com.cognos.cps.bseries.xts.pagelet.assembler.AssemblerURLRewriteHandler;
import com.cognos.cps.common.ExceptionExtension;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.pagelet.assembler.impl.AssemblerImpl;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.IServiceImplementation;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.helpers.ContextImpl;
import com.cognos.cps.services.pagelet.assembler.v1.intf.IAssembler;
import com.cognos.cps.services.pagelet.assembler.v1.types.GetPagelet;
import com.cognos.cps.services.pagelet.assembler.v1.types.GetPageletResponse;
import com.cognos.cps.services.pagelet.assembler.v1.types.InvalidCredentialsFault;
import com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.assembler.v1.types.TypeFactory;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletMarkup;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.wsrp.consumer.URLRewriteException;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import com.cognos.cps.wsrp.consumer.URLRewriter;
import com.cognos.portal.utils.TrustedSessionHelper;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.properties.PropertiesManager;
import java.io.CharArrayWriter;
import java.io.Writer;
import java.util.Map;

public class AssemblerRequest
extends WebServiceRequest {
    private IAssembler m_assembler;
    private static final String ATT_VL_BASEURL = "baseURL";
    private static final String ATT_VL_RESOURCEURL = "resourceURL";
    private static final String ATT_VL_NAMESPACEPREFIX = "namespacePrefix";
    private static final String ATT_VL_ENCODEDPAGEURL = "encodedPageURL";
    private static final String ATT_VL_ENCODEDCSSURL = "encodedCSSURL";
    private static final String ATT_VL_REWRITESTATE = "rewriteState";
    private static final String ATT_VL_STATEID = "stateID";
    private static final String ATT_VL_BACKURL = "backURL";
    private static final String ATT_VL_BACKID = "backID";
    private static final String ATT_VL_BACKTEMPLATE = "backTemplate";

    public AssemblerRequest() {
        this.m_logger = new XTSServiceLoggerImpl(AssemblerRequest.class);
    }

    @Override
    protected Object performRequest(String methodName, Object request, IContext context) throws XTSInstructionException {
        String MN = "performRequest";
        if (this.m_assembler == null) {
            this.m_logger.error(this.getDefaultExceptionCode() + " is not initialized.");
            throw new XTSInstructionException(this.getDefaultExceptionCode());
        }
        Cookie[] cookies = (Cookie[])context.getProperty("COOKIES");
        if (cookies != null) {
            int cookiesLength = cookies.length;
            for (int j = 0; j < cookiesLength; ++j) {
                if (!"usersessionid".equals(cookies[j].getName())) continue;
                String userSessionId = cookies[j].getContent();
                context.setProperty("AuthToken", (Object)TrustedSessionHelper.staticGenerateAuthToken((String)userSessionId));
                break;
            }
        }
        try {
            if (request instanceof GetPagelet) {
                return this.m_assembler.getPagelet((GetPagelet)request, context);
            }
            this.m_logger.error(MN);
            Object[] args = new String[]{this.m_identifier, methodName};
            throw new XTSInstructionException("cps.common.undefinedmethod.error", args);
        }
        catch (InvalidCredentialsFault e) {
            throw new XTSInstructionException("cps.pagelet.storage.client.failed", (Throwable)((Object)new CPSExceptionWrapper((ExceptionExtension)e)));
        }
        catch (RuntimeException runtime) {
            this.m_logger.error(MN, (Throwable)runtime);
            throw runtime;
        }
        catch (OperationFailedFault e) {
            this.m_logger.error(MN, (Throwable)e);
            Throwable root = e.getRootCause();
            if (root != null && root instanceof XTSInstructionException) {
                throw (XTSInstructionException)root;
            }
            throw new XTSInstructionException(this.getDefaultExceptionCode(), (Throwable)((Object)new CPSExceptionWrapper((ExceptionExtension)e)));
        }
    }

    @Override
    protected void processResponse(Object request, Object response, Map params, StringBuffer additionalXML) throws XTSInstructionException {
        String MN = "processPostRequest";
        String baseURL = UXTSInstructionUtils.getParameter((String)ATT_VL_BASEURL, (Map)params);
        if (baseURL != null) {
            String resourceURL = UXTSInstructionUtils.getParameter((String)ATT_VL_RESOURCEURL, (Map)params);
            String namespacePrefix = UXTSInstructionUtils.getParameter((String)ATT_VL_NAMESPACEPREFIX, (Map)params);
            String encodedPageURL = UXTSInstructionUtils.getParameter((String)ATT_VL_ENCODEDPAGEURL, (Map)params);
            String encodedCssURL = UXTSInstructionUtils.getParameter((String)ATT_VL_ENCODEDCSSURL, (Map)params);
            String rewriteState = UXTSInstructionUtils.getParameter((String)ATT_VL_REWRITESTATE, (Map)params);
            String stateID = UXTSInstructionUtils.getParameter((String)ATT_VL_STATEID, (Map)params);
            String backURL = UXTSInstructionUtils.getParameter((String)ATT_VL_BACKURL, (Map)params);
            String backTemplate = UXTSInstructionUtils.getParameter((String)ATT_VL_BACKTEMPLATE, (Map)params);
            GetPagelet getPagelet = (GetPagelet)request;
            GetPageletResponse getPageletResponse = (GetPageletResponse)response;
            PageletMarkup markup = getPageletResponse.getPageletMarkup();
            if (markup != null && markup.getMarkupString() != null) {
                PageletContext pageletContext;
                boolean rewriteStateEnabled = "true".equals(rewriteState);
                byte[] state = rewriteStateEnabled ? (getPageletResponse.getUpdateResponse() != null && getPageletResponse.getUpdateResponse().getPageletContext() != null && getPageletResponse.getUpdateResponse().getPageletContext().getState() != null ? getPageletResponse.getUpdateResponse().getPageletContext().getState() : ((pageletContext = getPagelet.getPageletContext()) != null && pageletContext.getState() != null ? pageletContext.getState() : null)) : null;
                boolean isPreviewMode = getPagelet.getPageletParams() != null && "cps:preview".equals(getPagelet.getPageletParams().getPageletMode());
                try {
                    AssemblerURLRewriteHandler handler = new AssemblerURLRewriteHandler(baseURL, resourceURL, namespacePrefix, encodedPageURL, encodedCssURL, state, rewriteStateEnabled ? stateID : null, isPreviewMode, backURL, backTemplate, getPagelet.getPortalContext());
                    AssemblerRequest.rewriteMarkup(markup, handler, getPageletResponse);
                    if (handler.hasNewBackURL()) {
                        additionalXML.append("<backContext><id>");
                        EncodingUtils.xmlEncode((String)handler.getBackID(), (StringBuffer)additionalXML);
                        additionalXML.append("</id><newBack>");
                        EncodingUtils.xmlEncode((String)handler.getNewBackURL(), (StringBuffer)additionalXML);
                        additionalXML.append("</newBack><saveBack>");
                        EncodingUtils.xmlEncode((String)backURL, (StringBuffer)additionalXML);
                        additionalXML.append("</saveBack></backContext>");
                    }
                }
                catch (URLRewriteException e) {
                    this.m_logger.error(MN, (Throwable)e);
                    Object[] args = new String[]{this.m_identifier};
                    throw new XTSInstructionException(this.getDefaultExceptionCode(), args, (Throwable)((Object)new CPSExceptionWrapper((ExceptionExtension)e)));
                }
            }
        }
    }

    private static void rewriteMarkup(PageletMarkup markup, AssemblerURLRewriteHandler handler, GetPageletResponse getPageletResponse) throws URLRewriteException {
        URLRewriter rewriter = new URLRewriter((URLRewriteHandler)handler, null);
        CharArrayWriter out = new CharArrayWriter();
        rewriter.rewrite(markup.getMarkupString(), (Writer)out);
        if (handler.isOverFlow()) {
            handler.calculateRecoverableOverFlowOp();
            out = new CharArrayWriter();
            rewriter.rewrite(markup.getMarkupString(), (Writer)out);
        }
        markup.setMarkupString(out.toString());
        if (handler.canEraseState() && getPageletResponse.getUpdateResponse() != null) {
            getPageletResponse.getUpdateResponse().setPageletContext(null);
        }
    }

    @Override
    protected String getDefaultExceptionCode() {
        return "cps.pagelet.assembler.operation.failed";
    }

    @Override
    protected String getComponentName() {
        return "assembler";
    }

    @Override
    protected SOAPObjectHandler getTypeFactory() {
        return TypeFactory.newInstance();
    }

    @Override
    protected String getTypeFactoryNamespace() {
        return "http://developer.cognos.com/schemas/cps/asm/assembler/1/";
    }

    @Override
    public synchronized void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        String MN = "initialize";
        super.initialize(env, identifier, instAtts, instParams);
        try {
            int cacheValue;
            ContextImpl context = new ContextImpl();
            context.setProperty("XTS_ENV", (Object)env);
            context.setProperty("XTS_IDENTIFIER", (Object)identifier);
            String value = PropertiesManager.getInstance().getProperty("CPSMaxCacheSizePerPortlet");
            try {
                cacheValue = value != null ? Integer.parseInt(value) : -1;
            }
            catch (NumberFormatException e) {
                cacheValue = -1;
            }
            if (cacheValue != 0) {
                context.setProperty("CACHE_MANAGER", (Object)CacheManagerSingleton.getInstance());
                if (cacheValue > 0) {
                    context.setProperty("CACHE_MAXSIZEPERPORTLET", (Object)new Integer(cacheValue));
                }
            }
            value = PropertiesManager.getInstance().getProperty("CPSAllowPortletStateChange");
            context.setProperty("ALLOW_PORTLET_STATE_CHANGE", (Object)Boolean.valueOf(value));
            this.m_assembler = new AssemblerImpl(this.m_logger);
            ((IServiceImplementation)this.m_assembler).initialize((IContext)context);
        }
        catch (ServiceException e) {
            this.m_logger.error(MN, (Throwable)e);
            this.m_assembler = null;
        }
    }

    @Override
    public synchronized void terminate() throws XTSInstructionException {
        String MN = "terminate";
        super.terminate();
        if (this.m_assembler != null) {
            try {
                ((IServiceImplementation)this.m_assembler).terminate();
            }
            catch (ServiceException e) {
                this.m_logger.error(MN, (Throwable)e);
            }
            this.m_assembler = null;
        }
    }
}

