/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.pagelet.assembler;

import com.cognos.caf.CAFLibrary;
import com.cognos.caf.CAFLibraryException;
import com.cognos.cps.services.pagelet.objects.v1.types.Param;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalContext;
import com.cognos.cps.wsrp.consumer.URLRewriteException;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.TrustedSessionHelper;
import com.cognos.xts.ext.URLEncoderDecoder;
import com.cognos.xts.ext.XTSExt;
import com.cognos.xts.ext.base64;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public class AssemblerURLRewriteHandler
implements URLRewriteHandler {
    private static final String BACKID_MARKER = "{backID}";
    private static final int MAX_URL_LENGTH = 2048;
    private static final int OP_SAVE_NONE = 1;
    private static final int OP_SAVE_STATE = 2;
    private static final int OP_SAVE_BACKURL = 4;
    private String m_baseURL = null;
    private String m_resourceURL = null;
    private String m_namespacePrefix = null;
    private String m_encodedPageURL = null;
    private String m_encodedCssURL = null;
    private String m_state = null;
    private String m_stateID = null;
    private boolean m_isPreviewMode = false;
    private boolean m_overflow = false;
    private boolean m_retry = false;
    private int m_operation = 1;
    private int m_maxUrlLength;
    private String m_backURL;
    private String m_backID;
    private String m_backTemplate;
    private PortalContext m_portalContext;

    public AssemblerURLRewriteHandler(String baseURL, String resourceURL, String namespacePrefix, String encodedPageURL, String encodedCssURL, byte[] state, String stateID, boolean isPreviewMode, String backURL, String backTemplate, PortalContext aContext) {
        this.m_portalContext = aContext;
        this.m_baseURL = baseURL;
        this.m_resourceURL = resourceURL;
        this.m_namespacePrefix = namespacePrefix;
        this.m_encodedPageURL = encodedPageURL;
        this.m_encodedCssURL = encodedCssURL;
        this.m_isPreviewMode = isPreviewMode;
        this.m_stateID = stateID;
        if (state != null) {
            try {
                this.m_state = URLEncoderDecoder.encode((String)base64.encode((int)0, (byte[])state), (String)"UTF-8", (boolean)false);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (backURL != null) {
            try {
                this.m_backURL = URLEncoderDecoder.encode((String)backURL, (String)"UTF-8", (boolean)false);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.m_backTemplate = backTemplate;
    }

    public void generateURL(Map urlParams, Writer result, String rewriteFlags) throws URLRewriteException {
        char paramSep;
        StringBuffer paramsBuffer;
        boolean isResource;
        String mode = EncodingUtils.urldecode((String)((String)urlParams.get("wsrp-mode")), (String)"UTF8");
        String cpsAction = EncodingUtils.urldecode((String)((String)urlParams.get("cps-action")), (String)"UTF8");
        String encodedUrlType = (String)urlParams.get("wsrp-urlType");
        boolean isHelpMode = "wsrp:help".equals(mode);
        boolean isReset = "reset".equals(cpsAction);
        if (isHelpMode) {
            urlParams.put("wsrp-windowState", "wsrp:normal");
            urlParams.put("rui", "hh");
            urlParams.put("m_state", "");
        } else if (this.m_isPreviewMode) {
            urlParams.put("wsrp-mode", "wsrp:preview");
            urlParams.put("m_pagemode", "preview");
        }
        if (this.m_encodedPageURL != null && this.m_encodedPageURL.length() > 0) {
            urlParams.put("cps-page", this.m_encodedPageURL);
        }
        if (this.m_encodedCssURL != null && this.m_encodedCssURL.length() > 0) {
            urlParams.put("cps-style", this.m_encodedCssURL);
        }
        if (this.m_state != null && !isHelpMode) {
            urlParams.put("m_state", isReset ? "" : this.m_state);
        }
        if (!(this.m_backURL == null || isHelpMode || rewriteFlags != null && rewriteFlags.indexOf("b0") != -1)) {
            urlParams.put("backURL", this.m_backURL);
        }
        String scriptName = (isResource = "resource".equals(encodedUrlType)) ? this.m_resourceURL : this.m_baseURL;
        String wsrpURL = (String)urlParams.get("wsrp-url");
        if (isResource && wsrpURL != null && !wsrpURL.startsWith("http://") && !wsrpURL.startsWith("https://")) {
            StringBuffer aBuff = new StringBuffer();
            Param[] params = this.m_portalContext.getParam();
            for (int i = 0; i < params.length; ++i) {
                if (!"webContentURL".equals(params[i].getName())) continue;
                aBuff.append(params[i].getContent());
                aBuff.append("/");
            }
            aBuff.append(wsrpURL);
            try {
                result.write(aBuff.toString());
            }
            catch (IOException e) {
                throw new URLRewriteException("cps.wsrp.consumer.rewriteioerror", (Throwable)e);
            }
            return;
        }
        int index = scriptName.indexOf(63);
        if (index > 0) {
            paramsBuffer = new StringBuffer(scriptName.substring(index + 1));
            scriptName = scriptName.substring(0, index);
            paramSep = '&';
        } else {
            paramsBuffer = new StringBuffer();
            paramSep = '?';
        }
        Map.Entry pair = null;
        Iterator it = urlParams.entrySet().iterator();
        while (it.hasNext()) {
            paramsBuffer.append(paramSep);
            pair = it.next();
            String name = (String)pair.getKey();
            String value = (String)pair.getValue();
            paramsBuffer.append(name);
            paramsBuffer.append('=');
            paramsBuffer.append(value);
            paramSep = '&';
            if (!isResource || !"wsrp-url".equals(name)) continue;
            paramsBuffer.append(paramSep);
            paramsBuffer.append("cps-urltoken");
            paramsBuffer.append('=');
            String decodedValue = value != null ? EncodingUtils.urldecode((String)value, (String)"UTF8") : "";
            paramsBuffer.append(EncodingUtils.urlencode((String)TrustedSessionHelper.staticCreateBase64HMAC((String)decodedValue), (String)"UTF8", (boolean)false));
        }
        try {
            int length;
            String parameters = paramsBuffer.toString();
            if (rewriteFlags == null || rewriteFlags.indexOf("p0") == -1) {
                parameters = CAFLibrary.tpXSSEncode((String)parameters);
            }
            if ((length = parameters.length() + scriptName.length() + 1) > 2048) {
                this.m_overflow = true;
                if (this.m_retry) {
                    throw new URLRewriteOverflowException();
                }
            }
            if (this.m_overflow) {
                int n = this.m_maxUrlLength = this.m_maxUrlLength > length ? this.m_maxUrlLength : length;
            }
            if (isHelpMode || isReset) {
                result.write("javascript:");
                this.generateUniquePortletId(result);
                result.write(isReset ? "reset('" : "popup('");
                result.write(URLEncoderDecoder.encode((String)scriptName, (String)"UTF-8", (boolean)false));
                result.write("%3f");
                result.write(URLEncoderDecoder.encode((String)parameters, (String)"UTF-8", (boolean)false));
                result.write("');");
            } else {
                result.write(scriptName);
                result.write("?");
                result.write(parameters);
            }
        }
        catch (CAFLibraryException e) {
            throw new URLRewriteException("cps.wsrp.consumer.rewriteioerror", (Throwable)e);
        }
        catch (IOException e) {
            throw new URLRewriteException("cps.wsrp.consumer.rewriteioerror", (Throwable)e);
        }
    }

    public void generateUniquePortletId(Writer result) throws URLRewriteException {
        try {
            if (this.m_namespacePrefix != null) {
                result.write(this.m_namespacePrefix);
            } else {
                result.write("p" + Integer.toString(this.hashCode()).replace("-", "_"));
            }
        }
        catch (IOException e) {
            throw new URLRewriteException("cps.wsrp.consumer.rewriteioerror", (Throwable)e);
        }
    }

    public boolean isOverFlow() {
        return this.m_overflow;
    }

    public void calculateRecoverableOverFlowOp() throws URLRewriteException {
        if (this.m_overflow && !this.m_retry) {
            int index;
            this.m_retry = true;
            String sessionBackUrl = null;
            this.m_backID = XTSExt.generateGUID();
            if (this.m_backTemplate != null && this.m_backTemplate.length() > 0 && (index = this.m_backTemplate.indexOf(BACKID_MARKER)) != -1) {
                try {
                    String newBackURL = this.m_backTemplate.substring(0, index) + this.m_backID + this.m_backTemplate.substring(index + BACKID_MARKER.length(), this.m_backTemplate.length());
                    sessionBackUrl = URLEncoderDecoder.encode((String)newBackURL, (String)"UTF-8", (boolean)false);
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.m_operation = this.getRecoverOperation(sessionBackUrl);
            if ((this.m_operation & 4) == 4) {
                this.m_backURL = sessionBackUrl;
            }
            if ((this.m_operation & 2) == 2) {
                this.m_state = this.m_stateID;
            }
            this.m_maxUrlLength = 0;
            this.m_overflow = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getRecoverOperation(String sessionBackUrl) throws URLRewriteException {
        boolean canSaveBack;
        int operation = 1;
        if (!this.m_overflow) return operation;
        int stateLength = (this.m_state != null ? this.m_state.length() : 0) + 9;
        int stateIDLength = (this.m_stateID != null ? this.m_stateID.length() : 0) + 9;
        int backLength = (this.m_backURL != null ? this.m_backURL.length() : 0) + 9;
        int sessionBackLength = (sessionBackUrl != null ? sessionBackUrl.length() : 0) + 9;
        int fixedLength = this.m_maxUrlLength;
        fixedLength -= stateLength;
        fixedLength -= backLength;
        boolean canSaveState = this.m_stateID != null && this.m_stateID.length() > 0;
        boolean bl = canSaveBack = sessionBackUrl != null && sessionBackLength < backLength;
        if (canSaveState) {
            if (canSaveBack) {
                if (fixedLength + backLength + stateLength <= 2048) return operation;
                if (fixedLength + sessionBackLength + stateLength < 2048) {
                    return 4;
                }
                if (fixedLength + backLength + stateIDLength < 2048) {
                    return 2;
                }
                if (fixedLength + sessionBackLength + stateIDLength >= 2048) throw new URLRewriteOverflowException();
                return 6;
            }
            if (fixedLength + backLength + stateLength <= 2048) return operation;
            if (fixedLength + backLength + stateIDLength <= 2048) return 2;
            throw new URLRewriteOverflowException();
        }
        if (canSaveBack) {
            if (fixedLength + backLength <= 2048) return operation;
            if (fixedLength + sessionBackLength <= 2048) return 4;
            throw new URLRewriteOverflowException();
        }
        if (fixedLength + backLength + stateLength <= 2048) return operation;
        throw new URLRewriteOverflowException();
    }

    public boolean hasNewBackURL() {
        return (this.m_operation & 4) == 4;
    }

    public String getBackID() {
        return this.m_backID;
    }

    public String getNewBackURL() {
        if (this.m_backURL != null) {
            try {
                return URLEncoderDecoder.decode((String)this.m_backURL, (String)"UTF-8");
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean canEraseState() {
        return this.m_state != null && (this.m_operation & 2) != 2;
    }

    public class URLRewriteOverflowException
    extends URLRewriteException {
        public URLRewriteOverflowException() {
            super("cps.wsrp.consumer.rewriteioerror");
        }
    }
}

