/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.pagelet.consumer;

import com.cognos.cps.bseries.xts.common.CPSExceptionWrapper;
import com.cognos.cps.bseries.xts.common.cache.CacheManagerSingleton;
import com.cognos.cps.bseries.xts.common.logging.XTSServiceLoggerImpl;
import com.cognos.cps.bseries.xts.common.request.WebServiceRequest;
import com.cognos.cps.common.ExceptionExtension;
import com.cognos.cps.pagelet.consumer.impl.ConsumerImpl;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.IServiceImplementation;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.helpers.ContextImpl;
import com.cognos.cps.services.pagelet.consumer.v1.intf.IConsumer;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkup;
import com.cognos.cps.services.pagelet.consumer.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.consumer.v1.types.TypeFactory;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.properties.PropertiesManager;
import java.util.Map;

public class ConsumerRequest
extends WebServiceRequest {
    private IConsumer m_consumer;

    public ConsumerRequest() {
        this.m_logger = new XTSServiceLoggerImpl(ConsumerRequest.class);
    }

    @Override
    protected Object performRequest(String methodName, Object request, IContext context) throws XTSInstructionException {
        String MN = "performRequest";
        if (this.m_consumer == null) {
            this.m_logger.error(this.getDefaultExceptionCode() + " is not initialized.");
            throw new XTSInstructionException(this.getDefaultExceptionCode());
        }
        try {
            if (request instanceof GetMarkup) {
                return this.m_consumer.getMarkup((GetMarkup)request, context);
            }
            this.m_logger.error(MN);
            Object[] args = new String[]{this.m_identifier, methodName};
            throw new XTSInstructionException("cps.common.undefinedmethod.error", args);
        }
        catch (RuntimeException runtime) {
            this.m_logger.error(MN, (Throwable)runtime);
            throw runtime;
        }
        catch (OperationFailedFault e) {
            this.m_logger.error(MN, (Throwable)e);
            Throwable root = e.getRootCause();
            if (root != null && root instanceof XTSInstructionException) {
                throw (XTSInstructionException)root;
            }
            throw new XTSInstructionException(this.getDefaultExceptionCode(), (Throwable)((Object)new CPSExceptionWrapper((ExceptionExtension)e)));
        }
    }

    @Override
    protected void processResponse(Object request, Object response, Map params, StringBuffer additionalXML) throws XTSInstructionException {
    }

    @Override
    protected String getDefaultExceptionCode() {
        return "cps.pagelet.consumer.operation.failed";
    }

    @Override
    protected String getComponentName() {
        return "consumer";
    }

    @Override
    protected SOAPObjectHandler getTypeFactory() {
        return TypeFactory.newInstance();
    }

    @Override
    protected String getTypeFactoryNamespace() {
        return "http://developer.cognos.com/schemas/cps/asm/consumer/1/";
    }

    @Override
    public synchronized void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        String MN = "initialize";
        super.initialize(env, identifier, instAtts, instParams);
        try {
            int cacheValue;
            ContextImpl context = new ContextImpl();
            context.setProperty("XTS_ENV", (Object)env);
            context.setProperty("XTS_IDENTIFIER", (Object)identifier);
            String value = PropertiesManager.getInstance().getProperty("CPSMaxCacheSizePerPortlet");
            try {
                cacheValue = value != null ? Integer.parseInt(value) : -1;
            }
            catch (NumberFormatException e) {
                cacheValue = -1;
            }
            if (cacheValue != 0) {
                context.setProperty("CACHE_MANAGER", (Object)CacheManagerSingleton.getInstance());
                if (cacheValue > 0) {
                    context.setProperty("CACHE_MAXSIZEPERPORTLET", (Object)new Integer(cacheValue));
                }
            }
            this.m_consumer = new ConsumerImpl(this.m_logger);
            ((IServiceImplementation)this.m_consumer).initialize((IContext)context);
        }
        catch (ServiceException e) {
            this.m_logger.error(MN, (Throwable)e);
            this.m_consumer = null;
        }
    }

    @Override
    public synchronized void terminate() throws XTSInstructionException {
        String MN = "terminate";
        super.terminate();
        if (this.m_consumer != null) {
            try {
                ((IServiceImplementation)this.m_consumer).terminate();
            }
            catch (ServiceException e) {
                this.m_logger.error(MN, (Throwable)e);
            }
            this.m_consumer = null;
        }
    }
}

