/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.pagelet.storage;

import com.cognos.caf.CAFLibrary;
import com.cognos.caf.CAFLibraryException;
import com.cognos.cps.bseries.xts.common.sax.IObjectFactory;
import com.cognos.cps.bseries.xts.pagelet.storage.sax.ObjectFactory;
import com.cognos.cps.bseries.xts.request.nav.bus.xmlHandler.BusHeaderXMLHandler;
import com.cognos.cps.bseries.xts.request.nav.bus.xmlHandler.CMResponseXMLHandler;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.pagelet.storage.v1.types.InvalidCredentialsFault;
import com.cognos.cps.services.pagelet.storage.v1.types.OperationFailedFault;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.bus.cm.SimpleQuery;
import com.cognos.portal.utils.MessagesManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CMRequest {
    public static final int TRUST_NONE = 0;
    public static final int TRUST_SERVER = 1;
    public static final int TRUST_CONSUMER = 2;
    private static final String CM_TARGET = "bus://cm";
    private static final String TRUSTED_SOAP_HEADERS = "<bus:biBusHeader xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"/>";
    private ServiceLogger m_logger;
    private IObjectFactory objectFactory = ObjectFactory.getInstance();

    public CMRequest(com.cognos.cps.common.logging.ServiceLogger logger) {
        this.m_logger = new ServiceLoggerImpl(CMRequest.class);
    }

    public CMRequest(ServiceLogger logger) {
        this.m_logger = logger != null ? logger.cloneForClass(CMRequest.class) : new ServiceLoggerImpl(CMRequest.class);
    }

    public void setObjectFactory(IObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public synchronized void initialize(IContext context) throws ServiceException {
    }

    public synchronized void terminate() throws ServiceException {
    }

    public void send(IContext context, String request, int trustLevel) throws OperationFailedFault, InvalidCredentialsFault {
        SimpleQuery query = new SimpleQuery();
        this.send(context, request, trustLevel, false, query);
    }

    public List send(IContext context, String request, int trustLevel, boolean updateRequest) throws OperationFailedFault, InvalidCredentialsFault {
        SimpleQuery query = new SimpleQuery();
        BusHeaderXMLHandler busHeaderXMLHandler = new BusHeaderXMLHandler();
        CMResponseXMLHandler bodyXMLHandler = new CMResponseXMLHandler(true, updateRequest ? "updateResult" : "queryResult", this.objectFactory);
        query.setResponseHeaderHandler((IXMLHandler)busHeaderXMLHandler);
        query.setResponseBodyHandler((IXMLHandler)bodyXMLHandler);
        this.send(context, request, trustLevel, updateRequest, query);
        return bodyXMLHandler.getCMResponse().getAllObjects();
    }

    protected void send(IContext context, String request, int trustLevel, boolean updateRequest, SimpleQuery query) throws OperationFailedFault, InvalidCredentialsFault {
        String MN = "sendCMRequest";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
            this.m_logger.debug("request is: " + request);
        }
        SOAPConnection connection = null;
        Object hdr = null;
        switch (trustLevel) {
            case 2: {
                connection = ((SOAPConnectionFactory)context.getProperty("consumerTrustedSoapConnectionFactory")).createConnection(this.m_logger);
                hdr = context.getProperty("BUS_HEADER");
                if (hdr == null) {
                    hdr = TRUSTED_SOAP_HEADERS;
                }
                query.setBusHeader((Object)hdr.toString());
                break;
            }
            case 1: {
                connection = ((SOAPConnectionFactory)context.getProperty("trustedSoapConnectionFactory")).createConnection(this.m_logger);
                hdr = context.getProperty("BUS_HEADER");
                if (hdr == null) {
                    hdr = TRUSTED_SOAP_HEADERS;
                }
                query.setBusHeader((Object)hdr.toString());
                if (!this.m_logger.isDebugEnabled()) break;
                this.m_logger.debug("using trusted request");
                break;
            }
            case 0: {
                connection = ((SOAPConnectionFactory)context.getProperty("SoapConnectionFactory")).createConnection(this.m_logger);
                query.setBusHeader((Object)context.getProperty("BUS_HEADER").toString());
            }
        }
        query.setBody(request);
        query.setSOAPAction("http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201904/");
        try {
            connection.execute((SOAPMessage)query, CM_TARGET);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.exit(MN);
            }
        }
        catch (SOAPFault e) {
            this.m_logger.error(MN, (Throwable)e);
            this.m_logger.error("fault: " + e.toString());
            Element detailElement = null;
            SAXReader saxreader = new SAXReader();
            try {
                detailElement = saxreader.read((Reader)new StringReader(e.getDetail())).getRootElement();
            }
            catch (DocumentException e1) {
                throw new OperationFailedFault("cps.common.parse.error", (Object[])new String[]{CMRequest.class.getName()}, (Throwable)e1);
            }
            String detailErrorMessage = detailElement.valueOf("*[local-name()='message']/*[local-name()='messageString']");
            if (detailErrorMessage == null || detailErrorMessage.length() == 0) {
                detailErrorMessage = detailElement.valueOf("*[local-name()='exception']/*[local-name()='message']/*[local-name()='messageString']");
            }
            if (detailErrorMessage != null && detailErrorMessage.length() > 0) {
                try {
                    Document busHeaderDoc = DocumentHelper.parseText((String)hdr.toString());
                    BIBusEnvelope envelope = new BIBusEnvelope();
                    envelope.setBIBusHeader(busHeaderDoc.getRootElement());
                    detailErrorMessage = this.secureLogError(envelope, detailErrorMessage);
                }
                catch (Throwable e2) {
                    this.m_logger.error(MN, (Throwable)e);
                }
                if (detailErrorMessage.startsWith("CM-REQ-4011") || detailErrorMessage.startsWith("CM-REQ-4012") || detailErrorMessage.startsWith("CM-REQ-4013") || detailErrorMessage.startsWith("CM-REQ-4014")) {
                    throw new OperationFailedFault("cps.pagelet.storage.nopermission.failed", null, null);
                }
                if (detailErrorMessage.startsWith("CM-REQ-4024")) {
                    throw new OperationFailedFault("cps.pagelet.storage.create.duplicate.failed", null, null);
                }
                if (detailErrorMessage.startsWith("CM-REQ-4023")) {
                    throw new OperationFailedFault("cps.pagelet.storage.create.failed", null, null);
                }
                if (detailErrorMessage.startsWith("CM-REQ-4159")) {
                    throw new InvalidCredentialsFault("cps.pagelet.storage.client.failed", null, null);
                }
            }
            throw new OperationFailedFault("cps.pagelet.storage.cm.failed", (Object[])new String[]{detailErrorMessage}, null);
        }
        catch (MalformedURLException e) {
            this.m_logger.error(MN, (Throwable)e);
            throw new OperationFailedFault("cps.common.parse.error", null, (Throwable)e);
        }
        catch (IOException e) {
            this.m_logger.error(MN, (Throwable)e);
            throw new OperationFailedFault("cps.pagelet.storage.cm.failed", null, (Throwable)e);
        }
        catch (XMLStreamException e) {
            this.m_logger.error(MN, (Throwable)e);
            throw new OperationFailedFault("cps.common.parse.error", null, (Throwable)e);
        }
    }

    private String secureLogError(BIBusEnvelope bibusEnv, String error) throws CAFLibraryException {
        String securedErrorMsg = CAFLibrary.secureError((String)error, (BIBusEnvelope)bibusEnv);
        if (securedErrorMsg != null) {
            String locale = bibusEnv.getUserPreferenceValue("productLocale");
            if (locale == null) {
                locale = "en";
            }
            securedErrorMsg = MessagesManager.getInstance().getMessage(locale, "pf.common.securelog.errormsg", (Object[])new String[]{securedErrorMsg});
        } else {
            securedErrorMsg = error;
        }
        return securedErrorMsg;
    }
}

