/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.pagelet.storage;

import com.cognos.cps.bseries.xts.common.logging.XTSServiceLoggerImpl;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.pagelet.storage.CMRequest;
import com.cognos.cps.bseries.xts.pagelet.storage.helpers.CMRequestHelper;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.pagelet.storage.common.Cache;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.pagelet.objects.v1.types.Fault;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.xts.properties.PropertiesManager;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ProducerCache {
    private static final long EXPIRY_INTERVAL_DEFAULT = 7200L;
    private static final long TIME_TO_IDLE_DEFAULT = 86400L;
    private static final long TIME_TO_VALIDATE_DEFAULT = 3600L;
    private static ProducerCache INSTANCE;
    private ServiceLogger m_logger = new XTSServiceLoggerImpl(ProducerCache.class);
    private Map m_cache;
    private long validationInterval = this.timeToValidateSecs() * 1000L;

    public static synchronized ProducerCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProducerCache();
        }
        return INSTANCE;
    }

    private ProducerCache() {
        long expiryInterval = this.checkExpiryIntervalSecs();
        long timeToIdle = this.timeToIdleSecs();
        this.m_cache = new Cache(expiryInterval, timeToIdle);
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("producer cache cleanup interval : " + expiryInterval);
            this.m_logger.debug("producer cache max idle time : " + timeToIdle);
            this.m_logger.debug("producer cache validate time : " + this.timeToValidateSecs());
        }
    }

    private long checkExpiryIntervalSecs() {
        String sCheckExpiryIntervalSecs = PropertiesManager.getInstance().getProperty("properties.config.cps.storage.cache.checkExpiryIntervalSeconds");
        if (sCheckExpiryIntervalSecs != null) {
            try {
                return Long.parseLong(sCheckExpiryIntervalSecs);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 7200L;
    }

    private long timeToIdleSecs() {
        String sTimeToIdleSecs = PropertiesManager.getInstance().getProperty("properties.config.cps.storage.cache.timeToIdleSeconds");
        if (sTimeToIdleSecs != null) {
            try {
                return Long.parseLong(sTimeToIdleSecs);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 86400L;
    }

    private long timeToValidateSecs() {
        String sTimeToValidateSecs = PropertiesManager.getInstance().getProperty("properties.config.cps.storage.cache.timeToValidateSeconds");
        if (sTimeToValidateSecs != null) {
            try {
                return Long.parseLong(sTimeToValidateSecs);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 3600L;
    }

    public void cacheProducer(String storeID, String modificationDate, PortletProducer producer) {
        String MN = "cacheProducer";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
            this.m_logger.debug("storeID: " + storeID);
        }
        if (this.m_cache != null && producer != null) {
            PortletProducer clonedPortletProducer = new PortletProducer();
            clonedPortletProducer.setBinding(producer.getBinding());
            clonedPortletProducer.setDescription(producer.getDescription());
            clonedPortletProducer.setId(producer.getId());
            clonedPortletProducer.setName(producer.getName());
            clonedPortletProducer.setPath(producer.getPath());
            clonedPortletProducer.setRegistration(producer.getRegistration());
            clonedPortletProducer.setServiceDescription(producer.getServiceDescription());
            this.m_cache.put(storeID, new ProducerEntry(clonedPortletProducer, modificationDate));
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
    }

    public void removeProducerFromCache(String key) {
        if (this.m_cache != null && this.m_cache.containsKey(key)) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("removing producer from cache: " + key);
            }
            this.m_cache.remove(key);
        }
    }

    public PortletProducer getProducerFromCache(String key, IContext context, CMRequest cmRequest) {
        ProducerEntry producerEntry;
        String MN = "getProducerFromCache";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
            this.m_logger.debug("key: " + key);
        }
        PortletProducer clonedPortletProducer = null;
        if (this.m_cache != null && (producerEntry = (ProducerEntry)this.m_cache.get(key)) != null) {
            boolean valid = this.validateCachedProducer(producerEntry, context, cmRequest);
            if (!valid) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("The cached producer is not valid anymore, maybe it was modified or deleted. Removing it from cache");
                }
                this.removeProducerFromCache(key);
                return null;
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("found producer in cache: " + key);
            }
            PortletProducer producer = producerEntry.producer;
            clonedPortletProducer = new PortletProducer();
            clonedPortletProducer.setBinding(producer.getBinding());
            clonedPortletProducer.setDescription(producer.getDescription());
            clonedPortletProducer.setId(producer.getId());
            clonedPortletProducer.setName(producer.getName());
            clonedPortletProducer.setPath(producer.getPath());
            clonedPortletProducer.setRegistration(producer.getRegistration());
            clonedPortletProducer.setServiceDescription(producer.getServiceDescription());
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return clonedPortletProducer;
    }

    private boolean validateCachedProducer(ProducerEntry entry, IContext context, CMRequest cmRequest) {
        String MN = "validateCachedProducer";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("Modification time is: " + entry.validateString);
            this.m_logger.debug("Last validated: " + new Date(entry.lastValidated));
        }
        if (System.currentTimeMillis() - entry.lastValidated > this.validationInterval) {
            block11: {
                try {
                    String request = CMRequestHelper.getValidateProducerRequest(entry.producer.getPath());
                    List producers = cmRequest.send(context, request, 1, false);
                    if (producers.size() > 0) {
                        GenericCMObject cmObject = (GenericCMObject)producers.get(0);
                        String newModificationTime = cmObject.getParameter("modificationTime", "");
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug("New modification time is: " + newModificationTime);
                        }
                        if (!newModificationTime.equals(entry.validateString)) {
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug("Modification time is different");
                            }
                            return false;
                        }
                        break block11;
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("No producers returned in the cache validation response");
                    }
                    return false;
                }
                catch (Fault e) {
                    if (this.m_logger.isErrorEnabled()) {
                        this.m_logger.error("Error while validating cached producer. The producer will be removed from the cache", (Throwable)e);
                    }
                    return false;
                }
            }
            entry.lastValidated = System.currentTimeMillis();
        }
        return true;
    }

    private class ProducerEntry {
        long lastValidated = System.currentTimeMillis();
        String validateString;
        PortletProducer producer;

        public ProducerEntry(PortletProducer producer, String validateString) {
            this.validateString = validateString;
            this.producer = producer;
        }
    }
}

