/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.pagelet.storage;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.pagelet.storage.common.AsmTypeHelper;
import com.cognos.cps.pagelet.storage.impl.StorageImpl;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalPackage;
import com.cognos.xts.resource.XTSResourceManager;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StaticStorage
extends StorageImpl {
    public StaticStorage(ServiceLogger logger) {
        super(logger);
    }

    @Override
    public void initialize(IContext context) throws ServiceException {
        String path = this.getPackagePath(context);
        try {
            InputStream inputStream = XTSResourceManager.getInstance().getResource(path);
            if (inputStream == null) {
                this.logger.error("Cannot find portal package: " + path);
                Object[] args = new String[]{StaticStorage.class.toString()};
                throw new ServiceException("cps.services.initializefailed", args);
            }
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            this.portalPackage = (PortalPackage)AsmTypeHelper.deserializeAsmObj(reader, "portalPackage");
        }
        catch (Exception e) {
            this.logger.error("Could not load portal package : " + path, (Throwable)e);
            Object[] args = new String[]{StaticStorage.class.toString(), e.getLocalizedMessage()};
            throw new ServiceException("cps.services.initializefailed", args);
        }
    }
}

