/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.pagelet.storage;

import com.cognos.cps.bseries.xts.common.logging.XTSServiceLoggerImpl;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.pagelet.storage.CMRequest;
import com.cognos.cps.bseries.xts.pagelet.storage.ProducerCache;
import com.cognos.cps.bseries.xts.pagelet.storage.helpers.CMRequestHelper;
import com.cognos.cps.bseries.xts.pagelet.storage.helpers.OperationHelper;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.SmallMap;
import com.cognos.cps.pagelet.storage.common.AsmTypeHelper;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.IServiceImplementation;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.pagelet.objects.v1.types.Binding;
import com.cognos.cps.services.pagelet.objects.v1.types.Description;
import com.cognos.cps.services.pagelet.objects.v1.types.Layout;
import com.cognos.cps.services.pagelet.objects.v1.types.Metadata;
import com.cognos.cps.services.pagelet.objects.v1.types.Name;
import com.cognos.cps.services.pagelet.objects.v1.types.Pagelet;
import com.cognos.cps.services.pagelet.objects.v1.types.Portlet;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletInstance;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.cps.services.pagelet.objects.v1.types.Registration;
import com.cognos.cps.services.pagelet.objects.v1.types.ScreenTip;
import com.cognos.cps.services.pagelet.storage.v1.intf.IStorage;
import com.cognos.cps.services.pagelet.storage.v1.types.InvalidCredentialsFault;
import com.cognos.cps.services.pagelet.storage.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPagelet;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPageletResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPortletProducer;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPortletProducerResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveBinding;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveBindingResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveContext;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveContextResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortlet;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletProducer;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletProducerResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveRegistration;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveRegistrationResponse;
import com.cognos.portal.utils.capability.RequiredCapabilities;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class Storage
implements IStorage,
IServiceImplementation {
    public static final String PORTLET_VIRTUAL_ID = "PORTLETID";
    private ServiceLogger m_logger;
    protected CMRequest cmRequest;

    public Storage(ServiceLogger logger) {
        this.m_logger = logger != null ? logger.cloneForClass(Storage.class) : new XTSServiceLoggerImpl(Storage.class);
    }

    public synchronized void initialize(IContext context) throws ServiceException {
        String MN = "initialize";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        this.cmRequest = new CMRequest(this.m_logger);
        this.cmRequest.initialize(context);
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
    }

    public synchronized void terminate() throws ServiceException {
        String MN = "terminate";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        this.cmRequest.terminate();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
    }

    public QueryPageletResponse queryPagelet(QueryPagelet queryPagelet, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        if (this.isPortletPath(queryPagelet.getPath())) {
            return this.retrievePortletAsPagelet(queryPagelet, context);
        }
        return this.retrievePagelet(queryPagelet, context);
    }

    private QueryPageletResponse retrievePagelet(QueryPagelet queryPagelet, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        String MN = "retrievePagelet";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        String request = CMRequestHelper.getQueryPageletRequest(this.resolvePath(queryPagelet.getPath()));
        List portletInstances = this.cmRequest.send(context, request, 2, false);
        QueryPageletResponse pageletResponse = new QueryPageletResponse();
        if (portletInstances.size() > 0) {
            GenericCMObject cmObjPagelet = (GenericCMObject)portletInstances.remove(0);
            if (!OperationHelper.canExecute(cmObjPagelet)) {
                return pageletResponse;
            }
            Pagelet pagelet = new Pagelet();
            pageletResponse.setPagelet(pagelet);
            pagelet.setId(cmObjPagelet.getParameter("storeID", null));
            pagelet.setPath(this.getCPSPath(cmObjPagelet.getParameter("searchPath", null), false));
            Description description = new Description();
            description.setContent(cmObjPagelet.getParameter("defaultDescription", null));
            pagelet.setDescription(description);
            Name name = new Name();
            name.setContent(cmObjPagelet.getParameter("defaultName", null));
            pagelet.setName(name);
            String temp = cmObjPagelet.getParameter("layout", null);
            if (temp != null && temp.length() > 0) {
                StringBuffer layoutString = new StringBuffer();
                layoutString.append("<cps:layout xmlns:cps=\"http://developer.cognos.com/schemas/cps/asm/objects/1/\">");
                layoutString.append(temp);
                layoutString.append("</cps:layout>");
                Object layout = AsmTypeHelper.deserializeAsmObj(new StringReader(layoutString.toString()), "layout");
                pagelet.setLayout((Layout)layout);
            }
            try {
                String requiredCapabilitiesXML = cmObjPagelet.getParameter("metadata", null);
                cmObjPagelet.setParameter("requiredCapabilities", RequiredCapabilities.parseRequiredCapabilities((String)requiredCapabilitiesXML));
            }
            catch (Throwable e) {
                throw new OperationFailedFault("cps.common.parse.error", (Object[])new String[]{CMRequest.class.getName()}, e);
            }
            OperationHelper.setAccessRights(cmObjPagelet, pagelet, context);
            SmallMap producerMap = new SmallMap();
            ArrayList<String> noneCachedproducerKeys = new ArrayList<String>();
            ArrayList<ObjRef> objRefArray = new ArrayList<ObjRef>();
            for (int i = 0; i < portletInstances.size(); ++i) {
                GenericCMObject cmObjInstance = (GenericCMObject)portletInstances.get(i);
                GenericCMObject cmObjPortlet = cmObjInstance.getChildObject("portlet");
                Portlet portlet = new Portlet();
                PortletInstance portletInstance = new PortletInstance();
                String producerStoreId = OperationHelper.extractPortletInfoFromInstance(cmObjInstance, cmObjPortlet, portlet, portletInstance);
                pagelet.addPortletInstance(portletInstance);
                if (producerStoreId == null) continue;
                PortletProducer portletProducer = null;
                if (producerMap.containsKey(producerStoreId)) {
                    portletProducer = (PortletProducer)producerMap.get(producerStoreId);
                } else {
                    portletProducer = ProducerCache.getInstance().getProducerFromCache(producerStoreId, context, this.cmRequest);
                    if (portletProducer == null) {
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug("producer object not found in cache - creating new object");
                        }
                        portletProducer = new PortletProducer();
                        noneCachedproducerKeys.add("storeID(\"" + producerStoreId + "\")");
                    }
                    producerMap.put(producerStoreId, portletProducer);
                }
                if (cmObjPortlet != null && OperationHelper.canRead(cmObjPortlet)) {
                    portletProducer.addPortlet(portlet);
                }
                objRefArray.add(new ObjRef(cmObjInstance, cmObjPagelet, portletProducer, portletInstance));
            }
            if (noneCachedproducerKeys.size() > 0) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("requesting producers from cm: " + noneCachedproducerKeys);
                }
                String producerRequest = CMRequestHelper.getQueryProducers(noneCachedproducerKeys);
                List cmProdObjects = this.cmRequest.send(context, producerRequest, 1, false);
                for (int i = 0; i < cmProdObjects.size(); ++i) {
                    GenericCMObject cmObjProducer = (GenericCMObject)cmProdObjects.get(i);
                    String storeID = cmObjProducer.getParameter("storeID", null);
                    if (storeID == null) continue;
                    PortletProducer portletProducer = (PortletProducer)producerMap.get(storeID);
                    OperationHelper.extractProducer(cmObjProducer, portletProducer);
                    ProducerCache.getInstance().cacheProducer(storeID, cmObjProducer.getParameter("modificationTime", null), portletProducer);
                }
            }
            Metadata metadata = new Metadata();
            if (producerMap.size() > 0) {
                PortletProducer[] array = new PortletProducer[producerMap.size()];
                array = producerMap.values().toArray(array);
                metadata.setPortletProducer(array);
                for (ObjRef ref : objRefArray) {
                    OperationHelper.setAccessRights(ref.cmObjInstance, ref.cmObjPagelet, ref.portletProducer, ref.portletInstance, context);
                }
            }
            pagelet.setMetadata(metadata);
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return pageletResponse;
    }

    private QueryPageletResponse retrievePortletAsPagelet(QueryPagelet queryPagelet, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        String MN = "retrievePortletAsPagelet";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        String portletPath = this.resolvePath(queryPagelet.getPath());
        String request = CMRequestHelper.getQueryPortletRequest(portletPath);
        List portlets = this.cmRequest.send(context, request, 0, false);
        QueryPageletResponse response = new QueryPageletResponse();
        if (portlets.size() > 0) {
            Pagelet pagelet = new Pagelet();
            response.setPagelet(pagelet);
            GenericCMObject cmObjPortlet = (GenericCMObject)portlets.get(0);
            pagelet.setId(cmObjPortlet.getParameter("storeID", null));
            pagelet.setPath(this.getCPSPath(cmObjPortlet.getParameter("searchPath", null), true));
            Name name = new Name();
            name.setContent(cmObjPortlet.getParameter("defaultName", null));
            pagelet.setName(name);
            Description description = new Description();
            description.setContent(cmObjPortlet.getParameter("defaultDescription", null));
            pagelet.setDescription(description);
            ScreenTip screenTip = new ScreenTip();
            screenTip.setContent(cmObjPortlet.getParameter("defaultScreenTip", null));
            pagelet.setScreenTip(screenTip);
            pagelet.setLayout(null);
            OperationHelper.setAccessRights(cmObjPortlet, pagelet, context);
            Metadata metadata = new Metadata();
            pagelet.setMetadata(metadata);
            Portlet portlet = new Portlet();
            PortletInstance portletInstance = new PortletInstance();
            String producerId = OperationHelper.extractPortletInfoFromPortlet(cmObjPortlet, portlet, portletInstance);
            pagelet.setPortletInstance(new PortletInstance[]{portletInstance});
            if (producerId != null) {
                PortletProducer portletProducer = ProducerCache.getInstance().getProducerFromCache(producerId, context, this.cmRequest);
                if (portletProducer == null) {
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("producer object not found in cache - creating new object");
                    }
                    ArrayList<String> producerSearchPath = new ArrayList<String>();
                    producerSearchPath.add("storeID(\"" + producerId + "\")");
                    String producerRequest = CMRequestHelper.getQueryProducers(producerSearchPath);
                    List cmProdObjects = this.cmRequest.send(context, producerRequest, 1, false);
                    if (cmProdObjects.size() > 0) {
                        portletProducer = new PortletProducer();
                        GenericCMObject cmObjProducer = (GenericCMObject)cmProdObjects.get(0);
                        OperationHelper.extractProducer(cmObjProducer, portletProducer);
                        String storeID = cmObjProducer.getParameter("storeID", null);
                        if (storeID != null) {
                            ProducerCache.getInstance().cacheProducer(storeID, cmObjProducer.getParameter("modificationTime", null), portletProducer);
                        }
                    }
                }
                if (portletProducer != null) {
                    metadata.setPortletProducer(new PortletProducer[]{portletProducer});
                    OperationHelper.setAccessRights(cmObjPortlet, portletProducer, portletInstance, context);
                    if (cmObjPortlet != null && OperationHelper.canRead(cmObjPortlet)) {
                        portletProducer.setPortlet(new Portlet[]{portlet});
                    }
                }
            }
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return response;
    }

    public QueryPortletProducerResponse queryPortletProducer(QueryPortletProducer queryPortletProducer, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        String MN = "queryPortletProducer";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        QueryPortletProducerResponse response = new QueryPortletProducerResponse();
        String path = queryPortletProducer.getPath();
        if (path != null) {
            GenericCMObject obj;
            String storeID;
            String producerPath = this.resolvePath(path);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("requesting producer from cm: " + producerPath);
            }
            ArrayList<String> producerPathList = new ArrayList<String>();
            producerPathList.add(producerPath);
            String producerRequest = CMRequestHelper.getQueryProducers(producerPathList);
            List cmProdObjects = this.cmRequest.send(context, producerRequest, 0, false);
            if (cmProdObjects.size() > 0 && (storeID = (obj = (GenericCMObject)cmProdObjects.get(0)).getParameter("storeID", null)) != null) {
                PortletProducer producer = new PortletProducer();
                response.setPortletProducer(producer);
                OperationHelper.extractProducer(obj, producer);
                if (OperationHelper.canRead(obj)) {
                    ProducerCache.getInstance().cacheProducer(storeID, obj.getParameter("modificationTime", null), producer);
                }
            }
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return response;
    }

    public SaveContextResponse saveContext(SaveContext saveContext, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        String pageletPath;
        String MN = "saveContext";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        if ((pageletPath = saveContext.getPath()) != null && pageletPath.length() > 0) {
            pageletPath = this.resolvePath(pageletPath);
            String id = saveContext.getPortletId();
            boolean isInstance = !PORTLET_VIRTUAL_ID.equals(id);
            StringBuffer path = new StringBuffer();
            path.append(pageletPath);
            if (isInstance) {
                path.append("/portletInstance[@name='");
                path.append(id);
                path.append("']");
            }
            String soapRequest = CMRequestHelper.getSaveContextsRequest(path.toString(), saveContext.getPortletContext(), isInstance);
            this.cmRequest.send(context, soapRequest, 0);
        }
        SaveContextResponse returnSaveContextResponse = new SaveContextResponse();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return returnSaveContextResponse;
    }

    public SavePortletProducerResponse savePortletProducer(SavePortletProducer savePortletProducer, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        PortletProducer producer;
        String MN = "savePortletProducer";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        if ((producer = savePortletProducer.getPortletProducer()) != null) {
            String request = CMRequestHelper.getSaveProducerRequest(producer);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("cm request is: " + request);
            }
            this.cmRequest.send(context, request, 0);
        }
        SavePortletProducerResponse returnSavePortletProducerResponse = new SavePortletProducerResponse();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return returnSavePortletProducerResponse;
    }

    public SavePortletResponse savePortlet(SavePortlet savePortlet, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        String MN = "savePortlet";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        String path = savePortlet.getPath();
        Portlet portlet = savePortlet.getPortlet();
        if (path != null && path.length() > 0 && portlet != null) {
            path = this.resolvePath(path);
            String request = CMRequestHelper.getSavePortletRequest(path, new Portlet[]{portlet}, savePortlet.getResourceList());
            this.cmRequest.send(context, request, 0);
        }
        SavePortletResponse returnSavePortletResponse = new SavePortletResponse();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return returnSavePortletResponse;
    }

    public SaveRegistrationResponse saveRegistration(SaveRegistration saveRegistration, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        GenericCMObject obj;
        String registrationAsString;
        String request;
        List updateObjects;
        String MN = "saveRegistration";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug(MN);
        }
        String path = saveRegistration.getPath();
        Registration registration = saveRegistration.getRegistration();
        if (path != null && path.length() > 0 && registration != null && (updateObjects = this.cmRequest.send(context, request = CMRequestHelper.getsaveRegistrationRequest(path = this.resolvePath(path), registrationAsString = AsmTypeHelper.serializeAsm(registration, "registration")), 0, true)).size() > 0 && (obj = (GenericCMObject)updateObjects.get(0)) != null) {
            ProducerCache.getInstance().removeProducerFromCache(obj.getParameter("storeID", null));
        }
        SaveRegistrationResponse returnSaveRegistrationResponse = new SaveRegistrationResponse();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return returnSaveRegistrationResponse;
    }

    public SaveBindingResponse saveBinding(SaveBinding saveBinding, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        GenericCMObject obj;
        String bindingAsString;
        String request;
        List updateObjects;
        String MN = "saveBinding";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        String path = saveBinding.getPath();
        Binding binding = saveBinding.getBinding();
        if (path != null && path.length() > 0 && binding != null && (updateObjects = this.cmRequest.send(context, request = CMRequestHelper.getsaveBindingRequest(path = this.resolvePath(path), bindingAsString = AsmTypeHelper.serializeAsm(binding, "binding")), 0, true)).size() > 0 && (obj = (GenericCMObject)updateObjects.get(0)) != null) {
            ProducerCache.getInstance().removeProducerFromCache(obj.getParameter("storeID", null));
        }
        SaveBindingResponse returnSaveBindingResponse = new SaveBindingResponse();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return returnSaveBindingResponse;
    }

    private String getCPSPath(String searchPath, boolean isportlet) {
        if (searchPath != null) {
            return "/connection/" + (isportlet ? "portlet:path:" : "path:") + searchPath;
        }
        return null;
    }

    private String resolvePath(String path) throws OperationFailedFault {
        String MN = "resolvePath";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        if (path != null && path.startsWith("/connection/")) {
            if ((path = path.substring(12)).startsWith("portlet:")) {
                path = path.substring(8);
            }
            if (path.startsWith("path:")) {
                path = path.substring(5);
            } else if (!path.startsWith("storeID(")) {
                path = "storeID(\"" + path + "\")";
            }
        } else {
            throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, null);
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return path;
    }

    private boolean isPortletPath(String path) {
        String MN = "isPortletPath";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        boolean isPortletPath = path != null ? path.startsWith("/connection/portlet:") : false;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
        return isPortletPath;
    }

    class ObjRef {
        GenericCMObject cmObjInstance;
        GenericCMObject cmObjPagelet;
        PortletProducer portletProducer;
        PortletInstance portletInstance;

        public ObjRef(GenericCMObject cmObjInstance, GenericCMObject cmObjPagelet, PortletProducer portletProducer, PortletInstance portletInstance) {
            this.cmObjInstance = cmObjInstance;
            this.cmObjPagelet = cmObjPagelet;
            this.portletProducer = portletProducer;
            this.portletInstance = portletInstance;
        }
    }
}

