/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.pagelet.storage;

import com.cognos.cps.bseries.xts.common.CPSExceptionWrapper;
import com.cognos.cps.bseries.xts.common.logging.XTSServiceLoggerImpl;
import com.cognos.cps.bseries.xts.common.request.WebServiceRequest;
import com.cognos.cps.common.ExceptionExtension;
import com.cognos.cps.common.utils.SmallMap;
import com.cognos.cps.pagelet.common.utils.PageletFactory;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.IServiceImplementation;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.pagelet.storage.v1.intf.IStorage;
import com.cognos.cps.services.pagelet.storage.v1.types.InvalidCredentialsFault;
import com.cognos.cps.services.pagelet.storage.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPagelet;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPortletProducer;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveBinding;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveContext;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortlet;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletProducer;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveRegistration;
import com.cognos.cps.services.pagelet.storage.v1.types.TypeFactory;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import java.util.Iterator;
import java.util.Map;

public class StorageRequest
extends WebServiceRequest {
    private Map m_storageMap = new SmallMap();

    public StorageRequest() {
        this.m_logger = new XTSServiceLoggerImpl(StorageRequest.class);
    }

    @Override
    protected Object performRequest(String methodName, Object request, IContext context) throws XTSInstructionException {
        String MN = "performRequest";
        try {
            if (request instanceof QueryPagelet) {
                return this.retrieveStorage(this.getKeyFromPath(((QueryPagelet)request).getPath()), context).queryPagelet((QueryPagelet)request, context);
            }
            if (request instanceof QueryPortletProducer) {
                return this.retrieveStorage(this.getKeyFromPath(((QueryPortletProducer)request).getPath()), context).queryPortletProducer((QueryPortletProducer)request, context);
            }
            if (request instanceof SaveContext) {
                return this.retrieveStorage(this.getKeyFromPath(((SaveContext)request).getPath()), context).saveContext((SaveContext)request, context);
            }
            if (request instanceof SavePortletProducer) {
                return this.retrieveStorage(this.getKeyFromPath(((SavePortletProducer)request).getPath()), context).savePortletProducer((SavePortletProducer)request, context);
            }
            if (request instanceof SavePortlet) {
                return this.retrieveStorage(this.getKeyFromPath(((SavePortlet)request).getPath()), context).savePortlet((SavePortlet)request, context);
            }
            if (request instanceof SaveRegistration) {
                return this.retrieveStorage(this.getKeyFromPath(((SaveRegistration)request).getPath()), context).saveRegistration((SaveRegistration)request, context);
            }
            if (request instanceof SaveBinding) {
                return this.retrieveStorage(this.getKeyFromPath(((SaveBinding)request).getPath()), context).saveBinding((SaveBinding)request, context);
            }
            this.m_logger.error(MN);
            Object[] args = new String[]{this.m_identifier, methodName};
            throw new XTSInstructionException("cps.common.undefinedmethod.error", args);
        }
        catch (InvalidCredentialsFault e) {
            throw new XTSInstructionException("cps.pagelet.storage.client.failed", (Throwable)((Object)new CPSExceptionWrapper((ExceptionExtension)e)));
        }
        catch (RuntimeException runtime) {
            this.m_logger.error(MN, (Throwable)runtime);
            throw runtime;
        }
        catch (OperationFailedFault e) {
            this.m_logger.error(MN, (Throwable)e);
            Throwable root = e.getRootCause();
            if (root != null && root instanceof XTSInstructionException) {
                throw (XTSInstructionException)root;
            }
            throw new XTSInstructionException(this.getDefaultExceptionCode(), (Throwable)((Object)new CPSExceptionWrapper((ExceptionExtension)e)));
        }
    }

    @Override
    protected void processResponse(Object request, Object response, Map params, StringBuffer additionalXML) throws XTSInstructionException {
    }

    @Override
    protected String getDefaultExceptionCode() {
        return "cps.pagelet.consumer.operation.failed";
    }

    @Override
    protected String getComponentName() {
        return "storage";
    }

    @Override
    protected SOAPObjectHandler getTypeFactory() {
        return TypeFactory.newInstance();
    }

    @Override
    protected String getTypeFactoryNamespace() {
        return "http://developer.cognos.com/schemas/cps/asm/storage/1/";
    }

    @Override
    public synchronized void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        super.initialize(env, identifier, instAtts, instParams);
    }

    @Override
    public synchronized void terminate() throws XTSInstructionException {
        String MN = "terminate";
        super.terminate();
        Iterator it = this.m_storageMap.values().iterator();
        while (it.hasNext()) {
            IServiceImplementation service = (IServiceImplementation)it.next();
            try {
                service.terminate();
            }
            catch (ServiceException e) {
                this.m_logger.error(MN, (Throwable)e);
            }
            it.remove();
        }
    }

    private synchronized IStorage retrieveStorage(String key, IContext context) throws XTSInstructionException {
        IStorage storage = (IStorage)this.m_storageMap.get(key);
        if (storage == null) {
            storage = PageletFactory.createStorageObject(key, context, this.m_logger);
            if (storage != null) {
                this.m_storageMap.put(key, storage);
            } else {
                this.m_logger.error("retrieveStorage");
                Object[] args = new String[]{key};
                throw new XTSInstructionException("cps.pagelet.storage.invalidpath.failed", args);
            }
        }
        return storage;
    }

    private String getKeyFromPath(String pathURN) {
        if (pathURN != null) {
            int index = pathURN.indexOf(47, 1);
            if (index != -1) {
                String storageURN = pathURN.substring(0, index);
                return storageURN;
            }
            return pathURN;
        }
        return null;
    }
}

