/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.pagelet.storage.helpers;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.pagelet.storage.sax.DeploymentRefHandler;
import com.cognos.cps.bseries.xts.request.nav.helpers.NavHelper;
import com.cognos.cps.pagelet.storage.common.AsmTypeHelper;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.pagelet.objects.v1.types.AccessRightsType;
import com.cognos.cps.services.pagelet.objects.v1.types.Binding;
import com.cognos.cps.services.pagelet.objects.v1.types.Description;
import com.cognos.cps.services.pagelet.objects.v1.types.Name;
import com.cognos.cps.services.pagelet.objects.v1.types.Pagelet;
import com.cognos.cps.services.pagelet.objects.v1.types.Portlet;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletInstance;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.cps.services.pagelet.objects.v1.types.Registration;
import com.cognos.cps.services.pagelet.storage.v1.types.OperationFailedFault;
import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.MarkupType;
import com.cognos.cps.services.wsrp.v1.types.PortletContext;
import com.cognos.cps.services.wsrp.v1.types.PortletDescription;
import com.cognos.cps.services.wsrp.v1.types.ServiceDescription;
import com.cognos.portal.utils.capability.CapabilityHelpers;
import com.cognos.portal.utils.capability.RequiredCapabilities;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import org.exolab.castor.types.AnyNode;

public class OperationHelper {
    private static final String WSRP_VIEW_MODE = "wsrp:view";
    private static final String WSRP_EDIT_MODE = "wsrp:edit";
    private static final String WSRP_PREVIEW_MODE = "wsrp:preview";
    private static final String WSRP_HELP_MODE = "wsrp:help";
    private static final String CPS_CONFIG_MODE = "cps:config";

    public static void updateContext(PortletContext portletContext, DeploymentRefHandler deploymentRefs) {
        Extension[] extensions;
        if (deploymentRefs != null && portletContext != null && (extensions = portletContext.getExtensions()) != null) {
            for (int i = 0; i < extensions.length; ++i) {
                AnyNode firstChild;
                AnyNode anyNode;
                Extension extension = extensions[i];
                Object anyObject = extension.getAnyObject();
                if (!(anyObject instanceof AnyNode) || !"state".equals((anyNode = (AnyNode)anyObject).getLocalName()) || !"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/".equals(anyNode.getNamespaceURI())) continue;
                portletContext.removeExtensions(extension);
                AnyNode modifiedStateExtension = null;
                for (AnyNode child = firstChild = anyNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                    DeploymentRefHandler.DeploymentRef cmDeploymentRefValue;
                    String value;
                    AnyNode text;
                    if (child.getNodeType() != 1 || !"externalRef".equals(child.getLocalName())) continue;
                    String name = null;
                    String type = null;
                    for (AnyNode nameAttribute = child.getFirstAttribute(); nameAttribute != null; nameAttribute = nameAttribute.getNextSibling()) {
                        if (nameAttribute.getNodeType() != 2) continue;
                        if ("name".equals(nameAttribute.getLocalName())) {
                            name = nameAttribute.getStringValue();
                            continue;
                        }
                        if (!"type".equals(nameAttribute.getLocalName())) continue;
                        type = nameAttribute.getStringValue();
                    }
                    if (name == null || (text = child.getFirstChild()) == null || text.getNodeType() != 6 || (value = text.getStringValue()) == null || (cmDeploymentRefValue = deploymentRefs.getDeploymentReference(name)) == null) continue;
                    String modifiedValue = null;
                    if ("cm".equals(type)) {
                        String cmValue = value.startsWith("storeID('") ? "storeID('" + cmDeploymentRefValue.getStoreID() + "')" : (value.startsWith("storeID(\"") ? "storeID(\"" + cmDeploymentRefValue.getStoreID() + "\")" : (value.startsWith("/") ? cmDeploymentRefValue.getSearchPath() : cmDeploymentRefValue.getStoreID()));
                        if (!value.equals(cmValue)) {
                            modifiedValue = cmValue;
                        }
                    } else {
                        String navIdFromsearchPath = NavHelper.getNavIdFromSreachPath(cmDeploymentRefValue.getSearchPath());
                        String navIdFromstoreId = NavHelper.getNavIdFromStoreId(cmDeploymentRefValue.getStoreID());
                        if (!value.equals(navIdFromsearchPath) && !value.equals(navIdFromstoreId)) {
                            modifiedValue = navIdFromstoreId;
                        }
                    }
                    if (modifiedValue == null) continue;
                    if (modifiedStateExtension == null) {
                        modifiedStateExtension = new AnyNode(1, "state", "cpsext", "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/", null);
                        modifiedStateExtension.addNamespace(new AnyNode(3, null, "cpsext", "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/", null));
                        Extension e = new Extension();
                        e.setAnyObject((Object)modifiedStateExtension);
                        portletContext.addExtensions(e);
                    }
                    AnyNode newExternalRef = new AnyNode(1, "externalRef", "cpsext", "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/", null);
                    newExternalRef.addAttribute(new AnyNode(2, "name", null, "", name));
                    newExternalRef.addAttribute(new AnyNode(2, "type", null, "", type));
                    newExternalRef.addChild(new AnyNode(6, null, null, null, modifiedValue));
                    modifiedStateExtension.addChild(newExternalRef);
                }
                break;
            }
        }
    }

    public static String extractPortletInfoFromInstance(GenericCMObject cmObjInstance, GenericCMObject cmObjPortlet, Portlet portlet, PortletInstance instance) throws OperationFailedFault {
        instance.setId(cmObjInstance.getParameter("defaultName", null));
        String contextString = cmObjInstance.getParameter("context", null);
        if (contextString != null && contextString.length() > 0) {
            PortletContext portletContext = (PortletContext)AsmTypeHelper.deserializeWsrp(new StringReader(contextString), "portletContext");
            DeploymentRefHandler deploymentRefs = (DeploymentRefHandler)cmObjInstance.getAny("deploymentReferences");
            OperationHelper.updateContext(portletContext, deploymentRefs);
            instance.setPortletContext(portletContext);
        }
        if (cmObjPortlet != null) {
            GenericCMObject producer;
            String portlettId = cmObjPortlet.getParameter("storeID", null);
            instance.setPortletId(portlettId);
            portlet.setId(portlettId);
            Name name = new Name();
            name.setContent(cmObjPortlet.getParameter("defaultName", null));
            portlet.setName(name);
            Description description = new Description();
            description.setContent(cmObjPortlet.getParameter("defaultDescription", null));
            portlet.setDescription(description);
            portlet.setHandle(cmObjPortlet.getParameter("handle", null));
            contextString = cmObjPortlet.getParameter("context", null);
            if (contextString != null && contextString.length() > 0) {
                PortletContext portletContext = (PortletContext)AsmTypeHelper.deserializeWsrp(new StringReader(contextString), "portletContext");
                DeploymentRefHandler deploymentRefs = (DeploymentRefHandler)cmObjPortlet.getAny("deploymentReferences");
                OperationHelper.updateContext(portletContext, deploymentRefs);
                portlet.setPortletContext(portletContext);
            }
            if ((producer = cmObjPortlet.getChildObject("parent")) != null) {
                return producer.getParameter("storeID", null);
            }
        }
        return null;
    }

    public static String extractPortletInfoFromPortlet(GenericCMObject cmObjPortlet, Portlet portlet, PortletInstance instance) throws OperationFailedFault {
        instance.setId("PORTLETID");
        String portlettId = cmObjPortlet.getParameter("storeID", null);
        instance.setPortletId(portlettId);
        String contextString = cmObjPortlet.getParameter("context", null);
        PortletContext portletContext = null;
        if (contextString != null && contextString.length() > 0) {
            portletContext = (PortletContext)AsmTypeHelper.deserializeWsrp(new StringReader(contextString), "portletContext");
            DeploymentRefHandler deploymentRefs = (DeploymentRefHandler)cmObjPortlet.getAny("deploymentReferences");
            OperationHelper.updateContext(portletContext, deploymentRefs);
        }
        instance.setPortletContext(portletContext);
        portlet.setId(portlettId);
        Name name = new Name();
        name.setContent(cmObjPortlet.getParameter("defaultName", null));
        portlet.setName(name);
        Description description = new Description();
        description.setContent(cmObjPortlet.getParameter("defaultDescription", null));
        portlet.setDescription(description);
        portlet.setHandle(cmObjPortlet.getParameter("handle", null));
        GenericCMObject producer = cmObjPortlet.getChildObject("parent");
        if (producer != null) {
            return producer.getParameter("storeID", null);
        }
        return null;
    }

    public static void setAccessRights(GenericCMObject cmObjPagelet, Pagelet pagelet, IContext context) {
        if ("true".equals(cmObjPagelet.getParameter("disabled", ""))) {
            pagelet.addAccessRights(AccessRightsType.DISABLED);
        }
        if (!OperationHelper.canWrite(cmObjPagelet)) {
            pagelet.addAccessRights(AccessRightsType.READONLY);
        }
        if (!OperationHelper.hasCapabilities(cmObjPagelet.getParameter("requiredCapabilities", null), context) || !OperationHelper.canExecute(cmObjPagelet)) {
            pagelet.addAccessRights(AccessRightsType.UNAVAILABLE);
        }
    }

    public static void setAccessRights(GenericCMObject cmObjInstance, GenericCMObject cmObjPagelet, PortletProducer portletProducer, PortletInstance portletInstance, IContext context) {
        boolean canPreview;
        boolean canHelp;
        boolean canEdit;
        boolean canView;
        PortletDescription[] portlets;
        String portletHandle = null;
        boolean isDisabled = false;
        boolean isLocked = false;
        boolean isReadOnly = false;
        GenericCMObject portlet = cmObjInstance.getChildObject("portlet");
        if (portlet != null) {
            portletHandle = portlet.getParameter("handle", null);
            isDisabled = "true".equals(portlet.getParameter("disabled", "")) || "true".equals(cmObjPagelet.getParameter("disabled", ""));
            isLocked = "false".equals(portlet.getParameter("canCustomize", ""));
            boolean bl = isReadOnly = isLocked || !OperationHelper.canWrite(cmObjPagelet);
        }
        if (isDisabled) {
            portletInstance.addAccessRights(AccessRightsType.DISABLED);
        }
        if (isLocked) {
            portletInstance.addAccessRights(AccessRightsType.LOCKED);
            portletInstance.setPortletContext(null);
        }
        if (isReadOnly) {
            portletInstance.addAccessRights(AccessRightsType.READONLY);
        }
        boolean isPortletViewMode = false;
        boolean isPortletEditMode = false;
        boolean isPortletHelpMode = false;
        boolean isPortletPreviewMode = false;
        String requiredCapabilities = null;
        ArrayList<String> customModes = null;
        ServiceDescription serviceDescription = portletProducer.getServiceDescription();
        if (serviceDescription != null && portletHandle != null && (portlets = serviceDescription.getOfferedPortlets()) != null) {
            block0: for (int i = 0; i < portlets.length; ++i) {
                PortletDescription portletDescription = portlets[i];
                String h = portletDescription.getPortletHandle();
                if (!portletHandle.equals(h)) continue;
                requiredCapabilities = OperationHelper.getRequiredCapabilities(portletDescription.getExtensions());
                MarkupType[] markups = portletDescription.getMarkupTypes();
                if (markups != null) {
                    for (int j = 0; j < markups.length; ++j) {
                        MarkupType markup = markups[j];
                        String mimeType = markup.getMimeType();
                        if (!"text/html".equalsIgnoreCase(mimeType)) continue;
                        String[] modes = markup.getModes();
                        if (modes == null) {
                            isPortletViewMode = true;
                            break block0;
                        }
                        for (int k = 0; k < modes.length; ++k) {
                            String m = modes[k];
                            if (m == null) continue;
                            if (m.equals(WSRP_VIEW_MODE)) {
                                isPortletViewMode = true;
                                continue;
                            }
                            if (m.equals(WSRP_EDIT_MODE)) {
                                isPortletEditMode = true;
                                continue;
                            }
                            if (m.equals(WSRP_HELP_MODE)) {
                                isPortletHelpMode = true;
                                continue;
                            }
                            if (m.equals(WSRP_PREVIEW_MODE)) {
                                isPortletPreviewMode = true;
                                continue;
                            }
                            if (m.startsWith("wsrp:")) continue;
                            if (customModes == null) {
                                customModes = new ArrayList<String>();
                            }
                            customModes.add(m);
                        }
                    }
                    break;
                }
                isPortletViewMode = true;
                break;
            }
        }
        boolean canViewPagelet = OperationHelper.canRead(cmObjPagelet) && OperationHelper.canExecute(cmObjPagelet);
        boolean canViewPortletInstance = OperationHelper.canRead(cmObjInstance) && OperationHelper.canExecute(cmObjInstance);
        boolean canViewPortlet = OperationHelper.canRead(portlet) && OperationHelper.canExecute(portlet);
        boolean bl = canView = !isDisabled && canViewPagelet && canViewPortletInstance && canViewPortlet && isPortletViewMode && OperationHelper.hasCapabilities(requiredCapabilities, context);
        if (canView) {
            portletInstance.addAccessModes(WSRP_VIEW_MODE);
        }
        boolean bl2 = canEdit = !isLocked && OperationHelper.canWrite(cmObjPagelet) && canView && isPortletEditMode;
        if (canEdit) {
            portletInstance.addAccessModes(WSRP_EDIT_MODE);
        }
        boolean bl3 = canHelp = canView && isPortletHelpMode;
        if (canHelp) {
            portletInstance.addAccessModes(WSRP_HELP_MODE);
        }
        boolean bl4 = canPreview = canView && isPortletPreviewMode;
        if (canPreview) {
            portletInstance.addAccessModes(WSRP_PREVIEW_MODE);
        }
        if (canView && customModes != null) {
            for (String customMode : customModes) {
                if (customMode.equals(CPS_CONFIG_MODE)) continue;
                portletInstance.addAccessModes(customMode);
            }
        }
    }

    public static void setAccessRights(GenericCMObject cmObjPortlet, PortletProducer portletProducer, PortletInstance portletInstance, IContext context) {
        boolean canPreview;
        boolean canHelp;
        boolean canEdit;
        boolean canView;
        PortletDescription[] portlets;
        boolean isReadOnly;
        String portletHandle = cmObjPortlet.getParameter("handle", null);
        String requiredCapabilities = null;
        boolean isDisabled = "true".equals(cmObjPortlet.getParameter("disabled", ""));
        if (isDisabled) {
            portletInstance.addAccessRights(AccessRightsType.DISABLED);
        }
        boolean bl = isReadOnly = !OperationHelper.canWrite(cmObjPortlet);
        if (isReadOnly) {
            portletInstance.addAccessRights(AccessRightsType.READONLY);
        }
        boolean OfferedPortletViewMode = false;
        boolean OfferedPortletEditMode = false;
        boolean OfferedPortletHelpMode = false;
        boolean OfferedPortletPreviewMode = false;
        ArrayList<String> customModes = null;
        ServiceDescription serviceDescription = portletProducer.getServiceDescription();
        if (serviceDescription != null && portletHandle != null && (portlets = serviceDescription.getOfferedPortlets()) != null) {
            block0: for (int i = 0; i < portlets.length; ++i) {
                PortletDescription portletDescription = portlets[i];
                String h = portletDescription.getPortletHandle();
                if (!portletHandle.equals(h)) continue;
                requiredCapabilities = OperationHelper.getRequiredCapabilities(portletDescription.getExtensions());
                MarkupType[] markups = portletDescription.getMarkupTypes();
                if (markups != null) {
                    for (int j = 0; j < markups.length; ++j) {
                        MarkupType markup = markups[j];
                        String mimeType = markup.getMimeType();
                        if (!"text/html".equalsIgnoreCase(mimeType)) continue;
                        String[] modes = markup.getModes();
                        if (modes == null) {
                            OfferedPortletViewMode = true;
                            break block0;
                        }
                        for (int k = 0; k < modes.length; ++k) {
                            String m = modes[k];
                            if (m == null) continue;
                            if (m.equals(WSRP_VIEW_MODE)) {
                                OfferedPortletViewMode = true;
                                continue;
                            }
                            if (m.equals(WSRP_EDIT_MODE)) {
                                OfferedPortletEditMode = true;
                                continue;
                            }
                            if (m.equals(WSRP_HELP_MODE)) {
                                OfferedPortletHelpMode = true;
                                continue;
                            }
                            if (m.equals(WSRP_PREVIEW_MODE)) {
                                OfferedPortletPreviewMode = true;
                                continue;
                            }
                            if (m.startsWith("wsrp:")) continue;
                            if (customModes == null) {
                                customModes = new ArrayList<String>();
                            }
                            customModes.add(m);
                        }
                    }
                    break;
                }
                OfferedPortletViewMode = true;
                break;
            }
        }
        boolean canViewPortlet = OperationHelper.canRead(cmObjPortlet) && OperationHelper.canExecute(cmObjPortlet) && OperationHelper.hasCapabilities(requiredCapabilities, context);
        boolean bl2 = canView = !isDisabled && canViewPortlet && OfferedPortletViewMode;
        if (canView) {
            portletInstance.addAccessModes(WSRP_VIEW_MODE);
        }
        boolean bl3 = canEdit = canView && OperationHelper.canWrite(cmObjPortlet);
        if (canEdit && OfferedPortletEditMode) {
            portletInstance.addAccessModes(WSRP_EDIT_MODE);
        }
        boolean bl4 = canHelp = canView && OfferedPortletHelpMode;
        if (canHelp) {
            portletInstance.addAccessModes(WSRP_HELP_MODE);
        }
        boolean bl5 = canPreview = canView && OfferedPortletPreviewMode;
        if (canPreview) {
            portletInstance.addAccessModes(WSRP_PREVIEW_MODE);
        }
        if (canView && customModes != null) {
            for (String customMode : customModes) {
                if (customMode.equals(CPS_CONFIG_MODE) && !canEdit) continue;
                portletInstance.addAccessModes(customMode);
            }
        }
    }

    private static String getRequiredCapabilities(Extension[] extensions) {
        String requiredCapabilites = null;
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                AnyNode firstChild;
                AnyNode text;
                AnyNode anyNode;
                Extension extension = extensions[i];
                Object anyObject = extension.getAnyObject();
                if (!(anyObject instanceof AnyNode) || !"meta".equals((anyNode = (AnyNode)anyObject).getLocalName()) || !"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/".equals(anyNode.getNamespaceURI()) || (text = (firstChild = anyNode.getFirstChild()).getFirstChild()) == null || text.getNodeType() != 6) continue;
                requiredCapabilites = text.getStringValue();
            }
        }
        return requiredCapabilites;
    }

    public static void extractProducer(GenericCMObject cmObjProducer, PortletProducer portletProducer) throws OperationFailedFault {
        String serviceString;
        String regString;
        String id = cmObjProducer.getParameter("storeID", null);
        portletProducer.setId(id);
        portletProducer.setPath(cmObjProducer.getParameter("searchPath", null));
        Name name = new Name();
        name.setContent(cmObjProducer.getParameter("defaultName", null));
        portletProducer.setName(name);
        Description description = new Description();
        description.setContent(cmObjProducer.getParameter("defaultDescription", null));
        portletProducer.setDescription(description);
        String bindingString = cmObjProducer.getParameter("binding", null);
        if (bindingString != null && bindingString.length() > 0) {
            Object binding = AsmTypeHelper.deserializeAsmObj(new StringReader(bindingString), "binding");
            portletProducer.setBinding((Binding)binding);
        }
        if ((regString = cmObjProducer.getParameter("registration", null)) != null && regString.length() > 0) {
            Object registration = AsmTypeHelper.deserializeAsmObj(new StringReader(regString), "registration");
            portletProducer.setRegistration((Registration)registration);
        }
        if ((serviceString = cmObjProducer.getParameter("serviceDescription", null)) != null && serviceString.length() > 0) {
            serviceString = serviceString.substring(0, serviceString.indexOf(32)) + " xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" + serviceString.substring(serviceString.indexOf(32), serviceString.length());
            Object serviceDescription = AsmTypeHelper.deserializeWsrp(new StringReader(serviceString), "serviceDescription");
            portletProducer.setServiceDescription((ServiceDescription)serviceDescription);
        }
    }

    public static boolean canExecute(GenericCMObject object) {
        if (object != null) {
            return object.getArrayParameter("permissions").contains("execute");
        }
        return false;
    }

    private static boolean hasCapabilities(String requiredCapabilities, IContext context) {
        if (requiredCapabilities != null) {
            RequiredCapabilities rc = new RequiredCapabilities(requiredCapabilities, true);
            HashSet userCapabilities = (HashSet)context.getProperty("USER_CAPABILITIES");
            String browser = CapabilityHelpers.detectBrowser((String)((String)context.getProperty("USER_AGENT")));
            return rc.hasCapabilities(userCapabilities, browser);
        }
        return true;
    }

    public static boolean canRead(GenericCMObject object) {
        if (object != null) {
            return object.getArrayParameter("permissions").contains("read");
        }
        return false;
    }

    private static boolean canWrite(GenericCMObject object) {
        if (object != null) {
            return object.getArrayParameter("permissions").contains("write");
        }
        return false;
    }
}

