/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.repository;

import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cps.bseries.xts.repository.RepositoryAPIException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class QueryParameter
implements IQueryParameter {
    public static final String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    private String name;
    private Object value;
    private String type;

    public static SimpleDateFormat createDateFormatter() {
        SimpleDateFormat aFormat = new SimpleDateFormat(dateFormat);
        aFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return aFormat;
    }

    public QueryParameter(String name, Object value, String type) throws RepositoryAPIException {
        this.name = name;
        this.type = type;
        this.value = this.asQueryValue(value);
    }

    private Object asQueryValue(Object value) throws RepositoryAPIException {
        if (this.type.equals("DATETIME")) {
            Date aDate = null;
            try {
                aDate = QueryParameter.createDateFormatter().parse((String)value);
            }
            catch (ParseException e) {
                Object[] args = new String[]{this.name, (String)value};
                throw new RepositoryAPIException("protocol.repositoryconnectionInvalidDate", args, e);
            }
            Calendar parmDate = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            parmDate.setTimeInMillis(aDate.getTime());
            return parmDate;
        }
        if (this.type.equals("INTEGER")) {
            return Integer.parseInt((String)value);
        }
        return value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }
}

