/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.repository;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cm.repositoryPluginAPI.IRepositoryUserAgentFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cm.repositoryPluginFramework.IRepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.RepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginManager;
import com.cognos.cps.bseries.xts.repository.RepositoryAPIException;
import com.cognos.cps.bseries.xts.repository.RepositoryHttpClientFactory;
import com.cognos.cps.bseries.xts.repository.XTSPluginResourceLoader;
import com.cognos.cps.bseries.xts.repository.XTSRepositoryRequest;
import com.cognos.cps.common.utils.Base64;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.BusConnectionImpl;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.bus.cm.SimpleQuery;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.stream.PathIterator;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XTSRepositoryConnection {
    private static final String CM_DATA_SOURCE_CONNECTION = "cm:dataSourceConnection";
    public static final String CONSUMER_NAME = "XTS";
    private static final String CAM_INIT_PARAM = "<initializeDocument><serviceID>CPSRepository</serviceID></initializeDocument>";
    private static final CAMFactory camFactory = XTSRepositoryConnection.initializeCAMFactory();
    protected String dataSourceConnectionString;
    private XTSEnvironment env;
    private RepositoryConnection repConnection;
    private IXTSLogger traceLogger;
    private ServiceLogger logger;
    private SOAPConnectionFactoryImpl soapConnectionFactory;
    protected IPluginResourceLoader loader;
    private BIBusEnvelope biBus;
    private String targetSearchPath;
    private String dataSourceID;
    private HashMap<String, DataSourceConnection> connections = new HashMap();
    protected boolean isConfigured;
    protected RepositoryHttpClientFactory aHttpClientFactory;

    protected ServiceLogger getLogger() {
        if (this.logger == null) {
            this.logger = new ServiceLoggerImpl(XTSRepositoryRequest.class);
        }
        return this.logger;
    }

    protected void initializeSOAPFactory() throws RepositoryAPIException {
        ContextImpl context = new ContextImpl();
        try {
            context.setProperty("cmPath", (Object)new URL(CCLConfigurationFactory.getInstance().getValue("contentManager", true)).getFile());
            context.setProperty("dispatcherPath", (Object)new URL(CCLConfigurationFactory.getInstance().getValue("internalDispatcher", true)).getFile());
        }
        catch (CCLConfigurationException e) {
            throw new RepositoryAPIException("cps.common.init.error", new String[]{XTSRepositoryRequest.class.getName()}, e);
        }
        catch (MalformedURLException e) {
            throw new RepositoryAPIException("cps.common.init.error", new String[]{XTSRepositoryRequest.class.getName()}, e);
        }
        this.soapConnectionFactory = new SOAPConnectionFactoryImpl((IContext)context);
    }

    protected XTSRepositoryConnection() {
    }

    public XTSRepositoryConnection(IPluginResourceLoader resourceLoader, XTSEnvironment env, BIBusEnvelope biBus, String searchPath) throws RepositoryAPIException {
        this(env, biBus, searchPath);
        this.loader = resourceLoader;
    }

    private static CAMFactory initializeCAMFactory() {
        CAMFactory factory = new CAMFactory();
        try {
            factory.initialize(CAM_INIT_PARAM.getBytes("UTF-8"));
        }
        catch (CAMCryptoException e) {
            factory = null;
        }
        catch (UnsupportedEncodingException e) {
            factory = null;
        }
        return factory;
    }

    private CAMFactory getCAMFactory() {
        return camFactory;
    }

    public XTSRepositoryConnection(XTSEnvironment env, BIBusEnvelope biBus, String searchPath) throws RepositoryAPIException {
        IXTSLogger connectionPerfLogger = null;
        this.isConfigured = false;
        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0]) {
            connectionPerfLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0);
        }
        if (connectionPerfLogger != null) {
            connectionPerfLogger.log(env, 6, this.getClass().getName(), "execute", "Start instantiating repository connection: ");
            connectionPerfLogger.starttimer();
        }
        this.aHttpClientFactory = new RepositoryHttpClientFactory(this.getCAMFactory());
        this.biBus = biBus;
        this.targetSearchPath = searchPath;
        this.env = env;
        this.loader = new XTSPluginResourceLoader(env);
        this.repConnection = null;
        this.initializeSOAPFactory();
        if (connectionPerfLogger != null) {
            connectionPerfLogger.stoptimer();
            connectionPerfLogger.log(env, 1, this.getClass().getName(), "execute", "End instantiating repository connection: ");
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0]) {
            this.traceLogger = XTSTraceLoggerManager.getInstance().getLogger(4, 0);
        }
    }

    public BIBusEnvelope getBiBus() {
        return this.biBus;
    }

    public XTSEnvironment getEnvironment() {
        return this.env;
    }

    private static String getExceptionStack(Exception e) {
        ByteArrayOutputStream aBAOS = new ByteArrayOutputStream();
        PrintStream aS = new PrintStream(aBAOS);
        e.printStackTrace(aS);
        aS.flush();
        aS.close();
        return aBAOS.toString();
    }

    protected void getConnectionInformationFromDataSource() throws InvalidCredentialsFault, RepositoryAPIException {
        IXTSLogger connectionPerfLogger = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0]) {
            connectionPerfLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0);
        }
        if (connectionPerfLogger != null) {
            connectionPerfLogger.log(this.env, 6, this.getClass().getName(), "execute", "Start getting connection information from datasource: ");
            connectionPerfLogger.starttimer();
        }
        String cmQueryString_template = "<cm:custom xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><customFunction xsi:type=\"xsd:string\">customRepositoryRulesQuery</customFunction><functionSteps><functionStep name=\"repositoryRulesSignonQuery\" id=\"1\"><searchPath>SEARCHPATHID</searchPath><repositoryRuleObjectClass>reportVersion</repositoryRuleObjectClass><properties SOAP-ENC:arrayType=\"cm:propEnum[17]\"><item>connectionString</item><item>tenantID</item><item>credentials</item><item>parent</item></properties><options xsi:type=\"cm:queryOptions\"><permission xsi:type=\"xsd:string\">read</permission><schemaInfo xsi:type=\"xsd:boolean\">false</schemaInfo><skipObjects xsi:type=\"xsd:integer\">0</skipObjects><maxObjects xsi:type=\"xsd:integer\">0</maxObjects></options>       </functionStep><functionStep name=\"repositoryRulesQuery\" id=\"2\"><searchPath>SEARCHPATHID</searchPath><repositoryRuleObjectClass>output</repositoryRuleObjectClass><properties SOAP-ENC:arrayType=\"cm:propEnum[17]\"><item>searchPath</item><item>storeID</item><item>repositoryRules</item></properties><sortBy xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:sort[1]\"><item xsi:type=\"cm:sort\"><propName xsi:type=\"cm:propEnum\">defaultName</propName><order xsi:type=\"cm:orderEnum\">ascending</order></item></sortBy><options xsi:type=\"cm:queryOptions\"><permission xsi:type=\"xsd:string\">read</permission><schemaInfo xsi:type=\"xsd:boolean\">false</schemaInfo><skipObjects xsi:type=\"xsd:integer\">0</skipObjects><maxObjects xsi:type=\"xsd:integer\">0</maxObjects><dataEncoding xsi:type=\"cm:encodingEnum\">base64</dataEncoding><skipDataBytes xsi:type=\"xsd:integer\">0</skipDataBytes><maxDataBytes xsi:type=\"xsd:integer\">0</maxDataBytes></options></functionStep></functionSteps></cm:custom>";
        String cmQuery = cmQueryString_template.replaceAll("SEARCHPATHID", "storeID(\"" + this.targetSearchPath + "\")");
        SimpleQuery aQuery = new SimpleQuery();
        aQuery.setBody(cmQuery);
        aQuery.setBusHeader((Object)this.biBus.getBiBusHeader());
        aQuery.setResponseBodyHandler(new IXMLHandler(){

            public void handle(XMLStreamReader reader) throws XMLStreamException {
                XTSRepositoryConnection.this.parseCMResponse(reader);
            }
        });
        SOAPConnection connection = this.soapConnectionFactory.createConnection(this.getLogger());
        try {
            connection.execute((SOAPMessage)aQuery, BusConnectionImpl.BUS_CM);
        }
        catch (SOAPFault e) {
            Element detailElement = null;
            SAXReader saxreader = new SAXReader();
            try {
                detailElement = saxreader.read((Reader)new StringReader(e.getDetail())).getRootElement();
            }
            catch (DocumentException e1) {
                if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                    this.traceLogger.log(this.env, 4, "Error reading fault message" + XTSRepositoryConnection.getExceptionStack((Exception)((Object)e1)), null, null);
                }
                String detail = e.getDetail();
                Object[] arg = new String[]{detail};
                throw new RepositoryAPIException("protocol.repositoryFailedGetDataSourceParseError", arg, e1);
            }
            String detailErrorMessage = this.getFaultDetails(detailElement);
            if (detailErrorMessage != null && detailErrorMessage.length() > 0 && detailErrorMessage.startsWith("CM-REQ-4159")) {
                if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                    this.traceLogger.log(this.env, 4, "credential error" + XTSRepositoryConnection.getExceptionStack((Exception)((Object)e)), null, null);
                }
                throw new InvalidCredentialsFault("protocol.repositoryFailedGetDataSourceCredentialFailed", null, null);
            }
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                this.traceLogger.log(this.env, 4, "error occurred retrieving datasource information" + XTSRepositoryConnection.getExceptionStack((Exception)((Object)e)), null, null);
            }
            throw new RepositoryAPIException("protocol.repositoryFailedGetDataSource", new String[]{detailErrorMessage}, e);
        }
        catch (MalformedURLException e) {
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                this.traceLogger.log(this.env, 4, "Malformed exception occurred while getting datasource information" + XTSRepositoryConnection.getExceptionStack(e), null, null);
            }
            throw new RepositoryAPIException("protocol.repositoryFailedGetDataSourceGeneralError", new String[0], e);
        }
        catch (IOException e) {
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                this.traceLogger.log(this.env, 4, "IOEception exception occurred while getting datasource information" + XTSRepositoryConnection.getExceptionStack(e), null, null);
            }
            throw new RepositoryAPIException("protocol.repositoryFailedGetDataSourceGeneralError", new String[0], e);
        }
        catch (XMLStreamException e) {
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                this.traceLogger.log(this.env, 4, "Stream exception occurred while getting datasource information" + XTSRepositoryConnection.getExceptionStack(e), null, null);
            }
            throw new RepositoryAPIException("protocol.repositoryFailedGetDataSourceGeneralError", new String[0], e);
        }
        if (connectionPerfLogger != null) {
            connectionPerfLogger.stoptimer();
            connectionPerfLogger.log(this.env, 1, this.getClass().getName(), "execute", "end getting connection information from datasource ");
        }
    }

    private List selectNodes(Element e, String xPath) {
        return e.selectNodes(xPath);
    }

    private String getFaultDetails(Element detailElement) {
        List messages = this.selectNodes(detailElement, "//*[local-name()='message']/*[local-name()='messageString']");
        StringBuilder msgBuilder = new StringBuilder();
        int msgListSize = messages.size();
        for (Element msg : messages) {
            msgBuilder.append(msg.getText());
            if (--msgListSize <= 0) continue;
            msgBuilder.append(" ");
        }
        return msgBuilder.toString();
    }

    protected void parseCMResponse(XMLStreamReader reader) throws XMLStreamException {
        String[] paths = new String[]{"/customResponse/responses/response/queryResponse/queryResult/replies/item/queryResult/item", "/customResponse/responses/response/queryResponse/queryResult/replies/item/queryResult/item/connectionString/value", "/customResponse/responses/response/queryResponse/queryResult/replies/item/queryResult/item/credentials/value", "/customResponse/responses/response/queryResponse/queryResult/replies/item/queryResult/item/tenantID/value", "/customResponse/responses/response/queryResponse/queryResult/replies/item/queryResult/item/parent/value/item/storeID/value"};
        PathIterator pathIt = new PathIterator(reader, paths);
        boolean inDataSourceConnection = false;
        int index = 0;
        DataSourceConnection connection = null;
        String userName = null;
        String password = null;
        boolean dirty = false;
        while ((index = pathIt.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    String type = pathIt.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                    if (CM_DATA_SOURCE_CONNECTION.equals(type)) {
                        inDataSourceConnection = true;
                        connection = new DataSourceConnection();
                        dirty = this.save(connection, userName, password, dirty);
                        break;
                    }
                    inDataSourceConnection = false;
                    break;
                }
                case 1: {
                    this.dataSourceConnectionString = pathIt.getElementText();
                    this.isConfigured = true;
                    break;
                }
                case 2: {
                    String credentialString = pathIt.getElementText();
                    if (this.isTest()) {
                        userName = credentialString;
                        password = credentialString;
                        dirty = this.save(connection, userName, password, true);
                        break;
                    }
                    XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(credentialString));
                    String[] credPath = new String[]{"/credential/encryptedValue"};
                    PathIterator credIt = new PathIterator(xsr, credPath);
                    int index2 = 0;
                    while ((index2 = credIt.moveToNextPath()) != -1) {
                        switch (index2) {
                            case 0: {
                                String encypterCred = credIt.getElementText();
                                byte[] encryptedData = Base64.decode((String)encypterCred);
                                try {
                                    EncryptingSession es = camFactory.createEncryptingSession();
                                    byte[] decryptedData = es.decryptData(encryptedData);
                                    String sCredentialXML = new String(decryptedData, "UTF-8");
                                    XMLStreamReader credReader = XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(sCredentialXML));
                                    String[] upPaths = new String[]{"/credential/username", "/credential/password"};
                                    PathIterator upIt = new PathIterator(credReader, upPaths);
                                    int upIndex = 0;
                                    while ((upIndex = upIt.moveToNextPath()) != -1) {
                                        switch (upIndex) {
                                            case 0: {
                                                userName = upIt.getElementText();
                                                break;
                                            }
                                            case 1: {
                                                password = upIt.getElementText();
                                            }
                                        }
                                    }
                                    dirty = this.save(connection, userName, password, true);
                                    break;
                                }
                                catch (CAMCryptoException e) {
                                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                                        this.traceLogger.log(this.env, 4, "Error dycrypting signon credentials" + XTSRepositoryConnection.getExceptionStack((Exception)((Object)e)), null, null);
                                    }
                                    throw new XMLStreamException(e.getMessage(), e);
                                }
                                catch (UnsupportedEncodingException e) {
                                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                                        this.traceLogger.log(this.env, 4, "Error creating credential string" + XTSRepositoryConnection.getExceptionStack(e), null, null);
                                    }
                                    throw new XMLStreamException(e.getMessage(), e);
                                }
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    String connectionTenantID;
                    if (!inDataSourceConnection) break;
                    connection.connectionTenantID = connectionTenantID = pathIt.getElementText();
                    this.connections.put(connectionTenantID, connection);
                    break;
                }
                case 4: {
                    if (!inDataSourceConnection) break;
                    this.dataSourceID = pathIt.getElementText();
                }
            }
        }
        this.save(connection, userName, password, dirty);
    }

    private boolean save(DataSourceConnection connection, String userName, String password, boolean dirty) {
        if (dirty && connection != null && !connection.saved) {
            connection.userName = userName;
            connection.password = password;
            connection.saved = true;
            dirty = false;
        }
        return dirty;
    }

    public RepositoryConnection getConnectionToRepository(String userTenantID) throws RepositoryAPIException, InvalidCredentialsFault {
        try {
            IXTSLogger connectionPerfLogger = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0]) {
                connectionPerfLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0);
            }
            if (connectionPerfLogger != null) {
                connectionPerfLogger.log(this.env, 6, this.getClass().getName(), "execute", "Start getting repository connection: ");
                connectionPerfLogger.starttimer();
            }
            this.getConnectionInformationFromDataSource();
            DataSourceConnection connection = this.connections.get(userTenantID);
            if (this.isConfigured()) {
                Properties properties = new Properties();
                properties.put("CONSUMER_NAME", CONSUMER_NAME);
                if (userTenantID != null) {
                    properties.put("userTenantID", userTenantID);
                }
                if (connection != null) {
                    if (connection.userName != null) {
                        properties.put("user", connection.userName);
                    }
                    if (connection.password != null) {
                        properties.put("password", connection.password);
                    }
                    if (connection.connectionTenantID != null) {
                        properties.put("connectionTenantID", connection.connectionTenantID);
                    }
                }
                if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                    this.traceLogger.log(this.env, 4, "getConnection Connection String " + this.dataSourceConnectionString, null, null);
                }
                RepositoryConnection aConnection = this.getRepositoryConnection(this.dataSourceConnectionString, properties);
                if (connectionPerfLogger != null) {
                    connectionPerfLogger.stoptimer();
                    connectionPerfLogger.log(this.env, 1, this.getClass().getName(), "execute", "end getting repository connection ");
                }
                return aConnection;
            }
            return null;
        }
        catch (RepositoryException e) {
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                this.traceLogger.log(this.env, 4, "getConnection FAILED: " + e.getStackTrace().toString(), null, null);
            }
            String details = RepositoryAPIException.getRepositoryErrorDetails(e, this.env.getLocale());
            throw new RepositoryAPIException("protocol.repositoryconnectionFailed", new String[]{details}, e);
        }
    }

    protected RepositoryConnection getRepositoryConnection(String configuredString, Properties properties) throws RepositoryException {
        IXTSLogger repositoryGetConnPerfLogger = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0]) {
            repositoryGetConnPerfLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0);
        }
        if (this.repConnection == null) {
            if (repositoryGetConnPerfLogger != null) {
                repositoryGetConnPerfLogger.log(this.env, 6, this.getClass().getName(), "execute", "Start: Creating the repository Connection string ");
                repositoryGetConnPerfLogger.starttimer();
            }
            RepositoryConnectionString connectionString = new RepositoryConnectionString(configuredString);
            if (repositoryGetConnPerfLogger != null) {
                repositoryGetConnPerfLogger.stoptimer();
                repositoryGetConnPerfLogger.log(this.env, 1, this.getClass().getName(), "execute", "End: Creating the repository Connection string ");
            }
            if (repositoryGetConnPerfLogger != null) {
                repositoryGetConnPerfLogger.log(this.env, 6, this.getClass().getName(), "execute", "Start: Getting repository connection ");
                repositoryGetConnPerfLogger.starttimer();
            }
            this.repConnection = RepositoryPluginManager.getManager().getConnection((IRepositoryUserAgentFactory)this.aHttpClientFactory, (IRepositoryConnectionString)connectionString, properties, this.loader);
            if (repositoryGetConnPerfLogger != null) {
                repositoryGetConnPerfLogger.stoptimer();
                repositoryGetConnPerfLogger.log(this.env, 1, this.getClass().getName(), "execute", "End: Getting the repository Connection  ");
            }
        }
        return this.repConnection;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public String getDataSourceID() {
        return this.dataSourceID;
    }

    protected boolean isTest() {
        return false;
    }

    private class DataSourceConnection {
        String userName = null;
        String password = null;
        String connectionTenantID = null;
        boolean saved = false;

        private DataSourceConnection() {
        }
    }
}

