/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.repository;

import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryServiceHelper;
import com.cognos.cps.bseries.xts.repository.QueryParameter;
import com.cognos.cps.bseries.xts.repository.RepositoryAPIException;
import com.cognos.cps.bseries.xts.repository.XTSRepositoryConnection;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class XTSRepositoryRequest {
    private XTSRepositoryConnection rep_connection;
    protected IQueryResultObjects results = null;
    protected String currentCommand = null;
    protected String currentResultType = null;
    protected int currentSkipItems = 0;
    private IXTSLogger traceLogger;
    private String currentGateway;

    protected XTSRepositoryRequest() {
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0]) {
            this.traceLogger = XTSTraceLoggerManager.getInstance().getLogger(4, 0);
        }
    }

    public XTSRepositoryRequest(XTSRepositoryConnection aCon, String gateway) {
        this();
        this.rep_connection = aCon;
        this.currentGateway = gateway;
    }

    public IQueryResultObjects getResult() {
        return this.results;
    }

    public void executeRepositoryRequest(String command, String returnType, int skipItems, IQueryParameters params, String userTenantID) throws RepositoryAPIException {
        this.currentCommand = command;
        this.currentResultType = returnType;
        IXTSLogger requestPerfLogger = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0]) {
            requestPerfLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0);
        }
        String connectionTenantID = userTenantID;
        IQueryParameter connectionTenantIDParm = params.getParameter("connectionTenantID");
        if (connectionTenantIDParm != null) {
            connectionTenantID = connectionTenantIDParm.getValue().toString();
        }
        try {
            RepositoryConnection aCon = this.rep_connection.getConnectionToRepository(connectionTenantID);
            if (requestPerfLogger != null) {
                requestPerfLogger.log(this.rep_connection.getEnvironment(), 6, this.getClass().getName(), "execute", "Start getting result objects: ");
                requestPerfLogger.starttimer();
            }
            if (aCon != null) {
                this.results = aCon.queryObjects(command, params, null).getObjects();
                if (requestPerfLogger != null) {
                    requestPerfLogger.stoptimer();
                    requestPerfLogger.log(this.rep_connection.getEnvironment(), 1, this.getClass().getName(), "execute", "End getting result objects:");
                }
            }
        }
        catch (RepositoryException e) {
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                this.traceLogger.log(this.rep_connection.getEnvironment(), 4, "queryObjects FAILED: " + e.getStackTrace().toString(), null, null);
            }
            String details = RepositoryAPIException.getRepositoryErrorDetails(e, this.rep_connection.getEnvironment().getLocale());
            throw new RepositoryAPIException("protocol.repositoryExecutionFailed", new String[]{details}, e);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null && this.results != null) {
            this.traceLogger.log(this.rep_connection.getEnvironment(), 4, "queryObjects SUCCEEDED and retrieved " + this.results.size() + " objects", null, null);
        }
        this.currentSkipItems = skipItems;
    }

    public static String getQueryResultString(Object respositoryObject) {
        if (respositoryObject == null) {
            return "";
        }
        if (respositoryObject instanceof Calendar) {
            Calendar calendar = (Calendar)respositoryObject;
            SimpleDateFormat aFormat = QueryParameter.createDateFormatter();
            return aFormat.format(calendar.getTimeInMillis());
        }
        return respositoryObject.toString();
    }

    public String buildOutputURL(String gateway, String repositoryObjectId, String reportID, IQueryResultObjects currentObject, boolean bXMLEncode) throws RepositoryAPIException {
        String repositoryURL = null;
        try {
            RepositoryServiceHelper helper = new RepositoryServiceHelper();
            helper.setDocumentID(repositoryObjectId);
            helper.setDataSourceName(this.rep_connection.getDataSourceID());
            helper.setReportID(reportID);
            helper.setOutputFormat((String)currentObject.getPropertyValue("format"));
            String camPassportCookie = this.rep_connection.getBiBus().getCookieValue("cam_passport");
            helper.setCamPassportCookie(camPassportCookie);
            helper.setGateway(gateway);
            repositoryURL = helper.createViewOutputURL();
        }
        catch (Exception e) {
            Object[] args = new String[]{};
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && this.traceLogger != null) {
                this.traceLogger.log(this.rep_connection.getEnvironment(), 4, "build url failed: " + e.getStackTrace().toString(), null, null);
            }
            throw new RepositoryAPIException("protocol.repositoryqueryObjectsFailed", args, e);
        }
        if (bXMLEncode) {
            StringBuffer urlBufEncoded = new StringBuffer();
            EncodingUtils.xmlEncode((String)repositoryURL, (StringBuffer)urlBufEncoded);
            repositoryURL = urlBufEncoded.toString();
        }
        return repositoryURL;
    }
}

