/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.NavRequestResult;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.bus.NavBusRequest;
import com.cognos.cps.bseries.xts.request.nav.op.CCPSOperation;
import com.cognos.cps.bseries.xts.request.nav.op.CCPSOperationFactory;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.soap.impl.BusConnectionImpl;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.util.SequenceReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class NAVRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private ServiceLogger logger = new ServiceLoggerImpl(NAVRequest.class);
    private String m_sIdentifier = null;
    private CCPSOperationFactory factory;
    private NavBusRequest busRequest;
    private static final int POST_WRITER_SIZE = 32768;
    private SOAPConnectionFactoryImpl soapConnectionFactory;

    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.busRequest = new NavBusRequest(this.logger);
        this.factory = new CCPSOperationFactory();
        this.factory.initialize(this.logger);
        try {
            NavSystem.getInstance().initialize();
        }
        catch (NavException e) {
            throw new XTSInstructionException("cps.common.init.error", (Object[])new String[]{NAVRequest.class.getName()}, (Throwable)((Object)e));
        }
        ContextImpl context = new ContextImpl();
        try {
            context.setProperty("cmPath", (Object)new URL(CCLConfigurationFactory.getInstance().getValue("contentManager", true)).getFile());
            context.setProperty("dispatcherPath", (Object)new URL(CCLConfigurationFactory.getInstance().getValue("internalDispatcher", true)).getFile());
        }
        catch (CCLConfigurationException e) {
            throw new XTSInstructionException("cps.common.init.error", (Object[])new String[]{NAVRequest.class.getName()}, (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new XTSInstructionException("cps.common.init.error", (Object[])new String[]{NAVRequest.class.getName()}, (Throwable)e);
        }
        this.soapConnectionFactory = new SOAPConnectionFactoryImpl((IContext)context);
    }

    public void terminate() throws XTSInstructionException {
        this.m_sIdentifier = null;
        NavSystem.getInstance().terminate();
    }

    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String opName;
        ServiceLoggerImpl.setRequestId((String)env.getRequestContext());
        ServiceLoggerImpl.setSessionId((String)env.getSessionContext());
        Object prepareTimer = null;
        if (this.logger.isPerfLevelEnabled(4)) {
            prepareTimer = this.logger.startTimer(4, "execute", "prepare operation", null);
        }
        if (this.logger.isDebugEnabled()) {
            StringBuffer bodyBuffer = new StringBuffer();
            try {
                body = UXTSInstructionUtils.copyReader((Reader)body, (StringBuffer)bodyBuffer);
            }
            catch (IOException e) {
                throw new XTSInstructionException("IDS_ERR_OPERATION_FAILED", (Throwable)e);
            }
            this.logger.debug("Request body is : " + bodyBuffer.toString());
        }
        RequestContext context = this.createRequestContext(body, env);
        context.setProperty("navBusRequest", this.busRequest);
        context.setProperty("internalDispatcher", BusConnectionImpl.BUS_DISPATCHER);
        context.setProperty("contentManager", BusConnectionImpl.BUS_CM);
        context.setProperty("soapConnectionFactory", this.soapConnectionFactory);
        context.setProperty("locale", env.getLocale().toString());
        try {
            String value = CCLConfigurationFactory.getInstance().getValue("portal.launchBusinessInsightChromeless", true);
            context.setProperty("portal.launchBusinessInsightChromeless", value);
        }
        catch (CCLConfigurationException e) {
            Object[] args = new String[]{context.getRequest().getOpName()};
            throw new XTSInstructionException("IDS_ERR_OPERATION_FAILED", args, (Throwable)e);
        }
        String cmResponseData = UXTSInstructionUtils.getParameter((String)"cmResponseData", (Map)instParams);
        if (context.isMultipleRequest()) {
            opName = "request";
            if (cmResponseData != null) {
                if (prepareTimer != null) {
                    this.logger.stopTimer(prepareTimer);
                }
                return new NavRequestResult(new StringReader("<nav:requestResponse  xmlns:nav=\"http://developer.cognos.com/schemas/cps/navigation/1/\">xts:param=cmResponseData is not supported for nav:request.</nav:requestResponse>"));
            }
        } else {
            opName = context.getRequest().getOpName();
            if (cmResponseData != null) {
                context.setCMResponseData(cmResponseData);
            }
        }
        CCPSOperation operation = this.factory.getOperation(opName);
        StringWriter stringWriter = new StringWriter(32768);
        XMLStreamWriter writer = null;
        Reader soapheader = null;
        try {
            writer = XMLStreamFactory.createXMLStreamWriter((Writer)stringWriter);
            if (prepareTimer != null) {
                this.logger.stopTimer(prepareTimer);
            }
            Object executeTimer = null;
            if (this.logger.isPerfLevelEnabled(4)) {
                executeTimer = this.logger.startTimer(4, "execute", "execute operation: " + opName, null);
            }
            soapheader = operation.execute(context, writer);
            if (context.isRetryDeploymentId()) {
                Object reexecuteTimer = null;
                if (this.logger.isPerfLevelEnabled(4)) {
                    reexecuteTimer = this.logger.startTimer(4, "execute", "re-execute operation with deployment id: " + opName, null);
                }
                stringWriter = new StringWriter(32768);
                writer = XMLStreamFactory.createXMLStreamWriter((Writer)stringWriter);
                soapheader = operation.execute(context, writer);
                if (reexecuteTimer != null) {
                    this.logger.stopTimer(reexecuteTimer);
                }
            }
            writer.flush();
            if (executeTimer != null) {
                this.logger.stopTimer(executeTimer);
            }
        }
        catch (XMLStreamException e) {
            Object[] args = new String[]{context.getRequest().getOpName()};
            throw new XTSInstructionException("IDS_ERR_OPERATION_FAILED", args, (Throwable)e);
        }
        Object responseTimer = null;
        if (this.logger.isPerfLevelEnabled(4)) {
            responseTimer = this.logger.startTimer(4, "execute", "Setting up response", null);
        }
        Reader result = new StringReader(stringWriter.getBuffer().toString());
        if (this.logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            try {
                result = UXTSInstructionUtils.copyReader((Reader)result, (StringBuffer)buffer);
                this.logger.debug("Response body is : " + buffer.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean includeEnvelope = false;
        String responseEnvelope = UXTSInstructionUtils.getParameter((String)"responseEnvelope", (Map)instParams);
        if (responseEnvelope != null && responseEnvelope.equals("true")) {
            includeEnvelope = true;
        }
        if (includeEnvelope) {
            if (soapheader == null) {
                soapheader = new StringReader("");
            }
            result = new SequenceReader((Reader)new StringReader("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">"), (Reader)new SequenceReader(soapheader, (Reader)new SequenceReader((Reader)new StringReader("<soapenv:Body>"), (Reader)new SequenceReader(result, (Reader)new StringReader("</soapenv:Body></soapenv:Envelope>")))));
        }
        if (responseTimer != null) {
            this.logger.stopTimer(responseTimer);
        }
        return new NavRequestResult(result);
    }

    private RequestContext createRequestContext(Reader body, XTSEnvironment env) throws XTSInstructionException {
        RequestContext requestContext = null;
        try {
            XMLStreamReader reader = XMLStreamFactory.createXMLStreamReader((Reader)body);
            requestContext = new RequestContext(this.factory, this.logger);
            requestContext.parse(reader);
        }
        catch (XMLStreamException e) {
            throw new XTSInstructionException("soap.documentparseerror", (Throwable)e);
        }
        return requestContext;
    }
}

