/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav;

import com.cognos.cps.bseries.xts.request.nav.NAVRequest;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.bus.NavBusRequest;
import com.cognos.cps.bseries.xts.request.nav.op.CCPSOperation;
import com.cognos.cps.bseries.xts.request.nav.op.CCPSOperationFactory;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.xml.pipeline.IProcess;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class NavPipelineProcess
implements IProcess {
    private ServiceLogger logger;
    private CCPSOperationFactory factory;
    private NavBusRequest pipelineBusRequest;
    private String name;

    public NavPipelineProcess(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(NavPipelineProcess.class) : null;
    }

    public void initialize(Map inputs) throws PipelineException {
        this.factory = new CCPSOperationFactory();
        this.factory.initialize(this.logger);
        this.pipelineBusRequest = new NavBusRequest(this.logger);
        try {
            NavSystem.getInstance().initialize();
        }
        catch (NavException e) {
            throw new PipelineException("cps.common.init.error", (Object[])new String[]{NAVRequest.class.getName()}, (Throwable)((Object)e));
        }
    }

    protected XMLStreamReader getRequest(PipelineContext context) throws PipelineException {
        return context.getInputAsXMLStreamReader("request");
    }

    protected void addOutput(PipelineContext context, IPipelineOutput output) {
        context.addOutput("response", output);
    }

    protected void writeStartRootElement(XMLStreamWriter xsw) throws XMLStreamException {
    }

    protected void writeEndRootElement(XMLStreamWriter xsw) throws XMLStreamException {
    }

    public void execute(PipelineContext context) throws PipelineException {
        XMLStreamReader reader;
        Object prepareTimer = null;
        if (this.logger.isPerfLevelEnabled(4)) {
            prepareTimer = this.logger.startTimer(4, "execute", "prepare operation", null);
        }
        if ((reader = this.getRequest(context)) == null) {
            if (prepareTimer != null) {
                this.logger.stopTimer(prepareTimer);
            }
            return;
        }
        RequestContext requestContext = new RequestContext(this.factory, this.logger);
        requestContext.setProperty("internalDispatcher", context.getEnv().getProperty("internalDispatcher"));
        requestContext.setProperty("contentManager", context.getEnv().getProperty("contentManager"));
        requestContext.setProperty("soapConnectionFactory", context.getEnv().getProperty("SoapConnectionFactory"));
        requestContext.setProperty("navBusRequest", this.pipelineBusRequest);
        requestContext.setProperty("locale", context.getEnv().getProductLocale());
        try {
            requestContext.parse(reader);
        }
        catch (XMLStreamException e1) {
            throw new PipelineException("XMLStream", (Throwable)e1);
        }
        catch (XTSInstructionException e) {
            throw new PipelineException("XMLStream", (Throwable)e);
        }
        String opName = requestContext.isMultipleRequest() ? "request" : requestContext.getRequest().getOpName();
        CCPSOperation operation = this.factory.getOperation(opName);
        IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
        XMLStreamWriter writer = output.getXMLStreamWriter();
        if (prepareTimer != null) {
            this.logger.stopTimer(prepareTimer);
        }
        try {
            Object executeTimer = null;
            if (this.logger.isPerfLevelEnabled(4)) {
                executeTimer = this.logger.startTimer(4, "execute", "execute operation: " + opName, null);
            }
            this.writeStartRootElement(writer);
            operation.execute(requestContext, writer);
            this.writeEndRootElement(writer);
            if (requestContext.isRetryDeploymentId()) {
                Object reexecuteTimer = null;
                if (this.logger.isPerfLevelEnabled(4)) {
                    reexecuteTimer = this.logger.startTimer(4, "execute", "re-execute operation with deployment id: " + opName, null);
                }
                output = PipelineOutputFactory.getInstance().createOutput();
                writer = output.getXMLStreamWriter();
                this.writeStartRootElement(writer);
                operation.execute(requestContext, writer);
                this.writeEndRootElement(writer);
                if (reexecuteTimer != null) {
                    this.logger.stopTimer(reexecuteTimer);
                }
            }
            writer.flush();
            if (executeTimer != null) {
                this.logger.stopTimer(executeTimer);
            }
        }
        catch (XTSInstructionException e) {
            throw new PipelineException("XTSInstruction", (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new PipelineException("XMLStreamException", (Throwable)e);
        }
        Object responseTimer = null;
        if (this.logger.isPerfLevelEnabled(4)) {
            responseTimer = this.logger.startTimer(4, "execute", "Setting up response", null);
        }
        this.addOutput(context, output);
        if (responseTimer != null) {
            this.logger.stopTimer(responseTimer);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean canShare() {
        return true;
    }
}

