/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cps.bseries.xts.request.nav.NAVRequest;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.element.HandlerManager;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.NavPropertyManager;
import com.cognos.cps.bseries.xts.request.nav.helpers.ItemType;
import com.cognos.cps.bseries.xts.request.nav.stax.BusHeader;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.portal.utils.capability.CapabilityHelpers;
import com.cognos.xts.XTSException;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.XTSResourceManager;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class NavSystem {
    private static final String DEFAULT_WEB_CONTENT_URI = "..";
    private static final String g_junit_portalSystemPath = "com/cognos/cps/bseries/xts/request/nav/stylesheets/ps/portal/system.xml";
    private static final String g_portalSystemPath = "portal/system.xml";
    private static final String g_junit_systemPath = "com/cognos/cps/bseries/xts/request/nav/stylesheets/ps/system.xml";
    private static final String g_systemPath = "system.xml";
    private static final String g_junit_uiextensionsPath = "com/cognos/cps/bseries/xts/request/nav/stylesheets/ps/portal/uiExtensions.xml";
    private static final String g_uiextensionsPath = "portal/uiExtensions.xml";
    private static final String EMPTY_STRING = "";
    private static final String ROOT_LABEL_PROP = "nav.root.name";
    private static final String DEFAULT_ROOT_LABEL = "Cognos";
    private static final String CONSUMABLE_OUTPUT_FORMATS_ICON = "report";
    private boolean isInitialized = false;
    private boolean isTestEnv = false;
    private HashSet toHide;
    private static NavSystem system;
    private String defaultGateway;
    private HashMap<String, UIFormatGraphicsEntry> uiFormatGraphics;
    private HashMap uiGraphics;
    private HashMap objectFormatLookup;
    private HashMap uiObjects;
    private String cpsWebContent;
    private String systemSortUsage;
    private String systemVisibleFilter;
    private Set globalCapabilities;
    private boolean systemUseReportLocaleInRVUI;
    private HashMap<String, SupportedReportFormatEntry> supportedOutputFormats;
    private String viewerOutputFormatsList;
    private boolean isPackageCapabilitiesFeatureEnabled;
    private String mvc_remoteGateway = null;
    private String mvc_remoteWebContent = null;
    private boolean isExpandMHT = false;

    public static NavSystem getInstance() {
        return system;
    }

    public synchronized void terminate() {
        this.isInitialized = false;
    }

    private NavSystem() {
        this.setUpObjects();
    }

    private void setUpObjects() {
        this.uiGraphics = new HashMap();
        this.objectFormatLookup = new HashMap();
        this.uiFormatGraphics = new HashMap();
        this.uiObjects = new HashMap();
        this.globalCapabilities = new HashSet();
        this.supportedOutputFormats = new HashMap();
        this.isPackageCapabilitiesFeatureEnabled = false;
        this.toHide = new HashSet();
    }

    public String getDefaultGateway() {
        return this.defaultGateway;
    }

    public String getDefaultWebContent() {
        return DEFAULT_WEB_CONTENT_URI;
    }

    public String getCPSWebContent() {
        return this.cpsWebContent;
    }

    public String getSystemSortUsage() {
        return this.systemSortUsage;
    }

    public String getSystemVisibleFilter() {
        return this.systemVisibleFilter;
    }

    public boolean isUseReportLocaleInRVUI() {
        return this.systemUseReportLocaleInRVUI;
    }

    public String getConsumableOutputFormatsIcon() {
        return CONSUMABLE_OUTPUT_FORMATS_ICON;
    }

    public String getRootDefaultLabel(BusHeader header) {
        String localized = MessagesManager.getInstance().getMessage(header.getContentLocale(), ROOT_LABEL_PROP);
        if (!localized.equals(ROOT_LABEL_PROP)) {
            return localized;
        }
        return DEFAULT_ROOT_LABEL;
    }

    public String getUiFormatGraphics(String name) {
        if (this.uiFormatGraphics.containsKey(name) && this.supportedOutputFormats.containsKey(name)) {
            return this.uiFormatGraphics.get((Object)name).icon;
        }
        return this.getConsumableOutputFormatsIcon();
    }

    public boolean isUiFormatGraphicsDocument(String name) {
        if (this.uiFormatGraphics.containsKey(name) && this.supportedOutputFormats.containsKey(name)) {
            return this.uiFormatGraphics.get((Object)name).isDocument;
        }
        return false;
    }

    public String getOutputFormatDisplayName(String format) {
        return (String)this.objectFormatLookup.get(format);
    }

    public String getUiGraphics(String name) {
        if (this.uiGraphics.containsKey(name)) {
            return (String)this.uiGraphics.get(name);
        }
        return EMPTY_STRING;
    }

    public boolean isActionExcluded(String object, String name) {
        if (this.uiObjects.containsKey(object)) {
            return ((UIObject)this.uiObjects.get(object)).isActionExcluded(name);
        }
        return false;
    }

    public boolean isContainer(String name) {
        if (this.uiObjects.containsKey(name)) {
            return ((UIObject)this.uiObjects.get(name)).isContainer();
        }
        return false;
    }

    public String getPSObjectIcon(String classname) {
        UIObject uiobj = (UIObject)this.uiObjects.get("PS:" + classname);
        return uiobj != null ? uiobj.getIcon() : EMPTY_STRING;
    }

    public String getObjectClassMSGID(String classname) {
        UIObject uiobj = (UIObject)this.uiObjects.get(classname);
        return uiobj != null ? uiobj.getClassNameMSGID() : EMPTY_STRING;
    }

    public String getUiObjectClassId(String objectClass, String interfaceName) {
        return objectClass + "|" + interfaceName;
    }

    public boolean isOutputFormatSupported(String output) {
        return this.supportedOutputFormats.containsKey(output);
    }

    public boolean isOutputFormatDownloadable(String output) {
        SupportedReportFormatEntry entry = this.supportedOutputFormats.get(output);
        boolean downloadable = entry != null ? "true".equalsIgnoreCase(entry.downloadable) : false;
        return downloadable;
    }

    public boolean isOutputFormatSupported(String format, String browser, boolean bMissingDownloadableEntryAsTrue) {
        SupportedReportFormatEntry entry = this.supportedOutputFormats.get(format);
        if (entry != null && !entry.browserHide.equals(browser)) {
            if ("true".equals(entry.downloadable)) {
                return true;
            }
            if ((entry.downloadable == null || EMPTY_STRING.equals(entry.downloadable)) && bMissingDownloadableEntryAsTrue) {
                return true;
            }
        }
        return false;
    }

    public String getViewerOutputFormatsList() {
        return this.viewerOutputFormatsList;
    }

    public boolean isTestEnv() {
        return this.isTestEnv;
    }

    public void setTestEnv() {
        this.isTestEnv = true;
    }

    public boolean isMVCEnabled() {
        return this.mvc_remoteGateway != null && !EMPTY_STRING.equals(this.mvc_remoteGateway) && this.mvc_remoteWebContent != null && !EMPTY_STRING.equals(this.mvc_remoteWebContent);
    }

    public String getMVCRemoteGateway() {
        return this.mvc_remoteGateway;
    }

    public String getMVCRemoteWebContent() {
        return this.mvc_remoteWebContent;
    }

    public synchronized void initialize() throws NavException {
        InputStream uiExtensions;
        InputStream portalSystem;
        InputStream psSystem;
        if (this.isInitialized) {
            return;
        }
        this.setUpObjects();
        if (this.isTestEnv()) {
            psSystem = NavSystem.class.getClassLoader().getResourceAsStream(g_junit_systemPath);
            portalSystem = NavSystem.class.getClassLoader().getResourceAsStream(g_junit_portalSystemPath);
            uiExtensions = NavSystem.class.getClassLoader().getResourceAsStream(g_junit_uiextensionsPath);
        } else {
            try {
                psSystem = XTSResourceManager.getInstance().getResource(g_systemPath);
                portalSystem = XTSResourceManager.getInstance().getResource(g_portalSystemPath);
                uiExtensions = XTSResourceManager.getInstance().getResource(g_uiextensionsPath);
            }
            catch (XTSException e) {
                throw new NavException("cps.common.getresource.error", new String[]{NAVRequest.class.getName()}, e);
            }
        }
        this.initialize(psSystem, portalSystem, uiExtensions);
        this.isInitialized = true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    private void initialize(InputStream psSystem, InputStream portalSystem, InputStream uiExtensions) throws NavException {
        this.readPsSystem(psSystem);
        this.readPortalSystem(portalSystem, uiExtensions);
        this.calculateGatewayAndWebContent();
    }

    private void readPsSystem(InputStream in) throws NavException {
        String id;
        Element e;
        int i;
        InputStreamReader reader2 = new InputStreamReader(in);
        Element systemElem = null;
        SAXReader saxreader = new SAXReader();
        try {
            systemElem = saxreader.read((Reader)reader2).getRootElement();
        }
        catch (DocumentException e2) {
            throw new NavException("cps.common.parse.error", new String[]{NAVRequest.class.getName()}, e2);
        }
        StringBuffer formatsList = new StringBuffer();
        List formats = systemElem.selectNodes("/system/param[@name='reportFormats']/format");
        for (i = 0; i < formats.size(); ++i) {
            e = (Element)formats.get(i);
            id = e.attributeValue("id");
            String downloadable = e.attributeValue("downloadable");
            String browserHide = e.attributeValue("browserHide");
            String appMode = e.attributeValue("appMode");
            String extension = e.attributeValue("extension");
            if (id == null) continue;
            this.supportedOutputFormats.put(id, new SupportedReportFormatEntry(downloadable, browserHide, appMode, extension));
            formatsList.append(id + " ");
        }
        formats = systemElem.selectNodes("/system/param[@name='documentFormats']/format");
        for (i = 0; i < formats.size(); ++i) {
            e = (Element)formats.get(i);
            id = e.attributeValue("id");
            String extension = e.attributeValue("extension");
            if (id == null) continue;
            this.supportedOutputFormats.put(id, new SupportedReportFormatEntry(null, null, null, extension));
        }
        List toHideNodes = systemElem.selectNodes("/system/param[@name='ui_hide']/child::*");
        for (int i2 = 0; i2 < toHideNodes.size(); ++i2) {
            Element e3 = (Element)toHideNodes.get(i2);
            this.toHide.add(e3.getName());
        }
        this.viewerOutputFormatsList = formatsList.toString().trim();
        CapabilityHelpers.parseBrowserBasedCapabilities((Element)systemElem);
        Node allowExpandedMHT = systemElem.selectSingleNode("/system/param[@name='allowExpandedMHT']");
        if (allowExpandedMHT != null) {
            this.isExpandMHT = Boolean.parseBoolean(allowExpandedMHT.getText());
        }
    }

    public boolean isExpandMHT() {
        return this.isExpandMHT;
    }

    private void readPortalSystem(InputStream portalSystem, InputStream uiExtensions) throws NavException {
        String container;
        String classname;
        InputStreamReader reader = new InputStreamReader(portalSystem);
        Element systemElem = null;
        SAXReader saxreader = new SAXReader();
        try {
            systemElem = saxreader.read((Reader)reader).getRootElement();
        }
        catch (DocumentException e) {
            throw new NavException("cps.common.parse.error", new String[]{NAVRequest.class.getName()}, e);
        }
        this.isPackageCapabilitiesFeatureEnabled = "true".equalsIgnoreCase(systemElem.valueOf("/system/param[@name='enable-package-capability-check']"));
        List params = systemElem.selectNodes("/system/param[@name='ui_graphics']/param");
        for (int i = 0; i < params.size(); ++i) {
            Element e = (Element)params.get(i);
            String name = e.attributeValue("name");
            String value = e.getText();
            if (name.equals("output_format") || name.equals("document_format") || name.equals("agentHotlist_format")) {
                List formats = e.elements();
                for (int j = 0; j < formats.size(); ++j) {
                    Element format = (Element)formats.get(j);
                    String fname = format.attributeValue("name");
                    String fvalue = format.attributeValue("icon");
                    this.uiFormatGraphics.put(fname, new UIFormatGraphicsEntry(fvalue, name.equals("document_format")));
                }
                continue;
            }
            this.uiGraphics.put(name, value);
        }
        String useReportLocaleInRVUI = systemElem.valueOf("/system/param[@name='useReportLocaleInRVUI']");
        this.systemUseReportLocaleInRVUI = useReportLocaleInRVUI != null && "true".equalsIgnoreCase(useReportLocaleInRVUI);
        String entryOrderMode = systemElem.valueOf("/system/param[@name = 'entry-order-mode']");
        this.systemSortUsage = "2".equals(entryOrderMode) ? EMPTY_STRING : ("1".equals(entryOrderMode) ? "descending" : "ascending");
        this.systemVisibleFilter = systemElem.valueOf("/system/param[@name = 'visible']");
        InputStreamReader extReader = new InputStreamReader(uiExtensions);
        Element uiMetadataElem = null;
        SAXReader saxExtReader = new SAXReader();
        try {
            uiMetadataElem = saxExtReader.read((Reader)extReader).getRootElement();
            uiMetadataElem.addNamespace("nox", "http://developer.cognos.com/schemas/navomx/1/");
        }
        catch (DocumentException e) {
            throw new NavException("cps.common.parse.error", new String[]{NAVRequest.class.getName()}, e);
        }
        List globalCapabilitiesElements = uiMetadataElem.selectNodes("/nox:uiMetadata/nox:set[*[local-name()='name']='globalCapabilities']/nox:valueList/nox:value");
        for (int j = 0; j < globalCapabilitiesElements.size(); ++j) {
            Element capElem = (Element)globalCapabilitiesElements.get(j);
            this.globalCapabilities.add(capElem.getText().trim());
        }
        List extObjects = uiMetadataElem.selectNodes("/nox:uiMetadata/nox:classes/nox:class");
        for (int i = 0; i < extObjects.size(); ++i) {
            Element obj = (Element)extObjects.get(i);
            classname = obj.valueOf("./nox:name");
            container = obj.valueOf("./nox:container");
            String classId = obj.valueOf("./nox:idsString");
            boolean isContainer = container.equals("true");
            UIObject uiObject = UIObject.getUIObject(classname, isContainer, this.uiObjects);
            uiObject.setClassNameMSGID(classId);
            if (!isContainer) continue;
            List userInterfaces = obj.selectNodes("./nox:userInterface");
            for (int j = 0; j < userInterfaces.size(); ++j) {
                Element subObj = (Element)userInterfaces.get(j);
                String subObjName = subObj.valueOf("./nox:name");
                UIObject userInterfaceUiObject = UIObject.getUIObject(subObjName, isContainer, this.uiObjects);
                classId = obj.valueOf("./nox:idsString");
                uiObject.setClassNameMSGID(classId);
            }
        }
        List formatList = uiMetadataElem.selectNodes("/nox:uiMetadata/nox:objectFormatLookup/*/nox:format");
        if (formatList.size() > 0) {
            for (int i = 0; i < formatList.size(); ++i) {
                Element format = (Element)formatList.get(i);
                String name = format.valueOf("./@name");
                String idsString = format.valueOf("./nox:readableFormat/nox:idsString");
                this.objectFormatLookup.put(name, idsString);
            }
        }
        List customObjects = systemElem.selectNodes("/system/param[@name='base-object-actions']/actions/object");
        for (int i = 0; i < customObjects.size(); ++i) {
            String excludedActions;
            Element obj = (Element)customObjects.get(i);
            classname = obj.attributeValue("class");
            UIObject uiObject = UIObject.getUIObject(classname, false, this.uiObjects);
            if (uiObject != null && (excludedActions = obj.attributeValue("exclude")) != null && excludedActions.length() > 0) {
                StringTokenizer excluded = new StringTokenizer(excludedActions, " ");
                while (excluded.hasMoreTokens()) {
                    String token = excluded.nextToken();
                    if (token.length() <= 0) continue;
                    uiObject.addExcludedAction(token);
                }
            }
            List userInterfaces = obj.selectNodes("userInterface");
            for (Element userInterface : userInterfaces) {
                String excludedActions2;
                String userInterfaceName = this.getUiObjectClassId(classname, userInterface.attributeValue("name"));
                UIObject userInterfaceUiObject = UIObject.getUIObject(userInterfaceName, true, this.uiObjects);
                if (this.uiObjects == null || (excludedActions2 = userInterface.attributeValue("exclude")) == null || excludedActions2.length() <= 0) continue;
                StringTokenizer excluded = new StringTokenizer(excludedActions2, " ");
                while (excluded.hasMoreTokens()) {
                    String token = excluded.nextToken();
                    if (token.length() <= 0) continue;
                    userInterfaceUiObject.addExcludedAction(token);
                }
            }
        }
        List ps_ui_objects = systemElem.selectNodes("/system/param[@name='ui_objects']/object");
        if (ps_ui_objects.size() > 0) {
            for (int i = 0; i < ps_ui_objects.size(); ++i) {
                Element obj = (Element)ps_ui_objects.get(i);
                classname = "PS:" + obj.attributeValue("class");
                String icon = obj.attributeValue("icon");
                container = obj.attributeValue("container");
                UIObject uiobj = UIObject.getUIObject(classname, "true".equals(container), this.uiObjects);
                uiobj.setIcon(icon);
                this.uiObjects.put(classname, uiobj);
            }
        }
        HandlerManager.initialize(uiMetadataElem);
        ItemType.initialize(uiMetadataElem);
        NavPropertyManager.getInstance().initialize(uiMetadataElem);
    }

    private void calculateGatewayAndWebContent() throws NavException {
        try {
            this.defaultGateway = CCLConfigurationFactory.getInstance().getValue("gateway", true);
            Element cps = CCLConfigurationFactory.getInstance().getValueElement("CPS", true);
            if (cps != null) {
                cps.add(new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/"));
                this.cpsWebContent = cps.valueOf("./crn:parameter[@name = 'webcontent']/crn:value");
            }
            this.mvc_remoteGateway = CCLConfigurationFactory.getInstance().getValue("MVC_remoteGateway", true);
            this.mvc_remoteWebContent = CCLConfigurationFactory.getInstance().getValue("MVC_remoteWebContent", true);
        }
        catch (CCLConfigurationException e) {
            throw new NavException("cps.common.init.error", e);
        }
        if (this.cpsWebContent != null && this.cpsWebContent.length() == 0) {
            this.cpsWebContent = null;
        }
    }

    public void setCPSWebContent(String cpsWebContent) {
        this.cpsWebContent = cpsWebContent;
    }

    public void setDefaultGateway(String defaultGateway) {
        this.defaultGateway = defaultGateway;
    }

    public boolean isGlobalCapability(String capability) {
        return this.globalCapabilities.contains(capability);
    }

    public boolean isPackageCapabilitiesFeatureEnabled() {
        return this.isPackageCapabilitiesFeatureEnabled;
    }

    public String getProperty(String property) {
        return PropertiesManager.getInstance().getProperty(property);
    }

    public void setMVCRemoteGateway(String remoteGateway) {
        this.mvc_remoteGateway = remoteGateway;
    }

    public void setMVCRemoteWebContent(String remoteWebContent) {
        this.mvc_remoteWebContent = remoteWebContent;
    }

    public boolean isHidden(String contentTag) {
        return this.toHide.contains(contentTag);
    }

    static {
        ArrayList<String> msgFileList = new ArrayList<String>();
        msgFileList.add("cpsinavcrnmsgs");
        msgFileList.add("cpsinavcrnmsgs_custom");
        MessagesManager.getInstance().initialize(msgFileList);
        system = new NavSystem();
    }

    private class UIFormatGraphicsEntry {
        public String icon;
        public boolean isDocument;

        UIFormatGraphicsEntry(String icon, boolean isDocument) {
            this.icon = icon;
            this.isDocument = isDocument;
        }
    }

    private class SupportedReportFormatEntry {
        public String downloadable;
        public String browserHide;
        public String appMode;
        public String extension;

        public SupportedReportFormatEntry(String downloadable, String browserHide, String appMode, String extension) {
            this.downloadable = downloadable;
            this.browserHide = browserHide;
            this.appMode = appMode;
            this.extension = extension;
        }
    }

    private static class UIObject {
        private ArrayList excludedActions;
        private String className;
        private boolean isContainer;
        private String icon;
        private String classNameMSGID;

        public UIObject(String className, boolean isContainer) {
            this.className = className;
            this.isContainer = isContainer;
            this.excludedActions = new ArrayList();
            this.classNameMSGID = NavSystem.EMPTY_STRING;
        }

        public void addExcludedAction(String action) {
            this.excludedActions.add(action);
        }

        public boolean isActionExcluded(String action) {
            return this.excludedActions.contains(action);
        }

        public boolean isContainer() {
            return this.isContainer;
        }

        public void setClassNameMSGID(String id) {
            this.classNameMSGID = id;
        }

        public String getClassNameMSGID() {
            return this.classNameMSGID;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getIcon() {
            return this.icon;
        }

        public static UIObject getUIObject(String className, boolean isContainer, HashMap uiObjects) {
            UIObject result = null;
            if (uiObjects.containsKey(className)) {
                result = (UIObject)uiObjects.get(className);
            } else {
                result = new UIObject(className, isContainer);
                uiObjects.put(className, result);
            }
            return result;
        }
    }
}

