/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav;

import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.resource.CPSStylesheetResourceCache;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.xts.ext.XTSExt;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class NavUtils {
    private static final String RESOURCE_BASE = "nav/";

    public static String getCAFContextId(String passport) {
        if (passport != null) {
            return XTSExt.cafaction((String)("get_contextid_setcomponent_ps_settemplatename_cpsnav_setpassportid_" + passport), (String)"");
        }
        return null;
    }

    public static String urlEncode(String s) {
        if (s != null) {
            try {
                return XTSExt.urlencode((String)s);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String urlDecode(String s) {
        if (s != null) {
            try {
                return XTSExt.urldecode((String)s);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String urlEncodeAndProtect(String s, String s1, String s2, String s3) {
        if (s != null) {
            try {
                return XTSExt.protect((String)XTSExt.urlencode((String)s), (String)s1, (String)s2, (String)s3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String protect(String s, String s1, String s2, String s3) {
        if (s != null) {
            return XTSExt.protect((String)s, (String)s1, (String)s2, (String)s3);
        }
        return null;
    }

    public static boolean isSafeURL(String url) {
        return "true".equals(XTSExt.cafaction((String)"issafeurl_null", (String)url));
    }

    public static String web64Encode(String string, boolean b) {
        return XTSExt.web64encode((String)string, (boolean)b);
    }

    public static String web64Decode(String string, boolean b) {
        return XTSExt.web64decode((String)string, (boolean)b);
    }

    public static String formatDatFormUTC(String string, int i, int j, String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "en";
        }
        try {
            return XTSExt.formatDateFromUTC((String)string, (int)i, (int)j, (String)string2, (String)string3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String formatNumber(String number, String locale, int style) {
        if (number == null) {
            number = "";
        }
        if (locale == null) {
            locale = "en";
        }
        try {
            return XTSExt.formatNumber((String)number, (String)locale, (int)style);
        }
        catch (Exception exception) {
            return number;
        }
    }

    public static void transform(String stylesheetName, Reader xmlIn, Writer xmlOut) throws NavException {
        stylesheetName = RESOURCE_BASE + stylesheetName;
        HashMap<String, String> outputProps = new HashMap<String, String>();
        outputProps.put("omit-xml-declaration", "yes");
        HashMap stylesheetParams = new HashMap();
        SAXSource source = new SAXSource(new InputSource(xmlIn));
        source.setSystemId(stylesheetName);
        StreamResult result = new StreamResult(xmlOut);
        NavUtils.applyTransform(stylesheetName, stylesheetParams, outputProps, source, result, Locale.getDefault());
    }

    private static void applyTransform(String stylesheetName, Map stylesheetParams, Map outputProps, Source source, Result result, Locale locale) throws NavException {
        Map.Entry pair2;
        Transformer transformer = null;
        try {
            transformer = (Transformer)CPSStylesheetResourceCache.getInstance().getResource(stylesheetName, locale);
        }
        catch (Throwable e) {
            Object[] args = new String[]{stylesheetName};
            throw new NavException("cps.loadresourcefailed", args, e);
        }
        if (stylesheetParams != null) {
            pair2 = null;
            for (Map.Entry pair2 : stylesheetParams.entrySet()) {
                transformer.setParameter((String)pair2.getKey(), pair2.getValue());
            }
        }
        if (outputProps != null) {
            pair2 = null;
            for (Map.Entry pair2 : outputProps.entrySet()) {
                transformer.setOutputProperty((String)pair2.getKey(), (String)pair2.getValue());
            }
        }
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            Object[] args = new String[]{stylesheetName};
            throw new NavException("transformer.compileerror", args, e);
        }
    }

    public static void xmlEncode(String s, StringBuffer buffer) {
        EncodingUtils.xmlEncode((String)s, (StringBuffer)buffer);
    }

    public static String xmlDecode(String s) {
        return XTSExt.xmldecode((String)s);
    }

    public static boolean moveToElementWithinParent(String target, String parent, XMLStreamReader reader) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (event == 1 && reader.getLocalName().equals(target)) {
                return true;
            }
            if (event == 2 && reader.getLocalName().equals(parent)) {
                return false;
            }
            event = reader.next();
        }
        return false;
    }
}

