/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav;

import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.bseries.xts.request.nav.bus.NavBusRequest;
import com.cognos.cps.bseries.xts.request.nav.op.CCPSOperationFactory;
import com.cognos.cps.bseries.xts.request.nav.stax.BusHeader;
import com.cognos.cps.bseries.xts.request.nav.stax.NavRequest;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.common.utils.Strings;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.utils.web.WebUtils;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamReaderRecorder;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RequestContext {
    public static final String PROP_INDEX_SEARCH_RESPONSE = "index_search";
    public static final String PROP_USE_DEPLYMENT_ID = "dep_id";
    private static final String defaultImageLocation = "/ps/portal/images/";
    private ServiceLogger logger;
    private BusHeader busHeader;
    private HashSet capabilities;
    private boolean isMultipleRequest = false;
    private boolean atLeastOneCMOperation = false;
    private ArrayList navRequests;
    private Iterator it;
    private NavRequest currentRequest;
    private CCPSOperationFactory factory;
    private String usersBrowser = null;
    private String imageRootParam = null;
    private String imageRoot = null;
    private String webContentURL = null;
    private String gatewayURL = null;
    private String validateTag = null;
    private boolean retryDeploymentId = false;
    private int requestCountBase = 0;
    private String _localName;
    private String _attribute;
    private String cmResponseData;
    private boolean isCMResponseData = false;
    private Map properties = new HashMap();

    public HashSet getCapabilities() {
        return this.capabilities;
    }

    public RequestContext(CCPSOperationFactory factory, ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(RequestContext.class) : null;
        this.capabilities = null;
        this.navRequests = new ArrayList();
        this.factory = factory;
    }

    public boolean isMultipleRequest() {
        return this.isMultipleRequest;
    }

    public void setAtLeaseOneCMOperation(boolean atLeaseOneCMOperation) {
        this.atLeastOneCMOperation = atLeaseOneCMOperation;
    }

    public boolean hasAtLeaseOneCMOperation() {
        return this.atLeastOneCMOperation;
    }

    public void parse(XMLStreamReader reader) throws XMLStreamException, XTSInstructionException {
        String namespaceURI = "";
        while (reader.hasNext()) {
            StaxUtils.moveToElement((String)"Header", (XMLStreamReader)reader);
            namespaceURI = reader.getNamespaceURI();
            if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) continue;
            this.busHeader = new BusHeader();
            this.busHeader.parse(new XMLStreamReaderRecorder("biBusHeader", reader));
            StaxUtils.moveToElement((String)"Body", (XMLStreamReader)reader);
            namespaceURI = reader.getNamespaceURI();
            if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) continue;
            this.processBody(reader);
            break;
        }
        this.calculateCapabilites();
    }

    public void processBody(XMLStreamReader reader) throws XMLStreamException {
        reader.next();
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                this._localName = reader.getLocalName();
                if ("request".equals(this._localName)) {
                    this.processRequest(reader);
                    break;
                }
                NavRequest request = new NavRequest();
                request.parse(reader);
                this.currentRequest = request;
                this.setBrowser(this.currentRequest.getParam("browserAgent"));
                this.webContentURL = this.currentRequest.getParam("webContentURL");
                this.imageRootParam = this.currentRequest.getParam("imageRoot");
                this.gatewayURL = this.currentRequest.getParam("gatewayURL");
                this.validateTag = (String)this.currentRequest.getElement("validateTag");
                return;
            }
            reader.next();
        }
    }

    private void processRequest(XMLStreamReader reader) throws XMLStreamException {
        this.isMultipleRequest = true;
        HashMap<String, String> inheritableRequestParams = null;
        reader.next();
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                this._localName = reader.getLocalName();
                if ("queries".equals(this._localName)) {
                    while (NavUtils.moveToElementWithinParent("query", "queries", reader)) {
                        reader.next();
                        NavRequest request = new NavRequest();
                        if (inheritableRequestParams != null) {
                            request.addParams(inheritableRequestParams);
                        }
                        request.parse(reader);
                        request.setOperation(this.factory.getOperation(request.getOpName()));
                        this.currentRequest = request;
                        if (!this.hasAtLeaseOneCMOperation() && request.isCMOperation(this)) {
                            this.setAtLeaseOneCMOperation(true);
                        }
                        this.navRequests.add(request);
                    }
                    this.it = this.navRequests.iterator();
                } else if ("validateTag".equals(this._localName)) {
                    this.validateTag = reader.getElementText().trim();
                } else if ("param".equals(this._localName)) {
                    this._attribute = reader.getAttributeValue("", "name");
                    if ("browserAgent".equals(this._attribute)) {
                        this.setBrowser(reader.getElementText().trim());
                    } else if ("webContentURL".equals(this._attribute)) {
                        this.webContentURL = reader.getElementText().trim();
                    } else if ("imageRoot".equals(this._attribute)) {
                        this.imageRootParam = reader.getElementText().trim();
                    } else if ("gatewayURL".equals(this._attribute)) {
                        this.gatewayURL = reader.getElementText().trim();
                    } else if ("portalAgent".equals(this._attribute)) {
                        if (inheritableRequestParams == null) {
                            inheritableRequestParams = new HashMap<String, String>();
                        }
                        inheritableRequestParams.put("portalAgent", reader.getElementText().trim());
                    }
                }
            }
            reader.next();
        }
    }

    public String getValidateTag() {
        return this.validateTag;
    }

    public RequestContext next() {
        this.currentRequest = (NavRequest)this.it.next();
        return this;
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public RequestContext begin() {
        this.it = this.navRequests.iterator();
        return this;
    }

    private void calculateCapabilites() throws XTSInstructionException {
        String[] params;
        String navCap;
        try {
            if (NavSystem.getInstance().isTestEnv()) {
                this.capabilities = this.getHeader().getUserCapabilities();
                if (this.capabilities == null || this.capabilities.size() == 0) {
                    this.capabilities = new HashSet();
                    String CAP_STRING = "wrqhgnuslI";
                    boolean CAP_CAN_USE_REPORT_STUDIO = true;
                    int CAP_CAN_USE_QUERY_STUDIO = 2;
                    int CAP_CAN_USE_EVENT_STUDIO = 3;
                    int CAP_CAN_USE_ANALYSIS_STUDIO = 4;
                    int CAP_CAN_USE_METRIC_STUDIO = 5;
                    int CAP_CAN_USE_PLANNING_CONTRIBUTOR = 6;
                    int CAP_CAN_USE_COGNOS_VIEWER_RUNOPTIONS = 7;
                    int CAP_CAN_USE_SCHEDULING = 8;
                    String cap = this.getHeader().getCapability();
                    if (cap.indexOf(CAP_STRING.charAt(CAP_CAN_USE_QUERY_STUDIO)) != -1) {
                        this.capabilities.add("canUseQueryStudio");
                    }
                    if (cap.indexOf(CAP_STRING.charAt(CAP_CAN_USE_EVENT_STUDIO)) != -1) {
                        this.capabilities.add("canUseEventStudio");
                    }
                    if (cap.indexOf(CAP_STRING.charAt(CAP_CAN_USE_ANALYSIS_STUDIO)) != -1) {
                        this.capabilities.add("canUseAnalysisStudio");
                    }
                    if (cap.indexOf(CAP_STRING.charAt(CAP_CAN_USE_METRIC_STUDIO)) != -1) {
                        this.capabilities.add("canUseMetricStudio");
                    }
                    if (cap.indexOf(CAP_STRING.charAt(CAP_CAN_USE_PLANNING_CONTRIBUTOR)) != -1) {
                        this.capabilities.add("canUsePlanningContributor");
                    }
                    if (cap.indexOf(CAP_STRING.charAt(CAP_CAN_USE_COGNOS_VIEWER_RUNOPTIONS)) != -1) {
                        this.capabilities.add("canUseCognosViewerRunWithOptions");
                    }
                    if (cap.indexOf(CAP_STRING.charAt(CAP_CAN_USE_SCHEDULING)) != -1) {
                        this.capabilities.add("canUseScheduling");
                    }
                }
            } else {
                this.capabilities = this.getHeader().getUserCapabilities();
            }
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("CPS fault : UserCapabilities security rejection");
            }
            String navErrorCode = "nav:OperationFailed";
            String navErrorMessage = MessagesManager.getInstance().getMessage(this.getHeader().getProductLocale(), "IDS_ERR_OPERATION_FAILED");
            Reader faultReader = NavBusRequest.getFaultXML(navErrorCode, navErrorMessage);
            StringReader headerReader = new StringReader("<SOAP-ENV:Header>" + this.getHeader().getHeaderString() + "</SOAP-ENV:Header>");
            throw new XTSSoapFaultException(navErrorCode, faultReader, (Reader)headerReader, 11, false);
        }
        if (this.capabilities == null) {
            this.capabilities = new HashSet();
        }
        if ((navCap = this.getHeader().getNavCapabilities()) != null && navCap.length() > 0 && (params = Strings.split((String)navCap, (char)'|')) != null) {
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                this.capabilities.add(param);
            }
        }
    }

    public boolean hasCapability(String cap) {
        if (cap == null || cap.length() == 0) {
            return true;
        }
        return this.capabilities.contains(cap);
    }

    public BusHeader getHeader() {
        return this.busHeader;
    }

    public NavRequest getRequest() {
        return this.currentRequest;
    }

    public void resetRequestCountBase() {
        this.requestCountBase = 0;
    }

    public void addToRequestCountBase(int requestCount) {
        this.requestCountBase += requestCount;
    }

    public int getRequestCountBase() {
        return this.requestCountBase;
    }

    public String getGatewayURL() {
        if (this.gatewayURL != null) {
            return this.gatewayURL;
        }
        this.gatewayURL = NavSystem.getInstance().getDefaultGateway();
        return this.gatewayURL;
    }

    public String getImageRoot() {
        if (this.imageRoot != null) {
            return this.imageRoot;
        }
        this.imageRoot = this.imageRootParam == null ? this.getWebContentURL() + defaultImageLocation : this.getWebContentURL() + this.imageRootParam;
        return this.imageRoot;
    }

    public String getWebContentURL() {
        if (this.webContentURL != null) {
            return this.webContentURL;
        }
        this.webContentURL = this.calculateWebContentUrl();
        return this.webContentURL;
    }

    private String calculateWebContentUrl() {
        String portalAgent;
        String webContentRoot = NavSystem.getInstance().getCPSWebContent();
        if (webContentRoot != null) {
            return webContentRoot;
        }
        webContentRoot = this.busHeader.getWebContentRoot();
        if (webContentRoot == null) {
            webContentRoot = NavSystem.getInstance().getDefaultWebContent();
        }
        if ((portalAgent = this.getRequest().getParam("portalAgent")) != null && (portalAgent.equals("cognos") || portalAgent.equals("cognosFragmentServer"))) {
            return webContentRoot;
        }
        return WebUtils.getAbsoluteURI((String)webContentRoot, (String)NavSystem.getInstance().getDefaultGateway());
    }

    public void setBrowser(String usersBrowser) {
        this.usersBrowser = usersBrowser;
    }

    public String getBrowser() {
        return this.usersBrowser;
    }

    public void setRetryDeploymentId() {
        this.currentRequest.setProp(PROP_USE_DEPLYMENT_ID, new Object());
        this.retryDeploymentId = true;
    }

    public boolean isRetryDeploymentId() {
        return this.retryDeploymentId;
    }

    public void setCMResponseData(String cmData) {
        this.cmResponseData = cmData;
        this.isCMResponseData = true;
    }

    public String getCMResponseData() {
        return this.cmResponseData;
    }

    public boolean isCMResponseData() {
        return this.isCMResponseData;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }
}

