/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.bus;

import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.bus.NavBusCMRequestResponse;
import com.cognos.cps.bseries.xts.request.nav.bus.xmlHandler.BusHeaderXMLHandler;
import com.cognos.cps.bseries.xts.request.nav.bus.xmlHandler.CMResponseXMLHandler;
import com.cognos.cps.bseries.xts.request.nav.bus.xmlHandler.CSXMLHandler;
import com.cognos.cps.bseries.xts.request.nav.sax.CSResponseHandler;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.bus.cm.SimpleQuery;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import javax.xml.stream.XMLStreamException;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class NavBusRequest {
    private ServiceLogger logger;

    public NavBusRequest(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(NavBusRequest.class) : null;
    }

    public CSResponseHandler sendBurgundyRequest(String request, RequestContext context) throws XTSInstructionException {
        BusHeaderXMLHandler busHeaderXMLHandler = new BusHeaderXMLHandler();
        CSXMLHandler csXMLHandler = new CSXMLHandler();
        this.sendBusRequest(request, (String)context.getProperty("internalDispatcher"), "http://www.ibm.com/xmlns/prod/cognos/indexSearchService/201610/.session", context, true, busHeaderXMLHandler, csXMLHandler);
        return csXMLHandler.getCSResponse();
    }

    public NavBusCMRequestResponse sendCMRequest(String request, RequestContext context) throws XTSInstructionException {
        BusHeaderXMLHandler busHeaderXMLHandler = new BusHeaderXMLHandler();
        CMResponseXMLHandler bodyXMLHandler = new CMResponseXMLHandler();
        this.sendBusRequest(request, (String)context.getProperty("contentManager"), "http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201904/", context, false, busHeaderXMLHandler, bodyXMLHandler);
        NavBusCMRequestResponse result = new NavBusCMRequestResponse();
        result.setCMResponse(bodyXMLHandler.getCMResponse());
        result.setBusHeaderReader(new StringReader(busHeaderXMLHandler.getBusHeaderString()));
        return result;
    }

    private void sendBusRequest(String request, String target, String soapAction, RequestContext context, boolean maintainFaultMsg, BusHeaderXMLHandler busHeaderXMLHandler, IXMLHandler bodyXMLHandler) throws XTSInstructionException {
        SimpleQuery query = new SimpleQuery();
        query.setBody(request);
        query.setBusHeader((Object)context.getHeader().getHeaderString());
        query.setSOAPAction(soapAction);
        query.setResponseHeaderHandler((IXMLHandler)busHeaderXMLHandler);
        query.setResponseBodyHandler(bodyXMLHandler);
        SOAPConnection connection = ((SOAPConnectionFactory)context.getProperty("soapConnectionFactory")).createConnection(this.logger);
        try {
            connection.execute((SOAPMessage)query, target);
        }
        catch (MalformedURLException e) {
            throw new XTSInstructionException("IDS_ERR_OPERATION_FAILED", (Throwable)e);
        }
        catch (SOAPFault e) {
            String navErrorCode = null;
            String navErrorMessage = null;
            String detail = e.getDetail();
            if (detail != null && detail.indexOf("CM-REQ-4159") != -1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Received recoverable CM fault : <fault><faultcode>" + e.getFaultCode().toString() + "</faultcode><faultstring>" + e.getFaultString() + "</faultstring><detail>" + e.getDetail() + "</detail></fault>");
                }
                navErrorCode = "nav:InvalidCredentials";
                navErrorMessage = e.getFaultString();
            } else if (maintainFaultMsg) {
                Element detailElement = null;
                SAXReader saxreader = new SAXReader();
                try {
                    detailElement = saxreader.read((Reader)new StringReader(detail)).getRootElement();
                }
                catch (DocumentException e1) {
                    throw new XTSInstructionException("cps.common.parse.error", (Object[])new String[]{NavBusRequest.class.getName()}, (Throwable)e1);
                }
                navErrorCode = "nav:OperationFailed";
                Element messageStringEl = (Element)detailElement.selectSingleNode("//*[local-name()='message']/*[local-name()='messageString']");
                if (messageStringEl != null) {
                    navErrorMessage = messageStringEl.getText();
                    if (navErrorMessage == null || navErrorMessage.length() == 0) {
                        navErrorMessage = e.getFaultString();
                    }
                } else {
                    navErrorMessage = e.getFaultString();
                }
            } else {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("CM fault : <fault><faultcode>" + e.getFaultCode().toString() + "</faultcode><faultstring>" + e.getFaultString() + "</faultstring><detail>" + e.getDetail() + "</detail></fault>", (Throwable)e);
                }
                navErrorCode = "nav:OperationFailed";
                navErrorMessage = MessagesManager.getInstance().getMessage((String)context.getProperty("locale"), "IDS_ERR_CM_FAILED");
            }
            Reader faultReader = NavBusRequest.getFaultXML(navErrorCode, navErrorMessage);
            throw new XTSSoapFaultException(navErrorCode, faultReader, (Reader)new StringReader(busHeaderXMLHandler.getBusHeaderString()), 11, false);
        }
        catch (IOException e) {
            throw new XTSInstructionException("IDS_ERR_OPERATION_FAILED", (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new XTSInstructionException("IDS_ERR_OPERATION_FAILED", (Throwable)e);
        }
    }

    public static Reader getFaultXML(String key, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<SOAP-ENV:Fault xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:nav=\"http://developer.cognos.com/schemas/cps/navigation/1/\"><faultcode nav:hack=\"\">");
        buffer.append(key);
        buffer.append("</faultcode>");
        buffer.append("<faultstring>");
        NavUtils.xmlEncode(message, buffer);
        buffer.append("</faultstring><detail><");
        buffer.append(key);
        buffer.append("/></detail></SOAP-ENV:Fault>");
        return new StringReader(buffer.toString());
    }
}

