/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.element;

import com.cognos.cps.bseries.xts.common.logging.XTSServiceLoggerImpl;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.element.action.ActionSelector;
import com.cognos.cps.bseries.xts.request.nav.element.action.MoreActions;
import com.cognos.cps.bseries.xts.request.nav.element.action.NavAction;
import com.cognos.cps.bseries.xts.request.nav.element.action.PortalAction;
import com.cognos.cps.bseries.xts.request.nav.element.action.PreCalculatedActions;
import com.cognos.cps.bseries.xts.request.nav.element.action.Properties;
import com.cognos.cps.bseries.xts.request.nav.element.action.RunOptions;
import com.cognos.cps.bseries.xts.request.nav.element.action.Schedule;
import com.cognos.cps.bseries.xts.request.nav.element.action.Traverse;
import com.cognos.cps.bseries.xts.request.nav.element.core.BaseHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.RequiredCondition;
import com.cognos.cps.bseries.xts.request.nav.element.core.RequiredPermissions;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.AdminItemHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.ApplicationHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.ApplicationLinksHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.ContainerHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.ContainerLinksHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.GroupHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.HybridHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.ItemHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.ShortcutHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.modifier.ReportViewModifier;
import com.cognos.cps.bseries.xts.request.nav.element.core.modifier.ShortcutModifier;
import com.cognos.cps.bseries.xts.request.nav.element.img.BaseImg;
import com.cognos.cps.bseries.xts.request.nav.element.img.DefaultImg;
import com.cognos.cps.bseries.xts.request.nav.element.img.PreCalculatedImg;
import com.cognos.cps.bseries.xts.request.nav.element.img.RefPropImg;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.SmallMap;
import com.cognos.portal.utils.capability.RequiredCapabilities;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Element;

public class HandlerManager {
    public static String NAMESPACE = "http://developer.cognos.com/schemas/cps/navigation/1/";
    private static final String ActionClassPrefix = "com.cognos.cps.bseries.xts.request.nav.element.action.";
    private static final String ImgClassPrefix = "com.cognos.cps.bseries.xts.request.nav.element.img.";
    private static final String DEFAULT = "default";
    private static final String CONTAINER = "container";
    private static final String DANGLINGVIEW = "danglingView";
    private static final String DANGLINGSHORTCUT = "danglingShortcut";
    private static final String SHORTCUT = "shortcut";
    private static Properties properties;
    private static MoreActions moreActions;
    private static ServiceLogger m_logger;
    private static Map HANDLERS;

    private HandlerManager() {
    }

    public static void initialize(Element uiMetadataElem) throws NavException {
        GroupHandler groupHandler;
        List actionsList;
        Element groupsObj;
        int k;
        List groups;
        BaseHandler handler;
        if (uiMetadataElem == null) {
            return;
        }
        Element baseItemActions = (Element)uiMetadataElem.selectSingleNode("/nox:uiMetadata/nox:ActionsBase/nox:ItemActions");
        Element baseContainerLinks = (Element)uiMetadataElem.selectSingleNode("/nox:uiMetadata/nox:ActionsBase/nox:ContainerLinks");
        Element baseApplicationLinks = (Element)uiMetadataElem.selectSingleNode("/nox:uiMetadata/nox:ActionsBase/nox:ApplicationLinks");
        List objects = uiMetadataElem.selectNodes("/nox:uiMetadata/nox:classes/nox:class");
        for (int i = 0; i < objects.size(); ++i) {
            Element obj = (Element)objects.get(i);
            String classname = obj.valueOf("./nox:name");
            String container = obj.valueOf("./nox:container");
            String launchableType = obj.valueOf("./nox:launchableType");
            List defaultActions = obj.selectNodes("./nox:defaultActions/nox:action");
            List actions = obj.selectNodes("./nox:actions/*[self::nox:action or self::nox:actionSelector]");
            if (container.equals("true")) {
                HandlerManager.buildHandlersForVariants(classname, "userInterface", obj, baseItemActions);
                handler = new ContainerHandler();
                groups = obj.selectNodes("./nox:containerLinks/nox:group");
                if (groups.size() > 0) {
                    ContainerLinksHandler containerLinksHandler = new ContainerLinksHandler();
                    for (k = 0; k < groups.size(); ++k) {
                        groupsObj = (Element)groups.get(k);
                        actionsList = groupsObj.selectNodes("./nox:action");
                        groupHandler = new GroupHandler();
                        groupHandler.setName(groupsObj.selectSingleNode("./nox:name").getText());
                        HandlerManager.doActions(groupHandler, obj, null, actionsList, baseContainerLinks, true);
                        containerLinksHandler.registerElementHandler(groupHandler);
                    }
                    handler.registerElementHandler(containerLinksHandler);
                }
            } else {
                if ("launchable".equals(classname) && !"".equals(launchableType)) {
                    HandlerManager.buildHandlersForVariants(classname, "launchableType", obj, baseItemActions);
                    continue;
                }
                String admin = obj.valueOf("./nox:adminItem");
                String viewable = obj.valueOf("./nox:viewable");
                handler = admin.equals("true") ? new AdminItemHandler(!viewable.equals("false")) : new ItemHandler(!viewable.equals("false"));
            }
            String modifier = obj.valueOf("./nox:modifier");
            if (modifier.equals("ViewModifier")) {
                handler.registerModifier(new ReportViewModifier());
            }
            HandlerManager.doIcons(handler, obj);
            HandlerManager.doActions(handler, obj, defaultActions, actions, baseItemActions, false);
            HANDLERS.put("cm:" + classname, handler);
        }
        List applications = uiMetadataElem.selectNodes("/nox:uiMetadata/nox:applications/nox:application");
        for (int i = 0; i < applications.size(); ++i) {
            Element app = (Element)applications.get(i);
            String appname = app.valueOf("./nox:name");
            handler = new ApplicationHandler();
            groups = app.selectNodes("./nox:applicationLinks/nox:group");
            if (groups.size() > 0) {
                ApplicationLinksHandler applicationLinksHandler = new ApplicationLinksHandler();
                for (k = 0; k < groups.size(); ++k) {
                    groupsObj = (Element)groups.get(k);
                    actionsList = groupsObj.selectNodes("./nox:action");
                    groupHandler = new GroupHandler();
                    groupHandler.setName(groupsObj.selectSingleNode("./nox:name").getText());
                    HandlerManager.doActions(groupHandler, app, null, actionsList, baseApplicationLinks, true);
                    applicationLinksHandler.registerElementHandler(groupHandler);
                }
                handler.registerElementHandler(applicationLinksHandler);
            }
            HANDLERS.put("app:" + appname, handler);
        }
    }

    private static void buildHandlersForVariants(String classname, String variantProperty, Element obj, Element baseItemActions) {
        List variants = obj.selectNodes("./nox:" + variantProperty);
        for (int i = 0; i < variants.size(); ++i) {
            Element variant = (Element)variants.get(i);
            String name = variant.valueOf("./nox:name");
            BaseHandler handler = null;
            handler = "package".equals(classname) ? new HybridHandler(!variant.valueOf("./nox:viewable").equals("false")) : new ItemHandler(!variant.valueOf("./nox:viewable").equals("false"));
            List defaultActions = variant.selectNodes("./nox:defaultActions/nox:action");
            List actions = variant.selectNodes("./nox:actions/nox:action");
            HandlerManager.doIcons(handler, variant);
            HandlerManager.doActions(handler, variant, defaultActions, actions, baseItemActions, false);
            HANDLERS.put(name, handler);
        }
    }

    private static void doIcons(BaseHandler handler, Element obj) {
        String icon = obj.valueOf("./nox:icon");
        BaseImg imgToolObject = null;
        Element imgToolElem = (Element)obj.selectSingleNode("./nox:imgTool");
        String imgTool = imgToolElem != null ? imgToolElem.valueOf("./nox:name") : "";
        SmallMap params = new SmallMap();
        if (imgTool != null && imgTool.length() > 0) {
            try {
                String imgToolClassName = ImgClassPrefix + imgTool;
                Class<?> foundClass = HandlerManager.class.getClassLoader().loadClass(imgToolClassName);
                Constructor<?> constructor = foundClass.getConstructor(Map.class);
                HandlerManager.fillImgParams(params, obj);
                imgToolObject = (BaseImg)constructor.newInstance(params);
                handler.registerElementHandler(imgToolObject);
                params.clear();
            }
            catch (Exception e) {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Missing imgTool, " + imgTool);
                }
            }
        } else if (icon.length() > 0) {
            handler.registerElementHandler(new DefaultImg(icon));
        } else {
            handler.registerElementHandler(new DefaultImg());
        }
    }

    private static void fillImgParams(SmallMap params, Element curObject) {
        List paramsList = null;
        if (curObject != null) {
            paramsList = curObject.selectNodes("./nox:imgTool/nox:param");
            for (int i = 0; i < paramsList.size(); ++i) {
                Element param = (Element)paramsList.get(i);
                String paramName = param.valueOf("./nox:name");
                if (paramName == null || paramName.length() <= 0) continue;
                if (paramName.equals("types")) {
                    SmallMap types = !params.containsKey((Object)paramName) ? new SmallMap() : (SmallMap)params.get((Object)paramName);
                    List typesList = param.selectNodes("./nox:type");
                    for (int j = 0; j < typesList.size(); ++j) {
                        Element type = (Element)typesList.get(j);
                        types.put((Object)type.valueOf("./nox:search"), (Object)type.valueOf("./nox:icon"));
                    }
                    params.put((Object)paramName, (Object)types);
                    continue;
                }
                if (params.containsKey((Object)paramName)) continue;
                params.put((Object)paramName, (Object)param.valueOf("./nox:value"));
            }
        }
    }

    private static void fillActionParams(SmallMap params, Element curObject, Element actionObject, String actionName, String urlTool, Element globalArea) {
        Element baseActionUrlTool;
        List paramsList = null;
        if (actionObject != null) {
            paramsList = actionObject.selectNodes("./nox:urlTool/nox:param");
            HandlerManager.processActionParams(params, paramsList, curObject);
        }
        if ("defaultActions".equals(actionObject.getParent().getName())) {
            Element curActionUrlTool = (Element)curObject.selectSingleNode("./nox:actions/nox:action[*[local-name()='name']='" + actionName + "']/nox:urlTool[*[local-name()='name']='" + urlTool + "']");
            if (curActionUrlTool == null) {
                curActionUrlTool = (Element)curObject.selectSingleNode("./nox:actions/nox:actionSelector/nox:action[position()=1][*[local-name()='name']='" + actionName + "']/nox:urlTool[*[local-name()='name']='" + urlTool + "']");
            }
            if (curActionUrlTool != null) {
                paramsList = curActionUrlTool.selectNodes("./nox:param");
                HandlerManager.processActionParams(params, paramsList, curObject);
            }
        }
        if ((baseActionUrlTool = (Element)globalArea.selectSingleNode("./nox:action[*[local-name()='name']='" + actionName + "']/nox:urlTool[*[local-name()='name']='" + urlTool + "']")) != null) {
            paramsList = baseActionUrlTool.selectNodes("./nox:param");
            HandlerManager.processActionParams(params, paramsList, curObject);
        }
    }

    private static void processActionParams(SmallMap params, List paramsList, Element curObject) {
        for (int i = 0; i < paramsList.size(); ++i) {
            int pos;
            Element param = (Element)paramsList.get(i);
            String paramName = param.valueOf("./nox:name");
            String paramValue = param.valueOf("./nox:value");
            if (paramName == null || paramName.length() <= 0) continue;
            if (paramName.equals("parameter")) {
                SmallMap parameters = !params.containsKey((Object)paramName) ? new SmallMap() : (SmallMap)params.get((Object)paramName);
                StringTokenizer tokens = new StringTokenizer(paramValue, "=");
                String parameterName = null;
                String parameterValue = null;
                if (tokens.hasMoreTokens()) {
                    parameterName = tokens.nextToken();
                    if (tokens.hasMoreTokens()) {
                        parameterValue = tokens.nextToken();
                    }
                }
                if (parameterName != null && !parameters.containsKey((Object)parameterName)) {
                    parameters.put((Object)parameterName, (Object)parameterValue);
                }
                params.put((Object)paramName, (Object)parameters);
                continue;
            }
            if (params.containsKey((Object)paramName)) continue;
            if (paramName.equals("target") && (pos = paramValue.indexOf("$class")) != -1) {
                paramValue = paramValue.substring(0, pos) + curObject.valueOf("./nox:name") + paramValue.substring(pos + 6);
            }
            params.put((Object)paramName, (Object)paramValue);
        }
    }

    private static NavAction createURLTool(Element obj, Element action, String urlTool, String actionId, String tooltip, String icon, int visibilityLevel, Element globalArea) {
        NavAction navAction;
        block12: {
            Element condition;
            Element capabilities;
            navAction = null;
            SmallMap params = new SmallMap();
            String actionName = action.valueOf("./nox:name");
            Element labelElem = HandlerManager.getElementNode(obj, action, actionName, "nox:label", globalArea);
            Element permissions = HandlerManager.getElementNode(obj, action, actionName, "nox:permissions", globalArea);
            if (permissions != null && !permissions.hasContent()) {
                permissions = null;
            }
            if ((capabilities = HandlerManager.getElementNode(obj, action, actionName, "nox:capabilities", globalArea)) != null && !capabilities.hasContent()) {
                capabilities = null;
            }
            if ((condition = HandlerManager.getElementNode(obj, action, actionName, "nox:condition", globalArea)) != null && !condition.hasContent()) {
                condition = null;
            }
            String browsers = HandlerManager.getElementValue(obj, action, actionName, "nox:browsers", globalArea);
            if (urlTool != null && urlTool.length() > 0) {
                if (urlTool.equals("MoreActions")) {
                    navAction = moreActions;
                } else if (urlTool.equals("Properties")) {
                    navAction = properties;
                } else {
                    try {
                        String urlToolClassName = ActionClassPrefix + urlTool;
                        Class<?> foundClass = HandlerManager.class.getClassLoader().loadClass(urlToolClassName);
                        Constructor<?> constructor = foundClass.getConstructor(String.class, Map.class, String.class, String.class, RequiredCapabilities.class, RequiredPermissions.class, Integer.TYPE, String.class);
                        HandlerManager.fillActionParams(params, obj, action, actionName, urlTool, globalArea);
                        navAction = (NavAction)constructor.newInstance(new Object[]{actionId, params, tooltip, icon, capabilities == null ? null : new RequiredCapabilities(capabilities), permissions == null ? null : new RequiredPermissions(permissions), new Integer(visibilityLevel), browsers});
                        if (condition != null) {
                            navAction.setCondition(new RequiredCondition(condition));
                        }
                        params.clear();
                        if (labelElem != null) {
                            navAction.setLabel(labelElem.getTextTrim());
                        }
                    }
                    catch (Exception e) {
                        if (!m_logger.isDebugEnabled()) break block12;
                        m_logger.debug("Missing urltool, " + urlTool + " for " + actionId);
                    }
                }
            }
        }
        return navAction;
    }

    private static void doActions(BaseHandler handler, Element obj, List defaultActions, List actions, Element globalArea, boolean isLink) {
        String classname = obj.valueOf("./nox:name");
        HandlerManager.doItemDefaultAction(handler, obj, classname, defaultActions, globalArea, isLink);
        for (int j = 0; j < actions.size(); ++j) {
            Element actElem = (Element)actions.get(j);
            String actElemName = actElem.getName();
            if ("action".equals(actElemName)) {
                HandlerManager.doItemAction(handler, obj, classname, actElem, globalArea, isLink, null, null);
                continue;
            }
            if (!"actionSelector".equals(actElemName)) continue;
            HandlerManager.doItemActionSelector(handler, obj, classname, actElem, globalArea, isLink, null, null, false);
        }
    }

    private static void doItemDefaultAction(BaseHandler handler, Element obj, String classname, List defaultActions, Element globalArea, boolean isLink) {
        Element defAct;
        String actionName;
        NavAction navAction = null;
        Element urlToolElem = null;
        if (defaultActions != null && defaultActions.size() > 1) {
            String fallbackAllowed = obj.valueOf("./nox:defaultActions/nox:fallback");
            PortalAction defaultAction = new PortalAction(!fallbackAllowed.equals("false"));
            String lastDefault = obj.valueOf("./nox:defaultActions/nox:lastdefault");
            if (lastDefault.length() > 0) {
                defaultAction.setLastDefaultActionName(lastDefault);
            }
            for (int j = 0; j < defaultActions.size(); ++j) {
                String tip;
                String icon;
                Element defAct2 = (Element)defaultActions.get(j);
                String actionName2 = defAct2.valueOf("./nox:name");
                if (actionName2 == null || actionName2.length() <= 0 || NavSystem.getInstance().isActionExcluded(classname, actionName2)) continue;
                urlToolElem = HandlerManager.getElementNode(obj, defAct2, actionName2, "nox:urlTool", globalArea);
                if (urlToolElem != null && "actionSelector".equals(urlToolElem.getQName().getName())) {
                    icon = HandlerManager.getElementValue(obj, defAct2, actionName2, "nox:icon", globalArea);
                    ActionSelector actionSelector = HandlerManager.createActionSelector(obj, classname, urlToolElem, globalArea, isLink, DEFAULT, icon, true);
                    defaultAction.addAction(actionName2, actionSelector);
                    continue;
                }
                String urlTool = urlToolElem != null ? urlToolElem.valueOf("./nox:name") : "";
                if (urlTool == null || urlTool.length() <= 0) continue;
                if (urlTool.equals("StudioAction") || urlTool.equals("CognosViewerRunAction") || urlTool.equals("RunOptionsPPW") || urlTool.equals("RunOptions") || urlTool.equals("Generic")) {
                    tip = HandlerManager.getElementValue(obj, defAct2, actionName2, "nox:tip", globalArea);
                    icon = HandlerManager.getElementValue(obj, defAct2, actionName2, "nox:icon", globalArea);
                } else {
                    icon = null;
                    tip = null;
                }
                navAction = HandlerManager.createURLTool(obj, defAct2, urlTool, DEFAULT, tip, icon, 0, globalArea);
                if (navAction == null) continue;
                defaultAction.addAction(actionName2, navAction);
            }
            handler.registerElementHandler(defaultAction);
        } else if (defaultActions != null && defaultActions.size() == 1 && (actionName = (defAct = (Element)defaultActions.get(0)).valueOf("./nox:name")) != null && actionName.length() > 0 && !NavSystem.getInstance().isActionExcluded(classname, actionName)) {
            urlToolElem = HandlerManager.getElementNode(obj, defAct, actionName, "nox:urlTool", globalArea);
            if (urlToolElem != null && "actionSelector".equals(urlToolElem.getQName().getName())) {
                String icon = HandlerManager.getElementValue(obj, defAct, actionName, "nox:icon", globalArea);
                HandlerManager.doItemActionSelector(handler, obj, classname, urlToolElem, globalArea, isLink, DEFAULT, icon, true);
            } else {
                String icon;
                String urlTool = urlToolElem != null ? urlToolElem.valueOf("./nox:name") : "";
                if (urlTool != null && urlTool.length() > 0 && (navAction = HandlerManager.createURLTool(obj, defAct, urlTool, DEFAULT, null, icon = urlTool.equals("StudioAction") || urlTool.equals("CognosViewerRunAction") || urlTool.equals("RunOptionsPPW") || urlTool.equals("Generic") ? HandlerManager.getElementValue(obj, defAct, actionName, "nox:icon", globalArea) : null, 0, globalArea)) != null) {
                    handler.registerElementHandler(navAction);
                }
            }
        }
    }

    private static ActionSelector doItemActionSelector(BaseHandler handler, Element obj, String classname, Element actElemSelector, Element globalArea, boolean isLink, String actionNameOverride, String iconOverride, boolean isDefaultAction) {
        ActionSelector actionSelector = HandlerManager.createActionSelector(obj, classname, actElemSelector, globalArea, isLink, actionNameOverride, iconOverride, isDefaultAction);
        handler.registerElementHandler(actionSelector);
        return actionSelector;
    }

    private static ActionSelector createActionSelector(Element obj, String classname, Element actElemSelector, Element globalArea, boolean isLink, String actionNameOverride, String iconOverride, boolean isDefaultAction) {
        List actions = actElemSelector.selectNodes("./nox:action");
        ActionSelector actionSelector = new ActionSelector();
        if (!isDefaultAction) {
            actionSelector.setSelect(actElemSelector.attributeValue("select"));
        }
        for (int j = 0; j < actions.size(); ++j) {
            Element actElem = (Element)actions.get(j);
            NavAction navAction = HandlerManager.doItemAction(null, obj, classname, actElem, globalArea, isLink, actionNameOverride, iconOverride);
            if (navAction == null) continue;
            actionSelector.addAction(navAction);
        }
        return actionSelector;
    }

    private static NavAction doItemAction(BaseHandler handler, Element obj, String classname, Element actElem, Element globalArea, boolean isLink, String actionNameOverride, String iconOverride) {
        NavAction navAction = null;
        String actionName = actionNameOverride;
        if (actionName == null) {
            actionName = actElem.valueOf("./nox:name");
        }
        if (actionName != null && actionName.length() > 0 && !NavSystem.getInstance().isActionExcluded(classname, actionName)) {
            int visibilityLevel = 10;
            String visibility = HandlerManager.getElementValue(obj, actElem, actionName, "nox:visibilityLevel", globalArea);
            if (visibility != null && visibility.length() > 0) {
                try {
                    visibilityLevel = Integer.parseInt(visibility);
                }
                catch (NumberFormatException e) {
                    visibilityLevel = 10;
                }
            }
            Element urlToolElem = HandlerManager.getElementNode(obj, actElem, actionName, "nox:urlTool", globalArea);
            String icon = iconOverride;
            String urlTool = urlToolElem != null ? urlToolElem.valueOf("./nox:name") : "";
            if (urlTool != null && urlTool.length() > 0) {
                String tip = HandlerManager.getElementValue(obj, actElem, actionName, "nox:tip", globalArea);
                if (icon == null) {
                    icon = HandlerManager.getElementValue(obj, actElem, actionName, "nox:icon", globalArea);
                }
                if ((navAction = HandlerManager.createURLTool(obj, actElem, urlTool, actionName, tip, icon, visibilityLevel, globalArea)) != null) {
                    if (isLink) {
                        navAction.setIsLink(true);
                    }
                    if (handler != null) {
                        handler.registerElementHandler(navAction);
                    }
                }
            }
        }
        return navAction;
    }

    private static String getElementValue(Element curObject, Element actionObject, String actionName, String propName, Element globalArea) {
        Element elem = HandlerManager.findNode(curObject, actionObject, actionName, propName, globalArea);
        if (elem != null) {
            return elem.getTextTrim();
        }
        return "";
    }

    private static Element getElementNode(Element curObject, Element actionObject, String actionName, String nodeName, Element globalArea) {
        return HandlerManager.findNode(curObject, actionObject, actionName, nodeName, globalArea);
    }

    private static Element findNode(Element curObject, Element actionObject, String actionName, String nodeName, Element globalArea) {
        Element elem = (Element)actionObject.selectSingleNode("./" + nodeName);
        if (elem == null) {
            Element baseAction;
            if ("defaultActions".equals(actionObject.getParent().getName())) {
                Element curAction = (Element)curObject.selectSingleNode("./nox:actions/nox:action[*[local-name()='name']='" + actionName + "']");
                if (curAction == null) {
                    curAction = (Element)curObject.selectSingleNode("./nox:actions/nox:actionSelector/nox:action[*[local-name()='name']='" + actionName + "']/..");
                }
                if (curAction != null) {
                    if ("actionSelector".equals(curAction.getQName().getName())) {
                        return curAction;
                    }
                    elem = (Element)curAction.selectSingleNode("./" + nodeName);
                    if (elem != null) {
                        return elem;
                    }
                }
            }
            if ((baseAction = (Element)globalArea.selectSingleNode("./nox:action[*[local-name()='name']='" + actionName + "']")) != null) {
                return (Element)baseAction.selectSingleNode("./" + nodeName);
            }
        }
        return elem;
    }

    public static BaseHandler getHandler(GenericCMObject cmObj) {
        if (cmObj == null) {
            return null;
        }
        String type = cmObj.getType();
        List userInterfaces = cmObj.getArrayParameter("userInterfaces");
        Object object = null;
        if (userInterfaces.size() > 0) {
            String userInterface;
            Iterator it = userInterfaces.iterator();
            while (it.hasNext() && ((userInterface = (String)it.next()).equals("analysisStudio") || userInterface.equals("eventStudio") || userInterface.equals("queryStudio") || userInterface.equals("reportStudio") || userInterface.equals("powerPlayStudio") || (object = HANDLERS.get(userInterface)) == null)) {
            }
        }
        if (object == null) {
            String launchableType;
            if (type.equals("cm:reportView") || type.equals("cm:agentDefinitionView")) {
                boolean isDangling;
                GenericCMObject base = cmObj.getChildObject("base");
                boolean bl = isDangling = base == null || base.getType().indexOf("nil") != -1;
                if (isDangling) {
                    object = HANDLERS.get(DANGLINGVIEW);
                }
            } else if (type.equals("cm:shortcut")) {
                boolean isDangling = ShortcutHandler.isDangling(cmObj);
                object = isDangling ? HANDLERS.get(DANGLINGSHORTCUT) : HANDLERS.get(SHORTCUT);
            }
            if (object == null && type.equals("cm:launchable") && !"".equals(launchableType = cmObj.getParameter("launchableType", ""))) {
                object = HANDLERS.get(launchableType);
            }
            if (object == null) {
                object = HANDLERS.get(type);
            }
            if (object == null) {
                object = NavSystem.getInstance().isContainer(type.substring(3)) ? HANDLERS.get(CONTAINER) : HANDLERS.get(DEFAULT);
            }
        }
        return object;
    }

    static {
        m_logger = new XTSServiceLoggerImpl(HandlerManager.class);
        HANDLERS = new HashMap();
        properties = new Properties();
        moreActions = new MoreActions();
        BaseHandler handler = new ItemHandler(false);
        handler.registerElementHandler(new PreCalculatedImg("icon_url"));
        handler.registerElementHandler(new PreCalculatedActions(DEFAULT, "default_action"));
        handler.registerElementHandler(new PreCalculatedActions("action_list"));
        HANDLERS.put("non_cm_obj", handler);
        handler = new ItemHandler(true);
        handler.registerElementHandler(new DefaultImg());
        handler.registerElementHandler(properties);
        handler.registerElementHandler(new RunOptions());
        handler.registerElementHandler(new Schedule());
        handler.registerElementHandler(moreActions);
        HANDLERS.put(DEFAULT, handler);
        handler = new ContainerHandler();
        handler.registerElementHandler(new DefaultImg());
        handler.registerElementHandler(new Traverse(DEFAULT));
        handler.registerElementHandler(properties);
        handler.registerElementHandler(moreActions);
        HANDLERS.put(CONTAINER, handler);
        handler = new ItemHandler(false);
        String icon = NavSystem.getInstance().getUiGraphics("dang_ref") + NavSystem.getInstance().getUiGraphics("reportview_suffix");
        handler.registerElementHandler(new DefaultImg(icon));
        handler.registerElementHandler(properties);
        handler.registerElementHandler(moreActions);
        HANDLERS.put(DANGLINGVIEW, handler);
        handler = new ShortcutHandler();
        handler.registerElementHandler(new RefPropImg("target", NavSystem.getInstance().getUiGraphics("shortcut_suffix")));
        handler.registerElementHandler(properties);
        handler.registerElementHandler(moreActions);
        handler.registerModifier(new ShortcutModifier());
        HANDLERS.put(SHORTCUT, handler);
        handler = new ShortcutHandler();
        icon = NavSystem.getInstance().getUiGraphics("dang_ref") + NavSystem.getInstance().getUiGraphics("shortcut_suffix");
        handler.registerElementHandler(new DefaultImg(icon));
        handler.registerElementHandler(properties);
        handler.registerElementHandler(moreActions);
        HANDLERS.put(DANGLINGSHORTCUT, handler);
    }
}

