/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.element.action;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.action.NavAction;
import com.cognos.cps.bseries.xts.request.nav.element.core.RequiredPermissions;
import com.cognos.cps.bseries.xts.request.nav.helpers.UrlBuilder;
import com.cognos.portal.utils.capability.RequiredCapabilities;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DashboardDefaultAction
extends NavAction {
    private boolean isEdit;
    private static final String EXECUTIVE_DASHBOARD_URL_PROPERTY = "WEB.GATEWAY_URI";

    public DashboardDefaultAction(String id, Map params, String tipId, String icon, RequiredCapabilities capabilities, RequiredPermissions permissions, int visibilityLevel, String browsers) {
        super(id, tipId, icon, capabilities, permissions, visibilityLevel, browsers);
        this.isEdit = "edit".equals(params.get("mode"));
    }

    @Override
    public void renderImpl(GenericCMObject object, RequestContext context, XMLStreamWriter writer) throws XMLStreamException {
        String edUrl = NavSystem.getInstance().getProperty(EXECUTIVE_DASHBOARD_URL_PROPERTY);
        StringBuffer buffer = new StringBuffer();
        buffer.append(edUrl);
        if (!edUrl.endsWith("/")) {
            buffer.append('/');
        }
        buffer.append("cm/");
        buffer.append(object.getParameter("storeID", ""));
        UrlBuilder url = new UrlBuilder(context);
        url.setGateway(buffer.toString());
        if (this.isEdit) {
            url.addParam("frag-mode", "edit", 2);
        } else {
            url.addParam("frag-mode", "view", 2);
        }
        String tooltip = this.getToolTip(object, context, this.tipId);
        this.renderAction(tooltip, url, this.icon, null, false, writer, context);
    }

    @Override
    public boolean canRender(GenericCMObject object, RequestContext context) {
        boolean canRender = super.canRender(object, context);
        if (canRender) {
            String executiveDashboardUrl = NavSystem.getInstance().getProperty(EXECUTIVE_DASHBOARD_URL_PROPERTY);
            canRender = executiveDashboardUrl != null && executiveDashboardUrl.length() > 0;
        }
        return canRender;
    }
}

