/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.element.action;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.action.NavAction;
import com.cognos.cps.bseries.xts.request.nav.element.core.RequiredPermissions;
import com.cognos.cps.bseries.xts.request.nav.helpers.NavHelper;
import com.cognos.cps.bseries.xts.request.nav.helpers.UrlBuilder;
import com.cognos.cps.bseries.xts.request.nav.helpers.UrlHelper;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.capability.RequiredCapabilities;
import com.cognos.xts.ext.XTSExt;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Download
extends NavAction {
    private boolean isGeneratingAction = false;

    public Download(String id, Map params, String tipId, String icon, RequiredCapabilities capabilities, RequiredPermissions permissions, int visibilityLevel, String browsers) {
        super(id, tipId, icon, capabilities, permissions, visibilityLevel, browsers);
        if (params != null) {
            this.isGeneratingAction = params.get("isGeneratingAction") != null ? "true".equals(params.get("isGeneratingAction")) : false;
        }
    }

    public void renderDownloadURL(GenericCMObject object, String documentName, RequestContext context, XMLStreamWriter writer) throws XMLStreamException {
        UrlBuilder url = UrlHelper.getDownloadUrl("view", context.getGatewayURL(), object, documentName, context, this.id);
        UrlHelper.addURLParams(url, object);
        String tooltip = this.isGeneratingAction ? this.getToolTip(context, this.tipId) : this.getToolTip(object, context, this.tipId);
        this.renderAction(tooltip, url, this.icon, null, false, writer, context);
    }

    @Override
    public void renderImpl(GenericCMObject object, RequestContext context, XMLStreamWriter writer) throws XMLStreamException {
        String objType = object.getType();
        if ("cm:document".equals(objType)) {
            this.renderDownloadURL(object, null, context, writer);
        } else if ("cm:output".equals(objType) || "cm:documentContent".equals(objType)) {
            String objClass = object.getParameter("objectClass", "");
            String format = NavHelper.getOutputFormat(object, context);
            String dataType = object.getParameter("dataType", "");
            String documentType = context.getRequest().getParam("documentType");
            String documentName = context.getRequest().getParam("documentName");
            if ("documentContent".equals(objClass)) {
                this.renderDownloadURL(object, documentName, context, writer);
            } else if ("output".equals(objClass)) {
                if (this.isInteractiveReport(object)) {
                    StringBuilder web64Struct = new StringBuilder();
                    String browser = context.getBrowser();
                    String mName = documentName != null ? documentName : object.getParameter("defaultName", "");
                    StringBuffer encodedName = new StringBuffer();
                    NavUtils.xmlEncode(mName, encodedName);
                    web64Struct.append("<param name=\"br\">" + browser + "</param>");
                    web64Struct.append("<param name=\"m_download_obj\">storeID(&quot;" + object.getParameter("storeID", null) + "&quot;)" + "</param>");
                    web64Struct.append("<param name=\"m_name\">" + encodedName + "</param>");
                    web64Struct.append("<param name=\"format\">" + format + "</param>");
                    String web64StructEncoded = EncodingUtils.web64encode((byte[])web64Struct.toString().getBytes(), (boolean)true);
                    String webStructSigned = XTSExt.validator((String)"prepare", (String)"webStruct", (String)web64StructEncoded);
                    UrlBuilder href = new UrlBuilder(context);
                    href.setGateway(context.getGatewayURL());
                    href.addParam("b_action", "xts.run", 2);
                    href.addParam("m", "portal/download.xts", 2);
                    href.addParam("webcompress", "true", 2);
                    href.addParam("webStruct", webStructSigned, 2);
                    String tooltip = this.getToolTip(object, context, this.tipId);
                    this.renderAction(tooltip, href, this.icon, null, false, writer, context);
                } else {
                    this.renderDownloadURL(object, documentName, context, writer);
                }
            }
        }
    }

    private boolean isInteractiveReport(GenericCMObject object) {
        String dataType = object.getParameter("dataType", "");
        return dataType != null ? dataType.startsWith("message/rfc822") : false;
    }

    @Override
    public boolean canRender(GenericCMObject object, RequestContext context) {
        String objType;
        boolean bCanRender = super.canRender(object, context);
        if (bCanRender && this.isGeneratingAction && "cm:output".equals(objType = object.getType())) {
            String format = object.getParameter("format", null);
            String browser = context.getBrowser();
            bCanRender = this.isInteractiveReport(object) ? NavSystem.getInstance().isOutputFormatSupported(format, browser, true) : NavSystem.getInstance().isOutputFormatSupported(format, browser, false);
        }
        return bCanRender;
    }
}

