/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.element.action;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.INavElement;
import com.cognos.cps.bseries.xts.request.nav.element.core.RequiredCondition;
import com.cognos.cps.bseries.xts.request.nav.element.core.RequiredPermissions;
import com.cognos.cps.bseries.xts.request.nav.helpers.UrlBuilder;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.portal.utils.capability.RequiredCapabilities;
import com.ibm.cognos.i18n.util.Bidi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class NavAction
implements INavElement {
    protected final String id;
    private final boolean isDefault;
    private boolean isLink;
    protected final String tipId;
    protected String labelId;
    protected final String icon;
    private final RequiredPermissions permissions;
    private final RequiredCapabilities capabilities;
    private RequiredCondition condition;
    private final int visibilityLevel;
    private final List browsers;
    private String arialLabel;

    public NavAction(String id) {
        this.id = id;
        this.isDefault = "default".equals(id);
        this.tipId = null;
        this.labelId = null;
        this.icon = null;
        this.capabilities = null;
        this.permissions = null;
        this.condition = null;
        this.visibilityLevel = 10;
        this.isLink = false;
        this.browsers = null;
        this.arialLabel = "";
    }

    public NavAction(String id, String toolTipId, String icon, RequiredCapabilities capabilities, RequiredPermissions permissions, int visibilityLevel, String browsers) {
        this.arialLabel = "";
        this.id = id;
        this.isDefault = "default".equals(id);
        this.tipId = toolTipId;
        this.labelId = null;
        this.icon = icon;
        this.capabilities = capabilities;
        this.permissions = permissions;
        this.condition = null;
        this.visibilityLevel = visibilityLevel;
        this.isLink = false;
        if (browsers != null && !"".equals(browsers)) {
            this.browsers = new ArrayList();
            StringTokenizer tl = new StringTokenizer(browsers);
            while (tl.hasMoreElements()) {
                this.browsers.add(tl.nextToken());
            }
        } else {
            this.browsers = null;
        }
    }

    public void setCondition(RequiredCondition cond) {
        this.condition = cond;
    }

    public void setIsLink(boolean value) {
        this.isLink = value;
    }

    public boolean getIsLink() {
        return this.isLink;
    }

    public void setArialLabel(String aName) {
        this.arialLabel = aName;
    }

    public abstract void renderImpl(GenericCMObject var1, RequestContext var2, XMLStreamWriter var3) throws XMLStreamException;

    public boolean canRender(GenericCMObject object, RequestContext context) {
        boolean render = true;
        if (this.condition != null) {
            render = this.condition.meetsCondition(object);
        }
        if (render && this.capabilities != null) {
            HashSet calcUserCapabilities = (HashSet)object.getAny("calculatedUserCapabilties");
            render = calcUserCapabilities != null ? this.capabilities.hasCapabilities(calcUserCapabilities, this.getBrowser(context)) : this.capabilities.hasCapabilities(context.getCapabilities(), this.getBrowser(context));
        }
        if (render && this.permissions != null) {
            render = this.permissions.hasPermission(object);
        }
        return render;
    }

    public List getBrowser(RequestContext context) {
        if (this.browsers != null) {
            return this.browsers;
        }
        if (context.getBrowser() != null) {
            ArrayList<String> browsers = new ArrayList<String>();
            browsers.add(context.getBrowser());
            return browsers;
        }
        ArrayList<String> browsers = new ArrayList<String>();
        browsers.add(context.getHeader().getBrowser());
        return browsers;
    }

    @Override
    public void asXML(GenericCMObject object, RequestContext context, XMLStreamWriter writer) throws XMLStreamException {
        if (context.getRequest().isProperty("action") || this.isDefault) {
            boolean visible = false;
            visible = this.isLink ? context.getRequest().inLinksVisibilityRange(this.visibilityLevel) : context.getRequest().inActionsVisibilityRange(this.visibilityLevel);
            if (visible && this.canRender(object, context)) {
                this.renderImpl(object, context, writer);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected final String getToolTip(GenericCMObject object, RequestContext context, String id) {
        if (id != null) {
            String objectName = object.getParameter("tooltip", null);
            if (objectName == null) {
                objectName = object.getParameter("defaultName", "");
            }
            String localized = MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), id);
            if (context.getHeader().isBidiEnabled()) {
                objectName = Bidi.enforceBTD((String)objectName, (String)context.getHeader().getTextDirection(), (String)context.getHeader().getProductLocaleAsString());
            }
            return localized + " - " + objectName;
        }
        return null;
    }

    protected final String getToolTip(RequestContext context, String toolTipId) {
        if (toolTipId != null) {
            return MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), toolTipId);
        }
        return null;
    }

    public void setLabel(String actionLabel) {
        this.labelId = actionLabel;
    }

    protected final String getLabel(RequestContext context, String id) {
        String labelId;
        String string = labelId = id != null ? id : this.tipId;
        if (labelId != null) {
            return MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), labelId);
        }
        return null;
    }

    protected final void renderAction(String tooltip, UrlBuilder href, String icon, String windowProperties, boolean usePost, XMLStreamWriter writer, RequestContext context) throws XMLStreamException {
        if (this.isDefault) {
            if (tooltip != null) {
                tooltip = tooltip.substring(0, tooltip.indexOf(" - "));
            }
            this.renderDefaultAction(href, windowProperties, icon, writer, context, tooltip, usePost);
            return;
        }
        writer.writeStartElement("nav", "action", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeStartElement("nav", "name", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeCharacters(this.id != null ? this.id : "");
        writer.writeEndElement();
        String label = this.getLabel(context, this.labelId);
        writer.writeStartElement("nav", "label", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeCharacters(label != null ? label : "");
        writer.writeEndElement();
        writer.writeStartElement("nav", "alt", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeCharacters(tooltip != null ? tooltip : "");
        writer.writeEndElement();
        if (href != null) {
            href.asXML(writer);
        }
        if (icon != null) {
            writer.writeStartElement("nav", "imgURL", "http://developer.cognos.com/schemas/cps/navigation/1/");
            this.renderFullIconUrl(icon, context, writer);
            writer.writeEndElement();
        } else if (this.arialLabel != "") {
            writer.writeStartElement("nav", "aria-label", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(this.arialLabel);
            writer.writeEndElement();
        }
        this.writeWindowProperties(windowProperties, writer);
        this.writeUsePost(usePost, writer);
        writer.writeEndElement();
    }

    private void writeWindowProperties(String windowProperties, XMLStreamWriter writer) throws XMLStreamException {
        if (windowProperties != null && windowProperties.length() > 0) {
            writer.writeStartElement("nav", "windowProperties", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(windowProperties);
            writer.writeEndElement();
        }
    }

    private void writeUsePost(boolean usePost, XMLStreamWriter writer) throws XMLStreamException {
        if (usePost) {
            writer.writeStartElement("nav", "usePost", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters("true");
            writer.writeEndElement();
        }
    }

    protected final void renderDefaultAction(UrlBuilder url, String windowProperties, String icon, XMLStreamWriter writer, RequestContext context, String tooltip, boolean usePost) throws XMLStreamException {
        writer.writeStartElement("nav", "defaultAction", "http://developer.cognos.com/schemas/cps/navigation/1/");
        if (url != null) {
            url.asXML(writer);
        }
        this.writeWindowProperties(windowProperties, writer);
        this.writeUsePost(usePost, writer);
        if (icon != null && icon.length() > 0) {
            writer.writeStartElement("nav", "imgURL", "http://developer.cognos.com/schemas/cps/navigation/1/");
            this.renderFullIconUrl(icon, context, writer);
            writer.writeEndElement();
            writer.writeStartElement("nav", "alt", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(tooltip != null ? tooltip : "");
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void renderFullIconUrl(String icon, RequestContext context, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(context.getImageRoot());
        writer.writeCharacters(icon);
    }
}

