/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.element.action;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.action.NavAction;
import com.cognos.cps.bseries.xts.request.nav.element.core.IObjectModifier;
import com.cognos.cps.bseries.xts.request.nav.helpers.NavHelper;
import com.cognos.cps.common.utils.SmallMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PortalAction
extends NavAction
implements IObjectModifier {
    private Map actionUrls;
    private boolean isFallBackAllowed;
    private String lastDefaultActionName;

    public PortalAction(boolean isFallBackAllowed) {
        super("default");
        this.isFallBackAllowed = isFallBackAllowed;
        this.actionUrls = new SmallMap(3);
    }

    public void setLastDefaultActionName(String actionName) {
        this.lastDefaultActionName = actionName;
    }

    public void addAction(String actionName, NavAction action) {
        this.actionUrls.put(actionName, action);
    }

    @Override
    public void renderImpl(GenericCMObject object, RequestContext context, XMLStreamWriter writer) throws XMLStreamException {
        NavAction defaultAction;
        String calculatedAction = object.getParameter("calculatedPortalAction", null);
        if (calculatedAction != null && (defaultAction = (NavAction)this.actionUrls.get(calculatedAction)) != null && (this.isFallBackAllowed || defaultAction.canRender(object, context))) {
            defaultAction.renderImpl(object, context, writer);
        }
    }

    @Override
    public boolean canRender(GenericCMObject object, RequestContext context) {
        return true;
    }

    @Override
    public void modifyObject(GenericCMObject object, RequestContext context) throws NavException {
        NavAction action;
        String outputFormat;
        String defaultPortalAction = context.getRequest().getParam("defaultAction");
        if (defaultPortalAction == null || !this.actionUrls.containsKey(defaultPortalAction)) {
            defaultPortalAction = object.getParameter("defaultPortalAction", "");
        }
        if (defaultPortalAction.length() == 0 && this.lastDefaultActionName != null) {
            defaultPortalAction = this.lastDefaultActionName;
        }
        if ("powerPlayReport".equals(object.getParameter("objectClass", "")) && "run".equals(defaultPortalAction) && "HTML".equals(outputFormat = NavHelper.getOption("outputFormat", "", object))) {
            defaultPortalAction = "edit";
        }
        if ("documentContent".equals(object.getParameter("objectClass", "")) && context.getRequest().getParam("download") != null) {
            defaultPortalAction = "download";
        }
        if ((action = (NavAction)this.actionUrls.get(defaultPortalAction)) != null && action.canRender(object, context) || !this.isFallBackAllowed) {
            object.setParameter("calculatedPortalAction", defaultPortalAction);
            return;
        }
        if (this.isFallBackAllowed) {
            for (Map.Entry entry : this.actionUrls.entrySet()) {
                String name = (String)entry.getKey();
                action = (NavAction)this.actionUrls.get(name);
                if (!action.canRender(object, context)) continue;
                object.setParameter("calculatedPortalAction", name);
                return;
            }
        }
    }
}

