/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.element.core;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.INavElement;
import com.cognos.cps.bseries.xts.request.nav.element.core.IObjectModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class BaseHandler
implements INavElement {
    protected final String id;
    protected List objectModifiers;
    protected List elements;

    public BaseHandler(String id) {
        this.id = id;
        this.elements = new ArrayList();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public abstract void asXML(GenericCMObject var1, RequestContext var2, XMLStreamWriter var3) throws XMLStreamException, NavException;

    public void modifyObject(GenericCMObject object, RequestContext context) throws NavException {
        GenericCMObject capabilityObject = object.getChildObject("metadataModelPackage");
        if (capabilityObject == null) {
            capabilityObject = object;
        }
        if (capabilityObject.hasArrayParameter("effectiveUserCapabilities")) {
            List effectiveUserCapabilities = capabilityObject.getArrayParameter("effectiveUserCapabilities");
            HashSet<String> calculatedCapabilities = new HashSet<String>(effectiveUserCapabilities);
            HashSet headerCapabilities = context.getCapabilities();
            for (String capability : headerCapabilities) {
                if (!NavSystem.getInstance().isGlobalCapability(capability)) continue;
                calculatedCapabilities.add(capability);
            }
            object.setAny("calculatedUserCapabilties", calculatedCapabilities);
        }
        if (this.objectModifiers != null) {
            for (IObjectModifier m : this.objectModifiers) {
                m.modifyObject(object, context);
            }
        }
    }

    public void registerModifier(IObjectModifier modifier) {
        if (this.objectModifiers == null) {
            this.objectModifiers = new ArrayList(1);
        }
        this.objectModifiers.add(modifier);
    }

    public void registerElementHandler(INavElement element) {
        this.elements.add(element);
        if (element instanceof IObjectModifier) {
            this.registerModifier((IObjectModifier)((Object)element));
        }
    }

    public List getElementHandlers() {
        return Collections.unmodifiableList(this.elements);
    }

    public INavElement getElement(String id) {
        if (id != null) {
            for (INavElement element : this.elements) {
                if (!id.equals(element.getId())) continue;
                return element;
            }
        }
        return null;
    }
}

