/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.element.core.impl;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.INavElement;
import com.cognos.cps.bseries.xts.request.nav.helpers.NavHelper;
import com.cognos.cps.bseries.xts.request.nav.helpers.NavIcon;
import com.cognos.cps.common.message.MessagesManager;
import com.ibm.cognos.i18n.util.Bidi;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class BaseProperties
implements INavElement {
    private final String id = "baseProp";
    private static BaseProperties instance = null;

    private BaseProperties() {
    }

    public static BaseProperties getInstance() {
        if (instance == null) {
            instance = new BaseProperties();
        }
        return instance;
    }

    @Override
    public void asXML(GenericCMObject object, RequestContext context, XMLStreamWriter writer) throws XMLStreamException {
        NavIcon icon;
        List ancestors;
        List userInterfaces;
        GenericCMObject base;
        boolean isOuterContainer;
        String searchPathStoreId = NavHelper.getPath(object);
        String searchPath = object.getParameter("searchPath", "");
        GenericCMObject userFolder = context.getRequest().getUserFolder();
        String userFolderPath = null;
        if (userFolder != null) {
            userFolderPath = NavHelper.getPath(userFolder);
        }
        boolean bl = isOuterContainer = object.getParameter("outerContainer", null) != null;
        if (context.getRequest().isProperty("fullPath") || context.getRequest().isProperty("fullName") || isOuterContainer) {
            List ancestors2 = object.getAncestors();
            if (ancestors2.size() > 0) {
                int hiddenAncestorIndex = -1;
                boolean clearAll = false;
                String firstAncestorType = ((GenericCMObject)ancestors2.get(0)).getParameter("objectClass", "");
                if (!"content".equals(firstAncestorType)) {
                    int i;
                    for (i = ancestors2.size() - 1; i > 0; --i) {
                        GenericCMObject ancestor = (GenericCMObject)ancestors2.get(i);
                        if (NavSystem.getInstance().isContainer(ancestor.getParameter("objectClass", ""))) continue;
                        if (i == ancestors2.size() - 1) {
                            clearAll = true;
                            String ancestorType = ancestor.getParameter("objectClass", "");
                            if (!"account".equals(ancestorType) || searchPathStoreId.equals(userFolderPath)) break;
                            String user = ancestor.getParameter("title", "");
                            if (user.length() > 18 && user.charAt(4) == '-' && user.charAt(7) == '-' && user.charAt(10) == 'T' && user.charAt(13) == ':' && user.charAt(16) == ':') {
                                user = MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), "IDS_UNAVAILABLE");
                            }
                            object.setParameter("defaultName", object.getParameter("defaultName", "") + " (" + user + ")");
                            break;
                        }
                        hiddenAncestorIndex = i;
                        GenericCMObject nextAncestor = (GenericCMObject)ancestors2.get(i + 1);
                        String nextAncestorPath = NavHelper.getPath(nextAncestor);
                        String ancestorType = ancestor.getParameter("objectClass", "");
                        if (!"account".equals(ancestorType) || nextAncestorPath.equals(userFolderPath)) break;
                        String user = ancestor.getParameter("title", "");
                        if (user.length() > 18 && user.charAt(4) == '-' && user.charAt(7) == '-' && user.charAt(10) == 'T' && user.charAt(13) == ':' && user.charAt(16) == ':') {
                            user = MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), "IDS_UNAVAILABLE");
                        }
                        nextAncestor.setParameter("title", nextAncestor.getParameter("title", "") + " (" + user + ")");
                        break;
                    }
                    if (clearAll) {
                        ancestors2.clear();
                    } else {
                        for (i = 0; i <= hiddenAncestorIndex; ++i) {
                            ancestors2.remove(0);
                        }
                    }
                }
            }
            if (!"rootDefault".equals(searchPathStoreId)) {
                GenericCMObject cmObjectRoot = new GenericCMObject("cm:folder");
                cmObjectRoot.setParameter("searchPath", "rootDefault");
                cmObjectRoot.setParameter("storeID", "rootDefault");
                cmObjectRoot.setParameter("objectClass", "folder");
                cmObjectRoot.setParameter("title", NavSystem.getInstance().getRootDefaultLabel(context.getHeader()));
                ancestors2.add(0, cmObjectRoot);
            }
        }
        String navId = NavHelper.generateId(object, context);
        writer.writeStartElement("nav", "id", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeCharacters(navId);
        writer.writeEndElement();
        if (context.getRequest().isProperty("deploymentId")) {
            writer.writeStartElement("nav", "deploymentId", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(NavHelper.generateIdForDeployment(object, context));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("internalId")) {
            writer.writeStartElement("nav", "internalId", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("storeID", ""));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("parentId")) {
            writer.writeStartElement("nav", "parentId", "http://developer.cognos.com/schemas/cps/navigation/1/");
            if (searchPathStoreId.equals(userFolderPath) || searchPath.equals("/content")) {
                writer.writeCharacters("rootDefault");
            } else if (object.hasChildObject("parent")) {
                GenericCMObject parent = object.getChildObject("parent");
                if (NavSystem.getInstance().isContainer(parent.getType().substring(3))) {
                    writer.writeCharacters(NavHelper.generateId(parent, context));
                } else {
                    writer.writeCharacters("rootDefault");
                }
            } else if (context.getRequest().getContainer() != null) {
                writer.writeCharacters(NavHelper.generateId(context.getRequest().getContainer(), context));
            }
            writer.writeEndElement();
        }
        String name = object.getParameter("defaultName", "");
        writer.writeStartElement("nav", "name", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeCharacters(name);
        writer.writeEndElement();
        String objType = object.getParameter("objectClass", "");
        writer.writeStartElement("nav", "type", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeCharacters(objType);
        writer.writeEndElement();
        if (context.getRequest().isProperty("baseType") && (base = object.getChildObject("base")) != null) {
            String baseType = base.getType();
            int index = baseType.indexOf(58);
            if (index != -1) {
                baseType = baseType.substring(index + 1);
            }
            writer.writeStartElement("nav", "baseType", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(baseType);
            writer.writeEndElement();
        }
        if ("package".equals(objType) && (userInterfaces = object.getArrayParameter("userInterfaces")).size() > 0) {
            for (String userInterface : userInterfaces) {
                if (userInterface.equals("analysisStudio") || userInterface.equals("eventStudio") || userInterface.equals("queryStudio") || userInterface.equals("reportStudio") || userInterface.equals("powerPlayStudio")) continue;
                writer.writeStartElement("nav", "subType", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeCharacters(userInterface);
                writer.writeEndElement();
                break;
            }
        }
        if (context.getRequest().isProperty("description")) {
            writer.writeStartElement("nav", "description", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("defaultDescription", ""));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("screenTip")) {
            writer.writeStartElement("nav", "screenTip", "http://developer.cognos.com/schemas/cps/navigation/1/");
            String className = this.enforceBaseTextDirection(MessagesManager.getInstance().getMessage((String)context.getProperty("locale"), NavSystem.getInstance().getObjectClassMSGID(object.getParameter("objectClass", ""))), context);
            if (className != null && className.length() > 0) {
                writer.writeCharacters(className);
            } else {
                String defaultName = this.enforceBaseTextDirection(object.getParameter("defaultName", ""), context);
                writer.writeCharacters(defaultName);
            }
            String defaultScreenTip = object.getParameter("defaultScreenTip", null);
            if (defaultScreenTip != null && defaultScreenTip.length() > 0) {
                defaultScreenTip = this.enforceBaseTextDirection(defaultScreenTip, context);
                writer.writeCharacters((Bidi.isLocaleRTL((String)context.getHeader().getProductLocaleAsString()) ? "\u200f" : "\u200e") + " - ");
                writer.writeCharacters(defaultScreenTip);
            }
            if (object.getParameter("hidden", "false").equals("true")) {
                writer.writeCharacters((Bidi.isLocaleRTL((String)context.getHeader().getProductLocaleAsString()) ? "\u200f" : "\u200e") + " - ");
                writer.writeCharacters(MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), "IDS_HIDDEN"));
            }
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("createDate")) {
            writer.writeStartElement("nav", "createDate", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(NavUtils.formatDatFormUTC(object.getParameter("creationTime", ""), 2, 3, context.getHeader().getTimeZone(), context.getHeader().getContentLocaleAsString()));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("lastModifiedDate")) {
            writer.writeStartElement("nav", "lastModifiedDate", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(NavUtils.formatDatFormUTC(object.getParameter("modificationTime", ""), 2, 3, context.getHeader().getTimeZone(), context.getHeader().getContentLocaleAsString()));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("owner")) {
            GenericCMObject owner = null;
            owner = object.getChildObject("owner");
            if (owner != null) {
                writer.writeStartElement("nav", "owner", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeStartElement("nav", "searchPath", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeCharacters(owner.getParameter("searchPath", ""));
                writer.writeEndElement();
                writer.writeStartElement("nav", "internalId", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeCharacters(owner.getParameter("storeID", ""));
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        if (context.getRequest().isProperty("asOfDate")) {
            writer.writeStartElement("nav", "asOfDate", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(NavUtils.formatDatFormUTC(object.getParameter("asOfTime", ""), 2, 3, context.getHeader().getTimeZone(), context.getHeader().getContentLocaleAsString()));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("launchableType")) {
            writer.writeStartElement("nav", "launchableType", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("launchableType", ""));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("fullPath") || isOuterContainer) {
            ancestors = object.getAncestors();
            writer.writeStartElement("nav", "fullPath", "http://developer.cognos.com/schemas/cps/navigation/1/");
            this.pathStep(ancestors.iterator(), writer, context);
            writer.writeEndElement();
        } else if (context.getRequest().isProperty("fullName")) {
            ancestors = object.getAncestors();
            writer.writeStartElement("nav", "fullName", "http://developer.cognos.com/schemas/cps/navigation/1/");
            String calculatedfullName = object.getParameter("full_name", null);
            if (calculatedfullName != null) {
                writer.writeCharacters(calculatedfullName);
            } else {
                String separator = Bidi.isLocaleRTL((String)context.getHeader().getProductLocaleAsString()) ? "\u200f<" : "\u200e>";
                for (GenericCMObject ancestor : ancestors) {
                    String id = ancestor.getParameter("storeID", null);
                    if ("rootDefault".equals(id)) continue;
                    writer.writeCharacters(this.enforceBaseTextDirection(ancestor.getParameter("title", ""), context));
                    writer.writeCharacters(" " + separator + " ");
                }
                writer.writeCharacters(this.enforceBaseTextDirection(name, context));
            }
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("searchPath")) {
            writer.writeStartElement("nav", "searchPath", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("searchPath", ""));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("permissions")) {
            writer.writeStartElement("nav", "permissions", "http://developer.cognos.com/schemas/cps/navigation/1/");
            List list = object.getArrayParameter("permissions");
            if (list != GenericCMObject.NULL_LIST) {
                writer.writeCharacters(list.toString());
            }
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("icons") && (icon = this.getDisabledNavIcon(object)) != null) {
            icon.render(writer, object, context);
        }
        if (navId.length() > 0 && context.getRequest().getProp("index_search") != null) {
            NavIcon scoreIcon = NavIcon.getIcon("score_icon");
            scoreIcon.render(writer, object, context);
            writer.writeStartElement("nav", "score", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("score", "0"));
            writer.writeEndElement();
            writer.writeStartElement("nav", "matchDescription", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("match_desc", ""));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("requiredCapabilities")) {
            writer.writeStartElement("nav", "requiredCapabilities", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("parsedRequiredCapabilities", ""));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("dataType")) {
            writer.writeStartElement("nav", "dataType", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("dataType", ""));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("documentType")) {
            writer.writeStartElement("nav", "documentType", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("documentType", ""));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("burstKey")) {
            writer.writeStartElement("nav", "burstKey", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("burstKey", ""));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("locale")) {
            writer.writeStartElement("nav", "locale", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(object.getParameter("locale", ""));
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("formatName")) {
            writer.writeStartElement("nav", "formatName", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(NavHelper.getOutputFormatDisplayName(object, context));
            writer.writeEndElement();
        }
    }

    private void pathStep(Iterator it, XMLStreamWriter writer, RequestContext context) throws XMLStreamException {
        if (it.hasNext()) {
            writer.writeStartElement("nav", "pathStep", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeStartElement("nav", "id", "http://developer.cognos.com/schemas/cps/navigation/1/");
            GenericCMObject ancestor = (GenericCMObject)it.next();
            writer.writeCharacters(NavHelper.generateId(ancestor, context));
            writer.writeEndElement();
            writer.writeStartElement("nav", "name", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(ancestor.getParameter("title", ""));
            writer.writeEndElement();
            this.pathStep(it, writer, context);
            writer.writeEndElement();
        }
    }

    protected NavIcon getDisabledNavIcon(GenericCMObject object) {
        String base_disabled;
        GenericCMObject base;
        String target_disabled;
        String disabled = object.getParameter("disabled", null);
        if (disabled != null && disabled.equals("true")) {
            return NavIcon.getIcon("state_disabled");
        }
        GenericCMObject target = object.getChildObject("target");
        if (target != null ? (target_disabled = target.getParameter("disabled", null)) != null && target_disabled.equals("true") : (base = object.getChildObject("base")) != null && (base_disabled = base.getParameter("disabled", null)) != null && base_disabled.equals("true")) {
            return NavIcon.getIcon("state_source_disabled");
        }
        return null;
    }

    @Override
    public String getId() {
        return "baseProp";
    }

    public String enforceBaseTextDirection(String text, RequestContext context) {
        if (context.getHeader().isBidiEnabled()) {
            text = Bidi.enforceBTD((String)text, (String)context.getHeader().getTextDirection(), (String)context.getHeader().getProductLocaleAsString());
        }
        return text;
    }
}

