/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.element.core.impl;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.HandlerManager;
import com.cognos.cps.bseries.xts.request.nav.element.INavElement;
import com.cognos.cps.bseries.xts.request.nav.element.core.BaseHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.BaseProperties;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.CustomNavPropertiesHandler;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ItemHandler
extends BaseHandler {
    private final boolean isViewable;

    public ItemHandler(boolean isViewable) {
        super("item");
        this.isViewable = isViewable;
        this.elements.add(BaseProperties.getInstance());
        this.elements.add(CustomNavPropertiesHandler.getInstance());
    }

    boolean isViewable() {
        return this.isViewable;
    }

    @Override
    public void asXML(GenericCMObject object, RequestContext context, XMLStreamWriter writer) throws XMLStreamException, NavException {
        this.modifyObject(object, context);
        writer.writeStartElement("nav", "item", "http://developer.cognos.com/schemas/cps/navigation/1/");
        for (INavElement element : this.elements) {
            element.asXML(object, context, writer);
        }
        if (context.getRequest().isProperty("newState")) {
            writer.writeEmptyElement("nav", "newState", "http://developer.cognos.com/schemas/cps/navigation/1/");
        }
        if (context.getRequest().isProperty("readState")) {
            writer.writeEmptyElement("nav", "readState", "http://developer.cognos.com/schemas/cps/navigation/1/");
        }
        if (context.getRequest().isProperty("status")) {
            writer.writeEmptyElement("nav", "status", "http://developer.cognos.com/schemas/cps/navigation/1/");
        }
        if (context.getRequest().isProperty("viewable")) {
            BaseHandler baseHandler;
            boolean calculatedIsViewable = this.isViewable;
            GenericCMObject base = object.getChildObject("base");
            if (base != null && (baseHandler = HandlerManager.getHandler(base)) instanceof ItemHandler) {
                calculatedIsViewable = ((ItemHandler)baseHandler).isViewable();
            }
            writer.writeStartElement("nav", "viewable", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(calculatedIsViewable ? "true" : "false");
            writer.writeEndElement();
        }
        if (context.getRequest().isProperty("portalPagesInfo")) {
            writer.writeStartElement("nav", "portalPages", "http://developer.cognos.com/schemas/cps/navigation/1/");
            List list = object.getArrayParameter("portalPages");
            if (list != GenericCMObject.NULL_LIST) {
                GenericCMObject portalPage2 = null;
                BaseHandler portalPageHandler = null;
                for (GenericCMObject portalPage2 : list) {
                    portalPageHandler = HandlerManager.getHandler(portalPage2);
                    portalPageHandler.modifyObject(portalPage2, context);
                    portalPageHandler.asXML(portalPage2, context, writer);
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

