/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.element.img;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.img.BaseImg;
import com.cognos.cps.bseries.xts.request.nav.helpers.NavHelper;
import com.cognos.cps.bseries.xts.request.nav.helpers.UrlHelper;
import com.cognos.cps.common.utils.Strings;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ReportImg
extends BaseImg {
    private String defaultFormat;
    private String icon;
    private String capabilityBasedIcon;
    private String[] capabilityIcons;

    public ReportImg(Map params) {
        if (params != null) {
            this.icon = (String)params.get("icon");
            this.defaultFormat = (String)params.get("defaultFormat");
            this.capabilityBasedIcon = (String)params.get("capabilityBasedIcon");
            if (this.capabilityBasedIcon != null) {
                this.capabilityIcons = Strings.split((String)this.capabilityBasedIcon, (char)'|');
            }
        }
    }

    @Override
    protected void generateIconName(XMLStreamWriter writer, RequestContext context, GenericCMObject object, boolean baseOnlyMode) throws XMLStreamException {
        String defaultPortalAction = object.getParameter("calculatedPortalAction", null);
        if (defaultPortalAction == null || "edit".equals(defaultPortalAction) || context.getRequest().isParam("useDefaultIcon") || baseOnlyMode) {
            if (this.capabilityBasedIcon == null) {
                writer.writeCharacters(this.icon);
            } else {
                String iconName = null;
                for (int i = 0; i < this.capabilityIcons.length; ++i) {
                    String paramValue = this.capabilityIcons[i];
                    if (!context.hasCapability(paramValue.substring(0, paramValue.indexOf(":")))) continue;
                    iconName = paramValue.substring(paramValue.indexOf(":") + 1);
                    writer.writeCharacters(iconName);
                    break;
                }
                if (iconName == null) {
                    writer.writeCharacters(this.icon);
                }
            }
        } else {
            String outputFormat = null;
            if (this.defaultFormat != null) {
                outputFormat = this.defaultFormat;
            } else if ("run".equals(defaultPortalAction)) {
                outputFormat = object.getParameter("executionFormat", null);
                if (!(outputFormat != null && outputFormat.length() != 0 || (outputFormat = context.getHeader().getFormat()) != null && outputFormat.length() != 0)) {
                    outputFormat = "HTML";
                }
                outputFormat = UrlHelper.adjustOutputFormat(outputFormat, context);
            } else {
                outputFormat = NavHelper.getOutputFormat(object, context);
            }
            if (outputFormat != null) {
                String new_icon = NavSystem.getInstance().getUiFormatGraphics(outputFormat);
                writer.writeCharacters(new_icon);
            } else if (this.capabilityBasedIcon == null) {
                writer.writeCharacters(this.icon);
            } else {
                String iconName = null;
                for (int i = 0; i < this.capabilityIcons.length; ++i) {
                    String paramValue = this.capabilityIcons[i];
                    if (!context.hasCapability(paramValue.substring(0, paramValue.indexOf(":")))) continue;
                    iconName = paramValue.substring(paramValue.indexOf(":1"));
                    writer.writeCharacters(iconName);
                    break;
                }
                if (iconName == null) {
                    writer.writeCharacters(this.icon);
                }
            }
        }
    }
}

