/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.element.navProperty;

import com.cognos.cps.bseries.xts.common.logging.XTSServiceLoggerImpl;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.ArrayHandler;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.CustomNavProperty;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.DateHandler;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.MapHandler;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.NumericHandler;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.ParameterHandler;
import com.cognos.cps.common.logging.ServiceLogger;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Element;

public class NavPropertyManager {
    private static NavPropertyManager instance = null;
    private static HashSet NAV_PROPERTIES;
    private static HashSet CM_BASE_PROPERTIES;
    private static HashSet CM_ALL_BASE_PROPERTIES;
    private static HashSet CM_ADMIN_PROPERTIES;
    private static HashSet CM_PARENT_REFPROP_PROPERTIES;
    private static String CM_BASE_PROPERTIES_STRING;
    private static String CM_ALL_BASE_PROPERTIES_STRING;
    private static String CM_ADMIN_PROPERTIES_STRING;
    private static String CM_PARENT_REFPROP_PROPERTIES_STRING;
    private HashMap customNavProperties = new HashMap();
    private static ServiceLogger m_logger;

    private static void addBaseProperty(String property) {
        CM_BASE_PROPERTIES.add(property);
        CM_BASE_PROPERTIES_STRING = CM_BASE_PROPERTIES_STRING + "<item xsi:type=\"cm:propEnum\">" + property + "</item>";
        CM_ALL_BASE_PROPERTIES.add(property);
        CM_ALL_BASE_PROPERTIES_STRING = CM_ALL_BASE_PROPERTIES_STRING + "<item xsi:type=\"cm:propEnum\">" + property + "</item>";
    }

    private static void addAllBaseProperty(String property) {
        CM_ALL_BASE_PROPERTIES.add(property);
        CM_ALL_BASE_PROPERTIES_STRING = CM_ALL_BASE_PROPERTIES_STRING + "<item xsi:type=\"cm:propEnum\">" + property + "</item>";
    }

    private static void addAdminProperty(String property) {
        CM_ADMIN_PROPERTIES.add(property);
        CM_ADMIN_PROPERTIES_STRING = CM_ADMIN_PROPERTIES_STRING + "<item xsi:type=\"cm:propEnum\">" + property + "</item>";
    }

    private static void addParentRefPropProperty(String property) {
        CM_PARENT_REFPROP_PROPERTIES.add(property);
        CM_PARENT_REFPROP_PROPERTIES_STRING = CM_PARENT_REFPROP_PROPERTIES_STRING + "<item xsi:type=\"cm:propEnum\">" + property + "</item>";
    }

    public static String getBasePropertyString() {
        return CM_BASE_PROPERTIES_STRING;
    }

    public static String getAllBasePropertyString() {
        return CM_ALL_BASE_PROPERTIES_STRING;
    }

    public static String getAdminPropertyString() {
        return CM_ADMIN_PROPERTIES_STRING;
    }

    public static String getParentRefPropPropertyString() {
        return CM_PARENT_REFPROP_PROPERTIES_STRING;
    }

    public static NavPropertyManager getInstance() {
        if (instance == null) {
            instance = new NavPropertyManager();
        }
        return instance;
    }

    public static boolean isNavProperty(String property) {
        return NAV_PROPERTIES.contains(property);
    }

    public void initialize(Element element) {
        List properties = element.selectNodes("/nox:uiMetadata/nox:customNavProperties/nox:navProperty");
        for (int i = 0; i < properties.size(); ++i) {
            Element property = (Element)properties.get(i);
            Element tool = (Element)property.selectSingleNode("./nox:customNavPropertyTool");
            CustomNavProperty customNavProperty = null;
            customNavProperty = tool != null ? this.createCustomNavProperty(property) : this.createDefaultCustomNavProperty(property);
            if (customNavProperty == null) continue;
            String navPropertyName = property.valueOf("./nox:name");
            customNavProperty.setNavPropertyName(navPropertyName);
            this.customNavProperties.put(navPropertyName, customNavProperty);
        }
    }

    private CustomNavProperty createDefaultCustomNavProperty(Element property) {
        Element cmProperty = (Element)property.selectSingleNode("./nox:cmProperties/nox:cmProperty");
        CustomNavProperty customNavProperty = null;
        if (cmProperty != null) {
            String type = cmProperty.valueOf("./nox:type");
            String name = cmProperty.valueOf("./nox:name");
            if (type.equals("parameter")) {
                customNavProperty = new ParameterHandler(name);
            } else if (type.equals("array")) {
                customNavProperty = new ArrayHandler(name);
            } else if (type.equals("map")) {
                customNavProperty = new MapHandler(name);
            } else if (type.equals("date")) {
                customNavProperty = new DateHandler(name);
            } else if (type.equals("numeric")) {
                customNavProperty = new NumericHandler(name);
            }
            if (customNavProperty != null) {
                customNavProperty.addDependantCMProperty(name, type);
            }
        }
        return customNavProperty;
    }

    private CustomNavProperty createCustomNavProperty(Element property) {
        CustomNavProperty customNavProperty;
        block5: {
            customNavProperty = null;
            String name = ((Element)property.selectSingleNode("./nox:customNavPropertyTool")).valueOf("./nox:name");
            try {
                Class<?> foundClass = CustomNavProperty.class.getClassLoader().loadClass(name);
                Constructor<?> constructor = foundClass.getConstructor(new Class[0]);
                customNavProperty = (CustomNavProperty)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (!m_logger.isDebugEnabled()) break block5;
                m_logger.debug("Missing CustomNavPropertyTool: " + name);
            }
        }
        if (customNavProperty != null) {
            List cmProperties = property.selectNodes("./nox:cmProperties/nox:cmProperty");
            for (int j = 0; j < cmProperties.size(); ++j) {
                Element cmProperty = (Element)cmProperties.get(j);
                customNavProperty.addDependantCMProperty(cmProperty.valueOf("./nox:name"), cmProperty.valueOf("./nox:type"));
            }
            List params = property.selectNodes("./nox:customNavPropertyTool/nox:param");
            for (int j = 0; j < params.size(); ++j) {
                Element param = (Element)params.get(j);
                customNavProperty.addParam(param.valueOf("./nox:name"), param.valueOf("./nox:value"));
            }
        }
        return customNavProperty;
    }

    public CustomNavProperty getCustomNavProperty(String property) {
        return (CustomNavProperty)this.customNavProperties.get(property);
    }

    public static boolean isCMBaseProperty(String property) {
        return CM_BASE_PROPERTIES.contains(property);
    }

    public static boolean isCMAllBaseProperty(String property) {
        return CM_ALL_BASE_PROPERTIES.contains(property);
    }

    public static boolean isCMAdminProperty(String property) {
        return CM_ADMIN_PROPERTIES.contains(property);
    }

    public static boolean isParentRefPropProperty(String property) {
        return CM_PARENT_REFPROP_PROPERTIES.contains(property);
    }

    public static int getCMBasePropertySize() {
        return CM_BASE_PROPERTIES.size();
    }

    public static int getCMAllBasePropertySize() {
        return CM_ALL_BASE_PROPERTIES.size();
    }

    public static int getCMAdminPropertySize() {
        return CM_ADMIN_PROPERTIES.size();
    }

    public static int getParentRefPropPropertySize() {
        return CM_PARENT_REFPROP_PROPERTIES.size();
    }

    static {
        CM_BASE_PROPERTIES_STRING = "";
        CM_ALL_BASE_PROPERTIES_STRING = "";
        CM_ADMIN_PROPERTIES_STRING = "";
        CM_PARENT_REFPROP_PROPERTIES_STRING = "";
        CM_BASE_PROPERTIES = new HashSet();
        CM_ALL_BASE_PROPERTIES = new HashSet();
        CM_ADMIN_PROPERTIES = new HashSet();
        CM_PARENT_REFPROP_PROPERTIES = new HashSet();
        NavPropertyManager.addBaseProperty("searchPath");
        NavPropertyManager.addBaseProperty("storeID");
        NavPropertyManager.addBaseProperty("defaultName");
        NavPropertyManager.addBaseProperty("objectClass");
        NavPropertyManager.addBaseProperty("permissions");
        if (NavSystem.getInstance().isPackageCapabilitiesFeatureEnabled()) {
            NavPropertyManager.addBaseProperty("effectiveUserCapabilities");
        }
        NavPropertyManager.addBaseProperty("iconURI");
        NavPropertyManager.addAllBaseProperty("defaultOutputFormat");
        NavPropertyManager.addAllBaseProperty("defaultPortalAction");
        NavPropertyManager.addAllBaseProperty("format");
        NavPropertyManager.addAllBaseProperty("dataType");
        NavPropertyManager.addAllBaseProperty("documentType");
        NavPropertyManager.addAllBaseProperty("burstKey");
        NavPropertyManager.addAllBaseProperty("locale");
        NavPropertyManager.addAllBaseProperty("target");
        NavPropertyManager.addAllBaseProperty("base");
        NavPropertyManager.addAllBaseProperty("uri");
        NavPropertyManager.addAllBaseProperty("position");
        NavPropertyManager.addAllBaseProperty("userInterfaces");
        NavPropertyManager.addAllBaseProperty("hasPrompts");
        NavPropertyManager.addAllBaseProperty("gateway");
        NavPropertyManager.addAllBaseProperty("cubeContentName");
        NavPropertyManager.addAllBaseProperty("options");
        NavPropertyManager.addAllBaseProperty("executionFormat");
        NavPropertyManager.addAllBaseProperty("executionLocale");
        NavPropertyManager.addAllBaseProperty("executionPrompt");
        NavPropertyManager.addAllBaseProperty("launchableType");
        NavPropertyManager.addAllBaseProperty("mostRecentEventList");
        NavPropertyManager.addAllBaseProperty("metadata");
        if (NavSystem.getInstance().isPackageCapabilitiesFeatureEnabled()) {
            NavPropertyManager.addAllBaseProperty("metadataModelPackage");
        }
        NavPropertyManager.addAdminProperty("requestedExecutionTime");
        NavPropertyManager.addAdminProperty("actualExecutionTime");
        NavPropertyManager.addAdminProperty("actualCompletionTime");
        NavPropertyManager.addAdminProperty("status");
        NavPropertyManager.addAdminProperty("parent");
        NavPropertyManager.addAdminProperty("output");
        NavPropertyManager.addAdminProperty("owner");
        NavPropertyManager.addAdminProperty("position");
        NavPropertyManager.addAdminProperty("eventID");
        NavPropertyManager.addParentRefPropProperty("searchPath");
        NavPropertyManager.addParentRefPropProperty("storeID");
        NavPropertyManager.addParentRefPropProperty("permissions");
        NavPropertyManager.addParentRefPropProperty("executionFormat");
        NavPropertyManager.addParentRefPropProperty("base");
        NavPropertyManager.addParentRefPropProperty("parent");
        NavPropertyManager.addParentRefPropProperty("ancestors");
        NavPropertyManager.addParentRefPropProperty("defaultName");
        NavPropertyManager.addParentRefPropProperty("defaultOutputFormat");
        NavPropertyManager.addParentRefPropProperty("mostRecentEventList");
        NavPropertyManager.addParentRefPropProperty("objectClass");
        NavPropertyManager.addParentRefPropProperty("defaultScreenTip");
        NAV_PROPERTIES = new HashSet();
        NAV_PROPERTIES.add("internalId");
        NAV_PROPERTIES.add("action");
        NAV_PROPERTIES.add("actionsURL");
        NAV_PROPERTIES.add("baseType");
        NAV_PROPERTIES.add("createDate");
        NAV_PROPERTIES.add("credential");
        NAV_PROPERTIES.add("deploymentId");
        NAV_PROPERTIES.add("description");
        NAV_PROPERTIES.add("dataType");
        NAV_PROPERTIES.add("documentType");
        NAV_PROPERTIES.add("burstKey");
        NAV_PROPERTIES.add("locale");
        NAV_PROPERTIES.add("fullPath");
        NAV_PROPERTIES.add("formatName");
        NAV_PROPERTIES.add("fullName");
        NAV_PROPERTIES.add("hasChildren");
        NAV_PROPERTIES.add("icons");
        NAV_PROPERTIES.add("lastModifiedDate");
        NAV_PROPERTIES.add("owner");
        NAV_PROPERTIES.add("asOfDate");
        NAV_PROPERTIES.add("launchableType");
        NAV_PROPERTIES.add("newState");
        NAV_PROPERTIES.add("parentId");
        NAV_PROPERTIES.add("permissions");
        NAV_PROPERTIES.add("readState");
        NAV_PROPERTIES.add("screenTip");
        NAV_PROPERTIES.add("searchPath");
        NAV_PROPERTIES.add("status");
        NAV_PROPERTIES.add("viewable");
        NAV_PROPERTIES.add("scopeInfo");
        NAV_PROPERTIES.add("searchTypes");
        NAV_PROPERTIES.add("content");
        NAV_PROPERTIES.add("normal");
        NAV_PROPERTIES.add("containerLinks");
        NAV_PROPERTIES.add("requestedExecutionTime");
        NAV_PROPERTIES.add("actualExecutionTime");
        NAV_PROPERTIES.add("actualCompletionTime");
        NAV_PROPERTIES.add("userName");
        NAV_PROPERTIES.add("userInfo");
        NAV_PROPERTIES.add("portalPagesInfo");
        NAV_PROPERTIES.add("requiredCapabilities");
        m_logger = new XTSServiceLoggerImpl(NavPropertyManager.class);
    }
}

