/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.helpers;

import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.CustomNavProperty;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.NavPropertyManager;
import com.cognos.cps.bseries.xts.request.nav.helpers.ItemType;
import com.cognos.cps.bseries.xts.request.nav.helpers.NavHelper;
import com.cognos.cps.bseries.xts.request.nav.stax.BusHeader;
import com.cognos.cps.bseries.xts.request.nav.stax.NavRequest;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.xts.ext.XTSExt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CMRequestHelper {
    private static final String CONTENT_OUTPUT_FILTER = "content-output";
    private static final String CONTENT_VERSION_FILTER = "content-version";
    private static final String FILTER = "filter";
    private static final String CONTENT_REFERENCE = "contentReference";
    private static final String ADVISOR_VIEW = "advisorView";
    private static final String ADVISOR_CANVAS = "advisorCanvas";
    private static final String COGNOSDESKTOP = "cd";
    private static final String PACKAGE = "package";
    private static final String ANALYTICS_PACKAGE = "analyticsPackage";
    private static final String PLANNING_PACKAGE = "planningPackage";
    private static final String METRICS_PACKAGE = "metricsPackage";
    private static final String TM1_PACKAGE = "tm1Package";
    private static final int BUFFER_SIZE = 6144;
    private static final String MATCH_EXACT = "exact";
    private static final String MATCH_STARTS = "starts";
    private static final String MATCH_CONTAINS = "contains";
    private static final String FIELDS_DESC = "df";
    private static final String FIELDS_NAME = "nf";
    private static final String FIELDS_NAME_DESC = "ndf";
    private static final String OBJECTS_ALL = "all";
    private static final String OBJECTS_ITEMS = "items";
    private static final String OBJECTS_CONTAINERS = "containers";
    private static final String OBJECTS_REPORTS = "reports";
    private static final String OBJECTS_NEWSITEMS = "newsItems";
    private static final String OBJECTS_AGENTS = "agents";
    private static final String VALUE_ANY = "any";
    private static final String CONTAINING_CLASS = "containingClass";

    public static String getLoginRequest(RequestContext context) {
        boolean isUserName = context.getRequest().isProperty("userName");
        int count = isUserName ? 2 : 1;
        StringBuffer buffer = new StringBuffer(6144);
        buffer.append("<item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">~~</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\"><item xsi:type=\"cm:propEnum\">userCapabilities</item></properties></item><item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">~</search>");
        buffer.append("<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[" + count + "]\">");
        buffer.append("<item xsi:type=\"cm:propEnum\">permissions</item>");
        if (isUserName) {
            buffer.append("<item xsi:type=\"cm:propEnum\">defaultName</item>");
        }
        buffer.append("</properties></item>");
        buffer.append("<item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">/configuration/uiProfileFolder[@name='User Interface Profiles']/uiProfileFolder[@name='Report Studio Profiles']/*</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[3]\"><item xsi:type=\"cm:propEnum\">objectClass</item><item xsi:type=\"cm:propEnum\">name</item><item xsi:type=\"cm:propEnum\">permissions</item></properties></item>");
        buffer.append("<item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">/catalog/catalogFolder[@name='User Interface Profiles']/catalogFolder[@name='Report Studio Profiles']/userInterfaceProfile[last()]</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\"><item xsi:type=\"cm:propEnum\">objectClass</item></properties></item>");
        buffer.append("<item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">/catalog/catalogFolder[@name='User Interface Profiles']/catalogFolder[@name='Report Studio Profiles']/userInterfaceProfile[permission('read')]</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\"><item xsi:type=\"cm:propEnum\">name</item></properties></item>");
        if (context.isMultipleRequest()) {
            context.getRequest().setCMRequestCount(5);
            return buffer.toString();
        }
        return "<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryRequest[5]\">" + buffer.toString() + "</requests>" + "</cm:query>";
    }

    public static String getSearchRequest(RequestContext context, String indexSearchPath) {
        int cmRequestCount;
        String scopePath;
        StringBuffer buffer = new StringBuffer(6144);
        NavRequest request = context.getRequest();
        BusHeader header = context.getHeader();
        boolean isAdminMode = context.getRequest().getOpMode() == 2;
        String searchString = (String)request.getElement("string");
        if (searchString != null) {
            StringBuffer tmp = new StringBuffer();
            EncodingUtils.escapeString((String)searchString, (String)"'", (char)'\'', (StringBuffer)tmp);
            searchString = tmp.toString();
        }
        boolean scopeOverride = false;
        String searchScope = (String)request.getElement("scope");
        if (searchScope == null || searchScope.length() == 0 || "systemDefault".equals(searchScope)) {
            scopePath = "/content";
        } else if ("userDefault".equals(searchScope)) {
            scopePath = "~/folder";
        } else if (searchScope.startsWith("path:")) {
            scopePath = searchScope.substring(5);
            scopeOverride = true;
        } else {
            scopePath = searchScope;
        }
        boolean isIndexSearch = indexSearchPath != null;
        StringBuffer expression = new StringBuffer();
        if (isIndexSearch) {
            expression.append(indexSearchPath);
        } else if (scopeOverride) {
            expression.append(scopePath);
        } else {
            StringTokenizer types;
            expression.append(scopePath);
            String recursive = (String)request.getElement("recursive");
            if (recursive != null && "false".equals(recursive)) {
                if (!isAdminMode) {
                    expression.append("/*");
                }
            } else {
                expression.append("/descendant-or-self::*[@objectClass != 'agentDefinition' and @objectClass != 'agentDefinitionView']/*");
            }
            if (searchString != null && searchString.length() > 0) {
                String match = (String)request.getElement("match");
                String fields = (String)request.getElement("fields");
                if (match != null && MATCH_EXACT.equals(match)) {
                    if (fields != null && FIELDS_DESC.equals(fields)) {
                        expression.append("[@defaultDescription = '");
                        expression.append(searchString);
                        expression.append("']");
                    } else if (fields != null && FIELDS_NAME_DESC.equals(fields)) {
                        expression.append("[@defaultName = '");
                        expression.append(searchString);
                        expression.append("' or @defaultDescription = '");
                        expression.append(searchString);
                        expression.append("']");
                    } else {
                        expression.append("[@defaultName = '");
                        expression.append(searchString);
                        expression.append("']");
                    }
                } else if (match != null && MATCH_STARTS.equals(match)) {
                    if (fields != null && FIELDS_DESC.equals(fields)) {
                        expression.append("[starts-with(@defaultDescription, '");
                        expression.append(searchString);
                        expression.append("' )]");
                    } else if (fields != null && FIELDS_NAME_DESC.equals(fields)) {
                        expression.append("[starts-with(@defaultName, '");
                        expression.append(searchString);
                        expression.append("' ) or starts-with(@defaultDescription, '");
                        expression.append(searchString);
                        expression.append("' )]");
                    } else {
                        expression.append("[starts-with(@defaultName, '");
                        expression.append(searchString);
                        expression.append("' )]");
                    }
                } else if (fields != null && FIELDS_DESC.equals(fields)) {
                    expression.append("[contains(@defaultDescription, '");
                    expression.append(searchString);
                    expression.append("' )]");
                } else if (fields != null && FIELDS_NAME_DESC.equals(fields)) {
                    expression.append("[contains(@defaultName, '");
                    expression.append(searchString);
                    expression.append("' ) or contains(@defaultDescription, '");
                    expression.append(searchString);
                    expression.append("' )]");
                } else {
                    expression.append("[contains(@defaultName, '");
                    expression.append(searchString);
                    expression.append("' )]");
                }
            }
            String objects = (String)request.getElement("objects");
            String itemTypes = request.getItemTypes();
            if (objects != null && OBJECTS_ALL.equals(objects)) {
                expression.append("[@objectClass!='model']");
            } else if (objects != null && OBJECTS_CONTAINERS.equals(objects)) {
                expression.append("[@objectClass='folder' or @objectClass='package' or @objectClass='content']");
            } else if (objects != null && OBJECTS_ITEMS.equals(objects)) {
                if (itemTypes != null && !VALUE_ANY.equals(itemTypes)) {
                    boolean firstToken = true;
                    types = new StringTokenizer(itemTypes, "~");
                    expression.append("[");
                    while (types.hasMoreTokens()) {
                        String itemType = types.nextToken();
                        if (itemType == null || itemType.length() <= 0) continue;
                        if (!firstToken) {
                            expression.append(" or ");
                        } else {
                            firstToken = false;
                        }
                        expression.append("@objectClass='").append(itemType).append("'");
                    }
                    expression.append("]");
                } else {
                    expression.append("[@objectClass!='model' and @objectClass!='folder' and @objectClass!='package' and @objectClass!='content']");
                }
            } else if (objects != null && OBJECTS_REPORTS.equals(objects)) {
                expression.append("[@objectClass='analysis' or @objectClass='powerPlayReport' or @objectClass='query' or @objectClass='report' or @objectClass='interactiveReport' or @objectClass='reportView']");
            } else if (objects != null && OBJECTS_NEWSITEMS.equals(objects)) {
                expression.append("[@objectClass='analysis' or @objectClass='powerPlayReport' or @objectClass='query' or @objectClass='report' or @objectClass='reportView' or @objectClass='agentDefinition' or @objectClass='agentDefinitionView' or @objectClass='URL' or @objectClass='pagelet']");
            } else if (objects != null && OBJECTS_AGENTS.equals(objects)) {
                expression.append("[@objectClass='agentDefinition' or @objectClass='agentDefinitionView']");
            } else if (itemTypes != null && !VALUE_ANY.equals(itemTypes)) {
                boolean firstToken = true;
                types = new StringTokenizer(itemTypes, "~");
                expression.append("[");
                while (types.hasMoreTokens()) {
                    String itemType = types.nextToken();
                    if (itemType == null || itemType.length() <= 0) continue;
                    if (!firstToken) {
                        expression.append(" or ");
                    } else {
                        firstToken = false;
                    }
                    CMRequestHelper.translateSearchClassType(expression, itemType);
                }
                expression.append("]");
            } else if (!isAdminMode) {
                List items;
                int maxItems;
                String searchType = request.getSearchType();
                if (searchType == null || searchType.length() == 0) {
                    searchType = "content";
                }
                if ((maxItems = (items = ItemType.getItemTypes(searchType)).size()) > 0) {
                    expression.append("[");
                    CMRequestHelper.translateSearchClassType(expression, ((ItemType)items.get(0)).getId());
                    for (int j = 1; j < maxItems; ++j) {
                        expression.append(" or ");
                        CMRequestHelper.translateSearchClassType(expression, ((ItemType)items.get(j)).getId());
                    }
                    expression.append("]");
                }
            }
            String itemModified = (String)request.getElement("itemModified");
            if (itemModified != null && !VALUE_ANY.equals(itemModified)) {
                int itemModifiedInt;
                expression.append("[@modificationTime > '");
                String timeZone = header.getTimeZone();
                if (timeZone == null || timeZone.length() == 0) {
                    timeZone = "GMT";
                }
                String todayAtMidinight = XTSExt.getCurrentDateTime((String)timeZone);
                todayAtMidinight = todayAtMidinight.substring(0, todayAtMidinight.indexOf("T"));
                todayAtMidinight = todayAtMidinight + "T00:00:00Z";
                try {
                    itemModifiedInt = Integer.parseInt(itemModified);
                }
                catch (Exception e) {
                    itemModifiedInt = 0;
                }
                try {
                    String localDate = XTSExt.getDateTimeOffset((String)todayAtMidinight, (int)(-1 * itemModifiedInt), (String)"second");
                    String utcDate = XTSExt.formatDateToUTC((String)localDate, (String)timeZone);
                    expression.append(utcDate);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                expression.append("']");
            }
            expression.append(CMRequestHelper.getVisibleFilter(isAdminMode));
        }
        String containingClass = context.getRequest().getParam(CONTAINING_CLASS);
        String contentFilter = context.getRequest().getParam(FILTER);
        if (CONTENT_OUTPUT_FILTER.equals(contentFilter) && containingClass != null && containingClass.length() > 0) {
            expression.append(CMRequestHelper.getFormatFilter(containingClass));
        }
        expression.append(CMRequestHelper.getClassFilter(contentFilter));
        if (!context.isMultipleRequest()) {
            buffer.append("<cm:query xmlns:xtsext=\"xalan://com.cognos.xts.ext.XTSExt\" xmlns:nav=\"http://developer.cognos.com/schemas/cps/navigation/1/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"><requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryRequest[2]\">");
        }
        CMRequestHelper.addUserFolderRequest(context, buffer);
        buffer.append("<item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">");
        NavUtils.xmlEncode(expression.toString(), buffer);
        buffer.append("</search>");
        StringBuffer properties = new StringBuffer(1024);
        CMRequestHelper.addProperties(context, true, isAdminMode, false, false, isIndexSearch, properties);
        buffer.append(properties);
        buffer.append("<options xsi:type=\"cm:queryOptions\">");
        CMRequestHelper.addRefProps(context, properties, isAdminMode, buffer);
        if (!isIndexSearch) {
            Integer maxObjects;
            Integer skipObjects = (Integer)request.getElement("skipObjects");
            if (skipObjects != null) {
                buffer.append("<skipObjects xsi:type=\"xsd:integer\">");
                buffer.append(skipObjects);
                buffer.append("</skipObjects>");
            }
            if ((maxObjects = (Integer)request.getElement("maxObjects")) != null) {
                buffer.append("<maxObjects xsi:type=\"xsd:integer\">");
                buffer.append(maxObjects + 1);
                buffer.append("</maxObjects>");
            }
        }
        buffer.append("</options>");
        if (!isIndexSearch) {
            CMRequestHelper.addSortByElement(context, buffer, "defaultName", "ascending");
        }
        buffer.append("</item>");
        if (request.isProperty("scopeInfo")) {
            buffer.append("<item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">");
            NavUtils.xmlEncode(scopePath, buffer);
            buffer.append("</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[5]\"><item xsi:type=\"cm:propEnum\">searchPath</item><item xsi:type=\"cm:propEnum\">storeID</item><item xsi:type=\"cm:propEnum\">defaultName</item><item xsi:type=\"cm:propEnum\">objectClass</item><item xsi:type=\"cm:propEnum\">permissions</item></properties></item>");
            cmRequestCount = 3;
        } else {
            cmRequestCount = 2;
        }
        if (context.isMultipleRequest()) {
            request.setCMRequestCount(cmRequestCount);
        } else {
            buffer.append("</requests><options xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryMultipleOptions\"><cacheValidator xsi:type=\"xsd:string\">");
            NavUtils.xmlEncode(CMRequestHelper.getValidateTag(context), buffer);
            buffer.append("</cacheValidator></options></cm:query>");
        }
        return buffer.toString();
    }

    private static String getClassFilter(String contentFilter) {
        String[] classes = null;
        String extraFilter = "";
        if (contentFilter == null) {
            return "";
        }
        if (CONTENT_OUTPUT_FILTER.equals(contentFilter)) {
            classes = new String[]{"output", "documentContent"};
            extraFilter = "[permission('read')]";
        } else if (CONTENT_VERSION_FILTER.equals(contentFilter)) {
            classes = new String[]{"reportVersion", "documentVersion"};
            extraFilter = "[permission('read')][@shown='true']";
        } else {
            classes = new String[]{"folder", "agentDefinition", "agentDefinitionView", "analysis", "dashboard", "document", PACKAGE, "pagelet", "powerPlayCube", "powerPlayReport", "powerPlay8Report", "query", "report", "reportTemplate", "reportView", "shortcut", "URL", "content"};
        }
        StringBuilder classesFilter = new StringBuilder();
        classesFilter.append("[");
        for (int index = 0; index < classes.length; ++index) {
            classesFilter.append("@objectClass='");
            classesFilter.append(classes[index]);
            classesFilter.append("' ");
            if (index == classes.length - 1) continue;
            classesFilter.append(" or ");
        }
        classesFilter.append("]");
        classesFilter.append(extraFilter);
        return classesFilter.toString();
    }

    private static String getFormatFilter(String containingClass) {
        String filter;
        String[] formats = NavHelper.getViewerOutputFormatsList(containingClass);
        if (formats.length > 0) {
            StringBuilder aBuilder = new StringBuilder();
            aBuilder.append("[");
            for (int index = 0; index < formats.length; ++index) {
                aBuilder.append("@format='");
                aBuilder.append(formats[index]);
                aBuilder.append("'");
                if (index == formats.length - 1) {
                    aBuilder.append("]");
                    continue;
                }
                aBuilder.append(" or ");
            }
            filter = aBuilder.toString();
        } else {
            filter = "";
        }
        return filter;
    }

    private static void translateSearchClassType(StringBuffer expression, String itemType) {
        if (METRICS_PACKAGE.equals(itemType)) {
            expression.append("(@objectClass='package' and (@userInterfaces = 'metricStudio' or not(@userInterfaces) ))");
        } else if (PLANNING_PACKAGE.equals(itemType)) {
            expression.append("(@objectClass='package' and (@userInterfaces = 'planningContributor' or not(@userInterfaces) ))");
        } else if (ANALYTICS_PACKAGE.equals(itemType)) {
            expression.append("(@objectClass='package' and (@userInterfaces = 'adaptiveAnalytics' or not(@userInterfaces) ))");
        } else if (TM1_PACKAGE.equals(itemType)) {
            expression.append("(@objectClass='package' and (@userInterfaces = 'tm1Studio' or not(@userInterfaces) ))");
        } else if (PACKAGE.equals(itemType)) {
            expression.append("(@objectClass='package' and (@userInterfaces != 'metricStudio' and @userInterfaces != 'planningContributor' and @userInterfaces != 'adaptiveAnalytics' and @userInterfaces != 'tm1Studio')) ");
        } else if (CONTENT_REFERENCE.equals(itemType)) {
            expression.append("(@objectClass='launchable' and @launchableType = 'application/vnd.ibm.cognos.instance')");
        } else if (ADVISOR_VIEW.equals(itemType)) {
            expression.append("(@objectClass='launchable' and @launchableType = 'application/vnd.ibm.cognos.ev')");
        } else if (ADVISOR_CANVAS.equals(itemType)) {
            expression.append("(@objectClass='launchable' and @launchableType = 'application/vnd.ibm.cognos.ev.canvas')");
        } else if (COGNOSDESKTOP.equals(itemType)) {
            expression.append("(@objectClass='launchable' and @launchableType = 'application/vnd.ibm.cognos.cd')");
        } else {
            expression.append("@objectClass='").append(itemType).append("'");
        }
    }

    private static void addSortByElement(RequestContext context, StringBuffer buffer, String defaultSortProp, String defaultOrder) {
        boolean addDisplaySequence;
        boolean addSortUsage;
        String sortUsage = CMRequestHelper.getSortUsage(context);
        LinkedHashMap<String, String> sortSpecs = context.getRequest().getSortSpecs();
        if (sortSpecs == null || sortSpecs.size() == 0) {
            sortSpecs = new LinkedHashMap<String, String>();
            sortSpecs.put(defaultSortProp, defaultOrder);
        }
        int count = sortSpecs.size();
        boolean bl = addSortUsage = sortUsage != null && sortUsage.length() > 0;
        boolean bl2 = sortSpecs != null ? sortSpecs.get("displaySequence") != null : (addDisplaySequence = false);
        if (addSortUsage) {
            ++count;
        }
        if (addDisplaySequence) {
            ++count;
        }
        buffer.append("<sortBy xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:sort[");
        buffer.append(String.valueOf(count));
        buffer.append("]\">");
        if (addSortUsage) {
            buffer.append("<item xsi:type=\"cm:sort\"><propName xsi:type=\"cm:propEnum\">usage</propName><order xsi:type=\"cm:orderEnum\">");
            buffer.append(sortUsage);
            buffer.append("</order></item>");
        }
        Map.Entry pair2 = null;
        for (Map.Entry pair2 : sortSpecs.entrySet()) {
            String sortProp = (String)pair2.getKey();
            String sortOrder = (String)pair2.getValue();
            sortProp = CMRequestHelper.getCMSortProp(sortProp);
            buffer.append("<item xsi:type=\"cm:sort\"><propName xsi:type=\"cm:propEnum\">");
            buffer.append(sortProp);
            buffer.append("</propName><order xsi:type=\"cm:orderEnum\">");
            buffer.append(sortOrder);
            buffer.append("</order></item>");
        }
        if (addDisplaySequence) {
            buffer.append("<item xsi:type=\"cm:sort\"><propName xsi:type=\"cm:propEnum\">defaultName</propName><order xsi:type=\"cm:orderEnum\">ascending</order></item>");
        }
        buffer.append("</sortBy>");
    }

    public static String getQueryRequest(RequestContext context) {
        int requestCount;
        StringBuffer buffer = new StringBuffer(6144);
        boolean isAdminMode = context.getRequest().getOpMode() == 2;
        NavRequest request = context.getRequest();
        String opName = request.getOpName();
        String id = (String)request.getElement("id");
        String deploymentId = (String)request.getElement("deploymentId");
        boolean useDeploymentId = request.getProp("dep_id") != null;
        String path = useDeploymentId && deploymentId != null && deploymentId.length() > 0 ? NavHelper.getCMSearchPath(deploymentId) : NavHelper.getCMSearchPath(id);
        String childObjects = (String)request.getElement("childObjects");
        StringBuffer childObjectFilter = (StringBuffer)request.getElement("childObjectFilter");
        boolean isChildObjects = childObjects != null && !"none".equals(childObjects) || childObjectFilter != null && childObjectFilter.length() > 0;
        int n = requestCount = "getItem".equals(opName) || !"root".equals(path) && !isChildObjects ? 2 : 3;
        if (context.isMultipleRequest()) {
            request.setCMRequestCount(requestCount);
        } else {
            buffer.append("<cm:query xmlns:xtsext=\"xalan://com.cognos.xts.ext.XTSExt\" xmlns:nav=\"http://developer.cognos.com/schemas/cps/navigation/1/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\">");
            buffer.append("<requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryRequest[");
            buffer.append(requestCount);
            buffer.append("]\">");
        }
        CMRequestHelper.addUserFolderRequest(context, buffer);
        if ("root".equals(path)) {
            CMRequestHelper.addQueryRequest(context, "/content", null, null, isAdminMode, buffer);
            CMRequestHelper.addQueryRequest(context, "~/folder", null, null, isAdminMode, buffer);
        } else if ("getItem".equals(opName)) {
            CMRequestHelper.addItemRequest(context, path, isAdminMode, buffer);
            if (isChildObjects) {
                StringBuffer childrenPath = new StringBuffer();
                if (!"/".equals(path)) {
                    childrenPath.append(path);
                }
                if (childObjects.length() > 0) {
                    childrenPath.append("/" + childObjects);
                }
                Integer skipObjects = (Integer)request.getElement("skipObjects");
                Integer maxObjects = (Integer)request.getElement("maxObjects");
                CMRequestHelper.addItemRequest(context, childrenPath.toString(), isAdminMode, buffer);
            }
        } else {
            CMRequestHelper.addContainerRequest(context, path, isAdminMode, buffer);
            if (isChildObjects) {
                StringBuffer childrenPath = new StringBuffer();
                if (!"/".equals(path)) {
                    childrenPath.append(path);
                }
                if (OBJECTS_ALL.equals(childObjects)) {
                    childrenPath.append("/*[@objectClass!='model' and @objectClass!='drillPath' and @objectClass!='packageConfiguration']");
                } else if (OBJECTS_CONTAINERS.equals(childObjects)) {
                    childrenPath.append("/*[@objectClass='folder' or @objectClass='package' or @objectClass='content']");
                } else if (OBJECTS_ITEMS.equals(childObjects)) {
                    childrenPath.append("/*[@objectClass!='model' and @objectClass!='drillPath' and @objectClass!='packageConfiguration' and @objectClass!='folder' and @objectClass!='package' and @objectClass!='content']");
                } else if ("urls".equals(childObjects)) {
                    childrenPath.append("/*[@objectClass='URL']");
                } else if ("rss".equals(childObjects)) {
                    childrenPath.append("/*[@objectClass='URL' or @objectClass='shortcut']");
                } else if (childObjectFilter != null && childObjectFilter.length() > 0) {
                    childrenPath.append("/*[");
                    StringTokenizer types = new StringTokenizer(childObjectFilter.toString(), "~");
                    int items = 0;
                    while (types.hasMoreTokens()) {
                        String type = types.nextToken();
                        if (items > 0) {
                            childrenPath.append(" or ");
                        }
                        childrenPath.append("@objectClass = '");
                        NavUtils.xmlEncode(type, childrenPath);
                        childrenPath.append("'");
                        ++items;
                    }
                    childrenPath.append("]");
                }
                Integer skipObjects = (Integer)request.getElement("skipObjects");
                Integer maxObjects = (Integer)request.getElement("maxObjects");
                CMRequestHelper.addQueryRequest(context, childrenPath.toString(), skipObjects, maxObjects, isAdminMode, buffer);
            }
        }
        if (!context.isMultipleRequest()) {
            buffer.append("</requests>");
            buffer.append("<options xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryMultipleOptions\"><cacheValidator xsi:type=\"xsd:string\">");
            NavUtils.xmlEncode(CMRequestHelper.getValidateTag(context), buffer);
            buffer.append("</cacheValidator></options></cm:query>");
        }
        return buffer.toString();
    }

    private static void addContainerRequest(RequestContext context, String path, boolean isAdminMode, StringBuffer buffer) {
        buffer.append("<item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">");
        NavUtils.xmlEncode(path, buffer);
        buffer.append("</search>");
        CMRequestHelper.addProperties(context, false, isAdminMode, true, false, false, buffer);
        buffer.append("</item>");
    }

    private static void addItemRequest(RequestContext context, String path, boolean isAdminMode, StringBuffer buffer) {
        buffer.append("<item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">");
        NavUtils.xmlEncode(path, buffer);
        buffer.append("</search>");
        StringBuffer properties = new StringBuffer(1024);
        CMRequestHelper.addProperties(context, true, isAdminMode, false, false, false, properties);
        buffer.append(properties);
        buffer.append("<options xsi:type=\"cm:queryOptions\">");
        CMRequestHelper.addRefProps(context, properties, isAdminMode, buffer);
        buffer.append("</options></item>");
    }

    private static void addQueryRequest(RequestContext context, String path, Integer skip, Integer max, boolean isAdminMode, StringBuffer buffer) {
        buffer.append("<item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">");
        NavUtils.xmlEncode(path, buffer);
        buffer.append(CMRequestHelper.getVisibleFilter(isAdminMode));
        buffer.append("</search>");
        CMRequestHelper.addProperties(context, true, false, false, false, false, buffer);
        CMRequestHelper.addSortByElement(context, buffer, "displaySequence", "descending");
        StringBuffer targetProperties = new StringBuffer(1024);
        CMRequestHelper.addProperties(context, true, isAdminMode, false, true, false, targetProperties);
        buffer.append("<options xsi:type=\"cm:queryOptions\">");
        CMRequestHelper.addRefProps(context, targetProperties, isAdminMode, buffer);
        if (skip != null) {
            buffer.append("<skipObjects xsi:type=\"xsd:integer\">");
            buffer.append(skip);
            buffer.append("</skipObjects>");
        }
        if (max != null) {
            buffer.append("<maxObjects xsi:type=\"xsd:integer\">");
            buffer.append(max + 1);
            buffer.append("</maxObjects>");
        }
        buffer.append("</options></item>");
    }

    private static void addUserFolderRequest(RequestContext context, StringBuffer buffer) {
        buffer.append("<item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">~/folder[permission(\"traverse\")]</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[2]\"><item xsi:type=\"cm:propEnum\">defaultName</item><item xsi:type=\"cm:propEnum\">searchPath</item><item xsi:type=\"cm:propEnum\">storeID</item></properties></item>");
    }

    private static void addProperties(RequestContext context, boolean allBaseProp, boolean adminProp, boolean isOuterContainer, boolean isTarget, boolean isIndexSearch, StringBuffer result) {
        boolean containerChild;
        NavRequest request = context.getRequest();
        ArrayList<String> cmProperties = new ArrayList<String>();
        StringBuffer propertiesStringBuffer = new StringBuffer();
        if (isIndexSearch) {
            cmProperties.add("shown");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">shown</item>");
        }
        if (request.isProperty("description")) {
            cmProperties.add("defaultDescription");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">defaultDescription</item>");
        }
        if (request.isProperty("dataType")) {
            cmProperties.add("dataType");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">dataType</item>");
        }
        if (request.isProperty("documentType")) {
            cmProperties.add("documentType");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">documentType</item>");
        }
        if (request.isProperty("burstKey")) {
            cmProperties.add("burstKey");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">burstKey</item>");
        }
        if (request.isProperty("locale")) {
            cmProperties.add("locale");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">locale</item>");
        }
        if (request.isProperty("screenTip")) {
            cmProperties.add("defaultScreenTip");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">defaultScreenTip</item>");
        }
        if (request.isProperty("createDate")) {
            cmProperties.add("creationTime");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">creationTime</item>");
        }
        if (request.isProperty("lastModifiedDate")) {
            cmProperties.add("modificationTime");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">modificationTime</item>");
        }
        if (request.isProperty("asOfDate")) {
            cmProperties.add("asOfTime");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">asOfTime</item>");
        }
        if (request.isProperty("fullName") || request.isProperty("fullPath") || isOuterContainer) {
            cmProperties.add("ancestors");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">ancestors</item>");
        }
        if (request.isProperty("formatName")) {
            cmProperties.add("format");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">format</item>");
        }
        if (request.isProperty("hasChildren")) {
            cmProperties.add("hasChildren");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">hasChildren</item>");
        }
        boolean bl = containerChild = "getContainer".equals(request.getOpName()) && !isOuterContainer;
        if (request.isProperty("parentId") && (isTarget || !containerChild)) {
            cmProperties.add("parent");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">parent</item>");
        }
        if (request.isProperty("owner")) {
            cmProperties.add("owner");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">owner</item>");
        }
        if (request.isProperty("icons")) {
            cmProperties.add("disabled");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">disabled</item>");
        }
        if (request.isProperty("credential")) {
            cmProperties.add("credential");
            propertiesStringBuffer.append("<item xsi:type=\"cm:propEnum\">credential</item>");
        }
        Iterator it = request.getCustomProperties().iterator();
        while (it.hasNext()) {
            for (Map.Entry entry : ((CustomNavProperty)it.next()).getCMProperties().entrySet()) {
                if (!allBaseProp ? NavPropertyManager.isCMBaseProperty((String)entry.getKey()) : NavPropertyManager.isCMAllBaseProperty((String)entry.getKey())) continue;
                if (adminProp && NavPropertyManager.isCMAdminProperty((String)entry.getKey()) || cmProperties.contains(entry.getKey())) continue;
                cmProperties.add((String)entry.getKey());
                propertiesStringBuffer.append(entry.getValue());
            }
        }
        result.append("<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[");
        int count = cmProperties.size();
        count = allBaseProp ? (count += NavPropertyManager.getCMAllBasePropertySize()) : (count += NavPropertyManager.getCMBasePropertySize());
        if (adminProp) {
            count += NavPropertyManager.getCMAdminPropertySize();
        }
        result.append(count);
        result.append("]\">");
        if (allBaseProp) {
            result.append(NavPropertyManager.getAllBasePropertyString());
        } else {
            result.append(NavPropertyManager.getBasePropertyString());
        }
        if (adminProp) {
            result.append(NavPropertyManager.getAdminPropertyString());
        }
        result.append(propertiesStringBuffer);
        result.append("</properties>");
    }

    private static void addBaseProperties(RequestContext context, StringBuffer buffer) {
        NavRequest request = context.getRequest();
        boolean isIcons = request.isProperty("icons");
        int count = isIcons ? 5 : 4;
        buffer.append("<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[");
        buffer.append(count);
        buffer.append("]\"><item xsi:type=\"cm:propEnum\">searchPath</item><item xsi:type=\"cm:propEnum\">storeID</item><item xsi:type=\"cm:propEnum\">permissions</item><item xsi:type=\"cm:propEnum\">executionFormat</item>");
        if (isIcons) {
            buffer.append("<item xsi:type=\"cm:propEnum\">disabled</item>");
        }
        buffer.append("</properties>");
    }

    private static void addOutputProperties(RequestContext context, StringBuffer buffer) {
        int count = 4;
        buffer.append("<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[");
        buffer.append(count);
        buffer.append("]\"><item xsi:type=\"cm:propEnum\">searchPath</item><item xsi:type=\"cm:propEnum\">storeID</item><item xsi:type=\"cm:propEnum\">defaultName</item><item xsi:type=\"cm:propEnum\">parent</item>");
        buffer.append("</properties>");
    }

    private static void addParentProperties(RequestContext context, StringBuffer buffer) {
        NavRequest request = context.getRequest();
        boolean isAdminMode = context.getRequest().getOpMode() == 2;
        int count = 0;
        StringBuffer customProperties = null;
        if (isAdminMode) {
            customProperties = new StringBuffer();
            Iterator it = request.getCustomProperties().iterator();
            while (it.hasNext()) {
                for (Map.Entry entry : ((CustomNavProperty)it.next()).getCMProperties().entrySet()) {
                    if (NavPropertyManager.isParentRefPropProperty((String)entry.getKey())) continue;
                    ++count;
                    customProperties.append(entry.getValue());
                }
            }
        }
        buffer.append("<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[");
        buffer.append(count + NavPropertyManager.getParentRefPropPropertySize());
        buffer.append("]\">");
        buffer.append(NavPropertyManager.getParentRefPropPropertyString());
        if (customProperties != null) {
            buffer.append(customProperties);
        }
        buffer.append("</properties>");
    }

    private static void addUserProperties(RequestContext context, StringBuffer buffer) {
        int count = 2;
        buffer.append("<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[");
        buffer.append(count);
        buffer.append("]\"><item xsi:type=\"cm:propEnum\">defaultName</item><item xsi:type=\"cm:propEnum\">userName</item>");
        buffer.append("</properties>");
    }

    private static void addRefProps(RequestContext context, StringBuffer targetProperties, boolean isAdminMode, StringBuffer buffer) {
        if (isAdminMode) {
            boolean isUserInfo = context.getRequest().isProperty("userInfo");
            int count = isUserInfo ? 3 : 2;
            buffer.append("<refProps xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:refProp[" + count + "]\">" + "<item xsi:type=\"cm:refProp\">" + "<refPropName xsi:type=\"cm:propEnum\">output</refPropName>");
            CMRequestHelper.addOutputProperties(context, buffer);
            buffer.append("</item><item xsi:type=\"cm:refProp\"><refPropName xsi:type=\"cm:propEnum\">parent</refPropName>");
            CMRequestHelper.addParentProperties(context, buffer);
            buffer.append("</item>");
            if (isUserInfo) {
                buffer.append("<item xsi:type=\"cm:refProp\"><refPropName xsi:type=\"cm:propEnum\">user</refPropName>");
                CMRequestHelper.addUserProperties(context, buffer);
                buffer.append("</item>");
            }
            buffer.append("</refProps>");
        } else {
            boolean isPortalPagesInfo = context.getRequest().isProperty("portalPagesInfo");
            int count = isPortalPagesInfo ? 4 : 3;
            buffer.append("<refProps xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:refProp[" + count + "]\">" + "<item xsi:type=\"cm:refProp\">" + "<refPropName xsi:type=\"cm:propEnum\">target</refPropName>");
            buffer.append(targetProperties);
            buffer.append("</item><item xsi:type=\"cm:refProp\"><refPropName xsi:type=\"cm:propEnum\">base</refPropName>");
            CMRequestHelper.addBaseProperties(context, buffer);
            buffer.append("</item>");
            buffer.append("<item xsi:type=\"cm:refProp\"><refPropName xsi:type=\"cm:propEnum\">metadataModelPackage</refPropName><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]]\"><item xsi:type=\"cm:propEnum\">effectiveUserCapabilities</item></properties></item>");
            if (isPortalPagesInfo) {
                buffer.append("<item xsi:type=\"cm:refProp\"><refPropName xsi:type=\"cm:propEnum\">portalPages</refPropName>");
                buffer.append(targetProperties);
                buffer.append("</item>");
            }
            buffer.append("</refProps>");
        }
    }

    public static String getValidateTag(RequestContext context) {
        String validateTag = context.getValidateTag();
        String passport = context.getHeader().getPassportID();
        if (validateTag != null && validateTag.startsWith(passport)) {
            return validateTag.substring(passport.length(), validateTag.length());
        }
        return "";
    }

    private static String getSortUsage(RequestContext context) {
        String sortUsage = (String)context.getRequest().getElement("sort@usage");
        if (sortUsage == null || sortUsage.length() == 0) {
            sortUsage = NavSystem.getInstance().getSystemSortUsage();
        }
        return sortUsage;
    }

    private static String getVisibleFilter(boolean isAdminMode) {
        if (isAdminMode) {
            return "";
        }
        String visibleFilter = NavSystem.getInstance().getSystemVisibleFilter();
        if (visibleFilter == null || visibleFilter.length() == 0) {
            visibleFilter = "[permission(\"read\") or permission(\"write\") or permission(\"execute\") or permission(\"traverse\") or permission(\"setPolicy\")]";
        }
        return visibleFilter + "[@shown='true']";
    }

    private static String getCMSortProp(String navSortProp) {
        if ("lastModifiedDate".equals(navSortProp)) {
            return "modificationTime";
        }
        if ("name".equals(navSortProp)) {
            return "defaultName";
        }
        if ("burstKey".equals(navSortProp)) {
            return "burstKey";
        }
        if ("locale".equals(navSortProp)) {
            return "locale";
        }
        return navSortProp;
    }
}

