/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.helpers;

import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.common.message.MessagesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Element;

public class ItemType {
    private static Map ITEM_TYPES;
    private String id;
    private String description;

    public static void initialize(Element uiMetadataElem) throws NavException {
        HashMap map = new HashMap();
        if (uiMetadataElem != null) {
            List sets = uiMetadataElem.selectNodes("/nox:uiMetadata/nox:searchSets/nox:searchSet");
            for (int i = 0; i < sets.size(); ++i) {
                Element setElem = (Element)sets.get(i);
                String setName = setElem.valueOf("./nox:name");
                ArrayList<ItemType> itemTypes = new ArrayList<ItemType>();
                List items = setElem.selectNodes("./nox:items/nox:item");
                for (int j = 0; j < items.size(); ++j) {
                    Element itemElem = (Element)items.get(j);
                    ItemType item = new ItemType(itemElem.valueOf("./nox:itemType"), itemElem.valueOf("./nox:idsString"));
                    itemTypes.add(item);
                }
                map.put(setName, itemTypes);
            }
        }
        ITEM_TYPES = Collections.unmodifiableMap(map);
    }

    public static List getItemTypes(String group) {
        List list = (List)ITEM_TYPES.get(group);
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public static Map getItemTypesMap() {
        return ITEM_TYPES;
    }

    public ItemType(String id, String desc) {
        this.id = id;
        this.description = desc;
    }

    public void toXml(XMLStreamWriter writer, RequestContext context) throws XMLStreamException {
        writer.writeStartElement("nav", "itemType", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeStartElement("nav", "id", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeCharacters(this.id);
        writer.writeEndElement();
        writer.writeStartElement("nav", "description", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeCharacters(MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), this.description));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }
}

