/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.helpers;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.common.message.MessagesManager;
import java.util.List;
import java.util.Map;

public class NavHelper {
    private static final String NAV_ID_MARKER = "_";
    public static final String ROOT_DEFAULT_PATH = "root";
    public static final String SYSTEM_DEFAULT_PATH = "/content";
    public static final String USER_DEFAULT_PATH = "~/folder";
    public static final String ROOT_DEFAULT_ID = "rootDefault";
    public static final String SYSTEM_DEFAULT_ID = "systemDefault";
    public static final String USER_DEFAULT_ID = "userDefault";

    public static final String getOption(String option, String defaultValue, GenericCMObject object) {
        Map options = object.getMapParameter("options");
        if (options.containsKey(option)) {
            return (String)options.get(option);
        }
        return defaultValue;
    }

    public static String getOutputFormat(GenericCMObject object, RequestContext context) {
        String defaultOutputFormat = null;
        String objType = object.getType();
        if ("cm:document".equals(objType)) {
            defaultOutputFormat = object.getParameter("documentType", null);
        } else if ("cm:agentDefinition".equals(objType) || "cm:agentDefinitionView".equals(objType)) {
            GenericCMObject output = object.getChildObject("mostRecentEventList");
            defaultOutputFormat = output != null ? "agentOutputHotlist" : null;
        } else if ("cm:output".equals(objType) || "cm:documentContent".equals(objType)) {
            String documentType;
            defaultOutputFormat = "cm:documentContent".equals(objType) ? ((documentType = context.getRequest().getParam("documentType")) != null && !"".equals(documentType) ? documentType : object.getParameter("format", null)) : object.getParameter("format", null);
        } else {
            List outputFormatList = object.getArrayParameter("defaultOutputFormat");
            if (outputFormatList.size() > 0) {
                defaultOutputFormat = (String)outputFormatList.get(0);
            }
        }
        return defaultOutputFormat;
    }

    public static String getOutputFormatDisplayName(GenericCMObject object, RequestContext context) {
        String defaultOutputFormat = "";
        String objType = object.getType();
        if ("cm:output".equals(objType) || "cm:documentContent".equals(objType)) {
            defaultOutputFormat = object.getParameter("format", null);
            defaultOutputFormat = NavHelper.getOutputFormat(object, context);
            String dataType = object.getParameter("dataType", "");
            boolean isInteractiveReport = "message/rfc822".startsWith(dataType);
            if (isInteractiveReport) {
                String reportFormat = MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), "IDS_PROP_FORMAT_HTML");
                return reportFormat;
            }
            String reportFormatMsgId = NavSystem.getInstance().getOutputFormatDisplayName(defaultOutputFormat);
            if (reportFormatMsgId != null && !"".equals(reportFormatMsgId)) {
                String reportFormat = MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), reportFormatMsgId);
                return reportFormat;
            }
            if ("cm:documentContent".equals(objType)) {
                String documentType = context.getRequest().getParam("documentType");
                String documentTypeMsgId = NavSystem.getInstance().getOutputFormatDisplayName(documentType);
                if (documentTypeMsgId == null || "".equals(documentTypeMsgId)) {
                    documentTypeMsgId = "IDS_ACT_DEFAULT_DOCUMENT_VIEW";
                }
                String documentTypeMsg = MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), documentTypeMsgId);
                return documentTypeMsg;
            }
            return defaultOutputFormat;
        }
        return defaultOutputFormat;
    }

    public static String getOutputFormatDisplayName(String format, String locale) {
        String formatMsgId = NavSystem.getInstance().getOutputFormatDisplayName(format);
        if (formatMsgId != null && !"".equals(formatMsgId)) {
            String reportFormat = MessagesManager.getInstance().getMessage(locale, formatMsgId);
            return reportFormat;
        }
        return format;
    }

    public static boolean canExecute(GenericCMObject object) {
        return object.getArrayParameter("permissions").contains("execute");
    }

    public static boolean canRead(GenericCMObject object) {
        return object.getArrayParameter("permissions").contains("read");
    }

    public static boolean canSetPolicy(GenericCMObject object) {
        return object.getArrayParameter("permissions").contains("setPolicy");
    }

    public static boolean canTraverse(GenericCMObject object) {
        return object.getArrayParameter("permissions").contains("traverse");
    }

    public static boolean canWrite(GenericCMObject object) {
        return object.getArrayParameter("permissions").contains("write");
    }

    public static String getStoreId(String navId) {
        if (navId.startsWith(NAV_ID_MARKER)) {
            return navId.substring(NAV_ID_MARKER.length(), navId.length());
        }
        return navId;
    }

    public static String getCMSearchPath(String id) {
        String path = null;
        path = ROOT_DEFAULT_ID.equals(id) ? ROOT_DEFAULT_PATH : (SYSTEM_DEFAULT_ID.equals(id) ? SYSTEM_DEFAULT_PATH : (USER_DEFAULT_ID.equals(id) ? USER_DEFAULT_PATH : (id.startsWith("path:") ? id.substring(5) : (id.startsWith(NAV_ID_MARKER) ? "storeID(\"" + id.substring(NAV_ID_MARKER.length(), id.length()) + "\")" : NavUtils.web64Decode(id, false)))));
        return path;
    }

    public static String getNavIdFromStoreId(String storeId) {
        if (storeId != null) {
            return NAV_ID_MARKER + storeId;
        }
        return null;
    }

    public static String getNavIdFromSreachPath(String searchPath) {
        if (searchPath != null) {
            return NavUtils.web64Encode(searchPath, false);
        }
        return null;
    }

    public static String generateId(GenericCMObject object, RequestContext context) {
        String path = object.getParameter("storeID", null);
        GenericCMObject userFolder = context.getRequest().getUserFolder();
        if (path != null) {
            String id = path;
            if (id.equals(ROOT_DEFAULT_ID)) {
                return id;
            }
            if (userFolder != null && userFolder.getParameter("storeID", "").equals(id)) {
                return USER_DEFAULT_ID;
            }
            return NAV_ID_MARKER + id;
        }
        path = object.getParameter("searchPath", "");
        if (path.equals(ROOT_DEFAULT_ID)) {
            return path;
        }
        if (userFolder != null && userFolder.getParameter("searchPath", "").equals(path)) {
            return USER_DEFAULT_ID;
        }
        return NavUtils.web64Encode(path, false);
    }

    public static String generateIdForDeployment(GenericCMObject object, RequestContext context) {
        String path = object.getParameter("searchPath", "");
        GenericCMObject userFolder = context.getRequest().getUserFolder();
        if (path.equals(ROOT_DEFAULT_ID)) {
            return path;
        }
        if (userFolder != null && userFolder.getParameter("searchPath", "").equals(path)) {
            return USER_DEFAULT_ID;
        }
        return NavUtils.web64Encode(path, false);
    }

    public static String getPath(GenericCMObject object) {
        String id = object.getParameter("storeID", null);
        if (id != null) {
            if (id.equals(ROOT_DEFAULT_ID)) {
                return id;
            }
            id = "storeID(\"" + id + "\")";
            return id;
        }
        return object.getParameter("searchPath", "");
    }

    public static String getRelativePath(GenericCMObject object) {
        String id = object.getParameter("storeID", null);
        if (id != null) {
            id = "/" + id;
        }
        return id;
    }

    public static boolean isReportType(String className) {
        return "report".equals(className) || "query".equals(className) || "analysis".equals(className) || "reportView".equals(className) || "powerPlay8Report".equals(className) || "powerPlay8ReportView".equals(className);
    }

    public static boolean isActiveReportType(String className) {
        return "interactiveReport".equals(className);
    }

    public static String[] getViewerOutputFormatsList(String className) {
        String[] formatsList;
        if (NavHelper.isActiveReportType(className)) {
            String[] activeReportFormatsList = new String[]{"XHTML"};
            formatsList = activeReportFormatsList;
        } else if (NavHelper.isReportType(className)) {
            NavSystem navSys = NavSystem.getInstance();
            formatsList = navSys.getViewerOutputFormatsList().split(" ");
        } else {
            String[] emptyFormatsList;
            formatsList = emptyFormatsList = new String[0];
        }
        return formatsList;
    }
}

