/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.helpers;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.common.message.MessagesManager;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class NavIcon {
    private static HashMap ICONS = new HashMap();
    private String name;
    private String icon;
    private String tooltip;
    private String property;

    public static NavIcon getIcon(String icon) {
        return (NavIcon)ICONS.get(icon);
    }

    public NavIcon(String name, String property, String icon, String tooltip) {
        this.name = name;
        this.icon = icon;
        this.tooltip = tooltip;
        this.property = property;
    }

    public void render(XMLStreamWriter writer, GenericCMObject obj, RequestContext context) throws XMLStreamException {
        writer.writeStartElement("nav", "icon", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeStartElement("nav", "name", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeCharacters(this.name);
        writer.writeEndElement();
        if (this.tooltip != null) {
            writer.writeStartElement("nav", "alt", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), this.tooltip));
            writer.writeEndElement();
        }
        writer.writeStartElement("nav", "imgURL", "http://developer.cognos.com/schemas/cps/navigation/1/");
        String tmp = this.icon;
        if (tmp == null && this.property != null) {
            tmp = obj.getParameter(this.property, null);
        }
        writer.writeCharacters(context.getImageRoot() + (tmp != null ? tmp + ".gif" : ""));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    static {
        ICONS.put("state_disabled", new NavIcon("disabled", null, "state_disabled", "IDS_ICON_DISABLED"));
        ICONS.put("state_source_disabled", new NavIcon("disabled", null, "state_source_disabled", "IDS_ICON_DISABLED"));
        ICONS.put("score_icon", new NavIcon("score", "score_icon", null, null));
    }
}

