/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.helpers;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.HandlerManager;
import com.cognos.cps.bseries.xts.request.nav.element.core.BaseHandler;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PagerList {
    private int start = 0;
    private int end = 0;
    private int max = -1;
    private int total = 0;
    private Integer estimatedTotal;
    private boolean more = false;
    private List objects;

    public PagerList(List objects, int max, int skip, boolean more) {
        this.objects = objects;
        if (objects.size() == 0) {
            this.start = 0;
            this.end = 0;
            max = -1;
            this.total = 0;
            more = false;
        } else {
            int itemCount = objects.size();
            if (itemCount > 0) {
                int countObjects = more && itemCount > max ? max : itemCount;
                this.start = skip + 1;
                this.end = skip + countObjects;
                this.max = max;
                this.more = more;
                if (!more) {
                    this.total = skip + countObjects;
                }
            }
        }
    }

    public void setEstimatedTotal(int estimatedTotal) {
        this.estimatedTotal = new Integer(estimatedTotal);
    }

    public PagerList(List objects, int max) {
        this(objects, max, objects.size() > 0 ? Integer.parseInt(((GenericCMObject)objects.get(0)).getParameter("position", "0")) : 0, max > 0 ? objects.size() > max : false);
    }

    public void asXML(RequestContext context, XMLStreamWriter writer) throws XMLStreamException, NavException {
        writer.writeStartElement("nav", "content", "http://developer.cognos.com/schemas/cps/navigation/1/");
        writer.writeAttribute("start", Integer.toString(this.start));
        writer.writeAttribute("end", Integer.toString(this.end));
        if (this.max > 0) {
            writer.writeAttribute("max", Integer.toString(this.max));
        }
        writer.writeAttribute("more", Boolean.toString(this.more));
        if (this.estimatedTotal != null) {
            writer.writeAttribute("estimatedTotal", this.estimatedTotal.toString());
        }
        if (!this.more) {
            writer.writeAttribute("total", Integer.toString(this.total));
        }
        if (this.start > 0) {
            for (int i = 0; i <= this.end - this.start; ++i) {
                GenericCMObject obj = (GenericCMObject)this.objects.get(i);
                BaseHandler handler = HandlerManager.getHandler(obj);
                handler.asXML(obj, context, writer);
            }
        }
        writer.writeEndElement();
    }
}

