/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.helpers;

import com.cognos.cps.common.utils.Base64;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.common.utils.Strings;

public class SearchContext {
    private static final String VERSION = "1";
    private static final char ESCAPE_CHAR = '\\';
    private static final char SEP_CHAR = '|';
    private static final String UNSAFE_CHARS = String.valueOf('|');
    private static int CTX_VERSION = 0;
    private static int CTX_SEARCH_STRING = 1;
    private static int CTX_SOURCE_CONTEXT = 2;
    private static int CTX_INDEX_ITEM_TYPE = 3;
    private static int CTX_MAX = 4;
    private static int CTX_DISPLAY_ITEM_FIRST = 5;
    private static int CTX_DISPLAY_ITEM_LAST = 6;
    private static int CTX_INDEX_ITEM_FIRST = 7;
    private static int CTX_INDEX_ITEM_LAST = 8;
    private static int CTX_INDEX_ITEM_REMAINING = 9;
    private static int CTX_INDEX_PAGE = 10;
    private static int CTX_COUNT = 11;
    public String searchString;
    public String sourceContext;
    public String itemType;
    public String itemRemaining;
    public int max;
    public int displayItemFirst;
    public int displayItemLast;
    public int indexItemFirst;
    public int indexItemLast;
    public int pageSize;

    public SearchContext() {
    }

    public SearchContext(String encodedContext) {
        String[] args = this.decodeSearchContext(encodedContext);
        this.searchString = args[CTX_SEARCH_STRING];
        this.sourceContext = args[CTX_SOURCE_CONTEXT];
        try {
            this.max = Integer.parseInt(args[CTX_MAX]);
        }
        catch (Exception e) {
            this.max = 0;
        }
        try {
            this.displayItemFirst = Integer.parseInt(args[CTX_DISPLAY_ITEM_FIRST]);
        }
        catch (Exception e) {
            this.displayItemFirst = 0;
        }
        try {
            this.displayItemLast = Integer.parseInt(args[CTX_DISPLAY_ITEM_LAST]);
        }
        catch (Exception e) {
            this.displayItemLast = 0;
        }
        try {
            this.indexItemFirst = Integer.parseInt(args[CTX_INDEX_ITEM_FIRST]);
        }
        catch (Exception e) {
            this.indexItemFirst = 0;
        }
        try {
            this.indexItemLast = Integer.parseInt(args[CTX_INDEX_ITEM_LAST]);
        }
        catch (Exception e) {
            this.indexItemLast = 0;
        }
        try {
            this.pageSize = Integer.parseInt(args[CTX_INDEX_PAGE]);
        }
        catch (Exception e) {
            this.pageSize = 0;
        }
        this.itemRemaining = args[CTX_INDEX_ITEM_REMAINING];
        this.itemType = args[CTX_INDEX_ITEM_TYPE];
    }

    public String encode() {
        String[] args = new String[CTX_COUNT];
        args[SearchContext.CTX_VERSION] = VERSION;
        args[SearchContext.CTX_SEARCH_STRING] = this.searchString;
        args[SearchContext.CTX_SOURCE_CONTEXT] = this.sourceContext;
        args[SearchContext.CTX_INDEX_ITEM_TYPE] = this.itemType;
        args[SearchContext.CTX_MAX] = String.valueOf(this.max);
        args[SearchContext.CTX_INDEX_PAGE] = String.valueOf(this.pageSize);
        args[SearchContext.CTX_DISPLAY_ITEM_FIRST] = String.valueOf(this.displayItemFirst);
        args[SearchContext.CTX_DISPLAY_ITEM_LAST] = String.valueOf(this.displayItemLast);
        args[SearchContext.CTX_INDEX_ITEM_FIRST] = String.valueOf(this.indexItemFirst);
        args[SearchContext.CTX_INDEX_ITEM_LAST] = String.valueOf(this.indexItemLast);
        args[SearchContext.CTX_INDEX_ITEM_REMAINING] = this.itemRemaining;
        return this.encodeSearchContext(args);
    }

    private String encodeSearchContext(String[] args) {
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg != null) {
                EncodingUtils.escapeString((String)arg, (String)UNSAFE_CHARS, (char)'\\', (StringBuffer)tmp);
            }
            if (i >= args.length - 1) continue;
            tmp.append('|');
        }
        try {
            return Base64.encode((byte[])tmp.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException("cps.common.data.conversion.error", e);
        }
    }

    private String[] decodeSearchContext(String context) {
        try {
            String decodedContext;
            byte[] bytes = Base64.decode((String)context);
            if (bytes != null && (decodedContext = new String(bytes, "UTF-8")) != null) {
                return Strings.split((String)decodedContext, (char)'|', (char)'\\');
            }
        }
        catch (Exception e) {
            throw new RuntimeException("cps.common.data.conversion.error", e);
        }
        return null;
    }
}

