/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.helpers;

import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.common.utils.SmallMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class UrlBuilder {
    public static final int FLAG_URL_ENCODE = 0;
    public static final int FLAG_URL_ENCODE_NAME_VALUE = 1;
    public static final int FLAG_URL_NO_ENCODING = 2;
    public static final int FLAG_URL_PROTECT_DATA = 3;
    public static final int FLAG_URL_PROTECT_PATH = 4;
    public static final int FLAG_URL_PROTECT_URL = 5;
    public static final int FLAG_URL_PROTECT_NAME_PATH = 6;
    boolean series7Encode;
    boolean isExternal;
    boolean isPost;
    SmallMap params;
    String gateway;

    public UrlBuilder(RequestContext context) {
        this(context, false);
    }

    public UrlBuilder(RequestContext context, boolean urlPartsRequested) {
        this.isPost = urlPartsRequested ? true : context.getRequest().isParam("postUrl");
        this.params = new SmallMap();
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public void addParam(String param, String value, int flag) {
        if (param == null) {
            throw new IllegalArgumentException("param must not be null");
        }
        if (!this.isPost) {
            switch (flag) {
                case 0: {
                    value = NavUtils.urlEncode(value);
                    break;
                }
                case 1: {
                    param = NavUtils.urlEncode(param);
                    value = NavUtils.urlEncode(value);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    value = NavUtils.urlEncodeAndProtect(value, "url", "userData", "getdata");
                    break;
                }
                case 4: {
                    value = NavUtils.urlEncodeAndProtect(value, "url", "searchPath", "getdata");
                    break;
                }
                case 5: {
                    value = NavUtils.urlEncodeAndProtect(value, "url", "url", "getdata");
                    break;
                }
                case 6: {
                    param = NavUtils.urlEncode(param);
                    value = NavUtils.urlEncodeAndProtect(value, "url", "searchPath", "getdata");
                }
            }
        }
        this.params.put((Object)param, (Object)value);
    }

    public void setEncodeForSeries7() {
        this.series7Encode = true;
    }

    public void setExternal() {
        this.isExternal = true;
        this.isPost = false;
    }

    private String toString(boolean xmlEncoded) {
        StringBuffer buffer = new StringBuffer();
        String separator = xmlEncoded ? "&amp;" : "&";
        buffer.append(this.gateway);
        if (this.params.size() > 0) {
            buffer.append('?');
            Set entries = this.params.entrySet();
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                buffer.append(entry.getKey());
                buffer.append('=');
                buffer.append(entry.getValue());
                if (!it.hasNext()) continue;
                buffer.append(separator);
            }
        }
        if (this.series7Encode) {
            return NavUtils.protect(buffer.toString(), "none", "s7url", "s7url");
        }
        return buffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public void asXML(XMLStreamWriter writer) throws XMLStreamException {
        if (this.isPost) {
            writer.writeStartElement("nav", "urlParts", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeStartElement("nav", "gateway", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeCharacters(this.gateway);
            writer.writeEndElement();
            Set entries = this.params.entrySet();
            for (Map.Entry entry : entries) {
                writer.writeStartElement("nav", "param", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeAttribute("name", (String)entry.getKey());
                String value = (String)entry.getValue();
                if (value != null) {
                    writer.writeCharacters(value);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        } else {
            writer.writeStartElement("nav", "url", "http://developer.cognos.com/schemas/cps/navigation/1/");
            if (this.isExternal) {
                writer.writeAttribute("type", "external");
            }
            writer.writeCharacters(this.toString());
            writer.writeEndElement();
        }
    }
}

