/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.helpers;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.helpers.NavHelper;
import com.cognos.cps.bseries.xts.request.nav.helpers.PathInfoUrlBuilder;
import com.cognos.cps.bseries.xts.request.nav.helpers.UrlBuilder;
import com.cognos.cps.bseries.xts.request.nav.stax.NavRequest;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UrlHelper {
    public static String getRedirectURL(RequestContext context) {
        String ticket;
        StringBuffer baseQuery = new StringBuffer();
        baseQuery.append("b_action=xts.run&m=portal/main.xts");
        String propagatePassport = null;
        try {
            propagatePassport = XTSConfigManager.getInstance().getProperty("CPSPropagatePassport");
        }
        catch (XTSConfigurationException xTSConfigurationException) {
            // empty catch block
        }
        if (propagatePassport == null || !propagatePassport.equals("0") && !propagatePassport.equals("false")) {
            baseQuery.append("&m_passportID=");
            baseQuery.append(NavUtils.urlEncode(context.getHeader().getPassportCookie()));
            baseQuery.append("&m_retryPassportID=true");
        }
        String propagateTicket = null;
        try {
            propagateTicket = XTSConfigManager.getInstance().getProperty("CPSPropagateTicket");
        }
        catch (XTSConfigurationException xTSConfigurationException) {
            // empty catch block
        }
        if ((propagateTicket == null || !propagateTicket.equals("0") && !propagateTicket.equals("false")) && (ticket = context.getHeader().getTicket()) != null && ticket.length() > 0) {
            baseQuery.append("&m_asTicket=");
            baseQuery.append(NavUtils.urlEncode(ticket));
        }
        baseQuery.append("&m_productLocale=");
        baseQuery.append(context.getHeader().getProductLocaleAsString());
        baseQuery.append("&m_contentLocale=");
        baseQuery.append(context.getHeader().getContentLocaleAsString());
        StringBuffer redirectUrl = new StringBuffer();
        redirectUrl.append(context.getGatewayURL());
        redirectUrl.append("?");
        redirectUrl.append(baseQuery.toString() + "&m_redirect=");
        return redirectUrl.toString();
    }

    public static UrlBuilder getStudioLaunchUrl(String tool, String gateway, GenericCMObject object, RequestContext context, String navAction, boolean standalone, boolean useStoreIds, boolean useRelativeIds, boolean useUiID, boolean isPost, String uiProfile) {
        UrlBuilder buffer = new UrlBuilder(context);
        buffer.setGateway(context.getGatewayURL());
        buffer.addParam("b_action", "xts.run", 2);
        buffer.addParam("m", "portal/launch.xts", 2);
        if (gateway != null) {
            buffer.addParam("ui.gateway", gateway, isPost ? 0 : 5);
        }
        buffer.addParam("ui.tool", tool, 2);
        if (useUiID) {
            buffer.addParam("ui.id", object.getParameter("storeID", ""), 0);
        } else {
            String searchPath = null;
            searchPath = useStoreIds ? NavHelper.getPath(object) : (useRelativeIds ? NavHelper.getRelativePath(object) : object.getParameter("searchPath", object.getParameter("objectClass", "")));
            buffer.addParam("ui.object", searchPath, isPost ? 0 : 4);
        }
        String objectClass = object.getParameter("objectClass", "");
        List userInterfaces = object.getArrayParameter("userInterfaces");
        if (objectClass.startsWith("powerPlay8Report")) {
            String defaultAction = null;
            if (navAction.equals("default") && (defaultAction = object.getParameter("calculatedPortalAction", null)) == null) {
                defaultAction = object.getParameter("defaultPortalAction", null);
            }
            if (navAction.startsWith("run") || defaultAction != null && defaultAction.startsWith("run")) {
                buffer.addParam("ui.action", "run", 2);
                buffer.addParam("ui.crnfrm", "PDF", 2);
                String ppReportPrompt = NavHelper.getOption("prompt", "", object);
                if (ppReportPrompt != null && ppReportPrompt.length() > 0) {
                    buffer.addParam("ui.crnp", ppReportPrompt, 0);
                }
            } else {
                buffer.addParam("ui.action", "edit", 2);
                buffer.addParam("ui.crnfrm", "HTML", 2);
                String data = NavHelper.getOption("data", "", object);
                if ("previewWithNoData".equals(data)) {
                    buffer.addParam("ui.crngnd", "true", 2);
                } else {
                    buffer.addParam("ui.crngnd", "false", 2);
                }
            }
        } else if (objectClass.equals("package") && userInterfaces.contains("planningContributor")) {
            buffer.addParam("ui.action", "new", 2);
        } else {
            buffer.addParam("ui.action", "edit", 2);
        }
        if (uiProfile != null) {
            buffer.addParam("ui.profile", uiProfile, 2);
        }
        UrlHelper.addCustomParams(tool, context, buffer);
        if (!standalone) {
            UrlHelper.appendBackUrlForLaunch(context, buffer, navAction, !isPost, null, objectClass.startsWith("powerPlay8Report"));
        }
        UrlHelper.addURLParams(buffer, object);
        return buffer;
    }

    public static UrlBuilder getLaunchActionUrl(String action, String gateway, GenericCMObject object, RequestContext context, String navAction) {
        GenericCMObject base;
        String className = object.getParameter("objectClass", "");
        boolean isInteractiveReport = false;
        if ("interactiveReport".equalsIgnoreCase(className)) {
            isInteractiveReport = true;
        } else if ("reportView".equals(className) && (base = object.getChildObject("base")) != null) {
            isInteractiveReport = "cm:interactiveReport".equals(base.getType());
        }
        if (isInteractiveReport) {
            return UrlHelper.getInteractiveReportUrl(action, gateway, object, context, navAction);
        }
        return UrlHelper.getCognosViewerLaunchUrl(action, gateway, object, context, navAction);
    }

    public static UrlBuilder getInteractiveReportUrl(String action, String gateway, GenericCMObject object, RequestContext context, String navAction) {
        if (UrlHelper.interactiveReportNewWindow(action)) {
            PathInfoUrlBuilder builder = new PathInfoUrlBuilder(context);
            String storeID = object.getParameter("storeID", "");
            builder.setGateway(context.getGatewayURL());
            builder.setExternal();
            StringBuffer pathInfo = new StringBuffer();
            pathInfo.append("/repository/sid/cm/rid/");
            pathInfo.append(storeID);
            pathInfo.append("/oid/default/content/mht/content");
            builder.setPathInfo(pathInfo.toString());
            return builder;
        }
        return UrlHelper.getCognosViewerLaunchUrl(action, gateway, object, context, navAction);
    }

    private static boolean interactiveReportNewWindow(String action) {
        return "view".equals(action) && NavSystem.getInstance().isExpandMHT();
    }

    public static UrlBuilder getCognosViewerLaunchUrl(String action, String gateway, GenericCMObject object, RequestContext context, String navAction) {
        UrlBuilder buffer = new UrlBuilder(context);
        String className = object.getParameter("objectClass", "");
        String searchPath = null;
        boolean isAgent = false;
        if ("agentDefinition".equals(className) || "agentDefinitionView".equals(className)) {
            isAgent = true;
            GenericCMObject output = object.getChildObject("mostRecentEventList");
            if (output != null) {
                searchPath = NavHelper.getPath(output);
            }
        } else {
            searchPath = NavHelper.getPath(object);
        }
        buffer.setGateway(context.getGatewayURL());
        buffer.addParam("b_action", "cognosViewer", 2);
        boolean useReportLocaleInRVUI = NavSystem.getInstance().isUseReportLocaleInRVUI();
        String defaultBackUrl = null;
        if ("view".equals(action)) {
            buffer.addParam("ui.action", "view", 2);
            if (!isAgent) {
                String outputFormat = NavHelper.getOutputFormat(object, context);
                boolean isSupportedFormat = NavSystem.getInstance().isOutputFormatSupported(outputFormat);
                if (NavHelper.isReportType(className) || NavHelper.isActiveReportType(className)) {
                    searchPath = "defaultOutput(" + searchPath;
                    if (outputFormat != null && !isSupportedFormat) {
                        searchPath = searchPath + ",'','','";
                        searchPath = searchPath + NavSystem.getInstance().getViewerOutputFormatsList();
                        searchPath = searchPath + "'";
                    }
                    searchPath = searchPath + ")";
                }
                if (outputFormat != null) {
                    if (isSupportedFormat) {
                        buffer.addParam("ui.format", outputFormat, 0);
                    } else {
                        buffer.addParam("ui.format", "", 2);
                    }
                }
            }
            buffer.addParam("ui.object", searchPath, 4);
            String documentName = null;
            if ("output".equals(className) || "documentContent".equals(className)) {
                documentName = context.getRequest().getParam("documentName");
            }
            String name = documentName != null ? documentName : object.getParameter("defaultName", "");
            buffer.addParam("ui.name", name, 3);
            if (useReportLocaleInRVUI) {
                buffer.addParam("lang", context.getHeader().getContentLocaleAsString(), 0);
            }
        } else {
            buffer.addParam("ui.action", "run", 2);
            buffer.addParam("ui.object", searchPath, 4);
            String name = object.getParameter("defaultName", "");
            buffer.addParam("ui.name", name, 3);
            String executionFormat = object.getParameter("executionFormat", "");
            executionFormat = UrlHelper.adjustOutputFormat(executionFormat, context);
            buffer.addParam("run.outputFormat", executionFormat, 3);
            String executionPrompt = object.getParameter("executionPrompt", "");
            buffer.addParam("run.prompt", executionPrompt, 3);
            if (useReportLocaleInRVUI) {
                String lang = object.getParameter("executionLocale", null);
                if (lang == null || lang.length() == 0) {
                    lang = context.getHeader().getContentLocaleAsString();
                }
                buffer.addParam("lang", lang, 0);
            }
        }
        UrlHelper.appendUrlFlagsForCognosViewer(context, buffer, navAction, isAgent);
        UrlHelper.appendBackUrlForLaunch(context, buffer, navAction, true, defaultBackUrl, false);
        UrlHelper.addURLParams(buffer, object);
        return buffer;
    }

    public static void addCustomParams(String app, RequestContext context, UrlBuilder urlBuilder) {
        String key = app + ".param.";
        NavRequest request = context.getRequest();
        Enumeration enumeration = request.getParamNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (!name.startsWith(key)) continue;
            String paramName = name.substring(key.length());
            urlBuilder.addParam(paramName, request.getParam(name), 0);
        }
    }

    private static void appendUrlFlagsForCognosViewer(RequestContext context, UrlBuilder xmlEncodedUrl, String action, boolean isAgent) {
        String urlFlags;
        String cvid = context.getRequest().getParam("cvId");
        if (cvid != null && cvid.length() > 0) {
            xmlEncodedUrl.addParam("cv.id", cvid, 0);
        }
        if ((urlFlags = context.getRequest().getParam(action + ":urlFlags")) == null) {
            urlFlags = context.getRequest().getParam("urlFlags");
        }
        if (urlFlags != null) {
            if (urlFlags.indexOf("h1") == -1) {
                xmlEncodedUrl.addParam("cv.header", "false", 2);
            }
            if (urlFlags.indexOf("t0") != -1 || isAgent) {
                xmlEncodedUrl.addParam("cv.toolbar", "false", 2);
            } else if (urlFlags.indexOf("t1") != -1) {
                xmlEncodedUrl.addParam("cv.toolbar", "true", 2);
            }
            if (urlFlags.indexOf("i1") != -1) {
                xmlEncodedUrl.addParam("cv.responseFormat", "inline", 2);
            } else if (urlFlags.indexOf("i0") != -1) {
                xmlEncodedUrl.addParam("cv.responseFormat", "page", 2);
            }
            if (urlFlags.indexOf("r1") != -1) {
                xmlEncodedUrl.addParam("cv.cclinks", "true", 2);
            } else if (urlFlags.indexOf("r0") != -1) {
                xmlEncodedUrl.addParam("cv.cclinks", "false", 2);
            }
            if (urlFlags.indexOf("n1") != -1) {
                xmlEncodedUrl.addParam("cv.navlinks", "true", 2);
            } else if (urlFlags.indexOf("n0") != -1) {
                xmlEncodedUrl.addParam("cv.navlinks", "false", 2);
            }
            return;
        }
        xmlEncodedUrl.addParam("cv.header", "false", 2);
        if (context.getRequest().isParam("windowState") && !isAgent) {
            if (context.getRequest().getParam("windowState").equals("wsrp:maximized")) {
                xmlEncodedUrl.addParam("cv.toolbar", "true", 2);
            } else {
                xmlEncodedUrl.addParam("cv.toolbar", "false", 2);
            }
        }
        if (isAgent) {
            xmlEncodedUrl.addParam("cv.toolbar", "false", 2);
        }
    }

    public static void appendOtherUrlFlags(RequestContext context, UrlBuilder xmlEncodedUrl, String action) {
        String urlFlags = context.getRequest().getParam(action + ":urlFlags");
        if (urlFlags == null) {
            urlFlags = context.getRequest().getParam("urlFlags");
        }
        if (urlFlags != null) {
            int cPos = urlFlags.indexOf("c");
            if (cPos != -1) {
                xmlEncodedUrl.addParam("tool_tab", urlFlags.substring(cPos + 1, cPos + 2), 0);
            }
            return;
        }
    }

    public static void appendBackUrlForLaunch(RequestContext context, UrlBuilder xmlEncodedUrl, String action, boolean protect, String defaultBackUrl, boolean isPowerPlay) {
        UrlHelper.getBackUrl(context, xmlEncodedUrl, action, "ui.backURL", protect, defaultBackUrl, isPowerPlay);
    }

    public static void appendBackUrlForS7AndProtect(RequestContext context, UrlBuilder xmlEncodedUrl, String action) {
        UrlHelper.getBackUrl(context, xmlEncodedUrl, action, "BACK", true, null, false);
    }

    public static void appendBackUrl(RequestContext context, UrlBuilder xmlEncodedUrl, String action) {
        UrlHelper.getBackUrl(context, xmlEncodedUrl, action, "backURL", true, null, false);
    }

    public static void appendBackUrl(RequestContext context, UrlBuilder xmlEncodedUrl, String action, String defaultBackUrl) {
        UrlHelper.getBackUrl(context, xmlEncodedUrl, action, "backURL", true, defaultBackUrl, false);
    }

    public static void appendBackUrlNoProtect(RequestContext context, UrlBuilder xmlEncodedUrl, String action) {
        UrlHelper.getBackUrl(context, xmlEncodedUrl, action, "backURL", false, null, false);
    }

    private static void getBackUrl(RequestContext context, UrlBuilder xmlEncodedUrl, String action, String backParam, boolean protect, String defaultBackUrlOverride, boolean isPowerPlay) {
        String defaultBackUrl;
        boolean series7Style = "BACK".equals(backParam);
        String backUrlProp = null;
        if (action != null) {
            backUrlProp = context.getRequest().getParam(action + ":backUrl");
            if (backUrlProp == null) {
                backUrlProp = context.getRequest().getParam("backUrl");
            }
            if (backUrlProp != null) {
                if ("false".equals(backUrlProp)) {
                    return;
                }
                if ("rewrite".equals(backUrlProp)) {
                    if (series7Style) {
                        xmlEncodedUrl.addParam(backParam, "navrewriteabsolutebackurl", 2);
                    } else if (isPowerPlay) {
                        xmlEncodedUrl.addParam(backParam, "navrewritebackurlnoprotect", 2);
                    } else {
                        xmlEncodedUrl.addParam(backParam, "navrewritebackurl", 2);
                    }
                    return;
                }
                if ("back.xts".equals(backUrlProp)) {
                    String originalUrl = xmlEncodedUrl.toString();
                    StringBuffer back_xts = new StringBuffer();
                    String gatewayURL = series7Style ? NavSystem.getInstance().getDefaultGateway() : context.getGatewayURL();
                    back_xts.append(gatewayURL);
                    back_xts.append("?b_action=xts.run&m=/cps4/common/back.xts&urlEncoded=true&url=");
                    back_xts.append(NavUtils.urlEncode(NavUtils.web64Encode(originalUrl, true)));
                    if (action.equals("run_options")) {
                        back_xts.append("&action=run");
                    }
                    if (series7Style) {
                        back_xts.append("&s7=1");
                        xmlEncodedUrl.addParam(backParam, back_xts.toString(), 0);
                        xmlEncodedUrl.setEncodeForSeries7();
                        return;
                    }
                    if (protect) {
                        xmlEncodedUrl.addParam(backParam, back_xts.toString(), 3);
                    } else {
                        xmlEncodedUrl.addParam(backParam, back_xts.toString(), 0);
                    }
                    return;
                }
            }
        }
        if (series7Style) {
            StringBuffer back_xts = new StringBuffer();
            String gatewayURL = NavSystem.getInstance().getDefaultGateway();
            back_xts.append(gatewayURL);
            back_xts.append("?b_action=xts.run&m=/cps4/common/back.xts&action=close");
            xmlEncodedUrl.addParam(backParam, back_xts.toString(), 0);
            xmlEncodedUrl.setEncodeForSeries7();
            return;
        }
        if (defaultBackUrlOverride != null) {
            defaultBackUrl = defaultBackUrlOverride;
        } else {
            StringBuilder defaultBackUrlBuffer = new StringBuilder();
            defaultBackUrlBuffer.append(context.getWebContentURL());
            defaultBackUrlBuffer.append("/cps4/portlets/common/close.html");
            defaultBackUrl = defaultBackUrlBuffer.toString();
        }
        if (protect) {
            xmlEncodedUrl.addParam(backParam, defaultBackUrl, 5);
        } else {
            xmlEncodedUrl.addParam(backParam, defaultBackUrl, 0);
        }
    }

    public static UrlBuilder generateActionURL(GenericCMObject object, RequestContext context, String target) {
        UrlBuilder href = new UrlBuilder(context);
        String objectClass = object.getParameter("objectClass", "");
        String objectName = object.getParameter("defaultName", "");
        String searchPath = NavHelper.getPath(object);
        href.setGateway(context.getGatewayURL());
        href.addParam("b_action", "xts.run", 2);
        href.addParam("m", "portal/" + target, 2);
        href.addParam("m_class", objectClass, 2);
        href.addParam("m_name", objectName, 3);
        GenericCMObject container = context.getRequest().getContainer();
        String containerPath = null;
        if (container != null) {
            containerPath = NavHelper.getPath(container);
        }
        if (containerPath != null && containerPath.length() > 0 && !containerPath.equals("rootDefault")) {
            href.addParam("m_path", containerPath, 4);
        } else if (object.hasChildObject("parent")) {
            GenericCMObject parent = object.getChildObject("parent");
            href.addParam("m_path", NavHelper.getPath(parent), 4);
        } else {
            href.addParam("m_path", "~/folder", 2);
        }
        href.addParam("m_obj", searchPath, 4);
        return href;
    }

    public static void addURLParams(UrlBuilder url, GenericCMObject object) {
        Map urlParmsMap = object.getMapParameter("map_urlParms");
        if (urlParmsMap != null) {
            int mapsize = urlParmsMap.size();
            Iterator keyValuePairs = urlParmsMap.entrySet().iterator();
            for (int i = 0; i < mapsize; ++i) {
                Map.Entry entry = keyValuePairs.next();
                url.addParam("p_" + entry.getKey().toString(), entry.getValue().toString(), 1);
            }
        }
    }

    public static UrlBuilder getDownloadUrl(String action, String gateway, GenericCMObject object, String documentName, RequestContext context, String navAction) {
        UrlBuilder buffer = new UrlBuilder(context);
        String searchPath = NavHelper.getPath(object);
        buffer.setGateway(context.getGatewayURL());
        buffer.addParam("b_action", "xts.run", 2);
        buffer.addParam("m", "portal/download.xts", 2);
        String className = object.getParameter("objectClass", "");
        if ("document".equals(className)) {
            searchPath = searchPath + "/documentVersion[last()]/documentContent[last()]";
        }
        buffer.addParam("m_download_obj", searchPath, 4);
        String outputFormat = NavHelper.getOutputFormat(object, context);
        if (outputFormat != null && NavSystem.getInstance().isOutputFormatSupported(outputFormat)) {
            buffer.addParam("format", outputFormat, 4);
        } else if (outputFormat != null) {
            buffer.addParam("format", "", 2);
        }
        String name = documentName != null ? documentName : object.getParameter("defaultName", "");
        buffer.addParam("m_name", name, 3);
        UrlHelper.appendBackUrlForLaunch(context, buffer, navAction, true, null, false);
        return buffer;
    }

    public static String adjustOutputFormat(String outputFormat, RequestContext context) {
        String preferredFormat = context.getHeader().getFormat();
        if (outputFormat.equals("PDF") && !context.hasCapability("canGeneratePDFOutput") || outputFormat.equals("XML") && !context.hasCapability("canGenerateXMLOutput") || outputFormat.equals("CSV") && !context.hasCapability("canGenerateCSVOutput") || (outputFormat.equals("XLS") || outputFormat.equals("singleXLS") || outputFormat.equals("XLWA") || outputFormat.equals("xlsxData") || outputFormat.equals("spreadsheetMLOfficeConnectionEnabled") || outputFormat.equals("spreadsheetML")) && !context.hasCapability("canGenerateXLSOutput")) {
            if (preferredFormat.equals("PDF") && !context.hasCapability("canGeneratePDFOutput") || preferredFormat.equals("XML") && !context.hasCapability("canGenerateXMLOutput") || preferredFormat.equals("CSV") && !context.hasCapability("canGenerateCSVOutput") || (preferredFormat.equals("XLS") || preferredFormat.equals("singleXLS") || preferredFormat.equals("XLWA") || preferredFormat.equals("xlsxData") || preferredFormat.equals("spreadsheetMLOfficeConnectionEnabled") || preferredFormat.equals("spreadsheetML")) && !context.hasCapability("canGenerateXLSOutput")) {
                return "HTML";
            }
            return preferredFormat;
        }
        return outputFormat;
    }
}

