/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.op;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.bus.NavBusCMRequestResponse;
import com.cognos.cps.bseries.xts.request.nav.bus.NavBusRequest;
import com.cognos.cps.bseries.xts.request.nav.bus.utils.ResponseUtils;
import com.cognos.cps.bseries.xts.request.nav.stax.CMResponse;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class CCPSOperation {
    protected static final GenericCMObject DUMMY_CONTAINER = new GenericCMObject("cm:folder");
    protected ServiceLogger logger;

    public abstract String preTransform(RequestContext var1) throws NavException;

    public abstract void postTransform(CMResponse var1, XMLStreamWriter var2, RequestContext var3) throws NavException;

    public abstract boolean isCMOperation(RequestContext var1);

    protected String getNavValidateTag(String validateTag, RequestContext context) {
        return context.getHeader().getPassportID() + validateTag;
    }

    public Reader execute(RequestContext context, XMLStreamWriter writer) throws XTSInstructionException {
        if (this.isCMOperation(context)) {
            Reader busHeaderReader = null;
            CMResponse cmResponse = null;
            if (!context.isCMResponseData()) {
                String preTransformString;
                try {
                    Object preTransformTimer = null;
                    if (this.logger.isPerfLevelEnabled(4)) {
                        preTransformTimer = this.logger.startTimer(4, "execute", "pre-transform", null);
                    }
                    preTransformString = this.preTransform(context);
                    if (preTransformTimer != null) {
                        this.logger.stopTimer(preTransformTimer);
                    }
                }
                catch (NavException e) {
                    Object[] args = new String[]{context.getRequest().getOpName()};
                    throw new XTSInstructionException("IDS_ERR_OPERATION_FAILED", args, (Throwable)((Object)e));
                }
                NavBusCMRequestResponse result = ((NavBusRequest)context.getProperty("navBusRequest")).sendCMRequest(preTransformString, context);
                cmResponse = result.getCMResponse();
                busHeaderReader = result.getBusHeaderReader();
            } else {
                try {
                    Object parseTimer = null;
                    if (this.logger.isPerfLevelEnabled(4)) {
                        parseTimer = this.logger.startTimer(4, "execute", "parseCMResponse", null);
                    }
                    cmResponse = ResponseUtils.parseCMResponse(XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(context.getCMResponseData())));
                    if (parseTimer != null) {
                        this.logger.stopTimer(parseTimer);
                    }
                }
                catch (XMLStreamException e) {
                    Object[] args = new String[]{context.getRequest().getOpName()};
                    throw new XTSInstructionException("IDS_ERR_OPERATION_FAILED", args, (Throwable)e);
                }
            }
            try {
                Object postTransformTimer = null;
                if (this.logger.isPerfLevelEnabled(4)) {
                    postTransformTimer = this.logger.startTimer(4, "execute", "post-transform", null);
                }
                this.postTransform(cmResponse, writer, context);
                if (postTransformTimer != null) {
                    this.logger.stopTimer(postTransformTimer);
                }
            }
            catch (NavException e) {
                Object[] args = new String[]{context.getRequest().getOpName()};
                throw new XTSInstructionException("IDS_ERR_OPERATION_FAILED", args, (Throwable)((Object)e));
            }
            return busHeaderReader;
        }
        try {
            Object postTransformTimer = null;
            if (this.logger.isPerfLevelEnabled(4)) {
                postTransformTimer = this.logger.startTimer(4, "execute", "post-transform", null);
            }
            this.postTransform(new CMResponse(), writer, context);
            if (postTransformTimer != null) {
                this.logger.stopTimer(postTransformTimer);
            }
        }
        catch (NavException e) {
            Object[] args = new String[]{context.getRequest().getOpName()};
            throw new XTSInstructionException("IDS_ERR_OPERATION_FAILED", args, (Throwable)((Object)e));
        }
        return null;
    }
}

