/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.op;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.HandlerManager;
import com.cognos.cps.bseries.xts.request.nav.element.core.BaseHandler;
import com.cognos.cps.bseries.xts.request.nav.element.core.impl.ContainerHandler;
import com.cognos.cps.bseries.xts.request.nav.helpers.CMRequestHelper;
import com.cognos.cps.bseries.xts.request.nav.helpers.UrlHelper;
import com.cognos.cps.bseries.xts.request.nav.op.CCPSOperation;
import com.cognos.cps.bseries.xts.request.nav.stax.CMResponse;
import com.cognos.cps.bseries.xts.request.nav.stax.NavRequest;
import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import com.cognos.portal.common.logging.ServiceLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class OpQuery
extends CCPSOperation {
    static DateTimeFormat informat = new DateTimeFormat("yyyy-MM-dd'T'HH:mm:ss");

    public OpQuery(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(OpQuery.class) : null;
    }

    @Override
    public String preTransform(RequestContext context) throws NavException {
        return CMRequestHelper.getQueryRequest(context);
    }

    @Override
    public void postTransform(CMResponse cmResponse, XMLStreamWriter writer, RequestContext context) throws NavException {
        NavRequest request = context.getRequest();
        try {
            String cacheValidator;
            String opName = request.getOpName();
            writer.writeStartElement("nav", opName + "Response", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeNamespace("nav", "http://developer.cognos.com/schemas/cps/navigation/1/");
            if (cmResponse.getItemCount() > 0) {
                boolean isRoot = "rootDefault".equals(request.getId());
                String portalAgent = request.getParam("portalAgent");
                if (!"cognos".equals(portalAgent) && !"cognosFragmentServer".equals(portalAgent)) {
                    writer.writeStartElement("nav", "redirectURL", "http://developer.cognos.com/schemas/cps/navigation/1/");
                    writer.writeCharacters(UrlHelper.getRedirectURL(context));
                    writer.writeEndElement();
                }
                if (opName.equals("getContainer")) {
                    if (isRoot) {
                        GenericCMObject cmObjectRoot = new GenericCMObject("cm:folder");
                        cmObjectRoot.setParameter("searchPath", "rootDefault");
                        cmObjectRoot.setParameter("storeID", "rootDefault");
                        cmObjectRoot.setParameter("objectClass", "folder");
                        cmObjectRoot.setParameter("defaultName", NavSystem.getInstance().getRootDefaultLabel(context.getHeader()));
                        cmObjectRoot.setParameter("hasChildren", "true");
                        List query1 = cmResponse.getObjectsFromQuery(context.getRequestCountBase());
                        GenericCMObject personalFolder = null;
                        if (query1.size() > 0) {
                            personalFolder = (GenericCMObject)query1.get(0);
                        }
                        ArrayList query2 = cmResponse.getObjectsFromQuery(context.getRequestCountBase() + 1);
                        if (personalFolder != null) {
                            cmObjectRoot.setParameter("creationTime", personalFolder.getParameter("creationTime", ""));
                            cmObjectRoot.setParameter("modificationTime", personalFolder.getParameter("modificationTime", ""));
                        } else {
                            GenericCMObject publicFolder = null;
                            if (query2.size() > 0) {
                                publicFolder = (GenericCMObject)query2.get(0);
                                cmObjectRoot.setParameter("creationTime", publicFolder.getParameter("creationTime", ""));
                                cmObjectRoot.setParameter("modificationTime", publicFolder.getParameter("modificationTime", ""));
                            }
                        }
                        ArrayList objects = null;
                        String childObjects = request.getChildObjects();
                        if (childObjects != null && !"all".equals(childObjects) && !"containers".equals(childObjects)) {
                            objects = new ArrayList();
                        } else {
                            int skip;
                            objects = query2;
                            objects.addAll(cmResponse.getObjectsFromQuery(context.getRequestCountBase() + 2));
                            LinkedHashMap sortSpecs = request.getSortSpecs();
                            if (sortSpecs != null && sortSpecs.size() > 0) {
                                Map.Entry pair2 = null;
                                for (Map.Entry pair2 : sortSpecs.entrySet()) {
                                    String sortString = (String)pair2.getKey();
                                    String sortOrder = (String)pair2.getValue();
                                    if (sortString == null || sortString.length() <= 0 || sortOrder == null || sortOrder.length() <= 0) continue;
                                    this.sort(objects, sortString, sortOrder);
                                }
                            }
                            if ((skip = request.getSkipObjects()) > 0 && objects.size() > 0) {
                                objects.remove(0);
                                ((GenericCMObject)objects.get(0)).setParameter("position", "1");
                                if (skip > 1) {
                                    objects.remove(0);
                                }
                            }
                        }
                        request.setUserFolder(personalFolder);
                        ContainerHandler rootFolderHandler = (ContainerHandler)HandlerManager.getHandler(DUMMY_CONTAINER);
                        rootFolderHandler.asXML(cmObjectRoot, context, objects, writer);
                    } else {
                        List query2;
                        GenericCMObject personalFolder = null;
                        List query1 = cmResponse.getObjectsFromQuery(context.getRequestCountBase());
                        if (query1.size() > 0) {
                            personalFolder = (GenericCMObject)query1.get(0);
                        }
                        if ((query2 = cmResponse.getObjectsFromQuery(context.getRequestCountBase() + 1)).size() > 0) {
                            GenericCMObject containerItem = (GenericCMObject)query2.get(0);
                            List objects = cmResponse.getObjectsFromQuery(context.getRequestCountBase() + 2);
                            BaseHandler containerHandler = HandlerManager.getHandler(containerItem);
                            if (containerHandler instanceof ContainerHandler) {
                                request.setUserFolder(personalFolder);
                                ((ContainerHandler)containerHandler).asXML(containerItem, context, objects, writer);
                            }
                        } else {
                            String deploymentId = request.getDeploymentId();
                            if (deploymentId != null && deploymentId.length() > 0) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("no results.. retrying with deployment id");
                                }
                                context.setRetryDeploymentId();
                            }
                            writer.writeEmptyElement("nav", "container", "http://developer.cognos.com/schemas/cps/navigation/1/");
                        }
                    }
                } else if (opName.equals("getItem")) {
                    List query2;
                    GenericCMObject personalFolder = null;
                    List query1 = cmResponse.getObjectsFromQuery(context.getRequestCountBase());
                    if (query1.size() > 0) {
                        personalFolder = (GenericCMObject)query1.get(0);
                    }
                    if ((query2 = cmResponse.getObjectsFromQuery(context.getRequestCountBase() + 1)).size() > 0) {
                        GenericCMObject item = (GenericCMObject)query2.get(0);
                        BaseHandler itemHandler = HandlerManager.getHandler(item);
                        request.setUserFolder(personalFolder);
                        itemHandler.asXML(item, context, writer);
                    } else {
                        String deploymentId = request.getDeploymentId();
                        if (deploymentId != null && deploymentId.length() > 0) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("no results.. retrying with deployment id");
                            }
                            context.setRetryDeploymentId();
                        }
                        writer.writeEmptyElement("nav", "item", "http://developer.cognos.com/schemas/cps/navigation/1/");
                    }
                }
            }
            if (!context.isMultipleRequest() && (cacheValidator = cmResponse.getCacheValidator()) != null && cacheValidator.length() > 0) {
                writer.writeStartElement("nav", "validateTag", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeCharacters(this.getNavValidateTag(cacheValidator, context));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new NavException("cps.transform.error", e);
        }
    }

    private void sort(List list, String sortType, final String sortOrder) {
        final String cmSortType = "lastModifiedDate".equals(sortType) ? "modificationTime" : ("type".equals(sortType) ? "objectClass" : "defaultName");
        if (sortOrder != null && sortOrder.length() > 0) {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String value1 = ((GenericCMObject)o1).getParameter(cmSortType, "");
                    String value2 = ((GenericCMObject)o2).getParameter(cmSortType, "");
                    int comparison = 0;
                    if ("modificationTime".equals(cmSortType)) {
                        try {
                            Date date1 = informat.parse(value1).getTime();
                            Date date2 = informat.parse(value2).getTime();
                            comparison = date1.compareTo(date2);
                        }
                        catch (Exception exception) {}
                    } else {
                        comparison = value1.compareTo(value2);
                    }
                    return "descending".equals(sortOrder) ? comparison * -1 : comparison;
                }
            };
            Collections.sort(list, c);
        }
    }

    @Override
    public boolean isCMOperation(RequestContext context) {
        return true;
    }

    static {
        informat.setTimeZone(new TimeZone("GMT"));
    }
}

