/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.op;

import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.helpers.CMRequestHelper;
import com.cognos.cps.bseries.xts.request.nav.op.CCPSOperation;
import com.cognos.cps.bseries.xts.request.nav.stax.CMResponse;
import com.cognos.portal.common.logging.ServiceLogger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class OpRequest
extends CCPSOperation {
    public OpRequest(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(OpRequest.class) : null;
    }

    @Override
    public String preTransform(RequestContext context) throws NavException {
        context.resetRequestCountBase();
        StringBuffer preTransform = new StringBuffer(4096);
        if (context.hasAtLeaseOneCMOperation()) {
            preTransform.append("<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryRequest[]\">");
        }
        context.begin();
        while (context.hasNext()) {
            context.next();
            if (!context.getRequest().isCMOperation(context)) continue;
            preTransform.append(context.getRequest().getOperation().preTransform(context));
        }
        if (context.hasAtLeaseOneCMOperation()) {
            preTransform.append("</requests><options xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryMultipleOptions\"><cacheValidator xsi:type=\"xsd:string\">");
            NavUtils.xmlEncode(CMRequestHelper.getValidateTag(context), preTransform);
            preTransform.append("</cacheValidator></options></cm:query>");
        }
        return preTransform.toString();
    }

    @Override
    public void postTransform(CMResponse cmResponse, XMLStreamWriter writer, RequestContext context) throws NavException {
        try {
            writer.writeStartElement("nav", "requestResponse", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeNamespace("nav", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeStartElement("nav", "queryReplies", "http://developer.cognos.com/schemas/cps/navigation/1/");
            context.begin();
            while (context.hasNext()) {
                context.next();
                writer.writeStartElement("nav", "queryReply", "http://developer.cognos.com/schemas/cps/navigation/1/");
                context.getRequest().getOperation().postTransform(cmResponse, writer, context);
                if (context.getRequest().isCMOperation(context)) {
                    context.addToRequestCountBase(context.getRequest().getCMRequestCount());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            String cacheValidator = cmResponse.getCacheValidator();
            if (cacheValidator != null && cacheValidator.length() > 0) {
                writer.writeStartElement("nav", "validateTag", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeCharacters(this.getNavValidateTag(cacheValidator, context));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new NavException("cps.transform.error", e);
        }
    }

    @Override
    public boolean isCMOperation(RequestContext context) {
        return context.hasAtLeaseOneCMOperation();
    }
}

