/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.op;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.bus.NavBusRequest;
import com.cognos.cps.bseries.xts.request.nav.helpers.CMRequestHelper;
import com.cognos.cps.bseries.xts.request.nav.helpers.ItemType;
import com.cognos.cps.bseries.xts.request.nav.helpers.PagerList;
import com.cognos.cps.bseries.xts.request.nav.helpers.SearchContext;
import com.cognos.cps.bseries.xts.request.nav.helpers.UrlHelper;
import com.cognos.cps.bseries.xts.request.nav.op.CCPSOperation;
import com.cognos.cps.bseries.xts.request.nav.sax.CSResponseHandler;
import com.cognos.cps.bseries.xts.request.nav.stax.CMResponse;
import com.cognos.cps.bseries.xts.request.nav.stax.NavRequest;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class OpSearch
extends CCPSOperation {
    public OpSearch(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(OpSearch.class) : null;
    }

    @Override
    public String preTransform(RequestContext context) throws NavException {
        String searchType = context.getRequest().getSearchType();
        if (searchType != null && "content".equals(searchType) || context.getRequest().getSearchContext() != null) {
            CSResponseHandler handler = this.doBurgundySearch(context);
            context.getRequest().setProp("index_search", handler);
            if (handler.requiresCMRequest()) {
                return CMRequestHelper.getSearchRequest(context, handler.getCmSearchPath());
            }
            return "";
        }
        return CMRequestHelper.getSearchRequest(context, null);
    }

    @Override
    public void postTransform(CMResponse cmResponse, XMLStreamWriter writer, RequestContext context) throws NavException {
        NavRequest request = context.getRequest();
        try {
            String cacheValidator;
            CSResponseHandler burgundyResponse;
            List query1;
            List tmpObj;
            String opName = request.getOpName();
            writer.writeStartElement("nav", opName + "Response", "http://developer.cognos.com/schemas/cps/navigation/1/");
            writer.writeNamespace("nav", "http://developer.cognos.com/schemas/cps/navigation/1/");
            String portalAgent = context.getRequest().getParam("portalAgent");
            if (!"cognos".equals(portalAgent) && !"cognosFragmentServer".equals(portalAgent)) {
                writer.writeStartElement("nav", "redirectURL", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeCharacters(UrlHelper.getRedirectURL(context));
                writer.writeEndElement();
            }
            if (cmResponse != null && request.isProperty("scopeInfo") && (tmpObj = cmResponse.getObjectsFromQuery(context.getRequestCountBase() + 2)).size() > 0) {
                GenericCMObject obj = (GenericCMObject)tmpObj.get(0);
                writer.writeStartElement("nav", "scopeInfo", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeStartElement("nav", "type", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeCharacters(obj.getParameter("objectClass", ""));
                writer.writeEndElement();
                writer.writeEndElement();
            }
            GenericCMObject personalFolder = null;
            if (cmResponse != null && (query1 = cmResponse.getObjectsFromQuery(context.getRequestCountBase())).size() > 0) {
                personalFolder = (GenericCMObject)query1.get(0);
            }
            request.setUserFolder(personalFolder);
            ArrayList objects = null;
            if (cmResponse != null) {
                objects = cmResponse.getObjectsFromQuery(context.getRequestCountBase() + 1);
            }
            if ((burgundyResponse = (CSResponseHandler)request.getProp("index_search")) != null && (!burgundyResponse.requiresCMRequest() || cmResponse != null && cmResponse.getItemCount() > 0)) {
                String itemsRemaining;
                if (objects == null || objects == Collections.EMPTY_LIST) {
                    objects = new ArrayList();
                }
                burgundyResponse.mergeObjects(objects, context);
                SearchContext searchContext = context.getRequest().getSearchContext();
                if (searchContext == null) {
                    searchContext = new SearchContext();
                    searchContext.max = context.getRequest().getMaxObjects();
                    searchContext.searchString = context.getRequest().getSearchString();
                    searchContext.itemType = context.getRequest().getItemTypes();
                }
                searchContext.displayItemFirst = burgundyResponse.getDisplayItemFirst();
                searchContext.displayItemLast = burgundyResponse.getDisplayItemLast();
                searchContext.indexItemFirst = burgundyResponse.getIndexItemFirst();
                searchContext.indexItemLast = burgundyResponse.getIndexItemLast();
                searchContext.pageSize = burgundyResponse.getPageSize();
                searchContext.itemRemaining = itemsRemaining = burgundyResponse.getItemsRemaining();
                writer.writeStartElement("nav", "context", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeCharacters(searchContext.encode());
                writer.writeEndElement();
                if (burgundyResponse.getLaunchNow()) {
                    writer.writeEmptyElement("nav", "open", "http://developer.cognos.com/schemas/cps/navigation/1/");
                }
                PagerList pagerList = new PagerList(objects, searchContext.max, searchContext.displayItemFirst, "true".equals(itemsRemaining));
                pagerList.setEstimatedTotal(burgundyResponse.getEstimatedTotal());
                pagerList.asXML(context, writer);
            } else {
                PagerList pagerList = new PagerList(objects, context.getRequest().getMaxObjects());
                pagerList.asXML(context, writer);
            }
            if (burgundyResponse != null) {
                List extensionsList = burgundyResponse.getExtensionsList();
                for (int i = 0; i < extensionsList.size(); ++i) {
                    String extension = (String)extensionsList.get(i);
                    if (extension == null || extension.length() <= 0) continue;
                    writer.writeStartElement("nav", "extensions", "http://developer.cognos.com/schemas/cps/navigation/1/");
                    XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(extension));
                    StaxUtils.copyChildren((XMLStreamReader)xsr, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
            }
            if (cmResponse != null && !context.isMultipleRequest() && (cacheValidator = cmResponse.getCacheValidator()) != null && cacheValidator.length() > 0) {
                writer.writeStartElement("nav", "validateTag", "http://developer.cognos.com/schemas/cps/navigation/1/");
                writer.writeCharacters(this.getNavValidateTag(cacheValidator, context));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new NavException("cps.transform.error", e);
        }
    }

    @Override
    public boolean isCMOperation(RequestContext context) {
        return true;
    }

    private CSResponseHandler doBurgundySearch(RequestContext context) throws NavException {
        SearchContext searchContext = context.getRequest().getSearchContext();
        String action = null;
        if (searchContext != null) {
            int currentSkip;
            int oldSkip = searchContext.displayItemFirst;
            int n = currentSkip = context.getRequest().isSkipObjects() ? context.getRequest().getSkipObjects() : oldSkip;
            action = currentSkip <= 0 ? "first" : (currentSkip > oldSkip && "true".equals(searchContext.itemRemaining) ? "forward" : (currentSkip < oldSkip ? "back" : "refresh"));
        }
        String requestString = this.getASyncRunSpecificationCommand(context, action);
        CSResponseHandler handler = null;
        try {
            handler = ((NavBusRequest)context.getProperty("navBusRequest")).sendBurgundyRequest(requestString, context);
        }
        catch (XTSInstructionException e) {
            throw new NavException("IDS_ERR_OPERATION_FAILED", e);
        }
        return handler;
    }

    private String getASyncRunSpecificationCommand(RequestContext context, String action) {
        StringBuffer buffer = new StringBuffer(2048);
        buffer.append("<ns:runSpecification xmlns:ns=\"http://developer.cognos.com/schemas/indexSearchService/1/\" xmlns:bibus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        buffer.append("<specification xsi:type=\"bibus:indexSearchServiceSpecification\">");
        buffer.append("<value xsi:type=\"bibus:specification\">");
        String request = this.getIndexSearchRequest(context, action);
        NavUtils.xmlEncode(request, buffer);
        buffer.append("</value>");
        buffer.append("</specification>");
        buffer.append("<options xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bibus:option[3]\">");
        buffer.append("<item xsi:type=\"bibus:asynchOptionInt\">");
        buffer.append("<name xsi:type=\"bibus:asynchOptionEnum\">primaryWaitThreshold</name>");
        buffer.append("<value xsi:type=\"xsd:int\">10000</value>");
        buffer.append("</item>");
        buffer.append("<item xsi:type=\"bibus:asynchOptionInt\">");
        buffer.append("<name xsi:type=\"bibus:asynchOptionEnum\">secondaryWaitThreshold</name>");
        buffer.append("<value xsi:type=\"xsd:int\">10000</value></item>");
        buffer.append("</options>");
        buffer.append("</ns:runSpecification>");
        return buffer.toString();
    }

    private String getIndexSearchRequest(RequestContext context, String action) {
        Object types;
        NavRequest request = context.getRequest();
        StringBuffer buffer = new StringBuffer(768);
        SearchContext searchContext = request.getSearchContext();
        boolean isOpen = "true".equals(request.getParam("open"));
        buffer.append("<cs:document xmlns:cs=\"http://developer.cognos.com/schemas/cs/\"><cs:request>");
        if (isOpen) {
            buffer.append("<cs:open>");
            String openId = request.getParam("openId");
            if (openId != null && openId.length() > 0) {
                buffer.append("<cs:storeID>").append(openId).append("</cs:storeID>");
            }
        } else {
            buffer.append("<cs:searchQuery>");
        }
        String sourceContext = null;
        String searchTerm = null;
        if (searchContext != null) {
            sourceContext = searchContext.sourceContext;
            searchTerm = searchContext.searchString;
        } else {
            sourceContext = request.getSourceContext();
            searchTerm = request.getSearchString();
        }
        if (sourceContext == null || sourceContext.length() == 0) {
            buffer.append("<cs:terms>");
            if (searchTerm != null) {
                NavUtils.xmlEncode(searchTerm, buffer);
            }
            buffer.append("</cs:terms>");
        }
        buffer.append("<cs:requestParameters><cs:searchType>normal</cs:searchType>");
        String userAllFilters = request.getParam("useAllFilters");
        if (userAllFilters != null && userAllFilters.length() > 0) {
            buffer.append("<cs:needAllfilters>");
            buffer.append(userAllFilters);
            buffer.append("</cs:needAllfilters>");
        }
        if (action != null) {
            buffer.append("<cs:searchDirection>");
            buffer.append("first".equals(action) ? "forward" : action);
            buffer.append("</cs:searchDirection>");
        }
        buffer.append("<cs:pageSize>");
        if (searchContext != null) {
            buffer.append(searchContext.max);
        } else {
            buffer.append(request.getMaxObjects());
        }
        buffer.append("</cs:pageSize><cs:includeSearchQuery>false</cs:includeSearchQuery><cs:includeSearchConversation>true</cs:includeSearchConversation><cs:includeSecurityContext>false</cs:includeSecurityContext>");
        String itemTypes = null;
        itemTypes = searchContext != null ? searchContext.itemType : request.getItemTypes();
        buffer.append("<cs:typeList>");
        if (itemTypes != null && itemTypes.length() > 0 && !itemTypes.equals("any")) {
            types = new StringTokenizer(itemTypes, "~");
            while (((StringTokenizer)types).hasMoreTokens()) {
                String itemType = ((StringTokenizer)types).nextToken();
                if (itemType == null || itemType.length() <= 0) continue;
                buffer.append("<cs:type>");
                NavUtils.xmlEncode(itemType, buffer);
                buffer.append("</cs:type>");
            }
        } else {
            types = ItemType.getItemTypes("content");
            Iterator it = types.iterator();
            while (it.hasNext()) {
                String itemType = ((ItemType)it.next()).getId();
                if (itemType == null || itemType.length() <= 0) continue;
                buffer.append("<cs:type>");
                NavUtils.xmlEncode(itemType, buffer);
                buffer.append("</cs:type>");
            }
        }
        buffer.append("</cs:typeList>");
        String urlParameters = request.getParam("urlParameters");
        if (urlParameters != null && urlParameters.length() > 0) {
            buffer.append("<cs:urlParameters>");
            StringTokenizer st = new StringTokenizer(urlParameters, "&");
            while (st.hasMoreTokens()) {
                int pos;
                String token = st.nextToken();
                if (token.length() <= 0 || (pos = token.indexOf(61)) <= 0) continue;
                buffer.append("<cs:urlParameter name='").append(token.substring(0, pos)).append("'>");
                NavUtils.xmlEncode(NavUtils.urlDecode(token.substring(pos + 1)), buffer);
                buffer.append("</cs:urlParameter>");
            }
            buffer.append("</cs:urlParameters>");
        }
        buffer.append("</cs:requestParameters>");
        if (isOpen) {
            buffer.append("</cs:open>");
        } else {
            buffer.append("</cs:searchQuery>");
        }
        if (sourceContext != null && sourceContext.length() > 0) {
            buffer.append("<cs:sourceContext>");
            NavUtils.xmlEncode(sourceContext, buffer);
            buffer.append("</cs:sourceContext>");
        }
        if (searchContext != null && action != null && !"first".equals(action)) {
            buffer.append("<cs:searchConversation><cs:position pageSize=\"");
            buffer.append(searchContext.pageSize);
            buffer.append("\" displayItemFirst=\"");
            buffer.append(searchContext.displayItemFirst);
            buffer.append("\" displayItemLast=\"");
            buffer.append(searchContext.displayItemLast);
            buffer.append("\" indexItemFirst=\"");
            buffer.append(searchContext.indexItemFirst);
            buffer.append("\" indexItemLast=\"");
            buffer.append(searchContext.indexItemLast);
            buffer.append("\"/></cs:searchConversation>");
        }
        buffer.append("</cs:request></cs:document>");
        return buffer.toString();
    }
}

