/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.resource;

import com.cognos.xts.util.XTSObjectCache;
import java.io.InputStream;
import java.util.Locale;

public abstract class CPSResourceCache {
    private XTSObjectCache m_oObjCache = new XTSObjectCache();
    private Object m_oMutexObj = new Object();
    private String m_resourceBase = "com/cognos/cps/bseries/xts/request/nav/stylesheets/";

    protected CPSResourceCache() {
    }

    protected CPSResourceCache(String resourceBase) {
        this.m_resourceBase = resourceBase;
    }

    protected abstract Object createObject(InputStream var1, Locale var2) throws Exception;

    protected abstract Object processObject(Object var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(String resourceBaseName, Locale locale) throws Throwable {
        Object resourceObj;
        block10: {
            String resourceFullName = this.m_resourceBase + resourceBaseName;
            String workingResourceFullName = CPSResourceCache.buildLocalizedResourceName(resourceFullName, locale);
            resourceObj = null;
            try {
                resourceObj = this.m_oObjCache.getObject(workingResourceFullName);
                if (resourceObj != null) break block10;
                Object object = this.m_oMutexObj;
                synchronized (object) {
                    resourceObj = this.m_oObjCache.getObject(workingResourceFullName);
                    if (resourceObj == null) {
                        InputStream resourceIn = this.getClass().getClassLoader().getResourceAsStream(workingResourceFullName);
                        if (resourceIn == null) {
                            workingResourceFullName = CPSResourceCache.buildLocalizedResourceName(resourceFullName, locale.getLanguage());
                            resourceIn = this.getClass().getClassLoader().getResourceAsStream(workingResourceFullName);
                            if (resourceIn == null) {
                                workingResourceFullName = resourceFullName;
                                resourceIn = this.getClass().getClassLoader().getResourceAsStream(workingResourceFullName);
                            }
                        }
                        if (resourceIn == null) {
                            throw new NullPointerException("Failed to load resource '" + resourceFullName + "'.");
                        }
                        resourceObj = this.createObject(resourceIn, locale);
                        if (resourceObj == null) {
                            throw new NullPointerException("Failed to create object for resource '" + resourceFullName + "'.");
                        }
                        this.m_oObjCache.addObject(CPSResourceCache.buildLocalizedResourceName(resourceFullName, locale), resourceObj);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
                throw e;
            }
        }
        return this.processObject(resourceObj);
    }

    private static String buildLocalizedResourceName(String fileName, Locale locale) {
        String extension = "";
        int lastdotpos = fileName.lastIndexOf(46);
        if (lastdotpos != -1) {
            extension = fileName.substring(lastdotpos);
            fileName = fileName.substring(0, lastdotpos);
        }
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (country.length() == 0) {
            return fileName + "_" + lang + extension;
        }
        return fileName + "_" + lang + "-" + country.toLowerCase() + extension;
    }

    private static String buildLocalizedResourceName(String fileName, String language) {
        String extension = "";
        int lastdotpos = fileName.lastIndexOf(46);
        if (lastdotpos != -1) {
            extension = fileName.substring(lastdotpos);
            fileName = fileName.substring(0, lastdotpos);
        }
        return fileName + "_" + language + extension;
    }
}

