/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.sax;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.helpers.Action;
import com.cognos.cps.bseries.xts.request.nav.sax.ResponseHandler;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.common.sax.BufferXMLContentHandler;
import com.cognos.cps.common.sax.ElementHandler;
import com.cognos.cps.common.utils.SmallMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CSResponseHandler
extends ResponseHandler {
    private static final int DOCUMENT = 1;
    private static final int RESULT = 2;
    private static final int SEARCH_RESULTS = 4;
    private static final int RESULTPARAMETERS = 8;
    private static final int ITEMS_REMAINING = 16;
    private static final int ITEMS = 32;
    private static final int ITEM = 64;
    private static final int SEARCH_CONVERSATION = 128;
    private static final int POSITION = 256;
    private static final int LAUNCH_NOW = 512;
    private static final int EXTENSIONS = 1024;
    private static final int ESTIMATED_TOTAL = 2048;
    private static Map elements = new HashMap();
    private CSObjectHandler csObjectHandler;
    private MatchDescription matchDescription;
    private Parameters parameters;
    private Extensions extensions;
    private ActionHandler action;
    private List itemPropList;
    private ItemProps currentObject;
    private int displayItemFirst;
    private int displayItemLast;
    private int indexItemFirst;
    private int indexItemLast;
    private int pageSize;
    private String itemsRemaining;
    private int estimatedTotal;
    private String launchNow;
    private List extensionsList;
    private Map m_glblPrefixNSMappingMap = new HashMap();
    private String cmExpression;

    public CSResponseHandler(XMLReader reader) {
        super(reader);
        this.itemPropList = new ArrayList();
        this.extensionsList = new ArrayList();
        this.csObjectHandler = new CSObjectHandler((DefaultHandler)this);
        this.extensions = new Extensions((DefaultHandler)this);
        this.matchDescription = new MatchDescription((DefaultHandler)this.csObjectHandler);
        this.parameters = new Parameters((DefaultHandler)this.csObjectHandler);
        this.action = new ActionHandler((DefaultHandler)this.csObjectHandler);
    }

    public int getDisplayItemFirst() {
        return this.displayItemFirst;
    }

    public int getDisplayItemLast() {
        return this.displayItemLast;
    }

    public int getIndexItemFirst() {
        return this.indexItemFirst;
    }

    public int getIndexItemLast() {
        return this.indexItemLast;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getItemsRemaining() {
        return this.itemsRemaining;
    }

    public int getEstimatedTotal() {
        return this.estimatedTotal;
    }

    public boolean getLaunchNow() {
        return "true".equals(this.launchNow);
    }

    public List getExtensionsList() {
        return this.extensionsList;
    }

    public String getCmSearchPath() {
        if (this.cmExpression != null) {
            return this.cmExpression;
        }
        StringBuffer expression = new StringBuffer();
        for (ItemProps props : this.itemPropList) {
            if (props.itemType != null && !"CM".equals(props.itemType)) continue;
            if (expression.length() > 0) {
                expression.append('|');
            }
            expression.append("storeID(\"").append(props.id).append("\")");
        }
        this.cmExpression = expression.toString();
        return this.cmExpression;
    }

    public boolean requiresCMRequest() {
        return this.getCmSearchPath().length() > 0;
    }

    public void mergeObjects(List objects, RequestContext context) {
        for (int i = 0; i < this.itemPropList.size(); ++i) {
            ItemProps props = (ItemProps)this.itemPropList.get(i);
            GenericCMObject obj = null;
            if (props.itemType == null || "CM".equals(props.itemType)) {
                for (int j = i; j < objects.size(); ++j) {
                    GenericCMObject tmp = (GenericCMObject)objects.get(j);
                    String id = tmp.getParameter("storeID", null);
                    if (!id.equals(props.id)) continue;
                    if ("false".equals(tmp.getParameter("shown", null))) {
                        objects.remove(j);
                    } else if (i != j) {
                        obj = (GenericCMObject)objects.remove(j);
                        objects.add(i, obj);
                    } else {
                        obj = tmp;
                    }
                    break;
                }
            } else {
                obj = new GenericCMObject("non_cm_obj");
                objects.add(i, obj);
                obj.setParameter("storeID", props.id);
                obj.setParameter("defaultName", props.name);
                obj.setParameter("defaultDescription", props.description);
                obj.setParameter("icon_url", props.icon);
                obj.setAny("default_action", props.defaultAction);
                obj.setParameter("full_name", props.path);
                obj.setParameter("defaultScreenTip", props.tooltip);
                if (props.actions != null) {
                    obj.setAny("action_list", props.actions);
                }
                obj.setArrayParameter("permissions", "read");
            }
            if (obj != null) {
                obj.setParameter("score", props.score);
                obj.setParameter("match_desc", props.matchingString.toString());
                obj.setParameter("score_icon", props.scoreIcon);
                if (props.parametersMap.size() <= 0) continue;
                obj.setMapParameter("map_urlParms", (Map)props.parametersMap);
                continue;
            }
            GenericCMObject tmp = new GenericCMObject("cm:nil");
            tmp.setParameter("defaultName", MessagesManager.getInstance().getMessage(context.getHeader().getProductLocale(), "IDS_UNAVAILABLE"));
            objects.add(i, tmp);
        }
    }

    @Override
    protected void startElementImpl(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.currentElement == 103) {
            this.currentObject = new ItemProps();
            this.csObjectHandler.startElement(uri, localName, qName, attributes);
        } else if (this.currentElement == 31) {
            this.startCollectData();
        } else if (this.currentElement == 527) {
            this.startCollectData();
        } else if (this.currentElement == 2063) {
            this.startCollectData();
        } else if (this.currentElement == 387) {
            try {
                this.pageSize = Integer.parseInt(attributes.getValue("pagesize"));
            }
            catch (Exception e) {
                this.pageSize = 0;
            }
            try {
                this.displayItemFirst = Integer.parseInt(attributes.getValue("displayItemFirst"));
            }
            catch (Exception e) {
                this.displayItemFirst = 0;
            }
            try {
                this.displayItemLast = Integer.parseInt(attributes.getValue("displayItemLast"));
            }
            catch (Exception e) {
                this.displayItemLast = 0;
            }
            try {
                this.indexItemFirst = Integer.parseInt(attributes.getValue("indexItemFirst"));
            }
            catch (Exception e) {
                this.indexItemFirst = 0;
            }
            try {
                this.indexItemLast = Integer.parseInt(attributes.getValue("indexItemLast"));
            }
            catch (Exception e) {
                this.indexItemLast = 0;
            }
        } else if (this.currentElement == 1027) {
            this.extensions.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    protected void endElementImpl(String uri, String localName, String name) {
        if (this.currentElement == 31) {
            this.stopCollectData();
            this.itemsRemaining = this.getData();
        } else if (this.currentElement == 527) {
            this.stopCollectData();
            this.launchNow = this.getData();
        } else if (this.currentElement == 2063) {
            this.stopCollectData();
            try {
                this.estimatedTotal = Integer.parseInt(this.getData());
            }
            catch (Exception e) {
                this.estimatedTotal = 0;
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_glblPrefixNSMappingMap.put(prefix, uri);
    }

    @Override
    protected int getCurrentElementFlag(String name) {
        if (elements.containsKey(name)) {
            ResponseHandler.Element e = (ResponseHandler.Element)elements.get(name);
            if ((e.level & this.currentLevel) == this.currentLevel) {
                return e.id;
            }
        }
        return 0;
    }

    static {
        elements.put("document", new ResponseHandler.Element(1, 1));
        elements.put("result", new ResponseHandler.Element(2, 2));
        elements.put("searchResults", new ResponseHandler.Element(4, 4));
        elements.put("resultParameters", new ResponseHandler.Element(8, 8));
        elements.put("hasNextPage", new ResponseHandler.Element(16, 16));
        elements.put("launchNow", new ResponseHandler.Element(512, 16));
        elements.put("totalUnsecuredItems", new ResponseHandler.Element(2048, 16));
        elements.put("items", new ResponseHandler.Element(32, 8));
        elements.put("item", new ResponseHandler.Element(64, 16));
        elements.put("searchConversation", new ResponseHandler.Element(128, 4));
        elements.put("position", new ResponseHandler.Element(256, 8));
        elements.put("extensions", new ResponseHandler.Element(1024, 4));
    }

    public class ItemProps {
        public String id;
        public String itemType;
        public String score;
        public String scoreIcon;
        public String icon;
        public String path;
        public String name;
        public String description;
        public String tooltip;
        public StringBuffer matchingString = new StringBuffer();
        public SmallMap parametersMap = new SmallMap();
        public Action defaultAction = new Action();
        public List actions;

        public void addDescription(String s) {
            this.matchingString.append(s);
        }

        public void addDescription(String s, String tag) {
            this.matchingString.append("<" + tag + ">");
            this.matchingString.append(s);
            this.matchingString.append("</" + tag + ">");
        }
    }

    public class CSObjectHandler
    extends ResponseHandler.BaseHandler {
        public CSObjectHandler(DefaultHandler parent) {
            super(CSResponseHandler.this, parent);
        }

        @Override
        public void startElementImpl(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("id".equals(localName) || "name".equals(localName) || "description".equals(localName) || "tooltip".equals(localName) || "icon".equals(localName) || "iconAction".equals(localName) || "path".equals(localName) || "itemType".equals(localName) || "url".equals(localName)) {
                CSResponseHandler.this.startCollectData();
            } else if ("relevance".equals(localName)) {
                int quantize;
                CSResponseHandler.this.startCollectData();
                try {
                    quantize = Integer.parseInt(attributes.getValue("quantize"));
                    if (quantize < 0) {
                        quantize = 0;
                    } else if (quantize > 10) {
                        quantize = 10;
                    }
                }
                catch (Exception e) {
                    quantize = 0;
                }
                ((CSResponseHandler)CSResponseHandler.this).currentObject.scoreIcon = "icon_score_" + String.valueOf(quantize);
            } else if ("matchDescription".equals(localName)) {
                CSResponseHandler.this.matchDescription.startElement(uri, localName, qName, attributes);
            } else if ("parameters".equals(localName)) {
                CSResponseHandler.this.parameters.startElement(uri, localName, qName, attributes);
            } else if ("action".equals(localName)) {
                CSResponseHandler.this.action.startElement(uri, localName, qName, attributes);
            } else if (!"item".equals(localName)) {
                CSResponseHandler.this.notSupportedHandler.setParent(this);
                CSResponseHandler.this.notSupportedHandler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElementImpl(String uri, String localName, String qName) throws SAXException {
            if ("id".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                ((CSResponseHandler)CSResponseHandler.this).currentObject.id = CSResponseHandler.this.getData().trim();
                CSResponseHandler.this.itemPropList.add(CSResponseHandler.this.currentObject);
            } else if ("name".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                ((CSResponseHandler)CSResponseHandler.this).currentObject.name = CSResponseHandler.this.getData().trim();
            } else if ("description".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                ((CSResponseHandler)CSResponseHandler.this).currentObject.description = CSResponseHandler.this.getData().trim();
            } else if ("tooltip".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                ((CSResponseHandler)CSResponseHandler.this).currentObject.tooltip = CSResponseHandler.this.getData().trim();
            } else if ("icon".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                ((CSResponseHandler)CSResponseHandler.this).currentObject.icon = CSResponseHandler.this.getData().trim();
            } else if ("iconAction".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                ((CSResponseHandler)CSResponseHandler.this).currentObject.defaultAction.setIconUrl(CSResponseHandler.this.getData().trim());
            } else if ("path".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                ((CSResponseHandler)CSResponseHandler.this).currentObject.path = CSResponseHandler.this.getData().trim();
            } else if ("itemType".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                ((CSResponseHandler)CSResponseHandler.this).currentObject.itemType = CSResponseHandler.this.getData().trim();
            } else if ("url".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                ((CSResponseHandler)CSResponseHandler.this).currentObject.defaultAction.setActionUrl(CSResponseHandler.this.getData().trim());
            } else if ("relevance".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                ((CSResponseHandler)CSResponseHandler.this).currentObject.score = CSResponseHandler.this.getData().trim();
            }
        }
    }

    public class Extensions
    extends ResponseHandler.BaseHandler {
        private BufferXMLContentHandler bufferXMLHandler;
        private Map m_extPrefixNSMappingMap;

        public Extensions(DefaultHandler parent) {
            super(CSResponseHandler.this, parent);
            this.m_extPrefixNSMappingMap = new HashMap();
        }

        @Override
        public void startElementImpl(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"extensions".equals(localName)) {
                this.bufferXMLHandler = new BufferXMLContentHandler();
                for (Map.Entry prefixUriMapping : this.m_extPrefixNSMappingMap.entrySet()) {
                    if (((String)prefixUriMapping.getKey()).length() <= 0) continue;
                    this.bufferXMLHandler.startPrefixMapping((String)prefixUriMapping.getKey(), (String)prefixUriMapping.getValue());
                }
                this.m_extPrefixNSMappingMap.clear();
                for (Map.Entry prefixUriMapping : CSResponseHandler.this.m_glblPrefixNSMappingMap.entrySet()) {
                    if (((String)prefixUriMapping.getKey()).length() <= 0) continue;
                    this.bufferXMLHandler.startPrefixMapping((String)prefixUriMapping.getKey(), (String)prefixUriMapping.getValue());
                }
                ElementHandler elementHandler = new ElementHandler(CSResponseHandler.this.xmlReader, (ContentHandler)this.bufferXMLHandler);
                elementHandler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElementImpl(String uri, String localName, String qName) throws SAXException {
            if (!"extensions".equals(localName) && this.bufferXMLHandler != null) {
                CSResponseHandler.this.extensionsList.add(this.bufferXMLHandler.getXML());
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.m_extPrefixNSMappingMap.put(prefix, uri);
        }
    }

    public class ActionHandler
    extends ResponseHandler.BaseHandler {
        Action current;

        public ActionHandler(DefaultHandler parent) {
            super(CSResponseHandler.this, parent);
        }

        @Override
        public void startElementImpl(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("action".equals(localName)) {
                this.current = new Action();
            } else {
                CSResponseHandler.this.startCollectData();
            }
        }

        @Override
        public void endElementImpl(String uri, String localName, String qName) throws SAXException {
            if ("action".equals(localName)) {
                if (((CSResponseHandler)CSResponseHandler.this).currentObject.actions == null) {
                    ((CSResponseHandler)CSResponseHandler.this).currentObject.actions = new ArrayList();
                }
                ((CSResponseHandler)CSResponseHandler.this).currentObject.actions.add(this.current);
                CSResponseHandler.this.stopCollectData();
            } else if ("icon".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                this.current.setIconUrl(CSResponseHandler.this.getData());
            } else if ("url".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                this.current.setActionUrl(CSResponseHandler.this.getData());
            } else if ("tooltip".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                this.current.setTooltip(CSResponseHandler.this.getData());
            }
        }
    }

    public class Parameters
    extends ResponseHandler.BaseHandler {
        String parameterName;
        String parameterValue;

        public Parameters(DefaultHandler parent) {
            super(CSResponseHandler.this, parent);
        }

        @Override
        public void startElementImpl(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("parameter".equals(localName)) {
                this.parameterName = "";
                this.parameterValue = "";
            } else if ("name".equals(localName)) {
                CSResponseHandler.this.startCollectData();
            } else if ("value".equals(localName)) {
                CSResponseHandler.this.startCollectData();
            } else if (!"parameters".equals(localName)) {
                CSResponseHandler.this.notSupportedHandler.setParent(this);
                CSResponseHandler.this.notSupportedHandler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElementImpl(String uri, String localName, String qName) throws SAXException {
            if ("name".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                this.parameterName = CSResponseHandler.this.getData();
            } else if ("value".equals(localName)) {
                CSResponseHandler.this.stopCollectData();
                this.parameterValue = CSResponseHandler.this.getData();
            } else if ("parameter".equals(localName) && this.parameterName != null && this.parameterName.length() > 0) {
                ((CSResponseHandler)CSResponseHandler.this).currentObject.parametersMap.put((Object)this.parameterName, (Object)this.parameterValue);
            }
        }
    }

    public class MatchDescription
    extends ResponseHandler.BaseHandler {
        boolean isDetail;

        public MatchDescription(DefaultHandler parent) {
            super(CSResponseHandler.this, parent);
        }

        @Override
        public void startElementImpl(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("detail".equals(localName)) {
                if (((CSResponseHandler)CSResponseHandler.this).currentObject.matchingString.length() > 0) {
                    CSResponseHandler.this.currentObject.addDescription(". ");
                }
                CSResponseHandler.this.startCollectData();
                this.isDetail = true;
            } else if (this.isDetail) {
                CSResponseHandler.this.stopCollectData();
                CSResponseHandler.this.currentObject.addDescription(CSResponseHandler.this.getData());
                CSResponseHandler.this.startCollectData();
            } else if (!"matchDescription".equals(localName)) {
                CSResponseHandler.this.notSupportedHandler.setParent(this);
                CSResponseHandler.this.notSupportedHandler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElementImpl(String uri, String localName, String qName) throws SAXException {
            if ("detail".equals(localName)) {
                this.isDetail = false;
                CSResponseHandler.this.stopCollectData();
                CSResponseHandler.this.currentObject.addDescription(CSResponseHandler.this.getData());
            } else if (this.isDetail) {
                CSResponseHandler.this.stopCollectData();
                CSResponseHandler.this.currentObject.addDescription(CSResponseHandler.this.getData(), localName);
                CSResponseHandler.this.startCollectData();
            }
        }
    }
}

