/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.stax;

import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.cps.common.utils.Strings;
import com.cognos.portal.utils.capability.CapabilityHelpers;
import com.cognos.portal.utils.capability.UserCapabilities;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamReaderRecorder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class BusHeader {
    private static final String EMPTY_STRING = "";
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static List ELEMENTS_TO_PARSE = new ArrayList();
    private String m_webContentRoot;
    private String m_ccSession;
    private String m_passportCookieFromCookieVars;
    private String m_passportCookieFromSetCookieVars;
    private String m_passportID;
    private String m_ticket;
    private String m_navCapabilities;
    private String m_timeZone;
    private String m_productLocaleString;
    private String m_contentLocaleString;
    private Locale m_productLocale;
    private Locale m_contentLocale;
    private String m_format;
    private String m_headerString;
    private String _localName;
    private String _name;
    private UserCapabilities userCapabilities = null;
    private String m_bidiEnabled;
    private String m_textDirection;
    private String m_browser;

    public void parse(XMLStreamReaderRecorder reader) throws XMLStreamException {
        reader.next();
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                this._localName = reader.getLocalName();
                if ("biBusHeader".equals(this._localName)) {
                    this.process(reader);
                    break;
                }
            }
            reader.next();
        }
    }

    private void process(XMLStreamReaderRecorder reader) throws XMLStreamException {
        boolean isCookieVars = false;
        this.userCapabilities = new UserCapabilities();
        reader.next();
        while (reader.hasNext()) {
            block10: {
                block8: {
                    block11: {
                        block9: {
                            if (!reader.isStartElement()) break block8;
                            this._localName = reader.getLocalName();
                            if (this._localName.equals("cookieVars")) {
                                isCookieVars = true;
                            }
                            if (!ELEMENTS_TO_PARSE.contains(this._localName)) break block9;
                            while (NavUtils.moveToElementWithinParent("item", this._localName, (XMLStreamReader)reader)) {
                                this.processElement(reader, isCookieVars);
                            }
                            break block10;
                        }
                        if (!"CAMPassport".equals(this._localName)) break block11;
                        if (NavUtils.moveToElementWithinParent("id", this._localName, (XMLStreamReader)reader)) {
                            this.m_passportID = reader.getElementText().trim();
                        }
                        break block10;
                    }
                    if (!"userCapabilityCache".equals(this._localName)) break block10;
                    this.userCapabilities.processUserCapabilityCache((XMLStreamReader)reader, this.m_passportID);
                    break block10;
                }
                if (reader.isEndElement()) {
                    if ("cookieVars".equals(reader.getLocalName())) {
                        isCookieVars = false;
                    }
                    if ("biBusHeader".equals(reader.getLocalName())) {
                        this.m_headerString = reader.getRecordedString();
                        break;
                    }
                }
            }
            reader.next();
        }
        if (this.userCapabilities.getPassportID() == null || EMPTY_STRING.equals(this.userCapabilities.getPassportID())) {
            this.userCapabilities.setPassport(this.m_passportID);
        }
    }

    private void processElement(XMLStreamReaderRecorder reader, boolean isCookieVars) throws XMLStreamException {
        StaxUtils.moveToElement((String)"name", (XMLStreamReader)reader);
        this._name = reader.getElementText().trim();
        StaxUtils.moveToElement((String)"value", (XMLStreamReader)reader);
        if (this._name.equals("navCapabilities")) {
            this.m_navCapabilities = reader.getElementText().trim();
        } else if (this._name.equals("timeZoneID")) {
            this.m_timeZone = reader.getElementText().trim();
        } else if (this._name.equals("productLocale")) {
            this.m_productLocaleString = reader.getElementText().trim();
        } else if (this._name.equals("contentLocale")) {
            this.m_contentLocaleString = reader.getElementText().trim();
        } else if (this._name.equals("format")) {
            this.m_format = reader.getElementText().trim();
        } else if (this._name.equals("AS_TICKET")) {
            this.m_ticket = reader.getElementText().trim();
        } else if (this._name.equals("cc_session")) {
            this.m_ccSession = reader.getElementText().trim();
        } else if (this._name.equals("WEB_CONTENT_ROOT")) {
            this.m_webContentRoot = reader.getElementText().trim();
        } else if (this._name.equals("cam_passport")) {
            if (isCookieVars) {
                this.m_passportCookieFromCookieVars = reader.getElementText().trim();
            } else {
                this.m_passportCookieFromSetCookieVars = reader.getElementText().trim();
            }
        } else if (this._name.equals("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled")) {
            this.m_bidiEnabled = reader.getElementText().trim();
        } else if (this._name.equals("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#baseTextDirection")) {
            this.m_textDirection = reader.getElementText().trim();
            if (this.m_textDirection != null && this.m_textDirection.lastIndexOf("#") != -1) {
                this.m_textDirection = this.m_textDirection.substring(this.m_textDirection.lastIndexOf("#") + 1).toLowerCase();
            }
        } else if (this._name.equals("HTTP_USER_AGENT")) {
            this.m_browser = CapabilityHelpers.detectBrowser((String)reader.getElementText().trim());
        }
    }

    private String getUIProfilesFromCCSession() {
        String uiProfile = null;
        String[] params = Strings.split((String)this.m_ccSession, (char)'|');
        if (params != null) {
            boolean isAll = false;
            boolean isPro = false;
            boolean isBua = false;
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                if (param.equals("rsuiprofile:all")) {
                    isAll = true;
                    continue;
                }
                if (param.equals("rsuiprofile:pro")) {
                    isPro = true;
                    break;
                }
                if (!param.equals("rsuiprofile:bua")) continue;
                isBua = true;
            }
            if (isAll) {
                uiProfile = "canUseRSPro|canUseRSAll|";
            } else if (isPro) {
                uiProfile = "canUseRSPro|";
            } else if (isBua) {
                uiProfile = "canUseRSBUA|";
            }
        }
        if (uiProfile == null) {
            uiProfile = EMPTY_STRING;
        }
        return uiProfile;
    }

    public String getCapability() {
        String[] params;
        String cap = EMPTY_STRING;
        if (this.m_ccSession != null && (params = Strings.split((String)this.m_ccSession, (char)'|')) != null) {
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                if (!param.startsWith("ucap:")) continue;
                cap = param.substring(5);
            }
        }
        return cap;
    }

    public String getNavCapabilities() {
        if (this.m_navCapabilities == null) {
            StringBuilder buffer = new StringBuilder();
            if (this.m_ccSession != null) {
                String[] params = Strings.split((String)this.m_ccSession, (char)'|');
                if (params != null) {
                    boolean canWrite = false;
                    for (int i = 0; i < params.length; ++i) {
                        String param = params[i];
                        if (!param.equals("write:true")) continue;
                        canWrite = true;
                        break;
                    }
                    if (canWrite) {
                        buffer.append("canWriteToAccount|");
                    }
                }
                buffer.append(this.getUIProfilesFromCCSession());
            }
            this.m_navCapabilities = buffer.toString();
        }
        return this.m_navCapabilities;
    }

    public String getFormat() {
        return this.m_format != null ? this.m_format : EMPTY_STRING;
    }

    public String getPassportID() {
        return this.m_passportID != null ? this.m_passportID : EMPTY_STRING;
    }

    public String getPassportCookie() {
        if (this.m_passportCookieFromSetCookieVars != null) {
            return this.m_passportCookieFromSetCookieVars;
        }
        if (this.m_passportCookieFromCookieVars != null) {
            return this.m_passportCookieFromCookieVars;
        }
        return EMPTY_STRING;
    }

    public String getTicket() {
        return this.m_ticket;
    }

    public Locale getProductLocale() {
        if (this.m_productLocale != null) {
            return this.m_productLocale;
        }
        if (this.m_productLocaleString != null) {
            String country;
            String lang;
            int index = this.m_productLocaleString.indexOf(45);
            if (index != -1) {
                lang = this.m_productLocaleString.substring(0, index);
                country = index < this.m_productLocaleString.length() ? this.m_productLocaleString.substring(index + 1, this.m_productLocaleString.length()) : EMPTY_STRING;
            } else {
                lang = this.m_productLocaleString;
                country = EMPTY_STRING;
            }
            this.m_productLocale = new Locale(lang, country);
        } else {
            this.m_productLocale = DEFAULT_LOCALE;
        }
        return this.m_productLocale;
    }

    public Locale getContentLocale() {
        if (this.m_contentLocale != null) {
            return this.m_contentLocale;
        }
        if (this.m_contentLocaleString != null) {
            String country;
            String lang;
            int index = this.m_contentLocaleString.indexOf(45);
            if (index != -1) {
                lang = this.m_contentLocaleString.substring(0, index);
                country = index < this.m_contentLocaleString.length() ? this.m_contentLocaleString.substring(index + 1, this.m_contentLocaleString.length()) : EMPTY_STRING;
            } else {
                lang = this.m_contentLocaleString;
                country = EMPTY_STRING;
            }
            this.m_contentLocale = new Locale(lang, country);
        } else {
            this.m_contentLocale = DEFAULT_LOCALE;
        }
        return this.m_contentLocale;
    }

    public String getProductLocaleAsString() {
        return this.m_productLocaleString != null ? this.m_productLocaleString : EMPTY_STRING;
    }

    public String getContentLocaleAsString() {
        return this.m_contentLocaleString != null ? this.m_contentLocaleString : EMPTY_STRING;
    }

    public String getTimeZone() {
        return this.m_timeZone != null ? this.m_timeZone : EMPTY_STRING;
    }

    public String getHeaderString() {
        return this.m_headerString;
    }

    public String getWebContentRoot() {
        return this.m_webContentRoot;
    }

    public HashSet getUserCapabilities() throws NavException {
        if (this.userCapabilities != null) {
            try {
                return this.userCapabilities.getUserCapabilities();
            }
            catch (Exception e) {
                throw new NavException("IDS_ERR_SESSIONCAPABILITY_VIOLATION", e);
            }
        }
        return null;
    }

    public boolean isBidiEnabled() {
        return "true".equals(this.m_bidiEnabled);
    }

    public String getTextDirection() {
        return this.m_textDirection != null ? this.m_textDirection : EMPTY_STRING;
    }

    public String getBrowser() {
        return this.m_browser != null ? this.m_browser : EMPTY_STRING;
    }

    static {
        ELEMENTS_TO_PARSE.add("cookieVars");
        ELEMENTS_TO_PARSE.add("setCookieVars");
        ELEMENTS_TO_PARSE.add("userPreferenceVars");
        ELEMENTS_TO_PARSE.add("environmentVars");
    }
}

